/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _PROGRESSDIALOG_H
#define _PROGRESSDIALOG_H

#include "dialog.h"
#include "label.h"

namespace uta {

///
class ProgressDialog : public Dialog
{
 //OBJECT

 public:
  ///
  ProgressDialog();
  ///
  virtual ~ProgressDialog();
  ///
  void remove();
  ///
  void info(const char*);
  ///
  void setValue(int);


 protected:
  ///
  int percentage_;
  ///
  Widget *bar_;
  ///
  Label *info_;

};



#define CREATE_PROGRESSBAR(info_txt) \
uta::ProgressDialog progress; \
progress.info(info_txt); \
progress.exec();
#define UPDATE_PROGRESSBAR(percent) progress.setValue(percent);
#define REMOVE_PROGRESSBAR progress.close();

}

#endif // !_DIALOG
