#include "surface.h"
#include <iostream>

void usage()
{
  cerr << "usage:" << endl
       << "convert <input file> <output file> " << endl;
}

int main(int argc, char** argv)
{
  if(argc != 3)
    {
      usage();
      return 1;
    }

  uta::Surface surface;
  surface.readFromFile(argv[1]);

  /* convert to an indexed format, using the default palette */
  
  uta::Pixelformat newformat = uta::Pixelformat::IND8;
  
  surface.convert(newformat, true);

  surface.writeToFile(argv[2]);

  return 0;
}
