/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux <klaux@student.uni-kl.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include <SDL/SDL.h>
#include "timer.h"

#include <stl.h>
#include <slist>

namespace uta {

slist<Timer*> Timer::systemTimers;

Timer::Timer(unsigned int mseconds) :
  deltaT_(mseconds),
  running_(true)
{
  systemTimers.push_front(this);
  theTime = SDL_GetTicks();
}

Timer::~Timer()
{
  systemTimers.remove(this);
}

void 
Timer::update(unsigned int now)
{
  if(!running_)
    return;

  unsigned int delta = now - theTime;
  if(delta >= deltaT_)
    {
      theTime = now;
      alarm1(delta - deltaT_);
      alarm();
    }
}

void
Timer::setInterval(unsigned int delta)
{
  deltaT_ = delta;
}

void
Timer::run()
{
  //enable timer and reset time
  running_ = true;
  theTime = SDL_GetTicks();
}

void
Timer::halt()
{
  running_ = false;
}

void
Timer::processAllTimers()
{
  
  unsigned int now = SDL_GetTicks();

  slist<Timer*>::iterator itr = systemTimers.begin();
  while(itr != systemTimers.end())
    {
      (*itr)->update(now);
      itr++;
    }
}
}
