/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux <klaux@student.uni-kl.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/


#include "movie.h"
#include "debug.h"

#include <assert.h>

namespace uta {

Movie::Movie(Widget* parent, int x, int y, int w, int h) :
  Widget(parent, x, y , w, h),
  index_(0),
  myTimer_(500)
{
  myTimer_.alarm.connect(slot(this, &Movie::tick));
  myTimer_.halt();
}

Movie::~Movie()
{
  //EMPTY
}

void
Movie::create()
{
  //allow to set widget the background, color, etc...
  Widget::create();
  
  const Surface* frame = frames_[index_];

  assert(frame);

  //center the image
  Rect dest = Rect((surface_->width()-frame->width())/2,
		     (surface_->height()-frame->height())/2,
		     frame->width(), frame->height());
  
  frame->blit(surface_, dest);

}

void Movie::start()
{
  myTimer_.run();
  needsUpdate_ = true;
}

void Movie::stop()
{
  myTimer_.halt();
}

void Movie::load(vector<const Surface*>* data)
{
  frames_.clear();
  
  frames_ = *data;

  needsUpdate_ = true;
  
  index_ = 0;
}

void Movie::setDelay(unsigned int data)
{
  myTimer_.setInterval(data);
}

void Movie::tick()
{
  
  index_++;
  if(index_ >= (int)(frames_.size()))
    index_ = 0;
  
  needsUpdate_ = true;
  
}
  
}

