/*
  libu - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#include "application.h"
#include "multilineedit.h"
#include "pushbutton.h"
#include "togglebutton.h"
#include "logo.h"
#include "resources.h"
#include "questionbox.h"

using namespace uta;

#include <stdio.h>

class AlphaApp : public Application
{

protected:
  Widget* back ;
  Logo logo;
  Surface image32, image8, image_gray, image_ga;
 
  Surface logo2;

public:

  
  //needs to be there, but do not use it, use startupProc instead
  AlphaApp(int argc, char** argv) : 
    Application(argc, argv) { };
  
  //needs to be there, but use shutdownProc instead
  virtual ~AlphaApp() {};


  //you should at least handle the QUIT event, otherwise
  //your app cannot be closed
  bool handleEvent(const Event* event)
    {
      bool handled = Application::handleEvent(event);
      if(!handled)
	{
	  if(event->type()==Event::QUIT)
	    {
	      QuestionBox d("Confirm","Really quit ?");
	      d.setColor(darkgrey);
	      if(d.exec() == Dialog::OK)
		{
		  cerr << "quitting ..."<<endl;
		  quit();
		}
	    }
	}
      return handled;
    }

  int startupProc(void)
    {
      cout << "starting up ..." << endl;
      //do you init here

      rootWindow()->setTitle("LIBUTA Demo");


      //eg fontloading ....
      //(these fonts are used by several gui elements from libu,
      // so you should slways load text_font and button_font when
      // using widgets from libu)
      REG_FONT_RES("text_font","flatbrush.ttf, 16, 0xF0F0F0, 0x80101010");
      REG_FONT_RES("button_font","flatbrush.ttf, 18, 0xF0F0F0, 0x80101010");
      
      //register this wav file as resources "press"
      //which is played whenever an button gets pressed
      REG_SAMPLE_RES("press","press.wav");
      //same but for "release"
      REG_SAMPLE_RES("release","release.wav");
      
      REG_SURFACE_RES("background","background.png");

      back = new Widget(rootWindow(),0,0,
			rootWindow()->width(),
			rootWindow()->height());
      

      //create your gui here
      MultiLineEdit* info 
	= new MultiLineEdit(back,50,50,300,50,
			    FONT_RES("button_font"));
      info->setText("LIBUTA - AlphaTest\n"
		    "written by Karsten Laux");
      info->setColor(Color(0,48,128,128));
      
      logo2.readFromFile("../logo_thumb.png");

      Widget *tmp = new Widget(back, back->width()-logo.width()-10, 10,
			       logo.width(), logo.height());
      tmp->setBackground(&logo);

      back->setBackground(SURFACE_RES("background"));

      //a pushbutton
      PushButton* quit_button 
	= new PushButton(back, 
			  back->width()-100,
			  back->height()-40,
			  90, 30);
      quit_button->setText("Quit");

      //connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
      quit_button->clicked.connect(slot(this, &AlphaApp::quit));
             
      image8.readFromFile("image8.png");
      image8.setTransColor(black);
      image8.setTransparency(true);      

      image32.readFromFile("image32.png");
      image32.setTransColor(black);
      image32.setTransparency(true);

      image_gray.readFromFile("image_gray.png");
      image_gray.setTransColor(black);
      image_gray.setTransparency(true);

      image_ga.readFromFile("image_gray_alpha.png");
      image_ga.setTransColor(black);
      image_ga.setTransparency(true);

      Label* label;

      label = new Label(back,80,300,140,25);
      label->setText("indexed");
      tmp = new Widget(back,100,200,100,100);
      //      tmp->setColor(Color(0,0,0,128));
      tmp->setBackground(&image8);
 
      label = new Label(back,280,300,140,25);
      label->setText("RGB, alpha");
      tmp = new Widget(back,300,200,100,100);
      //tmp->setColor(Color(0,0,0,128));
      tmp->setBackground(&image32);

      label = new Label(back,80,450,140,25);
      label->setText("greyscale");
      tmp = new Widget(back,100,350,100,100);
      //tmp->setColor(Color(0,0,0,128));
      tmp->setBackground(&image_gray);

      label = new Label(back,280,450,140,25);
      label->setText("greyscale, alpha");
      tmp = new Widget(back,300,350,100,100);
      //tmp->setColor(Color(0,0,0,128));
      tmp->setBackground(&image_ga);

      return 0;
    }

  int eventloopProc(void)
    {

     //do your processing here
      return 0;
    }

  int shutdownProc(void)
    {
      cout << "shutting down ..." << endl;
      //do your cleaning up here
      return 0;
    }
};


  
int main (int argc, char **argv)
{
  AlphaApp app(argc, argv);
  
  app.init(640,480,0);
  
  return app.exec();
	
}

