/*
 * The table is converted from CMEX's BIG5P-S1.ATB.
 *
 * The original copyright (in Big5 encoding) is:
 *
 * ۧ@vF|soiҮ֩e|Τqs|Ҧ@
 *
 * Copyright 1999, TaBE Project, All Rights Reserved.
 * Copyright 1999, Pai-Hsiang Hsiao, All Rights Reserved.
 *
 * $Id: tabe_yin2zhi.h,v 1.5 2001/11/06 15:19:54 thhsieh Exp $
 *
 */

/*
 * Some Big5 Tsi may have the same Yin. The table describing the
 * relationship of a specific Yin to all the Big5 Tsi of the Yin.
 *
 */
#ifndef __TABE_YIN2ZHI_H__
#define __TABE_YIN2ZHI_H__

struct YinZhi {
  Yin      yin;
  int      num;
  ZhiCode *codelist;
};

static ZhiCode codelist8[] = {
 0xaafc, 0xb0da, 0xa3ab,
};

static ZhiCode codelist12[] = {
 0xaafc,
};

static ZhiCode codelist13[] = {
 0xb0da, 0xaafc,
};

static ZhiCode codelist16[] = {
 0xb3e1, 0xa3ac,
};

static ZhiCode codelist18[] = {
 0xae40,
};

static ZhiCode codelist24[] = {
 0xaafc, 0xb0fe, 0xdecb, 0xa3ad, 0xd4f3,
 0xcea3, 0xebe8,
};

static ZhiCode codelist26[] = {
 0xc342, 0xb35f, 0xc35a, 0xae5a, 0xae40,
 0xb8bf, 0xae6f, 0xd76d, 0xab58, 0xcaa7,
 0xca78, 0xdacb, 0xb348, 0xe872, 0xcdd2,
 0xd678, 0xd269, 0xdab8, 0xdac1, 0xe8e2,
};

static ZhiCode codelist27[] = {
 0xe4fa,
};

static ZhiCode codelist28[] = {
 0xb463, 0xbe6a, 0xab58, 0xb66b, 0xa4cc,
 0xb94b, 0xc1ee, 0xa7e3, 0xc673, 0xc345,
 0xa763, 0xb46a, 0xbeb5, 0xb36d, 0xcbae,
 0xf5a7, 0xb0ee, 0xeba7, 0xb8b0, 0xce4b,
 0xb0d7, 0xd8de, 0xdd7e, 0xb8e3, 0xec46,
 0xe8b6, 0xd8a5, 0xf8ed, 0xcce2, 0xd8ae,
 0xcac3, 0xf8cc, 0xf459, 0xcfee, 0xd2de,
 0xd3c4, 0xdbe5, 0xdc47, 0xdce1, 0xdda6,
 0xe3e1, 0xe968, 0xec5f, 0xf4ba,
};

static ZhiCode codelist32[] = {
 0xa3ae,
};

static ZhiCode codelist36[] = {
 0xe44d,
};

static ZhiCode codelist40[] = {
 0xaec1, 0xab73, 0xae4a, 0xadfc, 0xab75,
 0xa3af, 0xe44d,
};

static ZhiCode codelist42[] = {
 0xb1ba, 0xbd4a, 0xef63, 0xe1f4,
};

static ZhiCode codelist43[] = {
 0xb847, 0xc4a7, 0xc647, 0xd5d9, 0xcb48,
 0xcef7, 0xca64,
};

static ZhiCode codelist44[] = {
 0xb752, 0xc3aa, 0xa6e3, 0xc0c7, 0xc0f5,
 0xb969, 0xbebc, 0xc940, 0xf957, 0xe4ed,
 0xd8a5, 0xe954, 0xf669, 0xeeb8, 0xed54,
 0xef7c, 0xf4cf, 0xe44d, 0xee49,
};

static ZhiCode codelist48[] = {
 0xa3b0,
};

static ZhiCode codelist56[] = {
 0xa557, 0xa3b1, 0xcbfc, 0xcf62,
};

static ZhiCode codelist58[] = {
 0xbcf5, 0xb1ce, 0xbe43, 0xbfac, 0xb9c8,
 0xee67, 0xf7b4, 0xc652, 0xc3ef, 0xf67d,
 0xe1bc, 0xe676, 0xe6a9, 0xc16d, 0xf36c,
 0xe2b0, 0xeaa2, 0xe4bb, 0xe5ad, 0xe757,
 0xf06a, 0xf0e6, 0xf26a,
};

static ZhiCode codelist59[] = {
 0xc3cd, 0xb6fe, 0xcdbd, 0xd844,
};

static ZhiCode codelist60[] = {
 0xb6c6, 0xbf44, 0xb6f8, 0xbed2, 0xe94d,
 0xd8b4, 0xcaf3, 0xe9ae, 0xa9ed, 0xdbe4,
 0xe96a,
};

static ZhiCode codelist64[] = {
 0xbcda, 0xbf5e, 0xbcde, 0xb9c3, 0xf0dd,
 0xc5c3, 0xa3b2, 0xe1d3, 0xb0cf, 0xe665,
 0xe75f, 0xf250,
};

static ZhiCode codelist66[] = {
 0xcaa1,
};

static ZhiCode codelist67[] = {
 0xb0b8, 0xc3c2, 0xb9c3, 0xbda2, 0xca7e,
 0xda42, 0xdf78, 0xeaf9,
};

static ZhiCode codelist68[] = {
 0xb9c3, 0xe278, 0xbebe,
};

static ZhiCode codelist72[] = {
 0xa677, 0xbe62, 0xb167, 0xbfda, 0xaef2,
 0xbbcf, 0xd369, 0xa3b3, 0xc44f, 0xd8c0,
 0xcbc8, 0xea75, 0xcea6, 0xdeca, 0xdf72,
 0xdfd6, 0xf54c, 0xce50,
};

static ZhiCode codelist74[] = {
 0xe0d8, 0xcfcd, 0xd875,
};

static ZhiCode codelist75[] = {
 0xadcd, 0xd47b, 0xd9a3, 0xd87e,
};

static ZhiCode codelist76[] = {
 0xb774, 0xaed7, 0xa9a4, 0xabf6, 0xc566,
 0xb5da, 0xeeee, 0xca43, 0xd3e0, 0xcbd8,
 0xd1db, 0xcf7d, 0xd3b0, 0xebfe, 0xd0ee,
 0xd4e9, 0xe8f8,
};

static ZhiCode codelist80[] = {
 0xaea6, 0xb6e2, 0xa3b4,
};

static ZhiCode codelist84[] = {
 0xddae,
};

static ZhiCode codelist88[] = {
 0xbbea, 0xb5cb, 0xa3b5,
};

static ZhiCode codelist90[] = {
 0xa9f9, 0xc957,
};

static ZhiCode codelist91[] = {
 0xdc42,
};

static ZhiCode codelist92[] = {
 0xaf73, 0xeecc,
};

static ZhiCode codelist96[] = {
 0xf1a2, 0xa3b6,
};

static ZhiCode codelist104[] = {
 0xa3b7, 0xa8e0,
};

static ZhiCode codelist106[] = {
 0xa8e0, 0xa6d3, 0xcfa5, 0xd053, 0xd36b,
 0xe077, 0xcbca, 0xd1e6, 0xd0c4, 0xef6c,
 0xefdf, 0xdb46, 0xd3b4, 0xd4a2, 0xef7b,
};

static ZhiCode codelist107[] = {
 0xbab8, 0xa6d5, 0xac7c, 0xbbe7, 0xc2e2,
 0xd2ad, 0xec62, 0xf0b9, 0xe47a, 0xcea9,
 0xc974, 0xd1f0,
};

static ZhiCode codelist108[] = {
 0xa447, 0xb64c, 0xcbb9, 0xcbd0, 0xcdfb,
 0xe9c2, 0xdb46, 0xd1fd, 0xd6ac, 0xdbc0,
};

static ZhiCode codelist128[] = {
 0xa440, 0xb3fc, 0xa6e7, 0xa8cc, 0xc2e5,
 0xa5ec, 0xb4a5, 0xbeb3, 0xbaac, 0xd661,
 0xaba9, 0xa3b8, 0xe2fc, 0xeddf, 0xf1e0,
 0xe9b5, 0xe476, 0xccfc, 0xf7c3, 0xd9da,
 0xdc54, 0xc9c9, 0xde55, 0xe349, 0xea57,
 0xcfab, 0xd848, 0xdbba, 0xe176, 0xea62,
 0xefde, 0xefe9, 0xf877, 0xe95e,
};

static ZhiCode codelist130[] = {
 0xbff2, 0xbac3, 0xb2be, 0xa979, 0xa9c9,
 0xabbc, 0xbbf6, 0xa669, 0xa440, 0xbdcb,
 0xafd8, 0xb64d, 0xb97e, 0xab78, 0xdbdf,
 0xa85e, 0xc05b, 0xc255, 0xada3, 0xddcb,
 0xb2ad, 0xb344, 0xa665, 0xecda, 0xd6d7,
 0xd1df, 0xc96c, 0xd166, 0xcf70, 0xedc6,
 0xb059, 0xd3e1, 0xd3ee, 0xcb44, 0xcf51,
 0xdbcd, 0xd441, 0xcea7, 0xd6ab, 0xdb42,
 0xe0c0, 0xecd9, 0xcbb7, 0xcfd4, 0xd0ad,
 0xe4ab, 0xce4d, 0xcec3, 0xdba6, 0xccf3,
 0xaeeb, 0xd2bf, 0xd7bb, 0xdb43, 0xdbb3,
 0xddbf, 0xe068, 0xe265, 0xe66f, 0xe6d6,
 0xeb6c, 0xef47, 0xf0eb, 0xf64c, 0xf8df,
};

static ZhiCode codelist131[] = {
 0xa548, 0xa477, 0xa441, 0xadca, 0xb4c8,
 0xa86f, 0xc3c6, 0xa7c0, 0xf2c3, 0xada3,
 0xd077, 0xb0c0, 0xd1b0, 0xba59, 0xeb63,
 0xc9e6, 0xd441, 0xdcaf, 0xd0c0, 0xf8a3,
 0xf3aa, 0xecf6, 0xe0bf, 0xa8b2, 0xd05e,
 0xf05c, 0xd578, 0xd848, 0xd8e4, 0xd9a8,
 0xf4da,
};

static ZhiCode codelist132[] = {
 0xb74e, 0xb871, 0xa9f6, 0xc4b3, 0xa5e7,
 0xaf71, 0xb2a7, 0xc3c0, 0xbbf5, 0xbed0,
 0xc4b6, 0xb247, 0xa7d0, 0xc16c, 0xaccc,
 0xbcdd, 0xb668, 0xa8b6, 0xa7ed, 0xb877,
 0xa440, 0xbdcb, 0xc3b6, 0xb7b8, 0xbf7e,
 0xb663, 0xb8da, 0xa67a, 0xa748, 0xb2dd,
 0xacfd, 0xc5e6, 0xb1b3, 0xc574, 0xb8c7,
 0xc172, 0xa6b2, 0xabb3, 0xbb69, 0xb5c5,
 0xa6e7, 0xa4c2, 0xc16b, 0xd1ba, 0xc2ef,
 0xc56d, 0xabd9, 0xa8db, 0xc940, 0xa47c,
 0xa6e3, 0xe97d, 0xbeb0, 0xe948, 0xecee,
 0xedf5, 0xd1a5, 0xe6b0, 0xc968, 0xe143,
 0xd4b7, 0xe961, 0xabd4, 0xe9b5, 0xcb40,
 0xcf41, 0xe9e2, 0xaf4a, 0xe666, 0xeaf7,
 0xf94a, 0xf554, 0xe8f1, 0xdcb2, 0xd0fa,
 0xed5c, 0xf2c9, 0xf345, 0xecd8, 0xca59,
 0xe66d, 0xca70, 0xecf3, 0xdccc, 0xe1bb,
 0xf65e, 0xf1a2, 0xf4e6, 0xf4e3, 0xd6f6,
 0xc9a9, 0xc9dd, 0xccdd, 0xca68, 0xcf7e,
 0xe9f9, 0xcb7b, 0xea55, 0xcfce, 0xccb4,
 0xf5f7, 0xcde2, 0xda61, 0xed5d, 0xd9a6,
 0xd151, 0xd7f8, 0xd1c3, 0xd1f7, 0xd4b0,
 0xd6f5, 0xd84c, 0xd9de, 0xdbf3, 0xdff6,
 0xe16e, 0xe36d, 0xe3a4, 0xe4c1, 0xe5dd,
 0xe65b, 0xe75a, 0xe94c, 0xea6d, 0xeeb0,
 0xf2af, 0xf45e, 0xceb3, 0xe5ce, 0xf37c,
 0xf8dd, 0xf967,
};

static ZhiCode codelist136[] = {
 0xa772, 0xc0a3, 0xbe7e, 0xc06e, 0xa9e3,
 0xa458, 0xd9b2, 0xb7da, 0xd4ef,
};

static ZhiCode codelist138[] = {
 0xa4fa, 0xaade, 0xb250, 0xb8c5, 0xb048,
 0xa9e3, 0xccd6, 0xcb62, 0xf3fa, 0xc9b7,
 0xd4c4,
};

static ZhiCode codelist139[] = {
 0xa8c8, 0xb0d7, 0xb6ae, 0xd56f, 0xc9c4,
 0xcacf, 0xeb56, 0xdca6, 0xa5d4,
};

static ZhiCode codelist140[] = {
 0xa8c8, 0xb359, 0xcdce, 0xcfeb, 0xb4e3,
 0xd4d5, 0xd95d, 0xebe2, 0xdb47, 0xaaee,
 0xc959, 0xca50, 0xcd67, 0xda6f, 0xe34b,
 0xf9d3,
};

static ZhiCode codelist144[] = {
 0xadf2,
};

static ZhiCode codelist160[] = {
 0xad43, 0xbc4f, 0xf7f9,
};

static ZhiCode codelist162[] = {
 0xb7dd, 0xad43, 0xb7a6, 0xb278, 0xd95e,
 0xeced,
};

static ZhiCode codelist163[] = {
 0xa45d, 0xb3a5, 0xa74d, 0xd4b1, 0xe2b2,
};

static ZhiCode codelist164[] = {
 0xb77e, 0xb8ad, 0xadb6, 0xa95d, 0xab7c,
 0xbfd6, 0xabfb, 0xc5e2, 0xbff3, 0xea4d,
 0xeda2, 0xeceb, 0xae67, 0xbee7, 0xf1ac,
 0xde6f, 0xeee4, 0xf667, 0xea45, 0xf165,
 0xd44f, 0xd9df, 0xe965, 0xe9ac, 0xb247,
};

static ZhiCode codelist170[] = {
 0xb156, 0xdedd, 0xd4a9, 0xd4e4,
};

static ZhiCode codelist184[] = {
 0xad6e, 0xb879, 0xa4d4, 0xa7af, 0xc1dc,
 0xa45c, 0xa65b, 0xb3e9, 0xd86d, 0xcff7,
 0xdfb7, 0xd7cc,
};

static ZhiCode codelist186[] = {
 0xb76e, 0xc1c1, 0xb3f3, 0xbbbb, 0xabc0,
 0xacab, 0xbabd, 0xb9ae, 0xb263, 0xc061,
 0xf3ad, 0xd85c, 0xedd9, 0xe566, 0xdd64,
 0xd9e2, 0xdead, 0xdbfe, 0xa4f8, 0xce5d,
 0xb15c, 0xe4a2, 0xd2b0, 0xcf57, 0xd662,
 0xf6af, 0xaad4, 0xdcf8, 0xd26c, 0xbd60,
 0xdce0, 0xdd6c, 0xba6f, 0xf672,
};

static ZhiCode codelist187[] = {
 0xab72, 0xafb7, 0xafe6, 0xa4d4, 0xccea,
 0xaa48, 0xd2f8, 0xd6c9, 0xf7c5, 0xcabc,
 0xccb3, 0xd0a5, 0xd2d3, 0xd450, 0xde4a,
 0xe255, 0xf3b5, 0xcac7, 0xdd45, 0xe3cf,
};

static ZhiCode codelist188[] = {
 0xad6e, 0xc3c4, 0xc4a3, 0xc260, 0xc65f,
 0xbcd6, 0xc563, 0xa9ed, 0xeffa, 0xd7c4,
 0xe4c8, 0xf0a3, 0xe446, 0xd040, 0xdae0,
 0xdfd3, 0xe678, 0xf34d,
};

static ZhiCode codelist192[] = {
 0xc075, 0xbc7e, 0xabd5, 0xb179, 0xcbe7,
 0xa7f1, 0xf5ef, 0xe0ee, 0xf24e, 0xf14d,
 0xefca, 0xccab, 0xefba, 0xeff3, 0xf5ea,
 0xd7ab,
};

static ZhiCode codelist194[] = {
 0xa5d1, 0xb4e5, 0xb943, 0xa4d7, 0xaa6f,
 0xb66c, 0xb553, 0xb7df, 0xb95c, 0xebc9,
 0xacd0, 0xd7a5, 0xeb4f, 0xceea, 0xe7a2,
 0xd7ca, 0xd7e6, 0xddcd, 0xbe7b, 0xc9ac,
 0xcb4f, 0xd25b, 0xd461, 0xd2f4, 0xd75f,
};

static ZhiCode codelist195[] = {
 0xa6b3, 0xa4cd, 0xa8bb, 0xb2fb, 0xbcf8,
 0xc24b, 0xd04e, 0xcd4f, 0xe47d, 0xcc6b,
 0xd176, 0xdfae, 0xcdc4, 0xd744, 0xe5d0,
};

static ZhiCode codelist196[] = {
 0xa453, 0xa56b, 0xa5ae, 0xbba4, 0xa6f6,
 0xac63, 0xb956, 0xafa7, 0xa6b3, 0xb2fb,
 0xabc9, 0xa8dd, 0xabaa, 0xc35e, 0xca72,
 0xce6e, 0xcd5c, 0xcead, 0xdbe6, 0xecab,
 0xcaf0, 0xcfbb, 0xd3f1,
};

static ZhiCode codelist200[] = {
 0xb7cf, 0xb26a, 0xb254, 0xaeef, 0xbe4d,
 0xab7c, 0xafda, 0xa961, 0xb4f3, 0xb5d2,
 0xb9e4, 0xbf50, 0xe759, 0xec49, 0xb9bd,
 0xd4fc, 0xf4b4, 0xe46b, 0xe2b1, 0xda6d,
 0xd2b8, 0xd460, 0xecd6, 0xf35c, 0xb5cb,
};

static ZhiCode codelist202[] = {
 0xace3, 0xa8a5, 0xc343, 0xc459, 0xa9b5,
 0xaa75, 0xaaa2, 0xc0f9, 0xc651, 0xa9a5,
 0xbae1, 0xc3b2, 0xc046, 0xa7b0, 0xe3e9,
 0xc0d1, 0xd4ba, 0xd877, 0xdd77, 0xe2f2,
 0xe372, 0xd7ee, 0xc5c9, 0xf7d5, 0xdde9,
 0xf8fa, 0xe8a9, 0xd15e, 0xdc6e, 0xd667,
 0xeb5a, 0xef4a, 0xf1f8, 0xf5b1, 0xf7d3,
 0xd77a, 0xd8e5,
};

static ZhiCode codelist203[] = {
 0xb2b4, 0xba74, 0xb1bb, 0xad6c, 0xb66e,
 0xb0b3, 0xab5e, 0xf5de, 0xc56b, 0xc64c,
 0xd0e6, 0xcebb, 0xdf6a, 0xcb56, 0xf7d6,
 0xd951, 0xd966, 0xda4a, 0xe7a7, 0xf97d,
 0xce6b, 0xe5ac, 0xd9b0, 0xf1fc, 0xf56a,
 0xc5c4, 0xda7c, 0xcdf4, 0xf1ef, 0xddf4,
 0xcaf1, 0xf5bf, 0xd7f5, 0xd8da, 0xd94c,
 0xdb62, 0xe0d1, 0xe3f9, 0xe7c6, 0xf5a1,
 0xf5b5, 0xf8ab, 0xd558, 0xebc8, 0xef56,
 0xf6cd,
};

static ZhiCode codelist204[] = {
 0xc5e7, 0xbf50, 0xb9bd, 0xaecb, 0xb6ad,
 0xae62, 0xb254, 0xc676, 0xbf56, 0xabdb,
 0xb3f7, 0xb578, 0xab7c, 0xc360, 0xadf1,
 0xc5e4, 0xace3, 0xf840, 0xbfce, 0xaa75,
 0xf9a9, 0xda5d, 0xc66f, 0xc5ac, 0xd869,
 0xf9d0, 0xf46a, 0xd845, 0xf6bb, 0xf1fc,
 0xef76, 0xf849, 0xb54b, 0xcd5b, 0xce6d,
 0xf86d, 0xddea, 0xf451, 0xece6, 0xd4e9,
 0xdcb5, 0xe8ed, 0xe945, 0xf55b, 0xf7fe,
 0xc641, 0xf976, 0xd77a, 0xd978,
};

static ZhiCode codelist208[] = {
 0xa65d, 0xadb5, 0xb3b1, 0xabc3, 0xaeef,
 0xaff4, 0xb9fe, 0xaef4, 0xe2da, 0xd866,
 0xd8a1, 0xb4f3, 0xd8fe, 0xe2fa, 0xdaf1,
 0xdbc7, 0xeef0, 0xec65, 0xe4a1, 0xe3d3,
 0xeba2, 0xce58, 0xf54d, 0xcfa7, 0xd468,
 0xddf6, 0xecc6, 0xeef7, 0xf54c, 0xf6cb,
 0xe1ed,
};

static ZhiCode codelist210[] = {
 0xbbc8, 0xa775, 0xb147, 0xb25d, 0xbbc2,
 0xc569, 0xc0d1, 0xc3f9, 0xabad, 0xb9db,
 0xd2a4, 0xefbd, 0xd543, 0xe7dd, 0xf0bf,
 0xd4d9, 0xc955, 0xcdc2, 0xdc6c, 0xd148,
 0xd27b, 0xd468, 0xd779, 0xe5f1, 0xe750,
 0xefe7, 0xf864, 0xf36d,
};

static ZhiCode codelist211[] = {
 0xa4de, 0xb6bc, 0xc1f4, 0xa4a8, 0xc57d,
 0xb043, 0xa776, 0xe0db, 0xd355, 0xc169,
 0xf8c1, 0xe7f2, 0xee58, 0xe4d5, 0xdc68,
 0xed41, 0xed56, 0xf5f4, 0xd34c,
};

static ZhiCode codelist212[] = {
 0xa64c, 0xb6bc, 0xc1f4, 0xbdae, 0xad4e,
 0xe1ba, 0xe34a, 0xe978, 0xda57, 0xd150,
 0xda79, 0xe1fa, 0xe475,
};

static ZhiCode codelist216[] = {
 0xa5a1, 0xafb1, 0xac6f, 0xc06d, 0xbbdf,
 0xaa74, 0xcbf6, 0xd066, 0xcf4b, 0xca62,
 0xcc47, 0xd6ef, 0xe0bd, 0xe0d9,
};

static ZhiCode codelist218[] = {
 0xb7a8, 0xb6a7, 0xb4ad, 0xac76, 0xa6cf,
 0xa8cb, 0xaf4c, 0xbac5, 0xc1ed, 0xabe2,
 0xc347, 0xb77a, 0xb7d5, 0xce52, 0xceef,
 0xe2fe, 0xdbb1, 0xdeb4, 0xd2b3, 0xf4fd,
 0xd8df, 0xf8e4, 0xd6b1, 0xd8bb,
};

static ZhiCode codelist219[] = {
 0xbe69, 0xa5f5, 0xaef1, 0xc46f, 0xbbdf,
 0xc957, 0xefd5, 0xcc62, 0xcfb4, 0xccbf,
 0xd67d, 0xefd0, 0xe3e3,
};

static ZhiCode codelist220[] = {
 0xbccb, 0xbe69, 0xae7e, 0xba79, 0xa9c2,
 0xb7d5, 0xefee, 0xd6f2,
};

static ZhiCode codelist224[] = {
 0xc0b3, 0xad5e, 0xc64e, 0xc0a6, 0xc561,
 0xc4e5, 0xc174, 0xb7eb, 0xc678, 0xc458,
 0xc4a2, 0xc5d5, 0xf44c, 0xc4ed, 0xdcfc,
 0xf277, 0xeadf, 0xde7d, 0xf1a7, 0xe6ad,
 0xeefb, 0xe2f7, 0xf5e3, 0xddc8, 0xe7bf,
 0xda56, 0xeb74, 0xd463, 0xec52, 0xf5fa,
 0xf651, 0xf7fa, 0xf5b0,
};

static ZhiCode codelist226[] = {
 0xc0e7, 0xaaef, 0xc3c7, 0xbfc3, 0xc4b9,
 0xacd5, 0xbcfc, 0xbfa2, 0xc373, 0xe26c,
 0xbec6, 0xb6f7, 0xbab7, 0xb7ad, 0xefef,
 0xf25e, 0xf96d, 0xf45d, 0xeeab, 0xf244,
 0xf444, 0xf446, 0xf0a6,
};

static ZhiCode codelist227[] = {
 0xbc76, 0xb4ba, 0xbf6f, 0xe5f9, 0xf6f4,
 0xb072, 0xf45f, 0xcfe9, 0xd5bb, 0xd256,
};

static ZhiCode codelist228[] = {
 0xc0b3, 0xb577, 0xac4d, 0xdcf9, 0xefef,
 0xf16a, 0xe1ef, 0xe454,
};

static ZhiCode codelist256[] = {
 0xabce, 0xaf51, 0xa6c3, 0xa6be, 0xa664,
 0xbb7a, 0xb6e3, 0xa7c5, 0xc2eb, 0xe0a9,
 0xcf72, 0xe264, 0xa3b9, 0xb463, 0xa9f3,
 0xcafe, 0xd0c5, 0xd46a, 0xd6c8, 0xdf77,
 0xef7a, 0xeb68,
};

static ZhiCode codelist258[] = {
 0xb54c, 0xa764, 0xa75e, 0xb1ef, 0xa7c5,
 0xbfbe, 0xadf8, 0xb8bc, 0xbb7a, 0xa4f0,
 0xa460, 0xd65c, 0xeaf0, 0xf1df, 0xc4d3,
 0xd3f5, 0xe86b, 0xe866, 0xd16d, 0xd24f,
 0xd66c, 0xcde1, 0xf1c5, 0xd762, 0xf869,
 0xd264, 0xeda1, 0xf2fe,
};

static ZhiCode codelist259[] = {
 0xa4ad, 0xa4c8, 0xaa5a, 0xbb52, 0xab56,
 0xa5ee, 0xc44d, 0xbcad, 0xbc61, 0xe64b,
 0xe575, 0xc9ae, 0xcade, 0xdee6, 0xed71,
 0xddb3, 0xd4a4, 0xaeb8, 0xdd54, 0xcd6d,
 0xd0da, 0xe9dd, 0xf656,
};

static ZhiCode codelist260[] = {
 0xa4c5, 0xaaab, 0xb0c8, 0xb463, 0xbb7e,
 0xaea9, 0xb1e0, 0xc3fa, 0xa5b3, 0xc2eb,
 0xb6f5, 0xa461, 0xc94a, 0xc445, 0xb9ed,
 0xb063, 0xcb42, 0xd8b8, 0xf5ad, 0xb0ee,
 0xcb57, 0xcdd1, 0xebd2, 0xe874, 0xc9d6,
 0xc9e5, 0xde7c, 0xcdf5, 0xd651, 0xdcaa,
 0xca56, 0xd34f, 0xcd7c, 0xcdbe, 0xd4c1,
 0xd7e5, 0xdab2, 0xf3f7, 0xf4ba, 0xcac4,
 0xe4fa, 0xe767,
};

static ZhiCode codelist264[] = {
 0xab7a, 0xb5ec, 0xabf5, 0xbada, 0xa94b,
 0xb445, 0xcf71, 0xca48, 0xde43, 0xd2fb,
 0xd6ca, 0xe270,
};

static ZhiCode codelist266[] = {
 0xabbd,
};

static ZhiCode codelist267[] = {
 0xa5cb, 0xca5f,
};

static ZhiCode codelist268[] = {
 0xc4fb, 0xdcda, 0xe3a6,
};

static ZhiCode codelist272[] = {
 0xbadb, 0xadd8, 0xb4f5, 0xb8b1, 0xda73,
 0xe841,
};

static ZhiCode codelist275[] = {
 0xa7da, 0xd4d6, 0xd5a6,
};

static ZhiCode codelist276[] = {
 0xb4a4, 0xaad7, 0xa855, 0xb4ec, 0xba57,
 0xc653, 0xd8f2, 0xd5e2, 0xd451, 0xed52,
 0xda5f,
};

static ZhiCode codelist296[] = {
 0xac6e,
};

static ZhiCode codelist299[] = {
 0xafe6,
};

static ZhiCode codelist300[] = {
 0xa57e,
};

static ZhiCode codelist304[] = {
 0xabc2, 0xb451, 0xb0b9, 0xb7db, 0xdfbb,
 0xdc7e, 0xb5e4, 0xa965, 0xb66a, 0xd26b,
 0xdddb, 0xda44, 0xe2ef, 0xd94f, 0xd96d,
 0xdfda, 0xdc7c, 0xde5a, 0xe050, 0xe7a9,
 0xe7d0, 0xed61,
};

static ZhiCode codelist306[] = {
 0xacb0, 0xb3f2, 0xb74c, 0xa64d, 0xb0df,
 0xbafb, 0xb1a9, 0xb948, 0xadb3, 0xc1a8,
 0xc4de, 0xaee9, 0xc1f2, 0xc0e5, 0xb163,
 0xdd52, 0xb457, 0xc949, 0xd9f8, 0xde57,
 0xdc51, 0xeee3, 0xef74, 0xe65c, 0xcfaa,
 0xf4cc, 0xe861, 0xf66f, 0xf262, 0xeff4,
 0xf04e, 0xf6e5,
};

static ZhiCode codelist307[] = {
 0xa965, 0xa7c0, 0xb0b6, 0xbd6e, 0xb5e4,
 0xbdd3, 0xb8ab, 0xb7f5, 0xb554, 0xde6d,
 0xf6d6, 0xe0d4, 0xae55, 0xf1a4, 0xd8d0,
 0xaca8, 0xdeb3, 0xf0a9, 0xf0b6, 0xf671,
 0xc243, 0xe6c7, 0xdfaf, 0xe8bb, 0xddc2,
 0xd67e, 0xe0e9, 0xddf0, 0xd24c, 0xdfa4,
 0xcdb7, 0xeee7, 0xce7c, 0xf1f7, 0xd87a,
 0xd8f7, 0xdf79, 0xe3e5, 0xe4e8, 0xe770,
 0xd542, 0xd6b7, 0xe843, 0xf7de,
};

static ZhiCode codelist308[] = {
 0xacb0, 0xa6ec, 0xa5bc, 0xc351, 0xbdc3,
 0xa8fd, 0xb0b0, 0xbfd7, 0xad47, 0xb3de,
 0xbca2, 0xc1fd, 0xb14c, 0xb4f4, 0xacc8,
 0xbdab, 0xf74c, 0xe7b3, 0xf6ee, 0xbff2,
 0xf6d6, 0xf37d, 0xe6c4, 0xeae0, 0xc1ba,
 0xee42, 0xd8bc, 0xe3e8, 0xf2d8, 0xf362,
 0xdb73, 0xe674, 0xec5e, 0xf0f6, 0xf759,
 0xf763, 0xbf71, 0xec75, 0xecde,
};

static ZhiCode codelist328[] = {
 0xc657, 0xc573, 0xbddc, 0xade6, 0xb2f0,
 0xbb64, 0xc9bd, 0xe655,
};

static ZhiCode codelist330[] = {
 0xa7b9, 0xaab1, 0xb978, 0xa459, 0xa6c5,
 0xd04b, 0xcba3, 0xd64a, 0xd4ce, 0xcac1,
 0xcaea,
};

static ZhiCode codelist331[] = {
 0xb1df, 0xb84a, 0xaebe, 0xa97b, 0xb0fb,
 0xae59, 0xb570, 0xbbb5, 0xb2f0, 0xd246,
 0xbb64, 0xdec4, 0xdb60, 0xda7b, 0xec56,
 0xbaed, 0xd9a1, 0xe377, 0xf1c3, 0xd0ca,
 0xd74e, 0xded8, 0xe864, 0xdac2, 0xdfcb,
};

static ZhiCode codelist332[] = {
 0xb855, 0xaab1, 0xb5c3, 0xb17b, 0xc9c3,
 0xe6f6, 0xcada, 0xc9ba, 0xdf64, 0xc945,
 0xee63, 0xd567, 0xe7f3,
};

static ZhiCode codelist336[] = {
 0xb7c5, 0xbd45, 0xeec1, 0xb6f3, 0xf3b3,
 0xe2ea, 0xeeb4, 0xe267,
};

static ZhiCode codelist338[] = {
 0xa4e5, 0xbb44, 0xafbe, 0xb041, 0xaab3,
 0xb6b2, 0xec4c, 0xcd54, 0xcdb2, 0xdaa7,
 0xec4a, 0xeef2, 0xefb2, 0xe4d9, 0xe8e0,
 0xe8e4,
};

static ZhiCode codelist339[] = {
 0xc3ad, 0xa76b, 0xa646, 0xcbea, 0xd5d5,
};

static ZhiCode codelist340[] = {
 0xb0dd, 0xbb44, 0xafbf, 0xa4e5, 0xa85a,
 0xa7ee, 0xa74b, 0xddaf, 0xf46f, 0xcab9,
};

static ZhiCode codelist344[] = {
 0xa84c, 0xcabf, 0xa471,
};

static ZhiCode codelist346[] = {
 0xa4fd, 0xa460,
};

static ZhiCode codelist347[] = {
 0xa9b9, 0xbaf4, 0xaa50, 0xaac9, 0xb1a6,
 0xc353, 0xbdfe, 0xefeb, 0xca49, 0xd9a4,
 0xdb76, 0xdb52,
};

static ZhiCode codelist348[] = {
 0xa7d1, 0xa66b, 0xb1e6, 0xa9f4, 0xa4fd,
 0xe1fb, 0xcdcd, 0xd75a,
};

static ZhiCode codelist352[] = {
 0xafce, 0xb6e4, 0xeb6f, 0xf6c8, 0xec53,
};

static ZhiCode codelist355[] = {
 0xbb63, 0xde5b, 0xe1f6, 0xd266, 0xe6bf,
 0xeae7, 0xdce9,
};

static ZhiCode codelist356[] = {
 0xc27c, 0xcfd8, 0xf8ea, 0xf2b9,
};

static ZhiCode codelist384[] = {
 0xb24a, 0xa8b1, 0xb7ef, 0xacfa, 0xa3ba,
 0xde40, 0xe350, 0xc9e3, 0xcda6, 0xd6a7,
};

static ZhiCode codelist386[] = {
 0xa9f3, 0xb472, 0xb3bd, 0xae54, 0xbe6c,
 0xa45f, 0xbaae, 0xa4a9, 0xb74d, 0xa745,
 0xacf2, 0xb7ae, 0xb94f, 0xb8b7, 0xab5c,
 0xc1d6, 0xb7ec, 0xb4fc, 0xb6a8, 0xaad8,
 0xb5cd, 0xaabb, 0xbddb, 0xebc6, 0xd370,
 0xa666, 0xc26a, 0xbfcc, 0xdaae, 0xb5e3,
 0xd8e1, 0xe34c, 0xa7b1, 0xd967, 0xddf9,
 0xaceb, 0xf659, 0xdca2, 0xb3b8, 0xcafd,
 0xd9bf, 0xcb69, 0xe6ee, 0xe6f4, 0xbdc2,
 0xbdc9, 0xdecf, 0xdfa8, 0xd2a8, 0xca53,
 0xf042, 0xdad1, 0xf4aa, 0xd7fe, 0xd8e3,
 0xda42, 0xdc5c, 0xdf7d, 0xe2e6, 0xe8ac,
 0xe9f3, 0xeafb, 0xee6d, 0xf0dc, 0xf1ce,
 0xf1d7, 0xf4bc, 0xf8e0, 0xf961, 0xd0ac,
 0xd4a5, 0xd8a4, 0xd8b2, 0xe0d7, 0xe6d1,
 0xf44f, 0xf56d, 0xf8ec,
};

static ZhiCode codelist387[] = {
 0xbb50, 0xbb79, 0xab42, 0xa4a9, 0xa6d0,
 0xc0ac, 0xa674, 0xacea, 0xb168, 0xc5c5,
 0xbebe, 0xae46, 0xb0eb, 0xe6d5, 0xdcba,
 0xcde3, 0xb1d6, 0xe940, 0xdde2, 0xdeb7,
 0xc94f, 0xdfcc, 0xebb3, 0xd459, 0xd6bc,
 0xd97b, 0xdc5b, 0xdd4a, 0xedc9, 0xf4c2,
 0xefd8, 0xf0cb,
};

static ZhiCode codelist388[] = {
 0xa87c, 0xb94a, 0xb977, 0xa5c9, 0xb1fd,
 0xb0ec, 0xb3eb, 0xb755, 0xc541, 0xbabb,
 0xbca4, 0xaf44, 0xb8ce, 0xb7d4, 0xb44a,
 0xbf6d, 0xbb50, 0xe0b1, 0xbfdd, 0xb173,
 0xc67b, 0xc67e, 0xbfd9, 0xc2a1, 0xada7,
 0xb6bf, 0xac52, 0xb7b6, 0xa8a1, 0xb14c,
 0xbcf7, 0xab5c, 0xae6e, 0xa6d6, 0xb9e1,
 0xd17b, 0xdcae, 0xf7a7, 0xa8a6, 0xf866,
 0xc0ee, 0xe3da, 0xae4b, 0xbb79, 0xbac7,
 0xd9b5, 0xbf48, 0xdac3, 0xaceb, 0xdf67,
 0xee40, 0xebd1, 0xec48, 0xec4f, 0xf1d9,
 0xd9ad, 0xd5e7, 0xea52, 0xe67a, 0xf071,
 0xf1c0, 0xee4d, 0xf77d, 0xd553, 0xeca3,
 0xe873, 0xd252, 0xf5b7, 0xd1e7, 0xd2e1,
 0xf2a2, 0xcce9, 0xf9ac, 0xe467, 0xd1ac,
 0xdefd, 0xe3b4, 0xe4fb, 0xe8e7, 0xf150,
 0xf3b0, 0xf9c6, 0xf9d1, 0xe1d8, 0xd7c1,
 0xe36b, 0xe777, 0xebf1,
};

static ZhiCode codelist416[] = {
 0xacf9, 0xa4ea, 0xe941, 0xe6dc, 0xda5f,
};

static ZhiCode codelist420[] = {
 0xa4eb, 0xb656, 0xbcd6, 0xaeae, 0xbe5c,
 0xb866, 0xc544, 0xa9a8, 0xc0ae, 0xc4a3,
 0xc65f, 0xc260, 0xc3c4, 0xe0b5, 0xbba1,
 0xa647, 0xf465, 0xc5d4, 0xe9c4, 0xf5db,
 0xcda3, 0xf6f7, 0xf654, 0xb063, 0xf962,
 0xefb6, 0xcd5e, 0xaab5, 0xc97c, 0xccf6,
 0xdc76, 0xcaf2, 0xd3cb, 0xf5fe, 0xf9c5,
};

static ZhiCode codelist456[] = {
 0xadde, 0xb257, 0xc070, 0xbbf0, 0xa97b,
 0xd2d7, 0xdfeb, 0xf3d8, 0xcb75, 0xebf0,
 0xd8fa, 0xd9d6, 0xe3b3, 0xe3f5, 0xf6cf,
 0xdfdb, 0xe3ec, 0xe442, 0xe8d1, 0xf1fa,
 0xf469,
};

static ZhiCode codelist458[] = {
 0xadec, 0xa4b8, 0xadfb, 0xb6e9, 0xb6ea,
 0xbd74, 0xb7bd, 0xb4a9, 0xb444, 0xb04b,
 0xb7e1, 0xabae, 0xa84a, 0xc1d5, 0xacb8,
 0xe947, 0xefb1, 0xdcf4, 0xf258, 0xcdb4,
 0xb545, 0xc4cd, 0xd346, 0xeae3, 0xe7b5,
 0xcbab, 0xe7b4, 0xcaba, 0xdfc5, 0xeb60,
 0xd3bb, 0xccd4, 0xe25b, 0xde5f, 0xdd43,
 0xda75, 0xdeab, 0xe244, 0xe3be, 0xf164,
 0xf4e0, 0xf5a8,
};

static ZhiCode codelist459[] = {
 0xbbb7, 0xcc53,
};

static ZhiCode codelist460[] = {
 0xb07c, 0xc440, 0xabe8, 0xad62, 0xbbb7,
 0xb444, 0xdeb6, 0xba40, 0xd964, 0xe7cb,
 0xc970, 0xeeae, 0xe343, 0xe8fe,
};

static ZhiCode codelist464[] = {
 0xb777, 0xba72, 0xead5, 0xf349, 0xe16a,
 0xeb64,
};

static ZhiCode codelist466[] = {
 0xb6b3, 0xa4aa, 0xa4c3, 0xa9fb, 0xafd0,
 0xaae5, 0xafc6, 0xe2be, 0xb861, 0xde65,
 0xe658, 0xcfda, 0xeac0, 0xcb4e, 0xe2bc,
 0xe8a3, 0xeafc, 0xcab3, 0xc9b4, 0xead4,
 0xd75d, 0xe0a8, 0xcce3, 0xcfe1,
};

static ZhiCode codelist467[] = {
 0xa4b9, 0xb96b, 0xe266, 0xcb65, 0xf176,
 0xeb70, 0xcae9, 0xebb6, 0xe465, 0xdc75,
 0xcbb0,
};

static ZhiCode codelist468[] = {
 0xb942, 0xc3fd, 0xa5a5, 0xbcf7, 0xc4ad,
 0xb759, 0xc1df, 0xd940, 0xb777, 0xf3a5,
 0xdc50, 0xedf4, 0xcce0, 0xe6e3, 0xf579,
 0xadfb,
};

static ZhiCode codelist480[] = {
 0xb6c4, 0xb165, 0xb96c, 0xbed6, 0xbec3,
 0xf7ea, 0xc173, 0xe156, 0xf360, 0xba48,
 0xf776, 0xb06f, 0xf5cb, 0xf175, 0xdcdc,
 0xf5d7, 0xbbc1, 0xe8fc, 0xe9e9, 0xee52,
 0xe2af, 0xebd4,
};

static ZhiCode codelist482[] = {
 0xb6c4, 0xd871, 0xf1aa, 0xd851, 0xe5e1,
 0xdcfe, 0xdd4d, 0xe178,
};

static ZhiCode codelist483[] = {
 0xa5c3, 0xaa61, 0xb5fa, 0xab69, 0xbed6,
 0xbfe3, 0xb4e9, 0xb8ba, 0xa869, 0xbec3,
 0xb176, 0xc173, 0xab4d, 0xe45c, 0xd155,
 0xdcea, 0xe6ce, 0xaf46, 0xd1a4, 0xe4ac,
};

static ZhiCode codelist484[] = {
 0xa5ce, 0xa6fe, 0xeec9,
};

static ZhiCode codelist512[] = {
 0xa374,
};

static ZhiCode codelist520[] = {
 0xa44b, 0xaec3, 0xa4da, 0xaccd, 0xaadd,
 0xafb9, 0xd34a, 0xa57a, 0xa5b6, 0xd7d0,
 0xa761, 0xc954, 0xc9f6,
};

static ZhiCode codelist522[] = {
 0xa9de, 0xb65b, 0xb959, 0xe8d9, 0xd06e,
 0xf1e4, 0xdbfd, 0xc9a5, 0xdb6e, 0xd05a,
 0xdbd9,
};

static ZhiCode codelist523[] = {
 0xa7e2, 0xb976, 0xdc6a,
};

static ZhiCode codelist524[] = {
 0xbd7d, 0xaaa8, 0xc551, 0xc5f2, 0xafd2,
 0xcad3, 0xc5f4, 0xa742, 0xd666,
};

static ZhiCode codelist525[] = {
 0xa761, 0xbd7d, 0xb55d, 0xaa49,
};

static ZhiCode codelist528[] = {
 0xaa69, 0xacc1, 0xbcb7, 0xade9, 0xb5d4,
 0xb2da, 0xe567, 0xd2dc, 0xbcbd, 0xafeb,
 0xdeeb, 0xd7b7, 0xf0d4, 0xf85b, 0xd471,
 0xcf59, 0xf351, 0xcc69,
};

static ZhiCode codelist530[] = {
 0xa742, 0xb3d5, 0xac66, 0xaa79, 0xab6b,
 0xb769, 0xb4f1, 0xbbe9, 0xa5d5, 0xc1a1,
 0xb2e4, 0xa9ad, 0xb2ed, 0xbae4, 0xb2f2,
 0xbdb3, 0xbb4b, 0xb959, 0xe8c1, 0xb960,
 0xf5ce, 0xf1d0, 0xe7f4, 0xd24a, 0xf64a,
 0xe463, 0xf157, 0xec61, 0xe0fb, 0xf1ae,
 0xf566, 0xd5c5, 0xeeac, 0xc0d0, 0xec60,
 0xd063, 0xd1b4, 0xdeaa, 0xdfb4, 0xe877,
 0xefcc, 0xf063, 0xf2a1, 0xf952, 0xd3f6,
 0xf97b, 0xf2ae,
};

static ZhiCode codelist531[] = {
 0xb65f, 0xc3b0, 0xd7b0,
};

static ZhiCode codelist532[] = {
 0xbcbd, 0xc0bc, 0xc3b0, 0xadbd, 0xc1a3,
 0xf342, 0xc1a1, 0xc0d0, 0xc4f4, 0xf2b7,
 0xcee0,
};

static ZhiCode codelist533[] = {
 0xbdb3,
};

static ZhiCode codelist552[] = {
 0xd954,
};

static ZhiCode codelist554[] = {
 0xa5d5,
};

static ZhiCode codelist555[] = {
 0xa6ca, 0xc25c, 0xa8d5, 0xc4fc, 0xdae9,
 0xd579, 0xf478, 0xdaf7,
};

static ZhiCode codelist556[] = {
 0xb1d1, 0xabf4, 0xd0f9, 0xe361, 0xd9c1,
 0xdefb, 0xf478, 0xcad1,
};

static ZhiCode codelist560[] = {
 0xad49, 0xaa4d, 0xb464, 0xa8f5, 0xb84f,
 0xadda, 0xb4ae, 0xd453, 0xacd7, 0xbb74,
 0xdb7c, 0xd5b5, 0xd9c1, 0xc9b8, 0xe373,
 0xf3ed, 0xf2d3,
};

static ZhiCode codelist563[] = {
 0xa55f,
};

static ZhiCode codelist564[] = {
 0xb351, 0xb3c6, 0xad49, 0xa8a9, 0xbdfa,
 0xadbf, 0xc175, 0xaf56, 0xbece, 0xaeaf,
 0xa7b8, 0xb548, 0xbb5f, 0xe7c8, 0xaaf5,
 0xdaaa, 0xe44f, 0xbe58, 0xd0fe, 0xeac7,
 0xd5cb, 0xd674, 0xdc58, 0xcfba, 0xd3f8,
 0xe2c8, 0xefc0,
};

static ZhiCode codelist568[] = {
 0xa55d, 0xad4d, 0xad63, 0xbdc7, 0xcf52,
 0xd6dd, 0xeb55, 0xcc55,
};

static ZhiCode codelist570[] = {
 0xb972, 0xc1a1, 0xd2fc, 0xcd6e,
};

static ZhiCode codelist571[] = {
 0xab4f, 0xc45f, 0xb9a1, 0xb3f9, 0xbdc8,
 0xb8b6, 0xe8e9, 0xccaf, 0xe4d7, 0xe4e4,
 0xd8bf,
};

static ZhiCode codelist572[] = {
 0xb3f8, 0xa9ea, 0xbcc9, 0xc37a, 0xb05c,
 0xc06a, 0xa753, 0xd3e5, 0xb95e, 0xeb58,
 0xc5e1, 0xecbc, 0xdbad, 0xde73, 0xd7c2,
 0xefbc, 0xf26f, 0xf449,
};

static ZhiCode codelist584[] = {
 0xaf5a, 0xafeb, 0xb768, 0xb4b3, 0xb97b,
 0xa7e6, 0xbd49, 0xee57, 0xddbd, 0xccc1,
 0xeb78,
};

static ZhiCode codelist587[] = {
 0xaa4f, 0xaaa9, 0xc1f3, 0xa8c1, 0xafea,
 0xccc6, 0xb67a, 0xd349, 0xe3ed,
};

static ZhiCode codelist588[] = {
 0xa562, 0xbfec, 0xa6f1, 0xa7ea, 0xa9d5,
 0xb2cc, 0xa972, 0xc3a4, 0xc962, 0xccad,
 0xd5e4, 0xe0c1, 0xe4bf,
};

static ZhiCode codelist592[] = {
 0xa962, 0xb64e, 0xebe6, 0xcd49, 0xd5eb,
};

static ZhiCode codelist595[] = {
 0xa5bb, 0xaf63, 0xad66,
};

static ZhiCode codelist596[] = {
 0xb2c2, 0xca5e, 0xcaac,
};

static ZhiCode codelist600[] = {
 0xc0b0, 0xa8b9, 0xb3c4, 0xb1f5, 0xf17d,
 0xeadb, 0xd157,
};

static ZhiCode codelist603[] = {
 0xba5d, 0xb86a, 0xe2c6, 0xbb48, 0xe9e8,
};

static ZhiCode codelist604[] = {
 0xb4ce, 0xbd53, 0xc1bd, 0xb046, 0xb3c4,
 0xc2e9, 0xaec7, 0xed72, 0xdceb, 0xeaf5,
};

static ZhiCode codelist608[] = {
 0xb159, 0xc15e, 0xca5b, 0xd54d, 0xcff4,
 0xdc79, 0xe15d, 0xdaed,
};

static ZhiCode codelist610[] = {
 0xacc7,
};

static ZhiCode codelist611[] = {
 0xdb66, 0xcd66, 0xda7d, 0xd4be, 0xe04f,
};

static ZhiCode codelist612[] = {
 0xc2db, 0xdd7b, 0xcf6e, 0xb06e, 0xe067,
};

static ZhiCode codelist640[] = {
 0xb947, 0xcc59, 0xd44d, 0xe344, 0xe7e6,
};

static ZhiCode codelist642[] = {
 0xbbf3,
};

static ZhiCode codelist643[] = {
 0xa4f1, 0xb5a7, 0xa9bc, 0xbbc0, 0xa450,
 0xa85d, 0xcff9, 0xcc59, 0xd3bc, 0xa7ad,
 0xcb70, 0xe65f, 0xcf44, 0xc9f5, 0xe7e7,
};

static ZhiCode codelist644[] = {
 0xa5b2, 0xb1cd, 0xb2a6, 0xbec0, 0xc1d7,
 0xc27a, 0xb3ac, 0xbbc0, 0xc175, 0xb9f4,
 0xb9fa, 0xb141, 0xc0c5, 0xbad1, 0xaa63,
 0xafa6, 0xadda, 0xbdaa, 0xa7c8, 0xb9cd,
 0xb470, 0xb940, 0xb45d, 0xbb74, 0xb0a1,
 0xb0f1, 0xbae8, 0xbf7b, 0xcd71, 0xa4f1,
 0xe958, 0xb844, 0xb64e, 0xf653, 0xc3ce,
 0xcf68, 0xe76e, 0xc2de, 0xf1b9, 0xcc7a,
 0xd54b, 0xd941, 0xddd0, 0xd9f0, 0xd2a5,
 0xe675, 0xedc3, 0xd06c, 0xc1a3, 0xeb7d,
 0xb647, 0xf4d9, 0xcdd3, 0xe0cd, 0xcefc,
 0xd5b2, 0xcfc7, 0xb7f4, 0xe0e2, 0xe4d1,
 0xe8c6, 0xf15d, 0xf7c0, 0xdab7, 0xd8aa,
 0xb963, 0xdecd, 0xdf74, 0xe8d2, 0xcaaf,
 0xe27d, 0xe667, 0xcfdd, 0xcc4c, 0xf372,
 0xf7c6, 0xcf47, 0xca5a, 0xdfe5, 0xe1bf,
 0xe358, 0xe3c9, 0xe857, 0xeae1, 0xec74,
 0xee76, 0xf1d6, 0xf4ca, 0xf67a, 0xf97e,
 0xcdb6, 0xd34b, 0xdefb, 0xe173, 0xe67e,
 0xe971, 0xf14a, 0xedd6,
};

static ZhiCode codelist672[] = {
 0xe578, 0xc5be, 0xf9bd,
};

static ZhiCode codelist674[] = {
 0xa74f, 0xf144, 0xcbdb, 0xe1c1, 0xee76,
 0xee6f,
};

static ZhiCode codelist675[] = {
 0xc3a7, 0xd7a1,
};

static ZhiCode codelist676[] = {
 0xb9fb, 0xedd6,
};

static ZhiCode codelist696[] = {
 0xbcd0, 0xb343, 0xc5df, 0xc3f0, 0xf674,
 0xbda8, 0xe664, 0xe8f0, 0xf2bc, 0xe149,
 0xa840, 0xe2a4, 0xefec, 0xda6e, 0xea6c,
 0xf4a2, 0xe4cd, 0xf9cd, 0xe1e1, 0xecb9,
 0xf2c2, 0xdcad, 0xd449, 0xf0ea, 0xe164,
 0xf348, 0xe75b, 0xf26c, 0xf2cb,
};

static ZhiCode codelist699[] = {
 0xaaed, 0xbff6, 0xb144, 0xe3f7, 0xd0cf,
 0xee74, 0xed46, 0xe7e0,
};

static ZhiCode codelist700[] = {
 0xc5c0,
};

static ZhiCode codelist712[] = {
 0xc3e4, 0xbd73, 0xc340, 0xbdbf, 0xafa2,
 0xf8fb, 0xe6db, 0xe348, 0xda78, 0xe2d6,
 0xcf5f, 0xdde4, 0xde74,
};

static ZhiCode codelist715[] = {
 0xabf3, 0xb653, 0xb0d0, 0xbdca, 0xd2f6,
 0xdfcf, 0xd947, 0xe2f3,
};

static ZhiCode codelist716[] = {
 0xab4b, 0xc5dc, 0xb94d, 0xbfeb, 0xc547,
 0xa858, 0xc47c, 0xcad9, 0xa5af, 0xa8bc,
 0xcae7, 0xe6ec, 0xe74b, 0xa4cb, 0xd971,
 0xcb5a, 0xecaa, 0xe0cf,
};

static ZhiCode codelist720[] = {
 0xbbab, 0xc0d8, 0xb16c, 0xc262, 0xbeaa,
 0xd979, 0xc47d, 0xc1c7, 0xc378, 0xcbac,
 0xf040, 0xf4c4, 0xf767, 0xe452, 0xc9a2,
 0xd9d7, 0xf37e, 0xf279, 0xf8d3,
};

static ZhiCode codelist724[] = {
 0xc26c, 0xc64b, 0xbeaa, 0xece8, 0xc2c1,
 0xf8d4, 0xf5ab,
};

static ZhiCode codelist736[] = {
 0xa74c, 0xa642, 0xd57c, 0xd1d9,
};

static ZhiCode codelist739[] = {
 0xbbe6, 0xa4fe, 0xb85b, 0xac60, 0xaac3,
 0xacb1, 0xcef4, 0xcdd4, 0xcc7d, 0xef40,
 0xbbd0, 0xd7ae, 0xcddc, 0xd07e, 0xd2f7,
 0xabcc, 0xceb5,
};

static ZhiCode codelist740[] = {
 0xa8c3, 0xaf66, 0xa8d6, 0xa67d, 0xb4ac,
 0xd8d6, 0xef78, 0xd452,
};

static ZhiCode codelist768[] = {
 0xd7e3, 0xd5aa, 0xe8c2, 0xd16c, 0xf1d1,
};

static ZhiCode codelist770[] = {
 0xa4a3,
};

static ZhiCode codelist771[] = {
 0xb8c9, 0xaeb7, 0xae48, 0xadf7, 0xa452,
 0xe0eb, 0xe67b,
};

static ZhiCode codelist772[] = {
 0xa4a3, 0xb3a1, 0xa5ac, 0xa842, 0xa9c6,
 0xa747, 0xc3af, 0xb0f0, 0xb95a, 0xe74f,
 0xedcb, 0xd1ca, 0xcbec,
};

static ZhiCode codelist1024[] = {
 0xa375,
};

static ZhiCode codelist1032[] = {
 0xad77, 0xb8b4, 0xb0d4, 0xd3c1, 0xd372,
};

static ZhiCode codelist1034[] = {
 0xaaa6, 0xa5b6, 0xb55d, 0xafd2, 0xaa49,
 0xd7da,
};

static ZhiCode codelist1036[] = {
 0xa9c8, 0xa9ac, 0xcacb, 0xd7bd,
};

static ZhiCode codelist1040[] = {
 0xaa69, 0xbce2, 0xa959, 0xab40, 0xf4fa,
 0xcfde, 0xd6f8,
};

static ZhiCode codelist1042[] = {
 0xb143, 0xbe49, 0xed78, 0xefe5,
};

static ZhiCode codelist1043[] = {
 0xbbe1, 0xade5, 0xa572, 0xd6db,
};

static ZhiCode codelist1044[] = {
 0xaf7d, 0xada2, 0xbe7a, 0xacc4, 0xaa79,
 0xa6b5, 0xb2cb, 0xc3e6, 0xcc6a, 0xd273,
 0xe3ba,
};

static ZhiCode codelist1064[] = {
 0xa9e7, 0xb0d4,
};

static ZhiCode codelist1066[] = {
 0xb1c6, 0xb550, 0xb172, 0xadd6, 0xf06c,
 0xd9d3,
};

static ZhiCode codelist1067[] = {
 0xf478, 0xcdeb,
};

static ZhiCode codelist1068[] = {
 0xaca3, 0xb4fb, 0xeece, 0xdfd5,
};

static ZhiCode codelist1072[] = {
 0xad46, 0xa941, 0xa7a5, 0xe85b, 0xcf42,
 0xcc5f, 0xd14e, 0xd3cf,
};

static ZhiCode codelist1074[] = {
 0xb0f6, 0xbddf, 0xb3ad, 0xbb70, 0xcdd6,
 0xdee5, 0xd9e3, 0xd849, 0xd379,
};

static ZhiCode codelist1075[] = {
 0xdaa6, 0xcef1,
};

static ZhiCode codelist1076[] = {
 0xb074, 0xa8d8, 0xa84b, 0xaf5c, 0xe8ae,
 0xcc6e, 0xd1cf, 0xd253, 0xc5af, 0xce72,
 0xd6fb, 0xc9b5,
};

static ZhiCode codelist1080[] = {
 0xa9df, 0xd74b,
};

static ZhiCode codelist1082[] = {
 0xb354, 0xa948, 0xa753, 0xb0cc, 0xa9b4,
 0xe8f0, 0xcfb2, 0xf5be, 0xe4c6, 0xacb6,
 0xd2bd,
};

static ZhiCode codelist1083[] = {
 0xb65d,
};

static ZhiCode codelist1084[] = {
 0xaa77, 0xafa5, 0xacb6, 0xaf70, 0xcc43,
 0xecb3, 0xe8d7,
};

static ZhiCode codelist1088[] = {
 0xade5, 0xca7d,
};

static ZhiCode codelist1090[] = {
 0xd568, 0xb8cf, 0xcaeb, 0xd1bc,
};

static ZhiCode codelist1091[] = {
 0xade5, 0xdec0, 0xd9ab, 0xd4e0,
};

static ZhiCode codelist1096[] = {
 0xbcef, 0xc36b, 0xcfe3,
};

static ZhiCode codelist1098[] = {
 0xbd4c, 0xbd59, 0xc2cf, 0xafeb, 0xad44,
 0xba6e, 0xc2da, 0xeda8, 0xbded, 0xf3a3,
 0xdd5c, 0xead9, 0xcefd, 0xeff8, 0xe3d2,
 0xdcfd, 0xe1d9, 0xdbf0,
};

static ZhiCode codelist1099[] = {
 0xcbfe,
};

static ZhiCode codelist1100[] = {
 0xa750, 0xab71, 0xacdf, 0xaf60, 0xa9e9,
 0xd7b5, 0xccf1, 0xf94b, 0xdbe2, 0xd84e,
 0xde64, 0xcb58, 0xcfb8, 0xe4cb,
};

static ZhiCode codelist1104[] = {
 0xbc51, 0xe9de,
};

static ZhiCode codelist1106[] = {
 0xacd6, 0xda4b, 0xdfe1,
};

static ZhiCode codelist1107[] = {
 0xcbeb, 0xf07b, 0xd6fd,
};

static ZhiCode codelist1112[] = {
 0xa5e3, 0xbd53, 0xb7bc,
};

static ZhiCode codelist1114[] = {
 0xaec7, 0xc365, 0xbb48, 0xbfc0, 0xb74b,
 0xe3ae, 0xcdf7, 0xcabe, 0xdca7, 0xd3ef,
 0xd178, 0xeab8, 0xdb59,
};

static ZhiCode codelist1115[] = {
 0xdcdf, 0xeae5,
};

static ZhiCode codelist1116[] = {
 0xad44,
};

static ZhiCode codelist1120[] = {
 0xaf79, 0xb269, 0xa9e1, 0xcc7b, 0xe2a7,
 0xbcea, 0xca71, 0xe0d0, 0xcec2, 0xdbfc,
 0xe8c7, 0xeaa6,
};

static ZhiCode codelist1122[] = {
 0xaa42, 0xb45e, 0xbcea, 0xbdb4, 0xbfb1,
 0xb84e, 0xb4d7, 0xc450, 0xc14f, 0xf0be,
 0xcba2, 0xd5f2, 0xf1bd, 0xded2, 0xec40,
 0xd0d6, 0xe84c, 0xdcbd, 0xec58, 0xef68,
 0xe57e, 0xe5e9, 0xf84c,
};

static ZhiCode codelist1123[] = {
 0xb1b7, 0xd6a5,
};

static ZhiCode codelist1124[] = {
 0xb849, 0xd4b8, 0xd56b, 0xd9ae,
};

static ZhiCode codelist1152[] = {
 0xa7e5, 0xa9dc, 0xa4c7, 0xbc41, 0xc552,
 0xcfec, 0xb351, 0xa541, 0xcbf2, 0xa7a5,
 0xca60, 0xcd5f, 0xafc4, 0xd2ef, 0xb965,
 0xe8ef, 0xccae, 0xd6f8, 0xdc6d, 0xece0,
 0xe47c, 0xe8c9, 0xe8d3,
};

static ZhiCode codelist1154[] = {
 0xa5d6, 0xaf68, 0xb5ca, 0xb55c, 0xaa4a,
 0xbb74, 0xb0e0, 0xac73, 0xb0f1, 0xa85d,
 0xeeb7, 0xab40, 0xf2bc, 0xbd7d, 0xafc4,
 0xd7ef, 0xb3b2, 0xc567, 0xb965, 0xe3a8,
 0xcf69, 0xcbad, 0xd7af, 0xe3eb, 0xcd68,
 0xd341, 0xdc66, 0xebed, 0xec77, 0xee66,
 0xf270, 0xccec, 0xd666, 0xf2d3, 0xf7d7,
};

static ZhiCode codelist1155[] = {
 0xa75f, 0xa4c7, 0xa5d4, 0xb56c, 0xf1f1,
 0xd0a1, 0xa5f6, 0xc979, 0xc9c8, 0xd4fd,
 0xe7de,
};

static ZhiCode codelist1156[] = {
 0xc4b4, 0xc550, 0xbbf7, 0xb742, 0xa7be,
 0xb940, 0xc27d, 0xf049, 0xe9a4, 0xe9ed,
 0xed57, 0xd5ed, 0xd95c, 0xe276, 0xf8e5,
 0xe8d6, 0xf059,
};

static ZhiCode codelist1184[] = {
 0xbf68, 0xba4a, 0xc97e,
};

static ZhiCode codelist1187[] = {
 0xba4a,
};

static ZhiCode codelist1208[] = {
 0xc4c6, 0xba7d, 0xe1c9, 0xee5f, 0xf0b7,
 0xdcb8, 0xecf1, 0xede6, 0xf6a8,
};

static ZhiCode codelist1210[] = {
 0xbf5d, 0xb9e2, 0xd641,
};

static ZhiCode codelist1211[] = {
 0xba7d, 0xd767, 0xc165, 0xbf67, 0xd5dc,
 0xf470, 0xe1e1, 0xf14f, 0xf26e, 0xf6ba,
};

static ZhiCode codelist1212[] = {
 0xb2bc, 0xba7d, 0xb6d1, 0xc559, 0xe1c0,
 0xedbf, 0xf54e, 0xe75b,
};

static ZhiCode codelist1224[] = {
 0xbd67, 0xb0be, 0xabf3, 0xbda1, 0xdfcf,
 0xd8be, 0xdbec, 0xe8ba, 0xf5ab,
};

static ZhiCode codelist1226[] = {
 0xab4b, 0xafe2, 0xc063, 0xebab, 0xebc5,
 0xdde1, 0xec6b,
};

static ZhiCode codelist1228[] = {
 0xa4f9, 0xc446, 0xb94d,
};

static ZhiCode codelist1232[] = {
 0xabf7, 0xabb9, 0xf2a3, 0xd263,
};

static ZhiCode codelist1234[] = {
 0xb368, 0xc378, 0xc057, 0xc649, 0xc0a7,
 0xf1f5, 0xf279,
};

static ZhiCode codelist1235[] = {
 0xab7e,
};

static ZhiCode codelist1236[] = {
 0xb875, 0xa6c9,
};

static ZhiCode codelist1248[] = {
 0xa5e2, 0xae5c, 0xd2dd, 0xe8b9, 0xee7b,
};

static ZhiCode codelist1250[] = {
 0xa5ad, 0xb27e, 0xbecc, 0xb5fb, 0xabcc,
 0xc4ab, 0xb5d3, 0xa957, 0xac69, 0xccf2,
 0xceb0, 0xcf6e, 0xdafc, 0xe075, 0xcde5,
 0xcfcc, 0xcb6e, 0xd06d, 0xd0b7, 0xcbe9,
 0xe34d, 0xdb5b, 0xdbb2, 0xb6be, 0xd3b1,
 0xdfa9, 0xcfb0,
};

static ZhiCode codelist1251[] = {
 0xdaed,
};

static ZhiCode codelist1280[] = {
 0xbcb3, 0xa4b2, 0xbe51, 0xbc50, 0xa5b7,
 0xdab1, 0xf35f, 0xccb7, 0xeda3,
};

static ZhiCode codelist1282[] = {
 0xb9b2, 0xbeeb, 0xb8b2, 0xbb5a, 0xb5d0,
 0xa6b5, 0xc3da, 0xb2e3, 0xc0e4, 0xbf5c,
 0xab6d, 0xb340, 0xe3bc, 0xf0d6, 0xe472,
 0xb07a, 0xf4f5, 0xf359, 0xf4af, 0xe54e,
};

static ZhiCode codelist1283[] = {
 0xb4b6, 0xaefa, 0xae48, 0xc3d0, 0xae45,
 0xb7c1, 0xd650, 0xe9e8, 0xf4ea, 0xe656,
 0xbba7,
};

static ZhiCode codelist1284[] = {
 0xbcc9, 0xbe51, 0xc272, 0xc36e, 0xe745,
};

static ZhiCode codelist1536[] = {
 0xa376,
};

static ZhiCode codelist1544[] = {
 0xb6fd, 0xb6dc, 0xc0a8,
};

static ZhiCode codelist1546[] = {
 0xb3c2, 0xb7f2, 0xb9c0, 0xbbf2, 0xc1b0,
 0xe673,
};

static ZhiCode codelist1547[] = {
 0xb0a8, 0xbfc2, 0xbd58, 0xbabf, 0xde62,
 0xb6dc, 0xf156, 0xf6c5, 0xe14d,
};

static ZhiCode codelist1548[] = {
 0xbd7c, 0xe6cc, 0xd858, 0xe259,
};

static ZhiCode codelist1549[] = {
 0xb9c0, 0xb6dc, 0xc1b0,
};

static ZhiCode codelist1552[] = {
 0xba4e,
};

static ZhiCode codelist1554[] = {
 0xbcd2, 0xbf69, 0xbcaf, 0xbda4, 0xc155,
 0xc55d, 0xbcb1, 0xc2d3, 0xc4a8, 0xf5c2,
 0xe172, 0xf2d7, 0xf6a2,
};

static ZhiCode codelist1555[] = {
 0xa9d9,
};

static ZhiCode codelist1556[] = {
 0xa5bd, 0xb2f6, 0xc071, 0xba7a, 0xa853,
 0xbda4, 0xb9e6, 0xadaf, 0xaa5c, 0xafdf,
 0xaa6a, 0xafb0, 0xad5b, 0xc55a, 0xbea5,
 0xb8e7, 0xbf69, 0xea70, 0xe4c0, 0xcceb,
 0xf3b1, 0xe46e, 0xf5eb, 0xf177, 0xefbb,
 0xd6af, 0xea7e, 0xf2d7, 0xe5c9, 0xcefe,
 0xf26d, 0xcc45, 0xc945, 0xe4b1, 0xf368,
 0xf0f1, 0xd6e0, 0xdbbe, 0xdbc5, 0xe14b,
 0xe166, 0xe1ce, 0xf0c5, 0xf6a3, 0xd772,
 0xdffb, 0xedd5, 0xe14d,
};

static ZhiCode codelist1557[] = {
 0xbbf2,
};

static ZhiCode codelist1565[] = {
 0xbbf2,
};

static ZhiCode codelist1578[] = {
 0xae49, 0xc5b5, 0xf0b4,
};

static ZhiCode codelist1579[] = {
 0xb652, 0xe547, 0xf868,
};

static ZhiCode codelist1580[] = {
 0xbde6, 0xb3c1, 0xc1da, 0xafdf, 0xe4f4,
 0xe7b1,
};

static ZhiCode codelist1586[] = {
 0xa853, 0xb7d1, 0xacdc, 0xaa54, 0xb1f6,
 0xb443, 0xb2f9, 0xbe60, 0xaab4, 0xc5f0,
 0xb7b0, 0xb544, 0xd8dd, 0xd0a3, 0xe2fb,
 0xdc53, 0xd8ab, 0xdebb, 0xd751, 0xe871,
 0xca7a, 0xdf75, 0xe15f, 0xecdd, 0xf44b,
};

static ZhiCode codelist1587[] = {
 0xacfc, 0xa843, 0xc1e2, 0xd25a, 0xdcf6,
 0xd9ed, 0xd8c3, 0xd1c0, 0xea54,
};

static ZhiCode codelist1588[] = {
 0xa966, 0xb441, 0xb44b, 0xac4e, 0xd2ce,
 0xbe79, 0xb7e8, 0xaa7a, 0xb04c, 0xdab6,
 0xe4c9, 0xde71, 0xe7ae,
};

static ZhiCode codelist1592[] = {
 0xbfdf,
};

static ZhiCode codelist1594[] = {
 0xa4f2, 0xad54, 0xa5d9, 0xbbec, 0xc1e3,
 0xd1d1, 0xee69, 0xcdbb, 0xe7ba, 0xe8d5,
 0xd8cb, 0xd8a8, 0xd35d, 0xd7f6, 0xe55c,
 0xf5a3, 0xccda, 0xd7dc, 0xda55,
};

static ZhiCode codelist1595[] = {
 0xa566, 0xcef6, 0xaa7d, 0xad67,
};

static ZhiCode codelist1596[] = {
 0xb455, 0xab5f, 0xbbaa, 0xb654, 0xad5a,
 0xb7e8, 0xc0b7, 0xd1d1, 0xacfe, 0xd8b9,
 0xddd5, 0xcfe4, 0xe2e7, 0xcdbb, 0xd7c0,
 0xde41, 0xe748, 0xdfc0, 0xe85a,
};

static ZhiCode codelist1602[] = {
 0xbfd1, 0xb2b6, 0xc15b, 0xa6c8, 0xcbc6,
 0xe7ba, 0xeede, 0xdbbf, 0xefad, 0xcfa8,
 0xe4b5, 0xefa4, 0xcbed, 0xce4e,
};

static ZhiCode codelist1603[] = {
 0xac59, 0xc94e, 0xe45e,
};

static ZhiCode codelist1610[] = {
 0xc65a, 0xc443, 0xbf66, 0xc2da, 0xbaa9,
 0xf54f, 0xf0e3, 0xc5c1, 0xe6a4, 0xd1ab,
 0xe1ca, 0xe5d8, 0xf6a5, 0xf6a4,
};

static ZhiCode codelist1611[] = {
 0xbaa1, 0xae5e, 0xf8b4,
};

static ZhiCode codelist1612[] = {
 0xba43, 0xbaa9, 0xb0d2, 0xbdaf, 0xb9f7,
 0xe170, 0xc3ee, 0xc167, 0xe15b, 0xe672,
 0xea42, 0xdcbb, 0xe2cd,
};

static ZhiCode codelist1616[] = {
 0xb465,
};

static ZhiCode codelist1618[] = {
 0xaaf9, 0xadcc, 0xb1bf, 0xe5d2, 0xebea,
 0xeab0, 0xdbaf, 0xf9c7,
};

static ZhiCode codelist1619[] = {
 0xe5c8,
};

static ZhiCode codelist1620[] = {
 0xb465, 0xbf54, 0xc256,
};

static ZhiCode codelist1621[] = {
 0xadcc,
};

static ZhiCode codelist1626[] = {
 0xa6a3, 0xa87e, 0xafed, 0xaabc, 0xaa5d,
 0xcabe, 0xdac9, 0xca51, 0xd0f6, 0xcab1,
 0xa841, 0xcd76, 0xe86c, 0xd160, 0xd65d,
 0xdab3, 0xdfe7, 0xef5c, 0xf4c0, 0xf878,
 0xd042,
};

static ZhiCode codelist1627[] = {
 0xb2f5, 0xc1af, 0xe2a5, 0xc9f9, 0xd178,
 0xdac7, 0xdb5c, 0xe169,
};

static ZhiCode codelist1634[] = {
 0xbb58, 0xb7f9, 0xb5de, 0xc3a9, 0xc261,
 0xc0db, 0xc263, 0xc36a, 0xecdc, 0xbf5f,
 0xea7b, 0xf4b6, 0xad6a, 0xefda, 0xcd70,
 0xf2a4, 0xefea, 0xe0d6, 0xd766, 0xe8f7,
 0xeb45, 0xebd5, 0xeec4, 0xf777, 0xf960,
};

static ZhiCode codelist1635[] = {
 0xb272, 0xbb67, 0xbb53, 0xbff8, 0xc36a,
 0xf4c8, 0xece7, 0xdec1,
};

static ZhiCode codelist1636[] = {
 0xb9da, 0xa973, 0xf771, 0xf178,
};

static ZhiCode codelist1664[] = {
 0xab7d, 0xbd4e,
};

static ZhiCode codelist1666[] = {
 0xb067, 0xc0b1, 0xc1bc, 0xc46a, 0xc3fb,
 0xc153, 0xc247, 0xeddd, 0xf46e, 0xf7f3,
 0xcbcd, 0xf5b2, 0xeec5, 0xf8c7, 0xefe4,
 0xf5f2, 0xf6e1, 0xf6f1, 0xf7e6, 0xefaa,
 0xf95e,
};

static ZhiCode codelist1667[] = {
 0xa6cc, 0xc3fb, 0xabda, 0xaec5, 0xd6a9,
 0xe477, 0xd9f7, 0xdfbe, 0xe76b, 0xed51,
 0xf6e9,
};

static ZhiCode codelist1668[] = {
 0xb14b, 0xbb65, 0xafb5, 0xafa6, 0xb356,
 0xaa63, 0xa851, 0xc1c4, 0xcc57, 0xbead,
 0xdce2, 0xe96d, 0xe8f2, 0xf2bb, 0xdd59,
 0xe2b7, 0xa6cd, 0xcea2, 0xe258, 0xe26d,
 0xe74c, 0xf643, 0xe147,
};

static ZhiCode codelist1696[] = {
 0xaba7, 0xc941, 0xaacb,
};

static ZhiCode codelist1700[] = {
 0xb7c0, 0xbdb0, 0xf647, 0xc14e, 0xf642,
 0xefc5, 0xdbd0, 0xdda9, 0xee47, 0xefcb,
 0xeff1, 0xf47a, 0xf977,
};

static ZhiCode codelist1720[] = {
 0xd870,
};

static ZhiCode codelist1722[] = {
 0xad5d, 0xb479, 0xbacb, 0xf85e,
};

static ZhiCode codelist1723[] = {
 0xaced, 0xb4f9, 0xc2c6, 0xc2e4, 0xbd7a,
 0xaa48, 0xace0, 0xd9e7, 0xaa57, 0xe6da,
};

static ZhiCode codelist1724[] = {
 0xa7ae, 0xbc71, 0xc15b, 0xcfc6,
};

static ZhiCode codelist1728[] = {
 0xd0f3,
};

static ZhiCode codelist1732[] = {
 0xc2d5,
};

static ZhiCode codelist1738[] = {
 0xb4d6, 0xbaf8, 0xaf76, 0xd8b6, 0xd4ed,
 0xe7aa, 0xf251, 0xf27a, 0xf476,
};

static ZhiCode codelist1739[] = {
 0xa74b, 0xab6a, 0xbd71, 0xb0c3, 0xae59,
 0xc053, 0xb542, 0xa85c, 0xb0c1, 0xcfe2,
 0xdf5f, 0xc94d, 0xcde9, 0xd94d, 0xd879,
 0xf1c9,
};

static ZhiCode codelist1740[] = {
 0xadb1, 0xc4d1,
};

static ZhiCode codelist1746[] = {
 0xa5c1, 0xa9a2, 0xaab3, 0xe6e8, 0xded0,
 0xd0a2, 0xcc78, 0xccc9, 0xe0c3, 0xccc5,
 0xec42, 0xd35e, 0xec4a, 0xcc7e, 0xd4fe,
 0xddc3,
};

static ZhiCode codelist1747[] = {
 0xb1d3, 0xbca7, 0xb67b, 0xbbd4, 0xa9d7,
 0xaa7b, 0xa5d7, 0xb543, 0xb75d, 0xe0ef,
 0xbf49, 0xd6d0, 0xcee8, 0xca6e, 0xe4ec,
 0xf06a, 0xddbc, 0xe65e,
};

static ZhiCode codelist1762[] = {
 0xa9fa, 0xa657, 0xbbef, 0xbbca, 0xbfc1,
 0xaddf, 0xbd50, 0xba5c, 0xaffa, 0xb955,
 0xde48, 0xe3b2, 0xe0a5, 0xcf79, 0xe240,
 0xdcf3, 0xee79, 0xe051, 0xe2bb,
};

static ZhiCode codelist1763[] = {
 0xd6ae, 0xce71, 0xdd6f,
};

static ZhiCode codelist1764[] = {
 0xa952, 0xba5c,
};

static ZhiCode codelist1794[] = {
 0xbcd2, 0xe5f5,
};

static ZhiCode codelist1795[] = {
 0xa5c0, 0xaf61, 0xa864, 0xa969, 0xa9e6,
 0xcfbc, 0xe0be, 0xabbe, 0xcea8, 0xd2e4,
};

static ZhiCode codelist1796[] = {
 0xa4ec, 0xa5d8, 0xb9f5, 0xaaaa, 0xbc7d,
 0xb9d3, 0xb6d2, 0xbf70, 0xb7fc, 0xbcc7,
 0xa84e, 0xad60, 0xf5ad, 0xdde6, 0xe8af,
 0xe0bb, 0xcd56, 0xcbf8, 0xd241, 0xd3be,
 0xe1b3, 0xf17e, 0xd771,
};

static ZhiCode codelist2048[] = {
 0xa377,
};

static ZhiCode codelist2056[] = {
 0xb56f, 0xa5ef, 0xe2e5,
};

static ZhiCode codelist2058[] = {
 0xa546, 0xa5ef, 0xbb40, 0xbbd6, 0xb5ad,
 0xaf7c, 0xd3ab, 0xaa6b, 0xd2ca, 0xf0b2,
};

static ZhiCode codelist2059[] = {
 0xaa6b, 0xbe76,
};

static ZhiCode codelist2060[] = {
 0xaa6b, 0xb557,
};

static ZhiCode codelist2066[] = {
 0xa6f2, 0xcbf3,
};

static ZhiCode codelist2096[] = {
 0xab44, 0xadb8, 0xb5e1, 0xb476, 0xb0d8,
 0xa66d, 0xe36e, 0xc050, 0xef57, 0xf1b4,
 0xf3d6, 0xf3b9, 0xd4da, 0xe3fd,
};

static ZhiCode codelist2098[] = {
 0xaace, 0xd5f3, 0xb5cc, 0xdb78, 0xe3f3,
};

static ZhiCode codelist2099[] = {
 0xadea, 0xbb42, 0xb4b4, 0xe3f2, 0xbdda,
 0xd55e, 0xb5e1, 0xcef9, 0xd9c6, 0xe249,
 0xeabd, 0xd4cd, 0xef4b,
};

static ZhiCode codelist2100[] = {
 0xbc6f, 0xb64f, 0xaacd, 0xaa6d, 0xa770,
 0xb7f3, 0xa9cc, 0xd2c8, 0xaae8, 0xb151,
 0xd0eb, 0xcd61, 0xd2e2, 0xeff7, 0xed75,
 0xceed, 0xd057, 0xd0d5, 0xd0ef, 0xe9b6,
 0xefb3, 0xf24d, 0xf0bc, 0xf4f0,
};

static ZhiCode codelist2114[] = {
 0xd04d, 0xaae6, 0xd352, 0xdcc8,
};

static ZhiCode codelist2115[] = {
 0xa75f, 0xa6ce, 0xd9e1, 0xd26f, 0xe8ea,
};

static ZhiCode codelist2120[] = {
 0xb566, 0xc2bd, 0xbfbb, 0xc2ba, 0xbc6e,
 0xa67c, 0xefd9, 0xf5e5, 0xe0fe, 0xe560,
 0xf35a, 0xf85d,
};

static ZhiCode codelist2122[] = {
 0xa45a, 0xb7d0, 0xc163, 0xa67c, 0xbfbb,
 0xc473, 0xc3bf, 0xbcd4, 0xf5fc, 0xea64,
 0xcda8, 0xbc5c, 0xea4f, 0xeaee, 0xf645,
 0xf353, 0xf3ab, 0xd6da, 0xb3ab, 0xf463,
 0xf4f6, 0xe144, 0xe9dc, 0xedf8, 0xf079,
 0xf873, 0xcb47, 0xcf5f, 0xf268,
};

static ZhiCode codelist2123[] = {
 0xa4cf, 0xaaf0, 0xe8e3,
};

static ZhiCode codelist2124[] = {
 0xbd64, 0xad53, 0xa5c7, 0xa5c6, 0xa6c6,
 0xb6ba, 0xb363, 0xaa78, 0xb1eb, 0xcfdb,
 0xd6cb, 0xe46f, 0xc9d2, 0xd3e9, 0xdc4a,
 0xe2b3, 0xe955,
};

static ZhiCode codelist2128[] = {
 0xa4c0, 0xafc9, 0xaae2, 0xaa5e, 0xa768,
 0xb4d9, 0xcd6a, 0xd7f4, 0xdca8, 0xccd0,
 0xdc77, 0xcfef, 0xd364, 0xd3d8, 0xf556,
 0xd5cf, 0xe8ec,
};

static ZhiCode codelist2130[] = {
 0xbc58, 0xb549, 0xa857, 0xccde, 0xd9c8,
 0xd3c7, 0xf346, 0xf1e3, 0xe56e, 0xe5fd,
 0xf356, 0xefb4, 0xcab7, 0xcd5a, 0xd362,
 0xe3cb, 0xf874, 0xcad2, 0xeafd, 0xf663,
};

static ZhiCode codelist2131[] = {
 0xafbb, 0xecb6,
};

static ZhiCode codelist2132[] = {
 0xa5f7, 0xa9c1, 0xbec4, 0xbcab, 0xa4c0,
 0xc154, 0xe0f3, 0xf45c, 0xcaae, 0xcffd,
 0xe8df, 0xe9c3, 0xeaeb, 0xf078,
};

static ZhiCode codelist2136[] = {
 0xa4e8, 0xaada, 0xa77b, 0xaa44, 0xcba8,
 0xd642, 0xdc62, 0xc943, 0xcb4b,
};

static ZhiCode codelist2138[] = {
 0xa9d0, 0xa8be, 0xa7ab, 0xaad5, 0xa77b,
 0xe8db,
};

static ZhiCode codelist2139[] = {
 0xb358, 0xa7cf, 0xa5e9, 0xafbc, 0xadc0,
 0xafe9, 0xccc4, 0xcfd7, 0xe4db, 0xf6c4,
};

static ZhiCode codelist2140[] = {
 0xa9f1,
};

static ZhiCode codelist2144[] = {
 0xadb7, 0xb8c1, 0xabca, 0xc2d7, 0xbac6,
 0xae70, 0xbe57, 0xa4a5, 0xb26c, 0xb7ac,
 0xbfd8, 0xf65a, 0xdfb1, 0xf5d3, 0xdea9,
 0xd1cb, 0xd5d1, 0xcab2, 0xed4a, 0xd467,
 0xd8ef, 0xf747, 0xf9b0, 0xf9cb, 0xda76,
};

static ZhiCode codelist2146[] = {
 0xb37b, 0xc15f, 0xb6be, 0xcab0, 0xda49,
 0xd8b0, 0xdfa7, 0xe1ea,
};

static ZhiCode codelist2147[] = {
 0xd477, 0xd7c5,
};

static ZhiCode codelist2148[] = {
 0xa95e, 0xbbf1, 0xadc4, 0xbfd8, 0xc15f,
 0xebb4, 0xda63,
};

static ZhiCode codelist2236[] = {
 0xdffa,
};

static ZhiCode codelist2304[] = {
 0xa4d2, 0xbda7, 0xbcc5, 0xb9e5, 0xa5ed,
 0xbea2, 0xdbfa, 0xb36c, 0xcf53, 0xcfea,
 0xe469, 0xb679, 0xe35b, 0xdb40, 0xd3d1,
 0xdad8, 0xcbaa, 0xccfd, 0xcecd, 0xd169,
 0xd760, 0xdf66, 0xe8e5, 0xcc54, 0xeaca,
 0xf275, 0xd6f0,
};

static ZhiCode codelist2306[] = {
 0xaa41, 0xbad6, 0xa7df, 0xaf42, 0xb2c5,
 0xa5f1, 0xa9bb, 0xbfa3, 0xb454, 0xab52,
 0xa9d8, 0xd07b, 0xa5b1, 0xa7b7, 0xb5f6,
 0xaadc, 0xbfe7, 0xbdbb, 0xb0cb, 0xdfec,
 0xd04d, 0xb265, 0xa4d2, 0xd3fa, 0xd767,
 0xa9cc, 0xd3ba, 0xd5be, 0xb2d1, 0xd3ac,
 0xb5e8, 0xb2d9, 0xcbe0, 0xcf7b, 0xdf5a,
 0xd758, 0xaae8, 0xd070, 0xdfa6, 0xca6c,
 0xcc6d, 0xd6cf, 0xdfb6, 0xd7b7, 0xac74,
 0xd9d2, 0xe651, 0xd64e, 0xcf52, 0xcfd5,
 0xcc66, 0xccd5, 0xce59, 0xceed, 0xcf47,
 0xd679, 0xd77b, 0xebbe, 0xe0ed, 0xc95d,
 0xccf7, 0xd2ea, 0xd6fb, 0xe4ca, 0xebad,
 0xeca7, 0xefb0, 0xf3e8, 0xf57a,
};

static ZhiCode codelist2307[] = {
 0xa9b2, 0xbb47, 0xbcbe, 0xbbb2, 0xa86a,
 0xa9f2, 0xadc1, 0xb079, 0xb2e3, 0xb5c6,
 0xb340, 0xde58, 0xe546, 0xccb9, 0xf3f5,
 0xf064, 0xbe66, 0xd3f4, 0xcc72, 0xf1c4,
 0xddc4, 0xca6b, 0xdff0, 0xd3c5, 0xdc44,
 0xa4f7,
};

static ZhiCode codelist2308[] = {
 0xa4f7, 0xad74, 0xb0fc, 0xa549, 0xaafe,
 0xb449, 0xb45f, 0xb0c6, 0xb3c5, 0xc2d0,
 0xbdc6, 0xb8a1, 0xa94a, 0xad75, 0xbde1,
 0xbe74, 0xaafa, 0xad72, 0xc34c, 0xc1cc,
 0xe7b8, 0xec7b, 0xd2e6, 0xd45e, 0xebcd,
 0xf56e, 0xeed9, 0xe246, 0xce60, 0xd062,
 0xd7a7, 0xdfca, 0xe7b9, 0xe7c4, 0xcc54,
 0xcea5, 0xdbbd, 0xe6ef, 0xeb50,
};

static ZhiCode codelist2404[] = {
 0xcfd9,
};

static ZhiCode codelist2560[] = {
 0xa378,
};

static ZhiCode codelist2568[] = {
 0xb766, 0xbfca, 0xb5aa, 0xe5bc, 0xbd44,
 0xc4be, 0xcbde, 0xd055,
};

static ZhiCode codelist2570[] = {
 0xb5aa, 0xb946, 0xc5b6, 0xbbde, 0xbd44,
 0xa9cd, 0xf2b8, 0xe8fd, 0xcc48, 0xd6d4,
 0xd3af, 0xee54, 0xeb7c, 0xf662, 0xd862,
 0xcbe3, 0xd67b, 0xcfaf, 0xf158,
};

static ZhiCode codelist2571[] = {
 0xa5b4,
};

static ZhiCode codelist2572[] = {
 0xa46a,
};

static ZhiCode codelist2586[] = {
 0xb16f, 0xbc77, 0xd5fc,
};

static ZhiCode codelist2589[] = {
 0xaaba, 0xb16f,
};

static ZhiCode codelist2600[] = {
 0xa762, 0xabdd, 0xe2ca,
};

static ZhiCode codelist2603[] = {
 0xa4ef, 0xb665,
};

static ZhiCode codelist2604[] = {
 0xa54e, 0xb161, 0xabdd, 0xb355, 0xc0b9,
 0xabe5, 0xac70, 0xc24c, 0xb655, 0xada4,
 0xa46a, 0xacc5, 0xa9a7, 0xb665, 0xf7fb,
 0xd4b4, 0xf8ce, 0xd6ed, 0xe1b7, 0xc9fb,
 0xc9e0, 0xf467, 0xdc4c, 0xe06f, 0xedf2,
 0xf140, 0xcf63, 0xdd73,
};

static ZhiCode codelist2611[] = {
 0xb16f,
};

static ZhiCode codelist2616[] = {
 0xa44d, 0xa56f, 0xc97b, 0xcdb1, 0xc9f7,
 0xdd5b, 0xe0ea,
};

static ZhiCode codelist2619[] = {
 0xadcb, 0xae71, 0xbec9, 0xc3ab, 0xb76f,
 0xecea, 0xd572, 0xeccb, 0xdef4,
};

static ZhiCode codelist2620[] = {
 0xa8ec, 0xb944, 0xadcb, 0xbd5f, 0xb573,
 0xc1d0, 0xb1a5, 0xbec9, 0xf941, 0xf4b1,
 0xed43, 0xdb71, 0xf6f2,
};

static ZhiCode codelist2624[] = {
 0xb3a3, 0xb0c2, 0xd3f2,
};

static ZhiCode codelist2627[] = {
 0xa4e6, 0xa7dd, 0xb07e, 0xb042, 0xaa55,
 0xd0f2, 0xd977,
};

static ZhiCode codelist2628[] = {
 0xb0ab, 0xa8a7, 0xb372, 0xb56b, 0xc475,
 0xd75e, 0xb2e8, 0xe8c3, 0xe865, 0xd5c6,
 0xd24d, 0xc5aa,
};

static ZhiCode codelist2632[] = {
 0xb3e6, 0xbee1, 0xa4a6, 0xafd4, 0xc2b0,
 0xe858, 0xcfe0, 0xd743, 0xd7f2, 0xcff2,
 0xf048, 0xf0d5, 0xe145, 0xf2c0, 0xe4f5,
 0xf1f4,
};

static ZhiCode codelist2635[] = {
 0xc178, 0xaf6e, 0xbcc2, 0xdcb3, 0xd350,
 0xc9bf, 0xe5b8, 0xcd6c, 0xd3db, 0xf964,
 0xc964, 0xe9fe,
};

static ZhiCode codelist2636[] = {
 0xa6fd, 0xa5b9, 0xb248, 0xb34a, 0xbdcf,
 0xbee1, 0xbc75, 0xbcaa, 0xb4e1, 0xb0dc,
 0xbf46, 0xe97e, 0xe4ee, 0xb0e8, 0xe4fc,
 0xa5db, 0xed76, 0xdf44, 0xe0f8, 0xe96c,
 0xf548, 0xe4dc, 0xdb79, 0xe0ba, 0xe9bb,
 0xcf5c, 0xcacc, 0xe649, 0xcd43, 0xcd63,
 0xdbd5, 0xd878, 0xe3ab, 0xe3f4, 0xe545,
 0xeca5, 0xf050, 0xe9e3, 0xf6ea, 0xcd4c,
};

static ZhiCode codelist2648[] = {
 0xb7ed, 0xbeb4, 0xc54c, 0xc3cb, 0xed68,
 0xf2aa, 0xbbfd, 0xf2df, 0xea40, 0xf2c4,
 0xdd4e,
};

static ZhiCode codelist2651[] = {
 0xc0c9, 0xc4d2, 0xbed7, 0xc66d, 0xf7dc,
 0xf8ac, 0xd0de,
};

static ZhiCode codelist2652[] = {
 0xb7ed, 0xbfba, 0xbed7, 0xc0fa, 0xe2ee,
 0xcc58, 0xdba5, 0xe07e, 0xed66, 0xd945,
 0xdec2, 0xf05d, 0xf061, 0xf66d,
};

static ZhiCode codelist2656[] = {
 0xb56e, 0xbf4f, 0xf4f1, 0xf068, 0xe053,
 0xea66, 0xe55d,
};

static ZhiCode codelist2659[] = {
 0xb5a5, 0xdd75,
};

static ZhiCode codelist2660[] = {
 0xbe48, 0xc0fc, 0xc3de, 0xb9b9, 0xbc6a,
 0xc145, 0xe54c, 0xebd3, 0xf549,
};

static ZhiCode codelist2688[] = {
 0xa743, 0xba77, 0xa5c2, 0xd6f4, 0xf17a,
 0xcc77, 0xedad, 0xeed7, 0xd7be, 0xdb7d,
 0xe161, 0xe669,
};

static ZhiCode codelist2690[] = {
 0xaaba, 0xbcc4, 0xad7d, 0xa866, 0xb2c3,
 0xbab0, 0xbb43, 0xb2fd, 0xb9de, 0xb9bf,
 0xc3e9, 0xf0f8, 0xaade, 0xbab9, 0xf740,
 0xf753, 0xedc1, 0xe77b, 0xdcab, 0xd5d2,
 0xe660, 0xd074, 0xecc9, 0xf95f, 0xf0af,
 0xf2ca,
};

static ZhiCode codelist2691[] = {
 0xa9b3, 0xa9e8, 0xaaf3, 0xb643, 0xacbb,
 0xafa1, 0xa5c2, 0xcbfb, 0xac6b, 0xcc73,
 0xdbd3, 0xcbee, 0xcddb, 0xe3a3, 0xdb63,
 0xdc45, 0xcaef,
};

static ZhiCode codelist2692[] = {
 0xa661, 0xb2c4, 0xa7cc, 0xabd2, 0xbbbc,
 0xb8a6, 0xaaba, 0xbd6c, 0xbfcd, 0xae58,
 0xdabb, 0xb4d0, 0xcb41, 0xcb6a, 0xe2f8,
 0xe760, 0xee61, 0xebc2, 0xdde8, 0xda4d,
 0xe2eb, 0xd0a9, 0xd7f9, 0xe5ca, 0xcafa,
 0xd3e8, 0xd5d4, 0xd649, 0xe0e6, 0xe15a,
 0xe1a5, 0xd66b, 0xea69,
};

static ZhiCode codelist2696[] = {
 0xdcdd,
};

static ZhiCode codelist2720[] = {
 0xaf52,
};

static ZhiCode codelist2722[] = {
 0xb65e, 0xbdba, 0xbfd2, 0xbad0, 0xc57c,
 0xada1, 0xb7de, 0xb3e3, 0xd2bc, 0xb5c0,
 0xb5bb, 0xcdfd, 0xce53, 0xd8a2, 0xe3d7,
 0xebc0, 0xf56b, 0xdbf7, 0xcef2, 0xce7b,
 0xcee4, 0xd05d, 0xd079, 0xd2d2, 0xdb45,
 0xdb54, 0xdbdd, 0xdc78, 0xe747, 0xe7c5,
 0xd944, 0xddd1, 0xe1a4,
};

static ZhiCode codelist2744[] = {
 0xc04a, 0xade4, 0xa44e, 0xb649, 0xf3e7,
 0xb84d, 0xa570, 0xb16e, 0xeaa1, 0xdaa4,
 0xc44b, 0xc9eb, 0xd7a2, 0xe0ec, 0xcdc9,
 0xe5f4,
};

static ZhiCode codelist2747[] = {
 0xce78,
};

static ZhiCode codelist2748[] = {
 0xbdd5, 0xb1bc, 0xb3a8, 0xa651, 0xa4dd,
 0xeab4, 0xe773, 0xe04b, 0xc9b9, 0xe4e0,
};

static ZhiCode codelist2752[] = {
 0xa5e1, 0xe4b7,
};

static ZhiCode codelist2760[] = {
 0xc441, 0xc571, 0xc5f6, 0xb7bf, 0xd569,
 0xd859, 0xe6b6, 0xcee7, 0xeeba, 0xe25c,
 0xf968, 0xd865,
};

static ZhiCode codelist2763[] = {
 0xc249, 0xa8e5, 0xb84b, 0xebfc, 0xd4e8,
 0xdaa9, 0xeb47,
};

static ZhiCode codelist2764[] = {
 0xb971, 0xa9b1, 0xb7b5, 0xa86c, 0xb3fe,
 0xb9d4, 0xbefd, 0xb17d, 0xc051, 0xa6fa,
 0xd5e0, 0xacbf, 0xb966, 0xf065, 0xcbf5,
 0xd2c4, 0xf04a, 0xedac, 0xcdd9, 0xced2,
 0xd4de, 0xe7f7, 0xe94e,
};

static ZhiCode codelist2784[] = {
 0xa442, 0xb076, 0xa56d, 0xcb6f, 0xadaa,
 0xa86e, 0xa4b1, 0xca45, 0xc978, 0xd84d,
 0xcdc7,
};

static ZhiCode codelist2787[] = {
 0xb3bb, 0xb9a9, 0xadaa, 0xe1b1, 0xe9ee,
 0xee43,
};

static ZhiCode codelist2788[] = {
 0xa977, 0xad71, 0xb076, 0xbff5, 0xdee4,
 0xd448, 0xd161, 0xd9cc, 0xd57e, 0xe2f4,
 0xef45, 0xdb5f, 0xd472,
};

static ZhiCode codelist2816[] = {
 0xb3a3, 0xb7fe, 0xb9ca, 0xec47, 0xebdc,
};

static ZhiCode codelist2818[] = {
 0xc5aa, 0xbf57, 0xac72, 0xc37c, 0xf941,
 0xc270, 0xc37d, 0xc5ea, 0xf9c8, 0xc675,
 0xc370, 0xecba, 0xdeec, 0xf25a, 0xe7a6,
 0xf75c, 0xf8d1, 0xf8d2, 0xf472,
};

static ZhiCode codelist2819[] = {
 0xbde4, 0xb0f4, 0xb840, 0xbf77, 0xa87b,
 0xec45, 0xe3fe, 0xd545,
};

static ZhiCode codelist2820[] = {
 0xabd7, 0xb4e7, 0xa87b, 0xa7aa, 0xc1e1,
 0xa7f9, 0xc5fb, 0xd6c4, 0xd868,
};

static ZhiCode codelist2832[] = {
 0xa668, 0xa6b7, 0xce47, 0xcefb, 0xd3a9,
};

static ZhiCode codelist2834[] = {
 0xb9dc, 0xc54d, 0xa668, 0xd573, 0xe440,
 0xd0ea, 0xd974, 0xddf2, 0xd469, 0xd5a7,
 0xd76a, 0xd9e4, 0xdb4d, 0xf1c8, 0xf2ec,
};

static ZhiCode codelist2835[] = {
 0xb8fa, 0xa6b7, 0xd8a6, 0xce57, 0xf3fe,
 0xf3c5, 0xd6a3, 0xe063,
};

static ZhiCode codelist2836[] = {
 0xb46b, 0xbc5a, 0xb2eb, 0xb8f6, 0xa8ef,
 0xa946, 0xbfe2, 0xb9a4, 0xce57, 0xe54f,
 0xe56d, 0xcf4f, 0xd0c3, 0xd0c6, 0xabd7,
 0xd7b2, 0xdbe7, 0xf3e3,
};

static ZhiCode codelist2864[] = {
 0xb0ef, 0xe8bd, 0xded4,
};

static ZhiCode codelist2868[] = {
 0xb9ef, 0xb6a4, 0xa749, 0xb850, 0xefc8,
 0xf2f7, 0xed55, 0xf0b3, 0xf658, 0xeff4,
 0xf264, 0xe976,
};

static ZhiCode codelist2888[] = {
 0xbadd, 0xad42, 0xd465, 0xd46b, 0xd8cd,
};

static ZhiCode codelist2891[] = {
 0xb575,
};

static ZhiCode codelist2892[] = {
 0xac71, 0xc25f, 0xbd76, 0xc1eb, 0xe9e4,
 0xdf7c, 0xf8b8, 0xdde0, 0xdfe0, 0xe2f1,
 0xf762,
};

static ZhiCode codelist2896[] = {
 0xb4b0, 0xc3db, 0xbc5b, 0xb1ac, 0xedab,
 0xf7a3, 0xe3d5, 0xe9aa, 0xf4e8,
};

static ZhiCode codelist2899[] = {
 0xacda, 0xc4bb,
};

static ZhiCode codelist2900[] = {
 0xb979, 0xbeb7, 0xacde, 0xb677, 0xb950,
 0xacda, 0xbf4c, 0xa850, 0xa779, 0xe851,
 0xcd57, 0xcaad, 0xcaf4, 0xc9b6, 0xcace,
 0xe654, 0xd8ec, 0xf5a9, 0xdf7b,
};

static ZhiCode codelist2912[] = {
 0xaa46, 0xa556, 0xa94e, 0xc35d, 0xd0a4,
 0xe3d9, 0xd4c0, 0xd4f8, 0xcf6c, 0xcfb5,
 0xd5e8, 0xdbaa, 0xf3f0,
};

static ZhiCode codelist2915[] = {
 0xc0b4, 0xb8b3, 0xe95c, 0xe551,
};

static ZhiCode codelist2916[] = {
 0xb0ca, 0xac7d, 0xade1, 0xb4c9, 0xabf0,
 0xafdb, 0xcedc, 0xd1af, 0xec69, 0xeef9,
};

static ZhiCode codelist3072[] = {
 0xa379,
};

static ZhiCode codelist3080[] = {
 0xa5a6, 0xa54c, 0xa66f, 0xa865, 0xb6f2,
 0xeb7c, 0xcda2, 0xe6cf,
};

static ZhiCode codelist3083[] = {
 0xb6f0, 0xe247, 0xf158,
};

static ZhiCode codelist3084[] = {
 0xbdf1, 0xba66, 0xc1cf, 0xb6f2, 0xc3a1,
 0xddad, 0xbbbd, 0xecc5, 0xc4be, 0xccee,
 0xdcd6, 0xbed8, 0xbbbe, 0xf66b, 0xf159,
 0xf16c, 0xebfd, 0xeefe, 0xf3a1, 0xf6ae,
 0xd04f, 0xd5f0, 0xd85a, 0xe26b, 0xe7db,
 0xf76f, 0xbaaa, 0xcdd0, 0xed4e, 0xf9d5,
};

static ZhiCode codelist3100[] = {
 0xaf53, 0xbc7c, 0xcad6, 0xcad7, 0xe869,
 0xd3e2, 0xf0c9,
};

static ZhiCode codelist3112[] = {
 0xad4c, 0xad61,
};

static ZhiCode codelist3114[] = {
 0xa578, 0xbb4f, 0xa9ef, 0xbbe4, 0xad61,
 0xcdd7, 0xb660, 0xc269, 0xc2ca, 0xcfb1,
 0xe8ce, 0xec7c, 0xe8f5, 0xecd5, 0xf4a6,
 0xcafb, 0xd2f0,
};

static ZhiCode codelist3116[] = {
 0xa4d3, 0xba41, 0xaef5, 0xa84f, 0xdc67,
 0xed60, 0xde5e, 0xca79, 0xd856,
};

static ZhiCode codelist3128[] = {
 0xb1c7, 0xc0dc, 0xb7ca, 0xc5b9, 0xc3fc,
 0xcc71, 0xb86c, 0xead6, 0xddb0, 0xdd6d,
 0xe24f, 0xdd5b, 0xe37b, 0xdd45, 0xe3e6,
};

static ZhiCode codelist3130[] = {
 0xb06b, 0xaee7, 0xb3b3, 0xb5e5, 0xb25e,
 0xc0dc, 0xb0de, 0xacab, 0xc276, 0xc268,
 0xcbd7, 0xce42, 0xe370, 0xe4c3, 0xe860,
 0xf1b5, 0xebeb, 0xec66, 0xdef6, 0xec41,
};

static ZhiCode codelist3131[] = {
 0xb051,
};

static ZhiCode codelist3132[] = {
 0xae4d,
};

static ZhiCode codelist3136[] = {
 0xb0bd, 0xd8c1,
};

static ZhiCode codelist3138[] = {
 0xc059, 0xa7eb, 0xdea4, 0xd7f3,
};

static ZhiCode codelist3139[] = {
 0xefae, 0xcc44, 0xd359, 0xdc6f, 0xf5f5,
};

static ZhiCode codelist3140[] = {
 0xb37a, 0xe9b2,
};

static ZhiCode codelist3141[] = {
 0xc059,
};

static ZhiCode codelist3144[] = {
 0xb367, 0xc579, 0xc575, 0xc5f5, 0xa77e,
 0xcec0, 0xccbe, 0xd752, 0xe364, 0xb1b4,
};

static ZhiCode codelist3146[] = {
 0xbdcd, 0xbc75, 0xb7f0, 0xbce6, 0xc3d3,
 0xc0c8, 0xbec2, 0xbee8, 0xc2bb, 0xb5f7,
 0xd7e8, 0xebe0, 0xec5c, 0xf77a, 0xf4ec,
 0xd0cb, 0xf35e, 0xf347, 0xd4df, 0xe5a1,
 0xf2c6, 0xe9c5, 0xf6cc, 0xf867,
};

static ZhiCode codelist3147[] = {
 0xa95a, 0xb4e0, 0xb352, 0xf2e9, 0xcad8,
 0xedaf, 0xdb65, 0xf34a, 0xe154, 0xede8,
 0xe5ab, 0xebd8, 0xe3f6,
};

static ZhiCode codelist3148[] = {
 0xb1b4, 0xb9c4, 0xbcdb, 0xbad2, 0xacb4,
 0xe7ee, 0xd4bc, 0xda45, 0xe6f3,
};

static ZhiCode codelist3160[] = {
 0xb4f6, 0xc3ed, 0xf8e9, 0xf141, 0xe7b0,
};

static ZhiCode codelist3162[] = {
 0xb0f3, 0xbf7d, 0xadf0, 0xb6ed, 0xbda3,
 0xc1ae, 0xb4c5, 0xc1de, 0xb765, 0xc3ed,
 0xde46, 0xeb5d, 0xbac1, 0xeeb9, 0xe1fd,
 0xe5e8, 0xe2b5, 0xe2c1, 0xf15f, 0xf378,
 0xe9d9, 0xe3b1, 0xe6c9, 0xebc3, 0xedfd,
 0xf6b3,
};

static ZhiCode codelist3163[] = {
 0xadd5, 0xbdf6, 0xc56c, 0xb249, 0xa9ae,
 0xd55c, 0xf9bf, 0xf166, 0xf7da, 0xf8aa,
 0xf8b1, 0xf8f8,
};

static ZhiCode codelist3164[] = {
 0xbdeb, 0xbf53, 0xf4e7, 0xe1f2,
};

static ZhiCode codelist3170[] = {
 0xaf6b, 0xc4cb, 0xc3c3, 0xc4f0, 0xc1c3,
 0xbcf0, 0xeb66, 0xead7,
};

static ZhiCode codelist3200[] = {
 0xb1e8, 0xbdf0, 0xade7, 0xd649,
};

static ZhiCode codelist3202[] = {
 0xc344, 0xb4a3, 0xb3da, 0xb3f6, 0xbfe1,
 0xebdb, 0xe2fd, 0xdad7, 0xbd7b, 0xd377,
 0xf3bb, 0xb6ac, 0xf5a5, 0xd94e, 0xcdf6,
 0xeee0, 0xd456, 0xebbc, 0xeea9, 0xf578,
 0xd8ea, 0xe2e3, 0xe7af, 0xeb4a, 0xf867,
 0xf56c, 0xf1cf,
};

static ZhiCode codelist3203[] = {
 0xc5e9, 0xca5e, 0xdf57,
};

static ZhiCode codelist3204[] = {
 0xb4c0, 0xb1a7, 0xaef7, 0xb150, 0xaead,
 0xab63, 0xbe4f, 0xc0a1, 0xd0d7, 0xee4b,
 0xe5f3, 0xe3fc, 0xd956, 0xf4a8, 0xf1bc,
 0xd552, 0xe7c2, 0xb37c, 0xf1cf,
};

static ZhiCode codelist3232[] = {
 0xb64b, 0xa9ab, 0xcca3,
};

static ZhiCode codelist3235[] = {
 0xc54b, 0xa9ab, 0xf852, 0xe0fd,
};

static ZhiCode codelist3236[] = {
 0xa9ab, 0xc34b, 0xd7a6,
};

static ZhiCode codelist3256[] = {
 0xac44, 0xd6bd, 0xcec9, 0xceb9, 0xef6f,
};

static ZhiCode codelist3258[] = {
 0xb1f8, 0xbdd5, 0xd6d1, 0xa8d9, 0xad7c,
 0xbb6d, 0xe8d4, 0xcc67, 0xd071, 0xf5bb,
 0xf7b2, 0xec55, 0xca4c, 0xf16b, 0xe066,
 0xd2eb,
};

static ZhiCode codelist3259[] = {
 0xac44, 0xb2c0, 0xe04b, 0xce77, 0xeccf,
};

static ZhiCode codelist3260[] = {
 0xb8f5, 0xb2b7, 0xf8fd, 0xd1d8, 0xb8d0,
 0xbe66, 0xdaf8, 0xeab5, 0xd36d,
};

static ZhiCode codelist3272[] = {
 0xa4d1, 0xb24b, 0xd0dd, 0xcc5a, 0xdc5f,
 0xd4ec,
};

static ZhiCode codelist3274[] = {
 0xa5d0, 0xb2a2, 0xb6f1, 0xabef, 0xc2f5,
 0xaccb, 0xe6d4, 0xccfa, 0xcfe5, 0xd9eb,
 0xdbb0, 0xe6c3,
};

static ZhiCode codelist3275[] = {
 0xbb51, 0xa9bd, 0xcf66, 0xb5c9, 0xc053,
 0xd5ee, 0xe4ce, 0xe7e9, 0xd562, 0xd3c9,
 0xd9a7, 0xded1,
};

static ZhiCode codelist3276[] = {
 0xd56d, 0xde6c, 0xe2d0,
};

static ZhiCode codelist3296[] = {
 0xc5a5, 0xc655, 0xa5c5, 0xd5b9, 0xca4b,
 0xcdaa,
};

static ZhiCode codelist3298[] = {
 0xb0b1, 0xae78, 0xa7ca, 0xab46, 0xb8bb,
 0xbe5e, 0xb440, 0xd9ea, 0xd76c, 0xc9ef,
 0xdf4d, 0xe7bb, 0xe6fb, 0xdfac, 0xf5b9,
 0xddca, 0xe257, 0xe8a8, 0xd8eb, 0xdf5e,
};

static ZhiCode codelist3299[] = {
 0xaebc, 0xb8a5, 0xcb6d, 0xb1f2, 0xec5b,
 0xd670, 0xd74d, 0xe86f, 0xd658, 0xc96e,
 0xcdee,
};

static ZhiCode codelist3300[] = {
 0xc5a5,
};

static ZhiCode codelist3328[] = {
 0xa872, 0xf1dd, 0xd260, 0xd5a1, 0xe1a4,
};

static ZhiCode codelist3330[] = {
 0xb9cf, 0xb37e, 0xacf0, 0xae7b, 0xb6ee,
 0xb14f, 0xa559, 0xb2fe, 0xd25c, 0xa745,
 0xbbc6, 0xdec8, 0xdad9, 0xdf7e, 0xd172,
 0xdfab, 0xf1dd, 0xd1cc, 0xcca8, 0xeeec,
 0xe459, 0xd5d3, 0xda4c, 0xdf50, 0xe3ad,
 0xe6ab, 0xef62, 0xf577, 0xf7bb, 0xf7c9,
 0xdd53, 0xe1b9, 0xe2a2, 0xf7c4,
};

static ZhiCode codelist3331[] = {
 0xa467, 0xa652, 0xd841, 0xcb7a, 0xd147,
};

static ZhiCode codelist3332[] = {
 0xa8df, 0xa652, 0xb5e9, 0xf3e6, 0xd4cb,
};

static ZhiCode codelist3344[] = {
 0xb2e6, 0xa9ec, 0xa6ab, 0xb055, 0xd8ad,
 0xcbc9, 0xd1be, 0xc9ec, 0xcd7e, 0xcd4b,
 0xe0e5, 0xcde7, 0xdbe1, 0xe4df,
};

static ZhiCode codelist3346[] = {
 0xbe6d, 0xaafb, 0xb9a4, 0xaa62, 0xa6ef,
 0xc06b, 0xb659, 0xe9d1, 0xcc40, 0xd6e3,
 0xdc5d, 0xd2d9, 0xca57, 0xec73, 0xcc5b,
 0xe2f6, 0xe4c7, 0xf7a2, 0xf965, 0xe0ae,
 0xd7b2, 0xd84f,
};

static ZhiCode codelist3347[] = {
 0xa7b4, 0xbef2, 0xe5bb, 0xd549, 0xe557,
};

static ZhiCode codelist3348[] = {
 0xa9dd, 0xb3e8, 0xac6c, 0xf6fb, 0xf4bd,
 0xdbfb, 0xddfd, 0xd1fe,
};

static ZhiCode codelist3376[] = {
 0xb1c0, 0xe761, 0xf2ce,
};

static ZhiCode codelist3378[] = {
 0xc05a, 0xf2a7, 0xe8aa, 0xf1c2, 0xe9d3,
 0xe0f9, 0xf352, 0xc9de,
};

static ZhiCode codelist3379[] = {
 0xbb4c, 0xcded,
};

static ZhiCode codelist3380[] = {
 0xb068, 0xb8c0, 0xef61, 0xeb61,
};

static ZhiCode codelist3400[] = {
 0xb4f8, 0xde7e, 0xebb2,
};

static ZhiCode codelist3402[] = {
 0xb9ce, 0xe1de, 0xc47b, 0xe277, 0xdcc7,
 0xe1c6, 0xf371, 0xf861, 0xe5e5,
};

static ZhiCode codelist3404[] = {
 0xcebd, 0xe7ca,
};

static ZhiCode codelist3408[] = {
 0xa75d, 0xe9b4, 0xd474, 0xd24b, 0xccce,
};

static ZhiCode codelist3410[] = {
 0xa4d9, 0xa779, 0xb362, 0xb6bb, 0xc176,
 0xd7db, 0xe8e1, 0xcadc, 0xcdb5, 0xcaa4,
 0xced7,
};

static ZhiCode codelist3411[] = {
 0xc9f8, 0xcaa4, 0xe2d8,
};

static ZhiCode codelist3412[] = {
 0xbfc6, 0xeb61,
};

static ZhiCode codelist3424[] = {
 0xb371, 0xabf0, 0xe766, 0xd6a2, 0xcfb5,
 0xe66b, 0xcfc3,
};

static ZhiCode codelist3426[] = {
 0xa650, 0xb5a3, 0xbbc9, 0xaee4, 0xbce0,
 0xc0fb, 0xa7cd, 0xca63, 0xb9ad, 0xabd0,
 0xcbbe, 0xf0a2, 0xe9b3, 0xeaf3, 0xedb1,
 0xede2, 0xd6bb, 0xe9bf, 0xe9e7, 0xe677,
 0xd3a6, 0xd275, 0xd268, 0xe0cb, 0xe4d0,
 0xc969, 0xe0ac, 0xd3eb, 0xdaea, 0xdaf0,
 0xe9bd, 0xea59, 0xeafa, 0xef6e, 0xf1e8,
 0xf6ec, 0xce40, 0xe04a,
};

static ZhiCode codelist3427[] = {
 0xb2ce, 0xb5a9, 0xb1ed, 0xd1b6, 0xce54,
 0xdf4a, 0xce6f,
};

static ZhiCode codelist3428[] = {
 0xb568, 0xdbc2, 0xba45, 0xf749,
};

static ZhiCode codelist3584[] = {
 0xa37a,
};

static ZhiCode codelist3594[] = {
 0xaeb3, 0xd1b2, 0xced4, 0xe7e3,
};

static ZhiCode codelist3595[] = {
 0xa8ba, 0xadfe,
};

static ZhiCode codelist3596[] = {
 0xa8ba, 0xafc7, 0xa76f, 0xb35b, 0xb675,
 0xb1cc, 0xae52, 0xcdb0, 0xd3d4, 0xd7de,
 0xcab4, 0xd7d1, 0xe8de, 0xd6d5,
};

static ZhiCode codelist3597[] = {
 0xadfe,
};

static ZhiCode codelist3608[] = {
 0xa94f,
};

static ZhiCode codelist3612[] = {
 0xb35b, 0xa8ba,
};

static ZhiCode codelist3626[] = {
 0xecd7, 0xe5ba,
};

static ZhiCode codelist3627[] = {
 0xa444, 0xa5a4, 0xb069, 0xa6bb, 0xecce,
 0xa960, 0xcced, 0xd443, 0xca4e, 0xc9d4,
};

static ZhiCode codelist3628[] = {
 0xad40, 0xa960, 0xeb71, 0xe8f3, 0xcf55,
 0xd0d2, 0xeb6e, 0xd9f2, 0xebe5,
};

static ZhiCode codelist3635[] = {
 0xbe6b, 0xadfe, 0xdb4e,
};

static ZhiCode codelist3636[] = {
 0xa4ba,
};

static ZhiCode codelist3640[] = {
 0xd16f,
};

static ZhiCode codelist3642[] = {
 0xbcb8, 0xc4c2, 0xbef8, 0xa94c, 0xda71,
 0xccac, 0xf2f8, 0xf7a4, 0xe960, 0xeffe,
 0xf2b3, 0xf6ef, 0xf1f9,
};

static ZhiCode codelist3643[] = {
 0xb8a3, 0xb46f, 0xb7ea,
};

static ZhiCode codelist3644[] = {
 0xbe78, 0xd5ef,
};

static ZhiCode codelist3650[] = {
 0xf4b0, 0xed63,
};

static ZhiCode codelist3652[] = {
 0xbfae, 0xf155, 0xdcd9, 0xf4d1,
};

static ZhiCode codelist3656[] = {
 0xa65f, 0xc9c6,
};

static ZhiCode codelist3658[] = {
 0xab6e, 0xa86b, 0xc3f8, 0xb3e4, 0xb7a3,
 0xcf49, 0xddc6, 0xeba4, 0xc9cf, 0xdfd9,
 0xd778,
};

static ZhiCode codelist3659[] = {
 0xb369, 0xf7d9, 0xe7bc, 0xd9f5, 0xdf76,
 0xd96b,
};

static ZhiCode codelist3660[] = {
 0xc3f8, 0xd8c9,
};

static ZhiCode codelist3668[] = {
 0xb9e0,
};

static ZhiCode codelist3672[] = {
 0xf8ee,
};

static ZhiCode codelist3674[] = {
 0xc56e,
};

static ZhiCode codelist3675[] = {
 0xc4e4, 0xf8ef, 0xf8f5,
};

static ZhiCode codelist3676[] = {
 0xf9d4,
};

static ZhiCode codelist3677[] = {
 0xf8ee,
};

static ZhiCode codelist3682[] = {
 0xafe0, 0xf0a4, 0xe8f4,
};

static ZhiCode codelist3684[] = {
 0xc0d7,
};

static ZhiCode codelist3714[] = {
 0xaa64, 0xa5a7, 0xa967, 0xadd9, 0xc04f,
 0xa9cb, 0xd665, 0xe3ea, 0xe84e, 0xd7ed,
 0xf3f3, 0xf1ca, 0xf3cd, 0xf8a4, 0xf944,
 0xd2f3, 0xcd5d, 0xe7d3, 0xd4dc, 0xd646,
 0xa94f, 0xcd62, 0xd16b, 0xdbf5, 0xe0b7,
 0xf3ec,
};

static ZhiCode codelist3715[] = {
 0xa741, 0xa970, 0xc0c0, 0xf2a5, 0xe8f6,
 0xb1dd, 0xceee, 0xcbf4, 0xcf46, 0xf0ae,
 0xefe4, 0xccbb, 0xd06f, 0xe4d2, 0xeef6,
 0xf650,
};

static ZhiCode codelist3716[] = {
 0xb066, 0xb7c4, 0xb0ce, 0xbfb0, 0xaa64,
 0xb845, 0xbcca, 0xd8fd, 0xf6b5, 0xf6b7,
 0xe17c, 0xeacf, 0xd0b4, 0xd4cc,
};

static ZhiCode codelist3744[] = {
 0xaeba, 0xe845, 0xf76e,
};

static ZhiCode codelist3746[] = {
 0xd07c,
};

static ZhiCode codelist3748[] = {
 0xc45e, 0xc2ec, 0xc65c, 0xc2bf, 0xc668,
 0xaf49, 0xc4d9, 0xf8a5, 0xafe5, 0xc941,
 0xefbf, 0xeaf4, 0xf16e, 0xdca1, 0xc56a,
 0xd976, 0xf9ae, 0xf741, 0xc4f4, 0xcd73,
 0xdd51, 0xe458, 0xeab7, 0xf458, 0xf751,
 0xf9c0, 0xf6dd,
};

static ZhiCode codelist3771[] = {
 0xb3be, 0xb8cd, 0xecd0, 0xbec5, 0xdcf5,
 0xe772, 0xeb73,
};

static ZhiCode codelist3772[] = {
 0xa7bf,
};

static ZhiCode codelist3776[] = {
 0xa7ac,
};

static ZhiCode codelist3778[] = {
 0xa4fb,
};

static ZhiCode codelist3779[] = {
 0xafc3, 0xa7e1, 0xb673, 0xa7d7, 0xcb63,
 0xcd55, 0xd770,
};

static ZhiCode codelist3780[] = {
 0xa9ed,
};

static ZhiCode codelist3786[] = {
 0xa67e, 0xc248, 0xd6df, 0xce70, 0xce44,
};

static ZhiCode codelist3787[] = {
 0xb1c9, 0xbcbf, 0xc25b, 0xa9e0, 0xbdfb,
 0xbd56, 0xc1d3, 0xaf47, 0xedcd, 0xdbf9,
 0xf655, 0xf3ce,
};

static ZhiCode codelist3788[] = {
 0xa9c0, 0xb0e1, 0xd5f9, 0xf5bc, 0xa4dc,
 0xf5b8,
};

static ZhiCode codelist3794[] = {
 0xb17a,
};

static ZhiCode codelist3795[] = {
 0xcee6,
};

static ZhiCode codelist3802[] = {
 0xae51, 0xc45d,
};

static ZhiCode codelist3804[] = {
 0xc643,
};

static ZhiCode codelist3810[] = {
 0xb9e7, 0xbeae, 0xc0f1, 0xc07b, 0xc266,
 0xdaac, 0xc0be, 0xf95d, 0xf76b, 0xd8d1,
 0xf4b2, 0xecd1,
};

static ZhiCode codelist3811[] = {
 0xc0be,
};

static ZhiCode codelist3812[] = {
 0xc0d7, 0xa6f0,
};

static ZhiCode codelist3842[] = {
 0xa5a3, 0xbe71, 0xcc56, 0xd6d9, 0xe3ca,
};

static ZhiCode codelist3843[] = {
 0xa756, 0xa9b8, 0xd2df,
};

static ZhiCode codelist3844[] = {
 0xabe3,
};

static ZhiCode codelist3858[] = {
 0xaebf, 0xae52, 0xf5c0, 0xd57b, 0xd5ca,
};

static ZhiCode codelist3859[] = {
 0xe9d6,
};

static ZhiCode codelist3860[] = {
 0xbfd5, 0xc0b6, 0xc47a, 0xddab, 0xd1bd,
 0xe0a3, 0xece2, 0xeacb,
};

static ZhiCode codelist3915[] = {
 0xb778, 0xef4e, 0xb7dc, 0xd9f6,
};

static ZhiCode codelist3938[] = {
 0xb941, 0xbf40, 0xc177, 0xbbfa, 0xbeba,
 0xc2aa, 0xf2eb, 0xf4e5, 0xf9b9, 0xf854,
};

static ZhiCode codelist3940[] = {
 0xa7cb,
};

static ZhiCode codelist3971[] = {
 0xa46b, 0xd046, 0xd7fd,
};

static ZhiCode codelist3972[] = {
 0xa7d7, 0xd17e, 0xd3d0, 0xd1d7,
};

static ZhiCode codelist4004[] = {
 0xad68, 0xbac4, 0xeba6,
};

static ZhiCode codelist4096[] = {
 0xa37b,
};

static ZhiCode codelist4104[] = {
 0xa9d4, 0xb0d5, 0xb3e2, 0xcf58, 0xeefd,
 0xd6f7, 0xdb69,
};

static ZhiCode codelist4106[] = {
 0xab66, 0xc3e5, 0xc9ed,
};

static ZhiCode codelist4107[] = {
 0xb3e2, 0xf2d9,
};

static ZhiCode codelist4108[] = {
 0xc3be, 0xc4fa, 0xf84e, 0xbbb6, 0xab66,
 0xdb4b, 0xb8a8, 0xf3c4, 0xe2dc, 0xddb7,
 0xddeb,
};

static ZhiCode codelist4109[] = {
 0xb0d5,
};

static ZhiCode codelist4124[] = {
 0xbcd6, 0xa955, 0xb0c7, 0xa6d8, 0xccf8,
 0xd14d, 0xa57b, 0xc952, 0xd1bb, 0xc97d,
 0xc9aa, 0xd2e3, 0xf7af, 0xc9a4, 0xd142,
 0xcda7,
};

static ZhiCode codelist4125[] = {
 0xa446,
};

static ZhiCode codelist4138[] = {
 0xa8d3, 0xb5dc, 0xb174, 0xd5e9, 0xf1b0,
 0xe35d, 0xd4fb, 0xd7ec, 0xebe4, 0xf3c9,
 0xd9b7, 0xd54a, 0xf3e0, 0xd4a8,
};

static ZhiCode codelist4140[] = {
 0xbfe0, 0xc4ee, 0xc375, 0xc5a3, 0xb7fd,
 0xe7ec, 0xf4bb, 0xd15f,
};

static ZhiCode codelist4144[] = {
 0xb0c7,
};

static ZhiCode codelist4146[] = {
 0xb970, 0xb2d6, 0xf5ec, 0xbedd, 0xb9e3,
 0xc54a, 0xc3bd, 0xc15d, 0xf5ed, 0xed44,
 0xe6ae, 0xf24f, 0xf276, 0xf641, 0xf764,
 0xf7d2, 0xf8f2,
};

static ZhiCode codelist4147[] = {
 0xb2d6, 0xc253, 0xc077, 0xbaaa, 0xa6d4,
 0xbd55, 0xc1a2, 0xe04c, 0xf2d2, 0xe5ea,
 0xf04f, 0xf057, 0xdaf5, 0xeaa4, 0xf973,
 0xe6b4, 0xf24f, 0xf254, 0xf47c, 0xf5d8,
 0xf757, 0xf97c, 0xe8bc, 0xf47b, 0xf74b,
 0xf945,
};

static ZhiCode codelist4148[] = {
 0xc3fe, 0xb25c, 0xb2d6, 0xbedd, 0xf5e8,
 0xe474, 0xe4b6, 0xf7d0, 0xf7f4, 0xf8b6,
};

static ZhiCode codelist4152[] = {
 0xbcb4,
};

static ZhiCode codelist4154[] = {
 0xb3d2, 0xa863, 0xc0f7, 0xe5fc, 0xbc47,
 0xf152, 0xd248, 0xf4f9, 0xf062, 0xf0bb,
 0xe563,
};

static ZhiCode codelist4155[] = {
 0xa6d1, 0xabbe, 0xa8d0, 0xd1dd, 0xcfc1,
 0xf357, 0xce4c, 0xe9c9, 0xe47b, 0xcec4,
 0xd379,
};

static ZhiCode codelist4156[] = {
 0xb3d2, 0xb5b8, 0xaf4f, 0xb954, 0xe16f,
 0xf355, 0xe9d4, 0xe0f2,
};

static ZhiCode codelist4160[] = {
 0xba4f,
};

static ZhiCode codelist4162[] = {
 0xbcd3, 0xb9c6, 0xb0fa, 0xc1b2, 0xc55c,
 0xdcbc, 0xe76f, 0xe1bd, 0xe27e, 0xede7,
 0xe66e, 0xf0e4, 0xedf0, 0xf54b, 0xf7bd,
 0xea79,
};

static ZhiCode codelist4163[] = {
 0xc14d, 0xba4f, 0xe15c, 0xe1a8,
};

static ZhiCode codelist4164[] = {
 0xba7c, 0xadae, 0xc553, 0xc3f3, 0xbf62,
};

static ZhiCode codelist4170[] = {
 0xc4f5, 0xc478, 0xc2c5, 0xc4e6, 0xc464,
 0xc469, 0xc4b0, 0xb0fd, 0xb450, 0xc1f1,
 0xf7fc, 0xf8c2, 0xc4e3, 0xc5d3, 0xf8f3,
 0xf9a4, 0xf5d9, 0xf8ae, 0xf2fd, 0xf8c6,
};

static ZhiCode codelist4171[] = {
 0xc4fd, 0xc369, 0xc5f3, 0xc656, 0xc66c,
 0xe949, 0xf8f6, 0xf8b0, 0xe85f, 0xf1fb,
 0xf958, 0xd25f,
};

static ZhiCode codelist4172[] = {
 0xc4ea, 0xc0dd, 0xc66c, 0xf953, 0xeff9,
 0xeccc,
};

static ZhiCode codelist4184[] = {
 0xd86a,
};

static ZhiCode codelist4186[] = {
 0xada6, 0xaf54, 0xb459, 0xbdb8, 0xb7e3,
 0xb277, 0xb77d, 0xdad6, 0xd75b, 0xdfe2,
 0xd5b0, 0xdf47, 0xe863, 0xcddd, 0xd171,
 0xd1f9,
};

static ZhiCode codelist4187[] = {
 0xaed4, 0xe8a6, 0xdac5, 0xceac, 0xd1a2,
 0xe44e, 0xd648, 0xdcf1,
};

static ZhiCode codelist4188[] = {
 0xaef6, 0xd14a, 0xe3ac,
};

static ZhiCode codelist4194[] = {
 0xb857, 0xd4f7, 0xd9b1, 0xee55, 0xbdb7,
 0xd0cd, 0xb7ab,
};

static ZhiCode codelist4195[] = {
 0xa74e,
};

static ZhiCode codelist4196[] = {
 0xb468, 0xe844, 0xb7ab,
};

static ZhiCode codelist4224[] = {
 0xadf9,
};

static ZhiCode codelist4226[] = {
 0xc2f7, 0xbcfe, 0xbea4, 0xb1f9, 0xc658,
 0xc2e7, 0xbcf9, 0xbfa9, 0xbba9, 0xc67a,
 0xb270, 0xba76, 0xf6e8, 0xaf57, 0xf2d4,
 0xb8c4, 0xc4f9, 0xf9cf, 0xe175, 0xee71,
 0xf5b6, 0xd5bc, 0xe5fa, 0xedd0, 0xeb49,
 0xe5f8, 0xcdf9, 0xf7f0, 0xdcc6, 0xb3ed,
 0xedcc, 0xf14e, 0xf9ce, 0xf7d1, 0xf6db,
 0xf6df, 0xf678, 0xe17d, 0xe5cb, 0xf0db,
 0xf3d1, 0xf3ee, 0xf6e0, 0xc452, 0xdb7a,
 0xf84d, 0xf875, 0xd34e, 0xf7c7,
};

static ZhiCode codelist4227[] = {
 0xa7f5, 0xa8bd, 0xb8cc, 0xb27a, 0xc2a7,
 0xf9d8, 0xadf9, 0xaf40, 0xc355, 0xae5b,
 0xab5a, 0xbf43, 0xc5dd, 0xc4bf, 0xc4f9,
 0xf8d7, 0xbe59, 0xdf55, 0xe054, 0xce7e,
 0xf8f4,
};

static ZhiCode codelist4228[] = {
 0xa44f, 0xa5df, 0xa751, 0xc452, 0xbefa,
 0xc363, 0xa8d2, 0xbee4, 0xb2fa, 0xbc46,
 0xc079, 0xc472, 0xb2c9, 0xbb59, 0xc645,
 0xc377, 0xc4d7, 0xc1f5, 0xc474, 0xa64f,
 0xafef, 0xaedf, 0xb758, 0xab57, 0xb567,
 0xc27e, 0xb2c1, 0xa9d1, 0xb0e6, 0xc5b0,
 0xb27c, 0xdbe0, 0xf1f2, 0xb7cc, 0xc4f7,
 0xf455, 0xcd42, 0xf5e6, 0xf252, 0xf765,
 0xf274, 0xef67, 0xd2aa, 0xf473, 0xeabc,
 0xd06b, 0xd145, 0xc976, 0xf760, 0xb07a,
 0xb0ac, 0xf471, 0xd2f5, 0xe2d4, 0xf848,
 0xcc6c, 0xc9f1, 0xc5cf, 0xf4a1, 0xd0b2,
 0xeca4, 0xcfed, 0xeff2, 0xd2da, 0xd560,
 0xd7a9, 0xd864, 0xdf53, 0xe374, 0xe3ef,
 0xf056, 0xf248, 0xf272, 0xf4be, 0xf646,
 0xf6ba, 0xf6ca, 0xf6e2, 0xf755, 0xf7be,
 0xf8a9, 0xf978, 0xf9ad, 0xd1e4, 0xd259,
 0xdcee, 0xddb9, 0xe7a4, 0xefb9, 0xf24b,
 0xf843, 0xf8b3, 0xf979, 0xd164,
};

static ZhiCode codelist4235[] = {
 0xadc7,
};

static ZhiCode codelist4256[] = {
 0xaba8,
};

static ZhiCode codelist4259[] = {
 0xaba8,
};

static ZhiCode codelist4260[] = {
 0xa643, 0xaf50, 0xa648, 0xb5f5, 0xc279,
 0xb1ca, 0xa8e6, 0xc663, 0xf761, 0xac7b,
 0xd37e, 0xdee1, 0xefd4, 0xe064, 0xce75,
 0xd3ea, 0xd74a, 0xdbb6, 0xdfee, 0xe8be,
 0xecbd, 0xef71, 0xefa5, 0xf271,
};

static ZhiCode codelist4280[] = {
 0xbcba,
};

static ZhiCode codelist4282[] = {
 0xb2e1, 0xbc64, 0xbff1, 0xc0f8, 0xb9e9,
 0xbcba, 0xb9b1, 0xbf52, 0xbce3, 0xbc49,
 0xc2b7, 0xf4ef, 0xe556, 0xe679, 0xf863,
 0xefc3, 0xf7ba, 0xe3aa, 0xe27b, 0xe1e5,
 0xf0ee, 0xe1a7, 0xe1cc, 0xe56c, 0xe5bf,
 0xeab6, 0xeaed, 0xf067, 0xf376, 0xf553,
 0xf673, 0xf551,
};

static ZhiCode codelist4283[] = {
 0xa446, 0xc141, 0xe764, 0xe5a4, 0xd442,
 0xbee9, 0xe46d, 0xf0c2,
};

static ZhiCode codelist4284[] = {
 0xb9f9, 0xaec6, 0xc141, 0xbf52, 0xc9d5,
 0xe1e6, 0xcd53, 0xee62, 0xe6d3,
};

static ZhiCode codelist4288[] = {
 0xb7c8, 0xeebc,
};

static ZhiCode codelist4290[] = {
 0xbc42, 0xac79, 0xaf64, 0xb2b8, 0xaf5b,
 0xba68, 0xc273, 0xbd46, 0xbbbf, 0xd97e,
 0xf561, 0xf365, 0xf675, 0xf6bf, 0xefcd,
 0xeedc, 0xaca6, 0xf15e, 0xdd46, 0xefc1,
 0xdd55, 0xf2d6, 0xdbc4, 0xefac, 0xf6be,
 0xdfd4, 0xf6b1, 0xdd57,
};

static ZhiCode codelist4291[] = {
 0xac68, 0xe371, 0xe6f1, 0xb967, 0xe0e3,
 0xcfd6,
};

static ZhiCode codelist4292[] = {
 0xa4bb, 0xb3b0, 0xb7c8, 0xc348, 0xc2fc,
 0xcbfd, 0xd6fc, 0xf379, 0xdd61, 0xdce8,
 0xeebc,
};

static ZhiCode codelist4298[] = {
 0xb373, 0xc170, 0xbca6, 0xb747, 0xbdac,
 0xbaa7, 0xc3ae, 0xc549, 0xc5bf, 0xb9dd,
 0xe6a3, 0xa9a9, 0xee72, 0xe155, 0xf154,
 0xf569, 0xde49, 0xf2e7, 0xe5d1, 0xede0,
 0xf0de, 0xe443, 0xe6c2, 0xbefc, 0xede5,
 0xedf7, 0xf0fd, 0xf4d4, 0xf6da, 0xe95a,
};

static ZhiCode codelist4299[] = {
 0xc179, 0xf14c, 0xeae9, 0xe1f1, 0xdcb6,
 0xf2bd,
};

static ZhiCode codelist4300[] = {
 0xbd6d, 0xc1e5, 0xc5ca, 0xb7d2, 0xc3ec,
 0xc0d4, 0xc0c4, 0xc46b, 0xb7af, 0xf2f0,
 0xd9ef, 0xea46, 0xf5fd, 0xed4b, 0xee56,
 0xdfb5, 0xd8a9,
};

static ZhiCode codelist4306[] = {
 0xaa4c, 0xc17b, 0xbe46, 0xb24f, 0xc5ec,
 0xc5ef, 0xc04d, 0xc143, 0xb559, 0xbfee,
 0xe562, 0xbf4d, 0xbf5a, 0xe360, 0xc3e1,
 0xe5fb, 0xb7f7, 0xed73, 0xed7a, 0xd559,
 0xe9b9, 0xdf69, 0xf778, 0xdee8, 0xe353,
 0xed6f, 0xf076, 0xe0fc, 0xf07a, 0xf350,
 0xf442, 0xf4e9,
};

static ZhiCode codelist4307[] = {
 0xbbfe, 0xbecf, 0xe96f, 0xecf5, 0xdbab,
 0xdcb1, 0xe36a, 0xdec6,
};

static ZhiCode codelist4308[] = {
 0xa75b, 0xc66e, 0xc4a9, 0xb8ee, 0xe9c0,
 0xec4d, 0xda65,
};

static ZhiCode codelist4314[] = {
 0xa87d, 0xb1e7, 0xb671, 0xc2b3, 0xb244,
 0xb864, 0xbcd9, 0xd9ca, 0xe378, 0xe847,
 0xe457, 0xef59,
};

static ZhiCode codelist4315[] = {
 0xa8e2, 0xadc7, 0xc352, 0xe379, 0xe3f8,
};

static ZhiCode codelist4316[] = {
 0xb671, 0xab47, 0xbdcc, 0xbdf8, 0xd867,
 0xb4bd, 0xb244, 0xd479, 0xe457, 0xda4e,
 0xd1a2,
};

static ZhiCode codelist4320[] = {
 0xa9f0,
};

static ZhiCode codelist4322[] = {
 0xb973, 0xacc2, 0xc646, 0xb961, 0xc4d6,
 0xb3ae, 0xade2, 0xb5d9, 0xb2e2, 0xb2dc,
 0xad64, 0xa744, 0xbaf0, 0xd5e6, 0xb2de,
 0xc06f, 0xcbf1, 0xb34d, 0xd2be, 0xaa7e,
 0xd757, 0xf4e1, 0xdc46, 0xebf6, 0xc4e7,
 0xcf61, 0xf9bb, 0xdedc, 0xd2e5, 0xdbde,
 0xe849, 0xeefa, 0xf3c7, 0xf8c8, 0xcc64,
 0xac53, 0xe9fb, 0xcbe5, 0xcc41, 0xcc42,
 0xcc52, 0xcd65, 0xd2cb, 0xcbef, 0xd676,
 0xd6d8, 0xe441, 0xf5f3, 0xccb0, 0xd4e2,
 0xe8cd, 0xee53, 0xf9bc, 0xd4c2, 0xa1b3,
};

static ZhiCode codelist4323[] = {
 0xbbe2, 0xc0ad, 0xcc76,
};

static ZhiCode codelist4324[] = {
 0xa54f, 0xa574, 0xcfb6,
};

static ZhiCode codelist4352[] = {
 0xc250,
};

static ZhiCode codelist4354[] = {
 0xbf63, 0xc4aa, 0xc366, 0xc4a4, 0xc46c,
 0xc660, 0xc379, 0xc674, 0xf847, 0xf1f6,
 0xf9b7, 0xd66a, 0xf743, 0xf746, 0xc644,
 0xf6fe, 0xf456, 0xf1f3, 0xf247, 0xf74f,
 0xf742,
};

static ZhiCode codelist4355[] = {
 0xbe7c, 0xb8b8, 0xbedb, 0xbab1, 0xb3bf,
 0xc372, 0xf2c5, 0xeaad, 0xf666, 0xf373,
 0xe769, 0xefd7, 0xf25b,
};

static ZhiCode codelist4356[] = {
 0xb8f4, 0xb3b0, 0xbffd, 0xb3c0, 0xc553,
 0xb8ef, 0xb853, 0xb84c, 0xb4e2, 0xc453,
 0xc64f, 0xbcae, 0xf146, 0xe764, 0xdc4f,
 0xe275, 0xe078, 0xb6ce, 0xe9f0, 0xf6fc,
 0xed69, 0xca46, 0xdef7, 0xbf72, 0xedbb,
 0xe85e, 0xf1b3, 0xd5f1, 0xdaa3, 0xded7,
 0xeaac, 0xcc74, 0xdb77, 0xe753, 0xebf5,
 0xce5a, 0xf370, 0xf3d4, 0xe1dc, 0xd6b5,
 0xdede, 0xe1b5, 0xe66a, 0xe7f9, 0xee46,
 0xee5c, 0xf2ab, 0xf3dd, 0xd5fb, 0xe163,
 0xf0fa,
};

static ZhiCode codelist4368[] = {
 0xc56f,
};

static ZhiCode codelist4370[] = {
 0xc3b9, 0xc1b3, 0xc5da, 0xc672, 0xc5de,
 0xc659, 0xc55b, 0xc56f, 0xc57a, 0xc4d8,
 0xf2f4, 0xe1e7, 0xf7e2, 0xe76d, 0xc3f1,
 0xf8e3, 0xcbd3,
};

static ZhiCode codelist4371[] = {
 0xbb72, 0xea73, 0xf5f0, 0xf2dd, 0xe3cc,
 0xeecf,
};

static ZhiCode codelist4372[] = {
 0xb8a8, 0xc064, 0xaca5, 0xb5b8, 0xbbdc,
 0xaf4f, 0xb954, 0xeff6, 0xbaba, 0xaba3,
 0xaf5f, 0xf942, 0xdbca, 0xd6b8, 0xef70,
 0xefa1, 0xceaa,
};

static ZhiCode codelist4426[] = {
 0xc572, 0xc671, 0xc67d, 0xc665, 0xf943,
 0xf96b, 0xf7e1, 0xf7df, 0xf8ba, 0xf9cc,
};

static ZhiCode codelist4427[] = {
 0xa75a,
};

static ZhiCode codelist4428[] = {
 0xb6c3, 0xee4a,
};

static ZhiCode codelist4432[] = {
 0xb1c1,
};

static ZhiCode codelist4434[] = {
 0xaddb, 0xbdd7, 0xbdfc, 0xb25f, 0xb15b,
 0xa8da, 0xbafa, 0xb1c1, 0xd4ac, 0xdef1,
 0xec43, 0xd565, 0xd84b, 0xdba1, 0xe846,
 0xd9c3, 0xe3ee,
};

static ZhiCode codelist4435[] = {
 0xdf41,
};

static ZhiCode codelist4436[] = {
 0xbdd7, 0xde6a,
};

static ZhiCode codelist4450[] = {
 0xc073, 0xb6a9, 0xc5a2, 0xc456, 0xc5a4,
 0xc46e, 0xc467, 0xc14b, 0xf25d, 0xed74,
 0xf453, 0xf5e2, 0xf450, 0xf1fd, 0xc4ef,
 0xf4b8, 0xf846, 0xf844, 0xf375, 0xf8cb,
 0xf8d0, 0xf750, 0xf752, 0xf9b8, 0xefb7,
 0xf6d5, 0xf74d,
};

static ZhiCode codelist4451[] = {
 0xc3f7, 0xc36c, 0xc362,
};

static ZhiCode codelist4452[] = {
 0xdbc1, 0xd0f1, 0xf240, 0xd5b1,
};

static ZhiCode codelist4482[] = {
 0xc66a, 0xbe5b, 0xc371, 0xf2d1, 0xe1cf,
 0xe5f6, 0xe742,
};

static ZhiCode codelist4483[] = {
 0xa766, 0xaec8, 0xbc69, 0xab51, 0xbe54,
 0xb9f0, 0xc15c, 0xc1b9, 0xb0fa, 0xbb4d,
 0xe27e, 0xf4a4, 0xd5cd, 0xd3f9, 0xcee2,
 0xdf65, 0xecbb, 0xd6c0,
};

static ZhiCode codelist4484[] = {
 0xabdf, 0xbaf1, 0xb276, 0xbc7b, 0xc26f,
 0xb4e2, 0xd8e9, 0xe6fe, 0xf84a, 0xdb77,
 0xdfd0, 0xecbf,
};

static ZhiCode codelist4516[] = {
 0xb2a4, 0xb1b0, 0xe86e, 0xe1e6, 0xefd3,
};

static ZhiCode codelist4554[] = {
 0xc5cb, 0xc570,
};

static ZhiCode codelist4555[] = {
 0xf6dc,
};

static ZhiCode codelist4608[] = {
 0xa37c,
};

static ZhiCode codelist4616[] = {
 0xb9c7, 0xc9ee,
};

static ZhiCode codelist4618[] = {
 0xaaee, 0xbebf, 0xd0c1,
};

static ZhiCode codelist4620[] = {
 0xa7bc,
};

static ZhiCode codelist4621[] = {
 0xbbf9,
};

static ZhiCode codelist4632[] = {
 0xadf4, 0xba71, 0xb3ce, 0xc246, 0xc0c1,
 0xafde, 0xa4e0, 0xcb76, 0xaab8, 0xd9fd,
 0xcfb7, 0xdb5d, 0xde4f, 0xe4e5,
};

static ZhiCode codelist4634[] = {
 0xaee6, 0xadb2, 0xb96a, 0xbbd5, 0xb8af,
 0xc066, 0xb5f0, 0xaba3, 0xbb4a, 0xf4dd,
 0xdcd0, 0xe1ee, 0xada8, 0xe8b4, 0xdced,
 0xe040, 0xb0ac, 0xbbd7, 0xcedd, 0xcbcc,
 0xebcb, 0xef75, 0xd1ce, 0xd3a8, 0xd943,
 0xea5c, 0xc2f0, 0xf3a2, 0xf87d,
};

static ZhiCode codelist4635[] = {
 0xb8af, 0xd0f8, 0xd753, 0xe9a5, 0xec7d,
 0xf3c0, 0xd6cd,
};

static ZhiCode codelist4636[] = {
 0xadd3, 0xa655, 0xbbcc, 0xd0a8, 0xbae7,
};

static ZhiCode codelist4637[] = {
 0xadd3,
};

static ZhiCode codelist4648[] = {
 0xb8d3, 0xabb2, 0xd0c2, 0xb8f0, 0xd375,
 0xcbb4, 0xce79, 0xd36a, 0xdad2, 0xdaec,
 0xe055, 0xe05b, 0xe0d3,
};

static ZhiCode codelist4651[] = {
 0xa7ef,
};

static ZhiCode codelist4652[] = {
 0xb7a7, 0xbb5c, 0xa4a2, 0xb674, 0xb540,
 0xdd76, 0xd962, 0xf047,
};

static ZhiCode codelist4659[] = {
 0xb5b9,
};

static ZhiCode codelist4664[] = {
 0xb0aa, 0xbf7c, 0xbb49, 0xbf74, 0xafcc,
 0xaf6f, 0xf253, 0xb841, 0xf6ce, 0xe252,
 0xe2e9, 0xde5c, 0xf3a6,
};

static ZhiCode codelist4667[] = {
 0xbd5a, 0xc5cd, 0xb764, 0xba60, 0xbfa5,
 0xaa58, 0xe1f7, 0xefe2, 0xdf52,
};

static ZhiCode codelist4668[] = {
 0xa769, 0xbba2, 0xd3fc, 0xe870, 0xdad5,
 0xde7b,
};

static ZhiCode codelist4672[] = {
 0xa579, 0xb7be, 0xa4c4, 0xb95f, 0xac65,
 0xccfb, 0xeaba, 0xe6ed, 0xccdb, 0xcdc5,
 0xeae6,
};

static ZhiCode codelist4675[] = {
 0xaaaf, 0xce41, 0xcc63, 0xac65, 0xad65,
 0xd6d6, 0xd051, 0xd3ad, 0xd7ad,
};

static ZhiCode codelist4676[] = {
 0xb0f7, 0xc1ca, 0xabaf, 0xba63, 0xb6fc,
 0xdd62, 0xb770, 0xb8e1, 0xbbb8, 0xee7a,
 0xd0e0, 0xce6c, 0xb96f, 0xd855, 0xe6be,
 0xf2a9, 0xf3a4, 0xd0f0,
};

static ZhiCode codelist4680[] = {
 0xb0ae, 0xa5cc, 0xa47a, 0xacf1, 0xa878,
 0xc0aa, 0xac61, 0xa958, 0xccf4, 0xcbdd,
 0xaf69, 0xcb68, 0xa7fd, 0xcd7a, 0xd0a6,
 0xdf51, 0xe3e0, 0xe4e2, 0xd8f1,
};

static ZhiCode codelist4683[] = {
 0xb4b1, 0xb750, 0xbbb0, 0xb1ec, 0xbef1,
 0xb57a, 0xe641, 0xcd75, 0xcd78, 0xd3e3,
};

static ZhiCode codelist4684[] = {
 0xb746, 0xc642, 0xd0e5, 0xb268, 0xd6e6,
 0xcaf8, 0xe0e8, 0xdbe3, 0xba6d, 0xf9a2,
 0xd647, 0xf2a8, 0xd8f1,
};

static ZhiCode codelist4688[] = {
 0xb8f2, 0xaeda,
};

static ZhiCode codelist4690[] = {
 0xcdfe,
};

static ZhiCode codelist4691[] = {
 0xa6e1,
};

static ZhiCode codelist4692[] = {
 0xa5e5, 0xa6e1, 0xd3a3,
};

static ZhiCode codelist4696[] = {
 0xade8, 0xbffb, 0xacfb, 0xb15e, 0xbaf5,
 0xa9a3, 0xa87a, 0xa6aa, 0xa7fe, 0xd35c,
 0xcd74, 0xd069, 0xb3aa, 0xdcef, 0xdeef,
 0xd9bb, 0xd2fe, 0xd4b6, 0xda6b,
};

static ZhiCode codelist4699[] = {
 0xb4e4, 0xb15e,
};

static ZhiCode codelist4700[] = {
 0xba62,
};

static ZhiCode codelist4704[] = {
 0xa7f3, 0xafd1, 0xa9b0, 0xb865, 0xc3bc,
 0xbde9, 0xd24e, 0xe6e5, 0xf3da, 0xdba9,
 0xd958,
};

static ZhiCode codelist4707[] = {
 0xb1f0, 0xafd5, 0xae43, 0xdf58, 0xf1c7,
 0xae47, 0xef64, 0xd3f3, 0xd1c4,
};

static ZhiCode codelist4708[] = {
 0xa7f3, 0xa5e5, 0xd87d,
};

static ZhiCode codelist4864[] = {
 0xa968, 0xa974, 0xb664, 0xa942, 0xaa66,
 0xa6f4, 0xdba3, 0xb5dd, 0xa94b, 0xb347,
 0xdecc, 0xe354, 0xc06c, 0xdbd4, 0xdc5e,
 0xcd40, 0xd360, 0xe356, 0xb957, 0xec7e,
 0xc95a, 0xcf54, 0xe0cc, 0xdc49, 0xae61,
 0xe555, 0xe9c6,
};

static ZhiCode codelist4866[] = {
 0xb0a9, 0xf6bc,
};

static ZhiCode codelist4867[] = {
 0xaad1, 0xa56a, 0xb9aa, 0xb0a9, 0xa8a6,
 0xbd5c, 0xb8eb, 0xa559, 0xc5db, 0xcb53,
 0xacba, 0xb7c6, 0xafcb, 0xe14c, 0xb5fe,
 0xc1d4, 0xc35b, 0xc2a2, 0xedea, 0xf053,
 0xd361, 0xd7aa, 0xc9e8, 0xb957, 0xcb46,
 0xd5ec, 0xcd60, 0xd146, 0xdd4c, 0xe242,
 0xe3c3, 0xed58, 0xeff0, 0xdd6b, 0xead3,
 0xedfa,
};

static ZhiCode codelist4868[] = {
 0xac47, 0xa954, 0xc555, 0xb6b1, 0xb9b5,
 0xc044, 0xa769, 0xa6f4, 0xdecc, 0xd5c0,
 0xe24c, 0xd65f, 0xd4c7, 0xd544, 0xd0e3,
 0xd9cf, 0xdefa,
};

static ZhiCode codelist4872[] = {
 0xa5ca, 0xac41, 0xa8ed, 0xbdbd, 0xbe68,
 0xa94b, 0xb5c1, 0xef7e, 0xd1eb, 0xd3ec,
 0xf3bc, 0xd067, 0xdfa2, 0xdae1, 0xdfb2,
 0xe141, 0xe2de, 0xe6ea, 0xefcf, 0xe061,
 0xedee,
};

static ZhiCode codelist4875[] = {
 0xb9e8, 0xd46c,
};

static ZhiCode codelist4876[] = {
 0xb1be, 0xa8f6, 0xbb6f, 0xdf68, 0xd6f1,
 0xdaee, 0xe047, 0xac45, 0xec6f,
};

static ZhiCode codelist4880[] = {
 0xb3a2, 0xc1e7, 0xc1b4, 0xb3fa, 0xe14f,
 0xd4f4, 0xd4ad, 0xe162, 0xe9f1,
};

static ZhiCode codelist4882[] = {
 0xb0ea, 0xb9f6, 0xe77e, 0xef55, 0xba51,
 0xe3a2, 0xe741, 0xe2b6, 0xe1d5, 0xedc4,
};

static ZhiCode codelist4883[] = {
 0xaa47, 0xbb71, 0xbccd, 0xe3e2, 0xe84b,
 0xe35f, 0xb274, 0xd5fe, 0xd55d, 0xf665,
 0xebe9,
};

static ZhiCode codelist4884[] = {
 0xb94c,
};

static ZhiCode codelist4904[] = {
 0xa8c4,
};

static ZhiCode codelist4907[] = {
 0xa9e4, 0xcf5e, 0xac62,
};

static ZhiCode codelist4908[] = {
 0xa9c7, 0xf24a, 0xc95b, 0xe973, 0xf04d,
};

static ZhiCode codelist4912[] = {
 0xc26b, 0xb357, 0xc074, 0xbac0, 0xbbd3,
 0xa663, 0xaf5e, 0xacd4, 0xb3c8, 0xd8b5,
 0xe5e2, 0xc244, 0xe5e4, 0xd0b8, 0xd6ca,
 0xd9ec, 0xe174, 0xe1f0,
};

static ZhiCode codelist4915[] = {
 0xb0ad, 0xad79, 0xb8de, 0xacd1, 0xd46f,
 0xb4be, 0xc973, 0xedc2, 0xcbc1, 0xce56,
 0xc9a3, 0xce69, 0xe7a5, 0xd177, 0xd6bf,
 0xdbb9, 0xdffe, 0xe146,
};

static ZhiCode codelist4916[] = {
 0xb651, 0xaedb, 0xc264, 0xb8f7, 0xe4f3,
 0xde60, 0xc5ed, 0xcccb, 0xcd50, 0xdae4,
 0xcf40, 0xe56b, 0xf2ef, 0xe5c5,
};

static ZhiCode codelist4936[] = {
 0xa978, 0xc3f6, 0xc65b, 0xab61, 0xb4c3,
 0xace1, 0xc560, 0xbafa, 0xadbe, 0xb2f0,
 0xe6b2, 0xc960, 0xf8da,
};

static ZhiCode codelist4939[] = {
 0xbade, 0xc05d, 0xb2f0, 0xb55f, 0xdf46,
 0xd745, 0xdec7, 0xebdd,
};

static ZhiCode codelist4940[] = {
 0xba44, 0xb365, 0xc4e9, 0xc5f8, 0xe1e8,
 0xbf64, 0xc67c, 0xab61, 0xc65b, 0xc963,
 0xf6ed, 0xf6f0, 0xdef3, 0xf7eb, 0xf975,
 0xd5e1, 0xd556, 0xd8f9, 0xf171, 0xf9ca,
};

static ZhiCode codelist4947[] = {
 0xba75, 0xb34f, 0xc358, 0xe36c, 0xbe40,
 0xd5a5, 0xe752,
};

static ZhiCode codelist4948[] = {
 0xb4d2, 0xed6b,
};

static ZhiCode codelist4952[] = {
 0xa5fa, 0xafd6, 0xaca9, 0xd1e9, 0xd2ae,
 0xcd59, 0xd3a4, 0xe4b4, 0xce5b, 0xd27c,
};

static ZhiCode codelist4955[] = {
 0xbc73, 0xc278,
};

static ZhiCode codelist4956[] = {
 0xb37d, 0xd1e9, 0xedef, 0xdb52, 0xf474,
};

static ZhiCode codelist4960[] = {
 0xa475, 0xa4bd, 0xa55c, 0xa8d1, 0xa7f0,
 0xae63, 0xaea5, 0xb060, 0xa47d, 0xb047,
 0xacf5, 0xc5c7, 0xaad0, 0xdffd, 0xcd74,
 0xb3aa, 0xeac2, 0xdce3, 0xdd70, 0xd863,
 0xa640, 0xdd5a,
};

static ZhiCode codelist4963[] = {
 0xbe64, 0xabfd, 0xa845, 0xa640, 0xd2ac,
 0xc471, 0xd1e2, 0xa47b, 0xd1b1, 0xdbbb,
 0xf4a3,
};

static ZhiCode codelist4964[] = {
 0xa640, 0xa8d1, 0xb05e, 0xd050, 0xdda2,
};

static ZhiCode codelist5120[] = {
 0xa37d,
};

static ZhiCode codelist5128[] = {
 0xa940, 0xb3d8, 0xaba2, 0xe0c7,
};

static ZhiCode codelist5131[] = {
 0xa564, 0xab79, 0xca61,
};

static ZhiCode codelist5132[] = {
 0xb3d8, 0xf3c1,
};

static ZhiCode codelist5144[] = {
 0xacec, 0xac5f, 0xa8e8, 0xb4ca, 0xc1fb,
 0xad56, 0xbd4f, 0xbd57, 0xb348, 0xbdc1,
 0xb661, 0xb85c, 0xb85e, 0xcfc8, 0xd2db,
 0xf2ac, 0xee48, 0xcea4, 0xe0b3, 0xe5ef,
 0xdea8, 0xd8e8,
};

static ZhiCode codelist5146[] = {
 0xab79, 0xb4df,
};

static ZhiCode codelist5147[] = {
 0xa569, 0xb4f7, 0xd0f8, 0xa956, 0xcc65,
 0xd4c6, 0xd975, 0xe95f, 0xe0ce,
};

static ZhiCode codelist5148[] = {
 0xabc8, 0xbdd2, 0xa8e8, 0xa74a, 0xab67,
 0xb3d8, 0xb7c2, 0xabf1, 0xb6df, 0xa569,
 0xe245, 0xbd79, 0xc34e, 0xd5df, 0xf1b2,
 0xdda4, 0xcbd9, 0xcdf2,
};

static ZhiCode codelist5160[] = {
 0xb67d, 0xb47b, 0xd67c, 0xcbb4,
};

static ZhiCode codelist5163[] = {
 0xb3cd, 0xb46e, 0xb7a2, 0xb75f, 0xb3cf,
 0xb05a, 0xf15a, 0xdce5, 0xf16d, 0xeed2,
 0xf3ac, 0xe1f8, 0xe074,
};

static ZhiCode codelist5164[] = {
 0xb46e, 0xb75a, 0xb474, 0xab79, 0xd1f5,
 0xd271, 0xd46e, 0xeccd,
};

static ZhiCode codelist5176[] = {
 0xc975,
};

static ZhiCode codelist5179[] = {
 0xa6d2, 0xaf4e, 0xabfe, 0xd1dc, 0xcaf7,
 0xedf6, 0xcfa2,
};

static ZhiCode codelist5180[] = {
 0xbe61, 0xbe52, 0xbab9,
};

static ZhiCode codelist5184[] = {
 0xe1e0, 0xe1be, 0xcdc3, 0xd7bc, 0xf363,
};

static ZhiCode codelist5187[] = {
 0xa466,
};

static ZhiCode codelist5188[] = {
 0xa6a9, 0xb146, 0xa56e, 0xe74d, 0xb3a7,
 0xf6b6, 0xdae5, 0xa746, 0xccaa, 0xe26e,
 0xe6be, 0xedca,
};

static ZhiCode codelist5192[] = {
 0xa55a, 0xb3f4, 0xb0c9, 0xb760, 0xacdd,
 0xf7ce, 0xd8dc,
};

static ZhiCode codelist5195[] = {
 0xace5, 0xa8d4, 0xa7a2, 0xae72, 0xd774,
 0xc265, 0xd9dc, 0xf4dc, 0xddfa, 0xefe8,
 0xd4b9, 0xc942, 0xf1a9,
};

static ZhiCode codelist5196[] = {
 0xacdd, 0xc0fd, 0xb0c9, 0xf545, 0xf8f9,
 0xeaa9, 0xd0ab, 0xe165, 0xf7a6, 0xf4a5,
};

static ZhiCode codelist5203[] = {
 0xaad6, 0xb0d9, 0xbec1, 0xc0b5, 0xc569,
 0xf3fb, 0xe056, 0xebfa,
};

static ZhiCode codelist5204[] = {
 0xd576, 0xd6b6, 0xdbcf,
};

static ZhiCode codelist5208[] = {
 0xb164, 0xba42, 0xc152, 0xf36e, 0xe274,
 0xe179,
};

static ZhiCode codelist5210[] = {
 0xa6aa,
};

static ZhiCode codelist5211[] = {
 0xba42,
};

static ZhiCode codelist5212[] = {
 0xa4ae, 0xa7dc, 0xaaa1, 0xa5ea, 0xc9c2,
 0xcaa9, 0xcb66, 0xdc7a, 0xcba7, 0xdc70,
};

static ZhiCode codelist5216[] = {
 0xa77c, 0xdac8, 0xc3f4, 0xd65e, 0xa75c,
 0xa8c2, 0xdef2, 0xe8a1, 0xd15b, 0xd1c6,
 0xeee8,
};

static ZhiCode codelist5219[] = {
 0xd1c6,
};

static ZhiCode codelist5376[] = {
 0xadfa, 0xac5c, 0xb85d, 0xbe75, 0xdbf2,
 0xced8, 0xd1f1, 0xcbd2, 0xf3a9, 0xd05c,
 0xe9c6,
};

static ZhiCode codelist5379[] = {
 0xad57, 0xb7b1,
};

static ZhiCode codelist5380[] = {
 0xae77, 0xbfc7, 0xbbc5, 0xf441, 0xcd7d,
 0xe2e0, 0xd3e7,
};

static ZhiCode codelist5384[] = {
 0xb8d8, 0xa66a, 0xce66, 0xd3a1, 0xd1d5,
 0xcbba, 0xdb5a,
};

static ZhiCode codelist5387[] = {
 0xabb1, 0xcbba, 0xe4b3,
};

static ZhiCode codelist5388[] = {
 0xb8f3, 0xafe3, 0xec6d,
};

static ZhiCode codelist5395[] = {
 0xe9ab,
};

static ZhiCode codelist5396[] = {
 0xac41, 0xc258, 0xc1ef, 0xb9f8, 0xf54a,
 0xe272, 0xb5f2, 0xce62, 0xf37a, 0xf6fa,
};

static ZhiCode codelist5416[] = {
 0xce4a, 0xd87b,
};

static ZhiCode codelist5419[] = {
 0xe3c7,
};

static ZhiCode codelist5420[] = {
 0xa7d6, 0xb6f4, 0xb77c, 0xb85f, 0xc0cc,
 0xbc44, 0xebd7, 0xe9f8, 0xc17a, 0xe944,
 0xea61, 0xbbfb, 0xf8db, 0xe4d3, 0xf856,
 0xd5d7,
};

static ZhiCode codelist5424[] = {
 0xc1ab, 0xbf73, 0xb2af, 0xf377, 0xcbd1,
 0xd1a7, 0xf54a, 0xeee5, 0xd378, 0xf0b1,
 0xd86b, 0xf5c9, 0xf74a,
};

static ZhiCode codelist5426[] = {
 0xbbed, 0xbacc, 0xabb6, 0xb47d, 0xb8aa,
 0xb666, 0xdd74, 0xc4dc, 0xf3b8, 0xddc0,
 0xdc55, 0xec5a, 0xe6fc, 0xddee, 0xefe1,
 0xd9f9, 0xd850, 0xddef, 0xf8f7, 0xf9be,
};

static ZhiCode codelist5427[] = {
 0xb3c8, 0xe069, 0xe0df, 0xde79, 0xf0fc,
 0xcea1,
};

static ZhiCode codelist5428[] = {
 0xb75c, 0xbcec, 0xb9bc, 0xf558, 0xc34a,
 0xb3e7, 0xc2b1, 0xdcfb, 0xf07c, 0xe5a6,
 0xedbd, 0xeb44, 0xed7e, 0xe5eb, 0xe9cc,
 0xf4f4, 0xe542, 0xe5b7, 0xf560, 0xd6b7,
 0xe76c,
};

static ZhiCode codelist5448[] = {
 0xbc65, 0xc662, 0xf2c1,
};

static ZhiCode codelist5451[] = {
 0xb4da, 0xedb7, 0xb1fb,
};

static ZhiCode codelist5456[] = {
 0xa9f8, 0xb158, 0xa95b, 0xb562, 0xc043,
 0xb54f, 0xe7c3, 0xd5ad, 0xf3cb, 0xdb74,
 0xf1b1, 0xb9a6, 0xd563, 0xd663,
};

static ZhiCode codelist5459[] = {
 0xaeb9, 0xb869, 0xd1a8, 0xb1ee, 0xe8a7,
 0xdcf2, 0xdf40, 0xdaca, 0xdff3, 0xf7cd,
};

static ZhiCode codelist5460[] = {
 0xa778, 0xb574, 0xd265,
};

static ZhiCode codelist5464[] = {
 0xa64a, 0xaed8, 0xb5a8, 0xe046, 0xa8f1,
 0xcec6, 0xcf6f,
};

static ZhiCode codelist5466[] = {
 0xa867, 0xbba5, 0xf1db,
};

static ZhiCode codelist5467[] = {
 0xcdea,
};

static ZhiCode codelist5468[] = {
 0xaa70, 0xc471, 0xc36d, 0xaed8, 0xb2b5,
 0xf14b, 0xdbe8, 0xc252, 0xf5e7, 0xdaef,
 0xefc9, 0xf269, 0xe576,
};

static ZhiCode codelist5472[] = {
 0xaac5, 0xb153, 0xadc3, 0xe34f, 0xd554,
 0xb851, 0xd5e3, 0xebf2,
};

static ZhiCode codelist5475[] = {
 0xaea3, 0xa4d5, 0xadc3,
};

static ZhiCode codelist5476[] = {
 0xaac5, 0xb1b1, 0xeefc,
};

static ZhiCode codelist5632[] = {
 0xa37e,
};

static ZhiCode codelist5640[] = {
 0xaba2,
};

static ZhiCode codelist5642[] = {
 0xb5f0,
};

static ZhiCode codelist5643[] = {
 0xaba2,
};

static ZhiCode codelist5656[] = {
 0xb3dc, 0xa8fe, 0xb646, 0xceab,
};

static ZhiCode codelist5658[] = {
 0xa6f3, 0xa658, 0xa94d, 0xaa65, 0xb2fc,
 0xaed6, 0xb2b0, 0xa5dd, 0xbdc5, 0xa8f0,
 0xc2f3, 0xbbd7, 0xac54, 0xf7cf, 0xb255,
 0xaf72, 0xf2f2, 0xbb5c, 0xb8e8, 0xbbd2,
 0xacf8, 0xde4e, 0xbfad, 0xe7b2, 0xb6df,
 0xf1ea, 0xada8, 0xef50, 0xf5a6, 0xe0ca,
 0xec7d, 0xf17b, 0xdb5d, 0xcc51, 0xddfe,
 0xe2c2, 0xe3bb, 0xeabb, 0xeb5b, 0xf05a,
 0xd2cc, 0xdd5d, 0xdde7, 0xe65d, 0xd3e6,
};

static ZhiCode codelist5660[] = {
 0xb650, 0xa94d, 0xc562, 0xb3dc, 0xb2fc,
 0xc07e, 0xbbae, 0xb071, 0xb77b, 0xdcca,
 0xe2ba, 0xda74, 0xeae4, 0xcbcb, 0xde77,
};

static ZhiCode codelist5672[] = {
 0xab79, 0xb6d9, 0xcbe8,
};

static ZhiCode codelist5674[] = {
 0xc1d9, 0xabc4, 0xc065, 0xe8b8,
};

static ZhiCode codelist5675[] = {
 0xaefc, 0xeec6, 0xd657,
};

static ZhiCode codelist5676[] = {
 0xae60, 0xa5e8, 0xc062, 0xb6d9, 0xaef3,
 0xdccd, 0xdaec, 0xe4cf,
};

static ZhiCode codelist5680[] = {
 0xb6c2, 0xbc4b, 0xe648,
};

static ZhiCode codelist5683[] = {
 0xb6c2,
};

static ZhiCode codelist5688[] = {
 0xbb55, 0xecc3, 0xee51,
};

static ZhiCode codelist5690[] = {
 0xb8b9, 0xb240, 0xbba8, 0xc0a2, 0xc0da,
 0xc4ae, 0xb8e8, 0xc07a, 0xc562, 0xb348,
 0xb6e7, 0xf4a9, 0xe7da, 0xcdf3, 0xf64d,
};

static ZhiCode codelist5691[] = {
 0xa66e, 0xb071,
};

static ZhiCode codelist5692[] = {
 0xb8b9, 0xafd3, 0xaf45, 0xb571, 0xc2ee,
 0xb255, 0xa9fe, 0xa66e, 0xf8af, 0xe650,
 0xe6b8, 0xc556, 0xb952, 0xcffb, 0xd5fd,
 0xde45, 0xe6ba, 0xd144, 0xd1ae, 0xf6aa,
 0xcef0, 0xedf3,
};

static ZhiCode codelist5696[] = {
 0xf3f8,
};

static ZhiCode codelist5698[] = {
 0xb555, 0xab4a, 0xb3ef, 0xbd6a, 0xeedb,
 0xef53, 0xe2df, 0xe4a5, 0xe6f5, 0xf56f,
 0xdfdf,
};

static ZhiCode codelist5699[] = {
 0xa771,
};

static ZhiCode codelist5700[] = {
 0xabe1, 0xadd4, 0xab70, 0xa65a, 0xb06d,
 0xc64d, 0xce5e, 0xb3fb, 0xd0bf, 0xdc5a,
 0xdafd, 0xcfac,
};

static ZhiCode codelist5704[] = {
 0xb66f, 0xc24d, 0xb346, 0xe977, 0xdcac,
 0xeca1, 0xd0fd, 0xdec3, 0xe450, 0xe17b,
};

static ZhiCode codelist5706[] = {
 0xb448, 0xa774, 0xa8e7, 0xb25b, 0xc1fa,
 0xcdd5, 0xa6bd, 0xca52, 0xba6d, 0xd672,
 0xd5c2, 0xe8a2, 0xd655,
};

static ZhiCode codelist5707[] = {
 0xb3db, 0xa875, 0xc944, 0xe755, 0xf344,
 0xecc7,
};

static ZhiCode codelist5708[] = {
 0xa94d, 0xba7e, 0xa6bd, 0xa7f2, 0xb26b,
 0xbed1, 0xbfab, 0xbed9, 0xaeab, 0xc058,
 0xc9e4, 0xc376, 0xd846, 0xaec2, 0xe5c3,
 0xe663, 0xd5a9, 0xca43, 0xdabe, 0xdb72,
 0xd3e0, 0xbe5a, 0xd7f7, 0xef5f, 0xd141,
 0xd254, 0xd5f6, 0xe0e4, 0xe3e7, 0xbe67,
 0xeb5f, 0xef46, 0xf170, 0xf246, 0xf2f9,
 0xe875, 0xf6b9,
};

static ZhiCode codelist5714[] = {
 0xb2aa, 0xceda, 0xe8b2,
};

static ZhiCode codelist5715[] = {
 0xabdc, 0xacbd,
};

static ZhiCode codelist5716[] = {
 0xabeb,
};

static ZhiCode codelist5720[] = {
 0xc971,
};

static ZhiCode codelist5722[] = {
 0xa6e6, 0xafe8, 0xaa43, 0xa75c, 0xe0de,
 0xaeec, 0xcdcc, 0xcdb3, 0xcdac, 0xd3b9,
 0xccc3, 0xd7d2, 0xe0d7, 0xe8da,
};

static ZhiCode codelist5723[] = {
 0xd3fe,
};

static ZhiCode codelist5724[] = {
 0xa6e6, 0xa859,
};

static ZhiCode codelist5728[] = {
 0xa6eb, 0xadf3, 0xd750, 0xebb0,
};

static ZhiCode codelist5730[] = {
 0xbeee, 0xabed, 0xbfc5, 0xf9da, 0xd2b2,
 0xf4c1, 0xaeec, 0xce64, 0xf76d, 0xddf3,
 0xe44b, 0xebb0, 0xd968, 0xcbbc,
};

static ZhiCode codelist5732[] = {
 0xbeee, 0xd4a6, 0xe65a, 0xdafb,
};

static ZhiCode codelist5888[] = {
 0xa9bf, 0xa949, 0xa547, 0xb1ab, 0xe2a3,
 0xc0b8, 0xda70, 0xd9db, 0xeaf0, 0xd77c,
 0xca76, 0xca4f, 0xe570, 0xe1a1, 0xccc7,
 0xe5f0, 0xd652, 0xcbf9, 0xccd1, 0xd47d,
 0xce7a, 0xd5f5, 0xf0e2, 0xc9c1, 0xd641,
};

static ZhiCode codelist5890[] = {
 0xad4a, 0xb4f2, 0xb3fd, 0xbdb9, 0xbd6b,
 0xaab0, 0xa9b7, 0xb8ac, 0xc447, 0xb7e4,
 0xef4d, 0xb1d8, 0xc35b, 0xa77a, 0xead1,
 0xe7c1, 0xee7d, 0xebd9, 0xda70, 0xddac,
 0xf57c, 0xe5da, 0xd8c8, 0xcaec, 0xf574,
 0xd656, 0xe8dc, 0xeb6d, 0xf260, 0xdded,
 0xe152, 0xf5af,
};

static ZhiCode codelist5891[] = {
 0xaaea, 0xb55b, 0xe271, 0xb0e4, 0xb35c,
 0xcb5c,
};

static ZhiCode codelist5892[] = {
 0xc540, 0xa4e1, 0xa4ac, 0xbaad, 0xb1af,
 0xb27d, 0xcc7c, 0xd2e9, 0xd343, 0xc9bc,
 0xccb2, 0xb7b1, 0xa85b, 0xcc5e, 0xe46a,
 0xf4b3, 0xf851, 0xcce1, 0xe5ee, 0xccc8,
 0xe171, 0xd4d7, 0xe16c, 0xe668, 0xeeb2,
 0xdf63, 0xeea6, 0xe77a,
};

static ZhiCode codelist5896[] = {
 0xaae1, 0xb5d8, 0xbc4d, 0xf872, 0xebfb,
};

static ZhiCode codelist5898[] = {
 0xb5d8, 0xb7c6, 0xa645, 0xb7e2, 0xc3cf,
 0xbc4d, 0xbeec, 0xf77e, 0xf4f3, 0xc1c5,
 0xb9ba, 0xd4f5, 0xd840, 0xeb62,
};

static ZhiCode codelist5900[] = {
 0xb8dc, 0xa4c6, 0xb565, 0xb9ba, 0xbeec,
 0xb5d8, 0xe554, 0xe1e3, 0xd4f5, 0xe55f,
 0xcce7, 0xdffc, 0xe5d4, 0xf070, 0xe645,
};

static ZhiCode codelist5904[] = {
 0xc1c5,
};

static ZhiCode codelist5906[] = {
 0xaca1, 0xcbc3, 0xdc64, 0xdfaa,
};

static ZhiCode codelist5907[] = {
 0xa4f5, 0xa5eb, 0xb9d9, 0xdc64,
};

static ZhiCode codelist5908[] = {
 0xa9ce, 0xc3ac, 0xc0f2, 0xa94d, 0xb462,
 0xbad7, 0xc04e, 0xb366, 0xc1c5, 0xc0a4,
 0xf4c9, 0xecc4, 0xf4b9, 0xf769, 0xf27c,
 0xefe6, 0xc0e2, 0xcff1, 0xf174, 0xd6ba,
 0xc0c3, 0xda46, 0xf3be, 0xeea5, 0xd1c5,
 0xcb5d, 0xd2d0, 0xd56e, 0xdcd1, 0xddfc,
 0xf043, 0xf07e, 0xf245, 0xf25f, 0xf452,
 0xf5e0, 0xf84f, 0xf8cf,
};

static ZhiCode codelist5909[] = {
 0xa94d,
};

static ZhiCode codelist5930[] = {
 0xc368, 0xb261, 0xabde, 0xba69, 0xbdef,
 0xcbbf, 0xcae4, 0xeb77, 0xeb76, 0xf454,
 0xf266,
};

static ZhiCode codelist5932[] = {
 0xc361, 0xa7a5, 0xe7e4, 0xd165, 0xce45,
 0xf7f2, 0xf7f6,
};

static ZhiCode codelist5936[] = {
 0xa6c7, 0xb4a7, 0xbdf7, 0xabec, 0xb8d9,
 0xb775, 0xbea3, 0xc0b2, 0xbc5a, 0xe7c3,
 0xd95a, 0xf16f, 0xde6b, 0xe6f8, 0xd3df,
 0xe7c7, 0xcfa4, 0xe0d2, 0xf773, 0xf7b3,
 0xcee5, 0xd86b, 0xe341,
};

static ZhiCode codelist5938[] = {
 0xa65e, 0xb06a, 0xb5ee, 0xaff5, 0xd3ca,
 0xcf77, 0xd6a4, 0xcec8, 0xf2c7,
};

static ZhiCode codelist5939[] = {
 0xb77c, 0xaeac, 0xbba3, 0xb7b4, 0xc0ec,
 0xb8ec, 0xad6b, 0xa6e4, 0xd274, 0xe9e5,
 0xecfd, 0xf4d5,
};

static ZhiCode codelist5940[] = {
 0xb77c, 0xb466, 0xb6d7, 0xc3b8, 0xbc7a,
 0xb74a, 0xc2a9, 0xbba3, 0xb8ec, 0xb1e2,
 0xb16b, 0xbfd0, 0xbcec, 0xa563, 0xbfb7,
 0xe9f4, 0xc0ed, 0xb3f1, 0xd17d, 0xee50,
 0xf2be, 0xf546, 0xe14a, 0xe5cd, 0xedbc,
 0xf072, 0xf06e, 0xf0c0, 0xed6e, 0xe55e,
 0xe5a2, 0xe659, 0xf055, 0xf2fa, 0xf75b,
 0xf4fc, 0xe9d8, 0xdd5f, 0xe050, 0xe549,
 0xe756, 0xea5b, 0xef51, 0xf668, 0xf677,
 0xd06a, 0xf05f, 0xf2ef,
};

static ZhiCode codelist5960[] = {
 0xc577, 0xf9c2, 0xf94e, 0xf5dd, 0xcb61,
 0xf5cc, 0xf65b, 0xe8ee,
};

static ZhiCode codelist5962[] = {
 0xc1d9, 0xc0f4, 0xaed9, 0xe947, 0xf2b4,
 0xf855, 0xc1ec, 0xf660, 0xbec8, 0xf66c,
 0xb1fb, 0xaca7, 0xf8b2, 0xe058, 0xbf4a,
 0xd37b, 0xdb7b, 0xcb77, 0xd1b3, 0xdf6c,
 0xe97c, 0xeeb3, 0xe953, 0xcfc2, 0xdca5,
};

static ZhiCode codelist5963[] = {
 0xbd77, 0xb570, 0xe9eb, 0xdaba, 0xe464,
};

static ZhiCode codelist5964[] = {
 0xb4ab, 0xb3ea, 0xabc6, 0xb177, 0xa4db,
 0xb7d8, 0xabb7, 0xb541, 0xbac8, 0xb8e6,
 0xb1fb, 0xdc4d, 0xe9a6, 0xe2a1, 0xd152,
 0xf4de, 0xdebd, 0xe449, 0xf5c6, 0xea7c,
};

static ZhiCode codelist5968[] = {
 0xb142, 0xa9fc, 0xb8a7, 0xec4e, 0xd55f,
 0xe2e8, 0xd9e0, 0xd9d5, 0xd5f7, 0xddbc,
 0xdedf,
};

static ZhiCode codelist5970[] = {
 0xbbee, 0xb4fd, 0xc05f, 0xb256, 0xb7e9,
 0xddcc, 0xef4c, 0xd9d0, 0xf1a8, 0xf7cb,
 0xedd7, 0xf149,
};

static ZhiCode codelist5971[] = {
 0xb256, 0xdee0,
};

static ZhiCode codelist5972[] = {
 0xb256, 0xb4fd, 0xde54, 0xeba1, 0xd149,
 0xe1c4, 0xbe40, 0xd0dc, 0xb1fb,
};

static ZhiCode codelist5976[] = {
 0xafee, 0xb757, 0xa877, 0xd0aa, 0xc9da,
 0xefbe,
};

static ZhiCode codelist5978[] = {
 0xb6c0, 0xb461, 0xb471, 0xc2ae, 0xbf58,
 0xc144, 0xbdc0, 0xb7d7, 0xacd3, 0xb0c4,
 0xb547, 0xb94e, 0xb6aa, 0xe643, 0xbd68,
 0xd874, 0xe74a, 0xeeda, 0xea49, 0xc341,
 0xf576, 0xd8b1, 0xf0c1, 0xd45d, 0xedb5,
 0xf86f, 0xd8ce, 0xf3bf, 0xd8ee, 0xdfcd,
 0xef52, 0xe5b2, 0xe67d, 0xf34c,
};

static ZhiCode codelist5979[] = {
 0xc1c0, 0xabe9, 0xaecc, 0xb745, 0xaca9,
 0xcca4, 0xe261, 0xe2bd, 0xf167, 0xde53,
 0xe6b9,
};

static ZhiCode codelist5980[] = {
 0xaecc, 0xdc41,
};

static ZhiCode codelist5984[] = {
 0xc546, 0xaba1, 0xaf4d, 0xc1a9, 0xd0b1,
 0xcaa1, 0xd96e, 0xda48, 0xce46, 0xebce,
 0xe7e5, 0xeeea, 0xda60, 0xe4e1,
};

static ZhiCode codelist5986[] = {
 0xacf5, 0xac78, 0xa7bb, 0xc245, 0xad69,
 0xa5b0, 0xaa6c, 0xb052, 0xe862, 0xb6a3,
 0xc664, 0xd041, 0xd354, 0xd363, 0xd247,
 0xe4c2, 0xcb5e, 0xdfd2, 0xd367, 0xc966,
 0xcb52, 0xdadd, 0xdc72, 0xeef8, 0xc9ce,
 0xcb6c, 0xd7cd, 0xda43, 0xdb58, 0xe044,
 0xe052, 0xe6dd, 0xe974, 0xcd6f, 0xd07d,
};

static ZhiCode codelist5987[] = {
 0xaba1, 0xdccf,
};

static ZhiCode codelist5988[] = {
 0xc069, 0xa845, 0xe5fe, 0xedfb, 0xeeed,
};

static ZhiCode codelist6144[] = {
 0xa3a1,
};

static ZhiCode codelist6272[] = {
 0xbef7, 0xb0f2, 0xbf6e, 0xc15a, 0xc2dd,
 0xbf45, 0xb8f1, 0xae56, 0xc2fb, 0xc4c8,
 0xa6d9, 0xbd5d, 0xb0a7, 0xa95f, 0xb7ee,
 0xf9d6, 0xbadf, 0xc146, 0xc3d5, 0xc5f9,
 0xa44c, 0xc9f3, 0xa5e4, 0xae6a, 0xc545,
 0xbf59, 0xb458, 0xbc54, 0xbd42, 0xb452,
 0xb551, 0xf6d2, 0xa8e4, 0xb4c1, 0xa97e,
 0xae41, 0xb6d6, 0xedb0, 0xf8f4, 0xc27e,
 0xf744, 0xf7f1, 0xe7d1, 0xeefb, 0xdbb5,
 0xe4ae, 0xccd3, 0xc946, 0xc95c, 0xedce,
 0xcdca, 0xf4f8, 0xefdd, 0xdef8, 0xe26a,
 0xe5e3, 0xe7df, 0xf3f9, 0xf670, 0xf76c,
 0xf7ac, 0xf87e, 0xd340, 0xd0e9, 0xeef4,
 0xf8e7, 0xf5df,
};

static ZhiCode codelist6274[] = {
 0xa4ce, 0xafc5, 0xb7a5, 0xa759, 0xb6b0,
 0xabe6, 0xc0bb, 0xaf65, 0xc479, 0xa64e,
 0xb149, 0xbfe8, 0xafe1, 0xa7a3, 0xae41,
 0xb6fa, 0xa856, 0xab45, 0xa659, 0xb4c6,
 0xc2c7, 0xbd43, 0xb7aa, 0xa7c4, 0xd344,
 0xf6c0, 0xb761, 0xddfb, 0xeebd, 0xa5f9,
 0xe3b0, 0xe3a1, 0xcdbf, 0xee44, 0xe7fa,
 0xdc6b, 0xcbb8, 0xd14b, 0xce63, 0xe9ef,
 0xf0d3, 0xe94f, 0xe64f, 0xef79, 0xe969,
 0xcfa1, 0xcadf, 0xda53, 0xcce5, 0xe4af,
 0xcfbf, 0xf542, 0xdfe9, 0xd3d6, 0xd464,
 0xd548, 0xd76e, 0xdce7, 0xe1fe, 0xe26f,
 0xe3a9, 0xe758, 0xe9c7, 0xeb40, 0xf4df,
 0xf66e, 0xcad5, 0xd1b9, 0xd5b8, 0xd6c5,
 0xe8b1, 0xeb5c, 0xd7c7,
};

static ZhiCode codelist6275[] = {
 0xb458, 0xb5b9, 0xa476, 0xc0bd, 0xafe1,
 0xb475, 0xc0d9, 0xa44c, 0xb9a8, 0xcacd,
 0xf0ca, 0xd0e9, 0xd571, 0xccfe, 0xe7fd,
 0xf7a9, 0xc950, 0xedb3, 0xc9cc, 0xe5b0,
};

static ZhiCode codelist6276[] = {
 0xad70, 0xb04f, 0xac4a, 0xacf6, 0xbbda,
 0xc47e, 0xa975, 0xb148, 0xa7de, 0xa7b2,
 0xc0d9, 0xbeaf, 0xc3b4, 0xb1aa, 0xb2bd,
 0xa7d2, 0xba5b, 0xbeac, 0xc34d, 0xc356,
 0xbd5e, 0xc545, 0xc2c9, 0xc66b, 0xc5b4,
 0xc1aa, 0xc067, 0xede4, 0xc1bb, 0xc9ab,
 0xacad, 0xe2db, 0xe45b, 0xecc1, 0xd8a7,
 0xd8fc, 0xe2b8, 0xf2a6, 0xaae7, 0xdfbd,
 0xded3, 0xf278, 0xeaaf, 0xef72, 0xf95c,
 0xf3d7, 0xf7b6, 0xc95e, 0xc9be, 0xdb53,
 0xdff7, 0xe345, 0xe44c, 0xe4dd, 0xea78,
 0xed40, 0xf044, 0xf1d4, 0xf1e9, 0xf241,
 0xf460, 0xf570, 0xf5f9, 0xf7f5,
};

static ZhiCode codelist6280[] = {
 0xae61, 0xa55b, 0xb9c5, 0xa8ce, 0xb3c3,
 0xad7b, 0xcf45, 0xb350, 0xaf6d, 0xd6d2,
 0xcfc9, 0xdbf6, 0xad58, 0xb8b5, 0xbfde,
 0xd740, 0xf5b3, 0xcd4a, 0xcf6a, 0xf153,
 0xecac, 0xda72, 0xdd58, 0xdea6, 0xebb1,
 0xa7a8,
};

static ZhiCode codelist6282[] = {
 0xa7a8, 0xaeb5, 0xc055, 0xdfe6, 0xb2f3,
 0xaf48, 0xb1ae, 0xd3f7, 0xd17c, 0xdbcb,
 0xdf49, 0xdff8, 0xe868, 0xd5b3, 0xe071,
 0xd755, 0xd140, 0xe4a6, 0xd6b3, 0xcaf6,
 0xe4c4, 0xe8b3, 0xf1d2,
};

static ZhiCode codelist6283[] = {
 0xb0b2, 0xa5d2, 0xb8eb, 0xb95b, 0xcc61,
 0xad4b, 0xd97a, 0xe248, 0xe2dd, 0xecf8,
 0xd8ca, 0xcfd2, 0xd8f5, 0xddd9, 0xae4c,
};

static ZhiCode codelist6284[] = {
 0xbbf9, 0xb0b2, 0xac5b, 0xbe72, 0xb6f9,
 0xb8eb, 0xbd5b, 0xc9b2,
};

static ZhiCode codelist6304[] = {
 0xb5f3, 0xb1b5, 0xacd2, 0xb6a5, 0xb4a6,
 0xb0ba, 0xb6d8, 0xd86e, 0xe96e, 0xb5b2,
 0xd9f4, 0xee4e, 0xdbc3, 0xd478, 0xd9ac,
 0xdb61, 0xe7a8, 0xf57e,
};

static ZhiCode codelist6306[] = {
 0xb860, 0xbce4, 0xb3c7, 0xb1b6, 0xbadc,
 0xa754, 0xba49, 0xb5b2, 0xaa4e, 0xbe65,
 0xb8d7, 0xaee5, 0xb7fb, 0xb050, 0xcdfc,
 0xabfa, 0xbd7e, 0xc0cd, 0xaedc, 0xa46d,
 0xf04b, 0xdaf4, 0xd455, 0xc25e, 0xd0cc,
 0xcbd5, 0xd4d0, 0xddda, 0xbad4, 0xef6a,
 0xcac6, 0xe251, 0xca44, 0xdbc3, 0xd8e0,
 0xd1ef, 0xf3c0, 0xde66, 0xe0c5, 0xf543,
 0xd3d6, 0xd3f0, 0xd4fa, 0xdd50, 0xdde5,
 0xe05f, 0xe7f8, 0xe9ad, 0xe9f6, 0xeee6,
 0xf9a7, 0xcccd, 0xd1b9, 0xe367, 0xefc4,
 0xe572,
};

static ZhiCode codelist6307[] = {
 0xa96a, 0xb8d1, 0xa96e, 0xecfb, 0xd4e3,
};

static ZhiCode codelist6308[] = {
 0xacc9, 0xadc9, 0xa4b6, 0xa7d9, 0xc2c7,
 0xa9a1, 0xacce, 0xaae3, 0xbb7c, 0xb8d1,
 0xd47a, 0xd86e, 0xcd6b, 0xd3c8, 0xe2c7,
 0xeb7a, 0xcaa5, 0xcac9, 0xc9b2, 0xcff0,
 0xd1a3, 0xd358, 0xdad2, 0xf950, 0xf2b6,
};

static ZhiCode codelist6328[] = {
 0xb1d0, 0xa5e6, 0xbda6, 0xc5ba, 0xb54a,
 0xbc62, 0xada5, 0xb8f8, 0xbce5, 0xb5eb,
 0xbfbc, 0xc147, 0xb4d4, 0xd374, 0xabbb,
 0xc242, 0xe0fa, 0xe5a9, 0xca4d, 0xf86b,
 0xea4e, 0xb8e5, 0xf860, 0xf4f7, 0xef77,
 0xf86a, 0xe153, 0xe9a1, 0xeaf1, 0xedb6,
 0xee64, 0xf6c7, 0xe568, 0xf0c8,
};

static ZhiCode codelist6330[] = {
 0xc45a,
};

static ZhiCode codelist6331[] = {
 0xb87d, 0xa8a4, 0xc3ba, 0xc5cd, 0xb6d3,
 0xc142, 0xb5b1, 0xabbb, 0xcbb3, 0xbbe5,
 0xb2ae, 0xb9ae, 0xb6cf, 0xb8fb, 0xbbc7,
 0xacbe, 0xf051, 0xe4ef, 0xdade, 0xf0c6,
 0xe1f3, 0xe5b9, 0xd1bf, 0xf7e5, 0xecf2,
 0xe2ae, 0xe4f2, 0xf340, 0xdea2,
};

static ZhiCode codelist6332[] = {
 0xb1d0, 0xa573, 0xaed5, 0xb8fb, 0xc4b1,
 0xc3e2, 0xb5a2, 0xf6f5, 0xc3e7, 0xe975,
 0xe943, 0xe569, 0xced5, 0xe1f5, 0xd2ab,
 0xf8c9, 0xde5d, 0xd2fa, 0xe150, 0xe64e,
 0xf4d3,
};

static ZhiCode codelist6336[] = {
 0xaac8, 0xb4aa, 0xb3ee, 0xb9a7, 0xf147,
 0xda47, 0xe5d6, 0xdd79, 0xc956, 0xc9f2,
 0xca42, 0xd0af, 0xd96a, 0xdbae, 0xf9c4,
};

static ZhiCode codelist6339[] = {
 0xa445, 0xa45b, 0xb073, 0xa868, 0xad76,
 0xa862, 0xadb4, 0xaac8,
};

static ZhiCode codelist6340[] = {
 0xb44e, 0xa873, 0xb1cf, 0xc2c2, 0xb8a4,
 0xa6dd, 0xac5e, 0xaab9, 0xa953, 0xe0f0,
 0xf86c, 0xb45c, 0xd1b5, 0xe5aa, 0xf3cc,
 0xf3f2,
};

static ZhiCode codelist6344[] = {
 0xb6a1, 0xbaca, 0xb0ed, 0xa679, 0xaddd,
 0xaad3, 0xc17d, 0xa66c, 0xabc1, 0xb7ce,
 0xbd70, 0xc271, 0xbaa5, 0xbae0, 0xc4e8,
 0xb5d5, 0xccb1, 0xf179, 0xda66, 0xddec,
 0xbfa1, 0xb4e6, 0xea4a, 0xe3b6, 0xf6b4,
 0xdd5e, 0xdea5, 0xf6fd, 0xd7cf, 0xc669,
 0xf3c2, 0xdc65, 0xf954, 0xf7ae, 0xf6ab,
 0xf5cf, 0xe66c, 0xeb46, 0xd959, 0xddb8,
 0xc9db, 0xdba2, 0xdca9, 0xdfd1, 0xe8e6,
 0xef54, 0xf27e, 0xf3b7, 0xf3ea, 0xf462,
 0xf8bc, 0xd55a, 0xd668, 0xefab,
};

static ZhiCode codelist6347[] = {
 0xc2b2, 0xbedf, 0xb0c5, 0xb4ee, 0xc0cb,
 0xb47a, 0xc3b5, 0xbbfc, 0xc650, 0xac5a,
 0xb863, 0xe6f9, 0xeeaa, 0xe1d6, 0xeebf,
 0xf756, 0xd7d6, 0xd8ac, 0xa65f, 0xf575,
 0xd1c9, 0xda51, 0xc2a5, 0xd8d2, 0xf0a5,
 0xf949, 0xddc1, 0xdeb9,
};

static ZhiCode codelist6348[] = {
 0xa8a3, 0xabd8, 0xb0b7, 0xbaa5, 0xa5f3,
 0xb6a1, 0xbaca, 0xc1e4, 0xc5b2, 0xbd62,
 0xbc43, 0xc4a5, 0xc5b3, 0xbde2, 0xbdee,
 0xbfcf, 0xb7b7, 0xc2cb, 0xc05e, 0xb878,
 0xc271, 0xb9b0, 0xc265, 0xb6a2, 0xcf74,
 0xd0d0, 0xcfbd, 0xd1e5, 0xddd4, 0xd2b6,
 0xf468, 0xbcee, 0xed7d, 0xaff2, 0xe7d7,
 0xe25d, 0xe6e2, 0xf572, 0xe75e, 0xec44,
 0xee5e, 0xf0d9, 0xf4ab, 0xf956,
};

static ZhiCode codelist6352[] = {
 0xa4b5, 0xaaf7, 0xb854, 0xac7a, 0xa4e7,
 0xa479, 0xb5ac, 0xc3cc, 0xace1, 0xaefb,
 0xad6f, 0xd3d7, 0xdad4, 0xe2d3, 0xdb7e,
 0xd2b4, 0xd156, 0xd357, 0xe56a, 0xd564,
};

static ZhiCode codelist6355[] = {
 0xbaf2, 0xb6c8, 0xc041, 0xc2d4, 0xbea8,
 0xc2d1, 0xbd40, 0xc444, 0xe5d3, 0xe158,
 0xe5f2, 0xd4bb, 0xe1cb, 0xdb6a, 0xceaf,
};

static ZhiCode codelist6356[] = {
 0xb669, 0xaaf1, 0xbac9, 0xb854, 0xaeca,
 0xbea8, 0xaefb, 0xab6c, 0xc2d1, 0xc275,
 0xe1b6, 0xbeb6, 0xe0da, 0xbfa7, 0xb6c8,
 0xf0b0, 0xcab5, 0xf652, 0xdd48, 0xdda8,
 0xcdaf, 0xea68, 0xebb5, 0xecd3, 0xe25d,
 0xe4e9, 0xe763, 0xea6e, 0xecc2, 0xed53,
 0xf045, 0xc9bb, 0xde61,
};

static ZhiCode codelist6360[] = {
 0xb14e, 0xa6bf, 0xc3a6, 0xbbf8, 0xbcdf,
 0xabb8, 0xc1a4, 0xd3de, 0xed4c, 0xc5b7,
 0xee6c, 0xed45, 0xd373, 0xf058, 0xcd6f,
 0xe37e,
};

static ZhiCode codelist6363[] = {
 0xc1bf, 0xbcfa, 0xbdb1, 0xbcd5, 0xf3a7,
 0xe743,
};

static ZhiCode codelist6364[] = {
 0xadb0, 0xa64b, 0xc2e6, 0xb16a, 0xb14e,
 0xb5bc, 0xedcf, 0xcf7a, 0xf0ec, 0xe1b0,
 0xbeca, 0xd54c, 0xdbc9,
};

static ZhiCode codelist6368[] = {
 0xb867, 0xbaeb, 0xa8ca, 0xc5e5, 0xb7fa,
 0xb2f4, 0xb4b9, 0xb5d7, 0xa7f3, 0xb9b8,
 0xaef9, 0xc448, 0xaff0, 0xb1dc, 0xb865,
 0xf5b4, 0xe352, 0xf3db, 0xcaca, 0xd4e1,
 0xd5a8, 0xf1d3, 0xf3d9, 0xf6d1, 0xf8e8,
 0xc9b0, 0xd561,
};

static ZhiCode codelist6371[] = {
 0xb4ba, 0xc4b5, 0xa4ab, 0xc056, 0xa8c0,
 0xe4ea, 0xbf5b, 0xbca9, 0xcdf0, 0xed6d,
 0xc964, 0xd64c, 0xece1, 0xe9ba, 0xf2e4,
 0xea58,
};

static ZhiCode codelist6372[] = {
 0xb771, 0xb3ba, 0xc3e8, 0xc052, 0xb9d2,
 0xb262, 0xc476, 0xb377, 0xae7c, 0xb974,
 0xab6c, 0xd0e1, 0xd748, 0xb56a, 0xe2cb,
 0xd0c8, 0xe8b0, 0xdf45, 0xd4d1, 0xd5c8,
 0xcddf, 0xd0e4, 0xdfbc, 0xe9a7, 0xd179,
};

static ZhiCode codelist6528[] = {
 0xa97e, 0xa9eb, 0xbe73, 0xaa71, 0xaf6a,
 0xb349, 0xaaae, 0xadd1, 0xa8ae, 0xd575,
 0xbff7, 0xe3fa, 0xd075, 0xdbed, 0xd35f,
 0xdb5e, 0xd4d4, 0xd9b9, 0xdb4c, 0xd4f9,
 0xd2c7, 0xdaa1, 0xe0d5, 0xd5fa, 0xdfc6,
 0xeca2, 0xf3e1, 0xcee9, 0xd963, 0xe3de,
 0xe7fc, 0xe07c,
};

static ZhiCode codelist6530[] = {
 0xa7bd, 0xc1f9, 0xb5e2, 0xbeef, 0xb1c5,
 0xbbb1, 0xaedc, 0xd1b7, 0xf17c, 0xab5d,
 0xcbd6, 0xe842, 0xe876, 0xf1d5, 0xf5a4,
 0xd9be, 0xd64b, 0xd644, 0xf9b5, 0xcfbe,
 0xd5b6, 0xdc56, 0xdea7, 0xe07b, 0xe35c,
 0xe7f0, 0xf3e5, 0xf5f6, 0xf7ca, 0xd84a,
 0xef5e,
};

static ZhiCode codelist6531[] = {
 0xc17c, 0xaf78, 0xa943, 0xb2f7, 0xaa71,
 0xc4d4, 0xf5d1, 0xdf4c, 0xebc4, 0xe3af,
 0xd9bc, 0xcf40, 0xd2fd, 0xd7c3, 0xdbf8,
 0xe7b7,
};

static ZhiCode codelist6532[] = {
 0xbeda, 0xa579, 0xa8e3, 0xa5a8, 0xbc40,
 0xbb45, 0xadd1, 0xa9da, 0xb65a, 0xbff7,
 0xc4df, 0xb964, 0xacb2, 0xdbd6, 0xc1d8,
 0xadd0, 0xc2a3, 0xbdf5, 0xc1fc, 0xccfb,
 0xad55, 0xeab2, 0xf4e4, 0xc0ab, 0xd2ee,
 0xe3d4, 0xe17e, 0xf65f, 0xca5c, 0xd575,
 0xd6de, 0xcc4e, 0xcca5, 0xd6eb, 0xa8ac,
 0xd6fe, 0xcc5d, 0xd4c5, 0xd77e, 0xe8c8,
 0xe9f2, 0xf0f2, 0xf4d7, 0xcd48, 0xda5e,
 0xe94b, 0xda6c,
};

static ZhiCode codelist6560[] = {
 0xe4fe, 0xb6d8, 0xe5b1,
};

static ZhiCode codelist6562[] = {
 0xa84d, 0xc4b1, 0xb5b4, 0xc0ef, 0xb1b8,
 0xc45a, 0xb35a, 0xb3d6, 0xbcfb, 0xc3dd,
 0xbfb9, 0xb155, 0xc5cc, 0xadcf, 0xcd50,
 0xa7e0, 0xbebb, 0xf477, 0xd7c6, 0xa8a4,
 0xa46e, 0xaab2, 0xb9bb, 0xe9c8, 0xf5da,
 0xc3d4, 0xefc2, 0xc5a9, 0xcd69, 0xb87d,
 0xede9, 0xeb54, 0xf9ab, 0xf7db, 0xd5c1,
 0xe644, 0xbea1, 0xf9aa, 0xd7d8, 0xc5ed,
 0xd852, 0xd8e0, 0xe6b5, 0xf96e, 0xf4f2,
 0xf9c1, 0xf7e9, 0xd1c2, 0xcdb8, 0xd654,
 0xdc69, 0xd3c0, 0xd7ce, 0xd7d3, 0xe0f6,
 0xe57c, 0xf0d0, 0xf7d8, 0xf85a, 0xf86e,
 0xd4b3, 0xd5de, 0xf6f9,
};

static ZhiCode codelist6563[] = {
 0xc3dd,
};

static ZhiCode codelist6564[] = {
 0xadcf,
};

static ZhiCode codelist6600[] = {
 0xaebd, 0xae53, 0xc359, 0xaefe, 0xc54f,
 0xb0e9, 0xf7f8, 0xd5af, 0xa8ad, 0xd74f,
 0xdff9,
};

static ZhiCode codelist6603[] = {
 0xb1b2, 0xa8f7, 0xd4af, 0xdb64, 0xeded,
};

static ZhiCode codelist6604[] = {
 0xadc2, 0xa8f7, 0xb2b2, 0xb868, 0xb96d,
 0xd1a6, 0xaf58, 0xb0e9, 0xea5d, 0xdabf,
 0xdeda, 0xdafe, 0xdc52, 0xceb2, 0xebdf,
 0xdb4a, 0xe8b5, 0xec72,
};

static ZhiCode codelist6608[] = {
 0xad78, 0xa767, 0xa7a1, 0xb676, 0xe2e1,
 0xcbf0, 0xecb1, 0xd764, 0xf1cb, 0xd5c9,
 0xd3cd, 0xd3d5, 0xec59, 0xc074, 0xdeea,
};

static ZhiCode codelist6611[] = {
 0xb57e, 0xe3e4,
};

static ZhiCode codelist6612[] = {
 0xab54, 0xb5df, 0xb070, 0xae6d, 0xb5a4,
 0xb96d, 0xc0e0, 0xc240, 0xbfb8, 0xaf43,
 0xd673, 0xdaad, 0xd64d, 0xd1b8, 0xe8c5,
 0xe359, 0xe95d, 0xd5ac, 0xcaa3, 0xf1dc,
 0xdfce, 0xe76a,
};

static ZhiCode codelist6624[] = {
 0xced3, 0xcbf7, 0xe8cc,
};

static ZhiCode codelist6627[] = {
 0xb57e, 0xad7e, 0xdea3, 0xccf9, 0xcd52,
 0xd6e7, 0xeb75, 0xca6a, 0xe662, 0xcaa8,
 0xe6bb, 0xacb3, 0xe571, 0xedd4,
};

static ZhiCode codelist6656[] = {
 0xa3a2,
};

static ZhiCode codelist6784[] = {
 0xa443, 0xa964, 0xb4db, 0xb1ad, 0xbaa3,
 0xb4cf, 0xb17e, 0xb259, 0xac6d, 0xb5d6,
 0xbca1, 0xb7cb, 0xcb50, 0xe7d5, 0xd7e9,
 0xd4d3, 0xf8dc, 0xe14e, 0xf550, 0xd551,
 0xe24e, 0xe6c5, 0xd0ce, 0xce48, 0xd1e1,
 0xc1c6, 0xd0e2, 0xd4a7, 0xd54e, 0xd5c3,
 0xe0f5, 0xe368, 0xeaa3, 0xec51, 0xf1c1,
 0xf3dc, 0xd972,
};

static ZhiCode codelist6786[] = {
 0xa8e4, 0xb4c1, 0xbbf4, 0xa95f, 0xba58,
 0xc34d, 0xace8, 0xb4d1, 0xb852, 0xf9d6,
 0xaac2, 0xb154, 0xb561, 0xa7c1, 0xaa5b,
 0xb558, 0xc451, 0xc55f, 0xb2a5, 0xc2c0,
 0xace9, 0xafcf, 0xb24e, 0xd7d7, 0xaa4b,
 0xe375, 0xf1af, 0xb04e, 0xf4bf, 0xa7a6,
 0xc042, 0xd1d2, 0xdb6d, 0xe3db, 0xd4c3,
 0xe159, 0xf4c5, 0xe0e0, 0xece3, 0xf4b7,
 0xd3ce, 0xd7dd, 0xf0ad, 0xf35d, 0xf3d5,
 0xf567, 0xd3bd, 0xebf7, 0xd5a4, 0xcac8,
 0xdee9, 0xdb44, 0xd843, 0xc951, 0xd3c3,
 0xdef8, 0xe4de, 0xe7fb, 0xef6b, 0xf3de,
 0xf3df, 0xf7e7, 0xf963, 0xed59,
};

static ZhiCode codelist6787[] = {
 0xb05f, 0xb1d2, 0xb05a, 0xa45e, 0xbaf6,
 0xa7fb, 0xbd5d, 0xe376, 0xc9d7, 0xd9c9,
 0xd973, 0xcb7d, 0xd4e5, 0xca55, 0xcdbc,
 0xcaa6,
};

static ZhiCode codelist6788[] = {
 0xa5f8, 0xaef0, 0xbeb9, 0xa854, 0xb1f3,
 0xabb4, 0xace4, 0xaa5f, 0xa8b4, 0xb057,
 0xc9fd, 0xbecd, 0xbd72, 0xab45, 0xdfc2,
 0xbf6c, 0xd1ed, 0xb474, 0xa964, 0xf2e6,
 0xf364, 0xcd79, 0xd3bd, 0xc9e1, 0xd9e8,
 0xc961, 0xebae, 0xd9e9, 0xe6ac, 0xf879,
};

static ZhiCode codelist6792[] = {
 0xd574,
};

static ZhiCode codelist6795[] = {
 0xa564, 0xdc61,
};

static ZhiCode codelist6796[] = {
 0xabea, 0xaca2, 0xceb1, 0xd94b, 0xd5dd,
};

static ZhiCode codelist6816[] = {
 0xa4c1, 0xcb50,
};

static ZhiCode codelist6818[] = {
 0xad58, 0xa6f7, 0xca47,
};

static ZhiCode codelist6819[] = {
 0xa542,
};

static ZhiCode codelist6820[] = {
 0xa4c1, 0xc5d1, 0xa963, 0xa9c4, 0xb467,
 0xaeb2, 0xe6d7, 0xc1e6, 0xabb4, 0xe1f9,
 0xe7f5, 0xf3d2, 0xdbb7, 0xe368, 0xf0b5,
 0xd25e,
};

static ZhiCode codelist6840[] = {
 0xba56, 0xc1ea, 0xbef5, 0xbcc0, 0xc3df,
 0xeda6, 0xf354, 0xe54b, 0xe96b, 0xf074,
 0xf1ba, 0xf664, 0xf374, 0xdcec, 0xe470,
 0xe94a, 0xec6a, 0xd175, 0xdc57, 0xe8b7,
};

static ZhiCode codelist6842[] = {
 0xbef4, 0xc140, 0xb9b4, 0xb3ec, 0xbef6,
 0xc2bc, 0xbcac, 0xeb4c, 0xedae, 0xc3d7,
 0xf06b, 0xf34e, 0xea56, 0xe142, 0xe548,
 0xe558, 0xf34b, 0xe9b0,
};

static ZhiCode codelist6843[] = {
 0xa5a9, 0xaea8, 0xb473, 0xc44e, 0xb3b6,
 0xea4e, 0xe8b7,
};

static ZhiCode codelist6844[] = {
 0xc2bc, 0xc2ac, 0xab4e, 0xae6b, 0xc054,
 0xbba6, 0xbcc0, 0xc3df, 0xb4df, 0xd173,
 0xe9a9, 0xf4d8,
};

static ZhiCode codelist6848[] = {
 0xacee, 0xaaf4, 0xa543, 0xb34c, 0xc2fe,
 0xc4cf, 0xf5ae, 0xdddf, 0xcbfa, 0xdfc7,
 0xd45a, 0xe6e6, 0xd8cf, 0xe75f, 0xebbb,
 0xc074, 0xcecf, 0xe7bd, 0xf0cc, 0xf644,
};

static ZhiCode codelist6850[] = {
 0xa844, 0xb279, 0xa57d, 0xa4b3, 0xada9,
 0xb8ca, 0xe07d, 0xb241, 0xaa73, 0xf7b5,
 0xd7e4, 0xcdde, 0xc958, 0xe6a5, 0xdf5b,
 0xca4d, 0xcdc8, 0xe7a3, 0xe447, 0xe453,
 0xdab9, 0xe867, 0xd84e, 0xecb8, 0xd0b0,
 0xc9a6, 0xc9f0, 0xb1fc, 0xd444, 0xde75,
 0xd076, 0xd35a, 0xd747, 0xd75c, 0xd8d9,
 0xdcc1, 0xdfe4, 0xec79, 0xf1cc, 0xd5db,
};

static ZhiCode codelist6851[] = {
 0xeac9,
};

static ZhiCode codelist6856[] = {
 0xa464, 0xb95d, 0xbe45, 0xc3b1, 0xb26f,
 0xc1be, 0xc5d2, 0xb44f, 0xa561, 0xa6e9,
 0xc648, 0xc4ca, 0xb75e, 0xdcc2, 0xe1c7,
 0xba53, 0xeb72, 0xd049, 0xcac0, 0xcb4c,
 0xc164, 0xcba1, 0xd952, 0xc9e7, 0xefe3,
 0xf66a, 0xd4ee, 0xdf6d, 0xf243, 0xf44e,
 0xf4d2, 0xf774, 0xc9d1, 0xc9e2, 0xef49,
 0xefab, 0xf256,
};

static ZhiCode codelist6858[] = {
 0xab65, 0xbffa, 0xb0ae, 0xbce7, 0xc072,
 0xb958, 0xb040, 0xbae3, 0xb678, 0xd57a,
 0xd8c4, 0xd961, 0xea48, 0xccb5, 0xf1bf,
 0xf5d5, 0xefaf, 0xcae5, 0xcaf5, 0xcac5,
 0xe279, 0xdfb0, 0xe8eb, 0xf3b4, 0xf6ac,
 0xc9b0, 0xcc46, 0xd3c6, 0xd7e1, 0xe24b,
};

static ZhiCode codelist6859[] = {
 0xbbba, 0xb24c, 0xc4fe, 0xf4ad, 0xe256,
 0xe5af, 0xc9e2, 0xe3f0,
};

static ZhiCode codelist6860[] = {
 0xa4ed, 0xba70, 0xadc5, 0xdd67, 0xd37d,
 0xb9d5, 0xcdc0, 0xd853, 0xdccb, 0xe5de,
 0xc164, 0xeac6, 0xe366, 0xd9ce, 0xe3c8,
 0xe848,
};

static ZhiCode codelist6864[] = {
 0xbfcb, 0xab49, 0xb4dc, 0xd3da, 0xef5d,
 0xbc6b, 0xdf5c, 0xf25c, 0xe86a,
};

static ZhiCode codelist6866[] = {
 0xb6d4, 0xb55e, 0xafb3, 0xb856, 0xbee0,
 0xaae0, 0xecfe, 0xecdf, 0xbeb2, 0xcdc1,
 0xeb5e, 0xdc74, 0xdd41, 0xe5c2, 0xd368,
 0xe0dd, 0xe9fd, 0xcad0, 0xcdad, 0xd3c6,
 0xd7e1, 0xdca4,
};

static ZhiCode codelist6867[] = {
 0xb9ec, 0xcccf, 0xd8d4, 0xe9b7, 0xee60,
 0xcaab, 0xef48,
};

static ZhiCode codelist6868[] = {
 0xa847, 0xbcc3, 0xd0f7, 0xdb6b,
};

static ZhiCode codelist6872[] = {
 0xba6a, 0xb5c4, 0xc2f2, 0xaaca, 0xb6e6,
 0xb76d, 0xc3f2, 0xf366, 0xe3d6, 0xeebe,
 0xccc2, 0xe2d2, 0xd9aa, 0xf142, 0xebe1,
 0xcd7b, 0xe1ac, 0xb14e, 0xe2c5, 0xeea8,
};

static ZhiCode codelist6874[] = {
 0xb16a, 0xc0f0, 0xc1a5, 0xa9cf, 0xf9d9,
 0xe952, 0xc0ce, 0xc962, 0xe27c, 0xf5fb,
 0xe970, 0xbeca,
};

static ZhiCode codelist6875[] = {
 0xb16a, 0xb76d, 0xee75, 0xeaaa, 0xdcc4,
 0xe168, 0xc166,
};

static ZhiCode codelist6876[] = {
 0xb6e6, 0xf5ee, 0xd476, 0xe2c4, 0xeebe,
};

static ZhiCode codelist6880[] = {
 0xb24d, 0xab43, 0xbbb4, 0xb6c9, 0xadeb,
 0xb242, 0xbb66, 0xb3bc, 0xc44a, 0xd4ab,
 0xd9e6, 0xcb67, 0xd7f0,
};

static ZhiCode codelist6882[] = {
 0xb1a1, 0xb4b8, 0xc0ba, 0xb6c9, 0xc0d2,
 0xd0ed, 0xd5da, 0xe5e0, 0xd5de,
};

static ZhiCode codelist6883[] = {
 0xbdd0, 0xb3bc, 0xe1b8,
};

static ZhiCode codelist6884[] = {
 0xbc79, 0xc16a, 0xbfcb, 0xd0e1, 0xe376,
 0xf0e7, 0xbf6b, 0xe653, 0xcb4d, 0xf76a,
 0xe4be, 0xd5a2, 0xdeed, 0xf2ba,
};

static ZhiCode codelist7040[] = {
 0xb0cf, 0xa97d, 0xc558, 0xc1cd, 0xc2df,
 0xb9f2, 0xa6b1, 0xb349, 0xc2a3, 0xd7b6,
 0xe5be, 0xb5f1, 0xca5d, 0xafa3, 0xd058,
 0xcc60, 0xd2e7, 0xcbdc, 0xc942, 0xccb6,
 0xcdd8, 0xe8a5, 0xec76, 0xf3e2, 0xf85c,
 0xd6e5, 0xec71,
};

static ZhiCode codelist7042[] = {
 0xb4eb, 0xa757, 0xc454, 0xc5fc, 0xf0d1,
 0xc2a3, 0xf7ec, 0xc0f3, 0xf6e7, 0xf5f8,
 0xedaa, 0xeaf8, 0xcefa, 0xdc43, 0xeca9,
 0xd6fa, 0xdfc9, 0xe057, 0xe979, 0xee6b,
 0xf1e7, 0xf3fd, 0xf5d6, 0xf6e4, 0xf745,
 0xf8be, 0xf951, 0xd061, 0xcee9, 0xd5f8,
 0xdba7, 0xefa8,
};

static ZhiCode codelist7043[] = {
 0xa8fa, 0xa6b1, 0xb0f9, 0xc654, 0xcfa6,
 0xd6e5,
};

static ZhiCode codelist7044[] = {
 0xa568, 0xbdec, 0xb0f9, 0xbaa3, 0xf2f3,
 0xeef1, 0xda40, 0xecb2, 0xca6d, 0xf1e1,
};

static ZhiCode codelist7072[] = {
 0xafca, 0xc2f6, 0xe3c5,
};

static ZhiCode codelist7074[] = {
 0xbf61,
};

static ZhiCode codelist7076[] = {
 0xab6f, 0xbd54, 0xc44e, 0xb3b6, 0xa9c4,
 0xc2f6, 0xba65, 0xdd7c, 0xabf1, 0xb4df,
 0xc1f0, 0xe1c3, 0xd14f, 0xdacc, 0xdee7,
 0xe6c1, 0xf05b, 0xdad0, 0xded6, 0xe269,
 0xf5e1,
};

static ZhiCode codelist7112[] = {
 0xb0e9, 0xd1aa, 0xd9af, 0xcebc, 0xdafa,
 0xd557,
};

static ZhiCode codelist7114[] = {
 0xa5fe, 0xc576, 0xac75, 0xb8e0, 0xaeb1,
 0xbbcd, 0xb2ac, 0xf9af, 0xbb6c, 0xdae2,
 0xa8f7, 0xaffe, 0xf1bb, 0xd2a1, 0xe079,
 0xa8de, 0xa4fc, 0xbdf4, 0xeec7, 0xced1,
 0xd4cf, 0xda68, 0xe041, 0xec68, 0xf5ca,
 0xf6d4, 0xf8bd, 0xce74, 0xdebe, 0xe070,
 0xead2, 0xf9a3,
};

static ZhiCode codelist7115[] = {
 0xa4fc, 0xe365, 0xaab6, 0xacca, 0xd66e,
 0xf946, 0xcb51,
};

static ZhiCode codelist7116[] = {
 0xc455, 0xa8e9, 0xd2a2, 0xd279, 0xdaf3,
 0xb0e9,
};

static ZhiCode codelist7120[] = {
 0xd7e7, 0xe45f, 0xd16e,
};

static ZhiCode codelist7122[] = {
 0xb873, 0xb8c8, 0xd167,
};

static ZhiCode codelist7136[] = {
 0xcb7c, 0xaac6, 0xe4a9,
};

static ZhiCode codelist7138[] = {
 0xbd61, 0xc3a3, 0xcb7c, 0xaac6, 0xe072,
 0xdbbc, 0xd946, 0xca54, 0xea63, 0xf2c8,
 0xe6bd, 0xde72, 0xd6cc, 0xe076, 0xf2d5,
 0xd1e0, 0xd7d5, 0xdadf, 0xe9d5, 0xdfb3,
};

static ZhiCode codelist7168[] = {
 0xa3a3,
};

static ZhiCode codelist7296[] = {
 0xa6e8, 0xa7c6, 0xa76c, 0xc4e2, 0xbc48,
 0xc4eb, 0xb57d, 0xb178, 0xb7cb, 0xaa52,
 0xc1b5, 0xbab3, 0xc148, 0xbda5, 0xb4cf,
 0xc2e7, 0xbc5e, 0xa4bc, 0xb552, 0xb4b7,
 0xbfaa, 0xb2a5, 0xc466, 0xb9af, 0xbb68,
 0xcaed, 0xbf51, 0xae4f, 0xcfe6, 0xf94c,
 0xc3d6, 0xb1e3, 0xd5d8, 0xc1d1, 0xe9ca,
 0xf445, 0xb258, 0xded5, 0xae44, 0xb26d,
 0xd85d, 0xdd63, 0xcec5, 0xeab3, 0xdae8,
 0xe451, 0xf151, 0xf87b, 0xd244, 0xd257,
 0xe652, 0xed5e, 0xf6f3, 0xcfdc, 0xf65c,
 0xdd47, 0xf172, 0xd1a9, 0xdac0, 0xd6b4,
 0xf8bf, 0xf972, 0xe250, 0xe9e0, 0xf46b,
 0xd677, 0xeb65, 0xcde6, 0xcebe, 0xcebf,
 0xd15d, 0xd16a, 0xc1c6, 0xd769, 0xdb6f,
 0xdcbe, 0xe5df, 0xeb6a, 0xeeb5, 0xeeb6,
 0xf1d8, 0xf55c, 0xf9c3, 0xd0be, 0xd5d0,
 0xd949, 0xe8f9, 0xf547, 0xe44d, 0xeda7,
};

static ZhiCode codelist7298[] = {
 0xb2df, 0xa9f5, 0xaea7, 0xae75, 0xb1a4,
 0xb740, 0xbffc, 0xc5a7, 0xbab6, 0xbb56,
 0xc1b7, 0xc0ca, 0xe444, 0xeef5, 0xe3fc,
 0xe1af, 0xeb67, 0xf7b1, 0xdb4b, 0xe5d5,
 0xda62, 0xf0df, 0xf169, 0xd1f6, 0xd9b6,
 0xe3cd, 0xe6b3, 0xea5f, 0xee4f, 0xf37b,
 0xf552, 0xf679, 0xe7a4,
};

static ZhiCode codelist7299[] = {
 0xb3df, 0xac7e, 0xb170, 0xc3a2, 0xc4ce,
 0xe1a2, 0xe775, 0xf8a6, 0xcf56, 0xf0bd,
 0xeddc, 0xf8fe, 0xf143, 0xf971, 0xc943,
 0xd2a7, 0xeba9, 0xedc7, 0xdfc4, 0xe2ab,
 0xe9b1,
};

static ZhiCode codelist7300[] = {
 0xb2d3, 0xc0b8, 0xab59, 0xa874, 0xc3b4,
 0xa469, 0xa6c1, 0xbbd8, 0xbef9, 0xf1be,
 0xb5bf, 0xcda5, 0xcdfd, 0xf8a8, 0xdf62,
 0xcdae, 0xe0ab, 0xf151, 0xf1ad, 0xde67,
 0xe7cd, 0xf65c, 0xbcf3, 0xdb57, 0xaabf,
 0xf972, 0xc96d, 0xcca7, 0xd7fb, 0xf15b,
 0xd7fa, 0xe05d, 0xd3fd, 0xe2bf, 0xe7cf,
 0xeb4d, 0xecb5, 0xeea3, 0xf0ba, 0xcc79,
 0xcece, 0xd962, 0xe2f9, 0xf7cc,
};

static ZhiCode codelist7304[] = {
 0xbd4d, 0xbdbc, 0xcac2, 0xe0e1, 0xeed5,
};

static ZhiCode codelist7306[] = {
 0xb776, 0xae6c, 0xc1d2, 0xc1f8, 0xab4c,
 0xaf55, 0xaeb5, 0xa758, 0xa945, 0xb949,
 0xdac6, 0xaaad, 0xb7e5, 0xb1d7, 0xc35c,
 0xac6a, 0xd6c1, 0xaca2, 0xdfa3, 0xe2f5,
 0xf3ba, 0xdda1, 0xd27a, 0xcbcf, 0xd6dc,
 0xeada, 0xd2bb, 0xd445, 0xe6c0, 0xebba,
 0xec78, 0xee45,
};

static ZhiCode codelist7308[] = {
 0xa455, 0xae4c, 0xc07e, 0xb748, 0xb776,
 0xede1, 0xcb79, 0xd1f8, 0xf367, 0xf6b2,
};

static ZhiCode codelist7328[] = {
 0xa8c7, 0xb7b2, 0xc3c8, 0xe7b2, 0xda74,
 0xe7cd, 0xdcce,
};

static ZhiCode codelist7330[] = {
 0xa8f3, 0xbe63, 0xb1d7, 0xafd9, 0xbfd3,
 0xa8b8, 0xb0ba, 0xbe65, 0xaeb5, 0xdaf4,
 0xc4e2, 0xc25e, 0xbc45, 0xf5e9, 0xf648,
 0xd746, 0xdd71, 0xc9c0, 0xe7be, 0xce5c,
 0xcedb, 0xd044, 0xd15a, 0xf9a1, 0xdd6a,
 0xddb2, 0xdeba, 0xe2c3, 0xed5f,
};

static ZhiCode codelist7331[] = {
 0xbc67, 0xa6e5,
};

static ZhiCode codelist7332[] = {
 0xc1c2, 0xb1f1, 0xacaa, 0xae68, 0xc26d,
 0xbed3, 0xa8f8, 0xaa6e, 0xc3c9, 0xb8d1,
 0xb150, 0xc1b6, 0xba6b, 0xabb4, 0xc062,
 0xe972, 0xd9f1, 0xc1db, 0xc0e8, 0xb7a4,
 0xdaf2, 0xedfc, 0xb2d8, 0xd8b7, 0xe963,
 0xe9f7, 0xf263, 0xea5e, 0xf8c3, 0xcb5f,
 0xd2c9, 0xf1a1, 0xe4da, 0xef5a, 0xd44c,
 0xecfb, 0xf3fc, 0xca67, 0xcab6, 0xcff8,
 0xe24a, 0xec57, 0xe561, 0xd65b, 0xd95b,
 0xf6d3, 0xf8c5,
};

static ZhiCode codelist7352[] = {
 0xaef8, 0xbe50, 0xbfbd, 0xc374, 0xae64,
 0xb370, 0xc4db, 0xc2ad, 0xab64, 0xb576,
 0xbe5d, 0xadfd, 0xc5bb, 0xb1fa, 0xf74e,
 0xcf4a, 0xef69, 0xeca6, 0xe4f9, 0xdf60,
 0xb9cc, 0xe263, 0xe646, 0xd26e, 0xe6a1,
 0xd3b7, 0xdfea, 0xdab0, 0xe57d, 0xca41,
 0xcbe2, 0xedb4, 0xcf6d, 0xd251, 0xdab4,
 0xdfbf, 0xe45d, 0xeaea, 0xf0a7, 0xf457,
 0xf564, 0xf7e3, 0xf947, 0xd175, 0xd4aa,
 0xdadb, 0xf672, 0xf0e2,
};

static ZhiCode codelist7354[] = {
 0xbec7, 0xcf6d, 0xd342, 0xd7f1,
};

static ZhiCode codelist7355[] = {
 0xa470, 0xbee5, 0xdf4e, 0xc151, 0xeea7,
};

static ZhiCode codelist7356[] = {
 0xaed5, 0xafba, 0xa7b5, 0xaec4, 0xbbc3,
 0xbc53, 0xa876, 0xb3cb, 0xcec1, 0xea53,
 0xe45a,
};

static ZhiCode codelist7360[] = {
 0xadd7, 0xa5f0, 0xb2db, 0xb2e7, 0xaba6,
 0xceba, 0xe05a, 0xec70, 0xf3af, 0xefa2,
 0xe2aa, 0xe5ed, 0xdb56, 0xd3aa, 0xe4b8,
 0xe774, 0xeeeb, 0xe2ad,
};

static ZhiCode codelist7363[] = {
 0xa6b4, 0xb14a, 0xeac8,
};

static ZhiCode codelist7364[] = {
 0xa871, 0xc2b8, 0xc4c3, 0xb353, 0xb6e5,
 0xb14a, 0xafe4, 0xf9d7, 0xd671, 0xb7cd,
 0xa9a6, 0xd2b5, 0xc9a7, 0xe268, 0xe7cc,
 0xeb69,
};

static ZhiCode codelist7368[] = {
 0xa5fd, 0xa550, 0xb1c8, 0xc241, 0xc5d6,
 0xbee6, 0xa96b, 0xf443, 0xe9a2, 0xf75f,
 0xe479, 0xaac4, 0xef44, 0xcf5b, 0xcb49,
 0xf3b2, 0xe957, 0xc96a, 0xc977, 0xc9d0,
 0xccdc, 0xcae0, 0xe647, 0xf96c, 0xace6,
 0xdcb9, 0xe148, 0xe3d0, 0xee73, 0xf447,
 0xf7fd, 0xd2b9,
};

static ZhiCode codelist7370[] = {
 0xbde5, 0xb6a2, 0xb6fb, 0xab77, 0xc4d0,
 0xa9b6, 0xbbce, 0xb2cd, 0xbc5f, 0xf9dc,
 0xb243, 0xb0e5, 0xb2ec, 0xb67e, 0xed77,
 0xeba3, 0xd77d, 0xe5a7, 0xf870, 0xd4e6,
 0xdfba, 0xd056, 0xdbb8, 0xe6f2, 0xea47,
 0xf479, 0xf871, 0xd4a1,
};

static ZhiCode codelist7371[] = {
 0xc049, 0xc5e3, 0xc241, 0xc57e, 0xc4f6,
 0xbbd1, 0xeffb, 0xe06e, 0xe964, 0xb8c3,
 0xce68, 0xdd4b, 0xf1fe, 0xea60, 0xed64,
 0xf7e8, 0xdae6, 0xf850, 0xd240, 0xd276,
 0xeedd, 0xdda3, 0xf87a, 0xf8eb, 0xd7d4,
 0xf242, 0xe342,
};

static ZhiCode codelist7372[] = {
 0xbfa4, 0xb27b, 0xbd75, 0xadad, 0xbecb,
 0xc46d, 0xb872, 0xb3b4, 0xb8a2, 0xc060,
 0xb8c3, 0xb341, 0xc4c5, 0xcde4, 0xb9b7,
 0xae73, 0xd5ab, 0xdabd, 0xeeb1, 0xf657,
 0xe87c, 0xd262, 0xf265, 0xdf56, 0xd162,
 0xe5b6, 0xebec, 0xce76,
};

static ZhiCode codelist7376[] = {
 0xa4df, 0xb773, 0xa8af, 0xc17e, 0xaa59,
 0xbe4e, 0xc4c9, 0xf8ca, 0xb2f1, 0xcd51,
 0xddf5, 0xaae4, 0xa9fd, 0xb360, 0xdc63,
 0xcfe7, 0xd860, 0xe574, 0xcae3, 0xcabb,
 0xe946,
};

static ZhiCode codelist7378[] = {
 0xb44d, 0xe856, 0xccdf, 0xe9af, 0xf0d8,
};

static ZhiCode codelist7379[] = {
 0xc9b3,
};

static ZhiCode codelist7380[] = {
 0xab48, 0xc65d, 0xaae4, 0xda5c, 0xf4b5,
 0xeaf2, 0xc9c7, 0xcabb, 0xde76, 0xca58,
};

static ZhiCode codelist7384[] = {
 0xb66d, 0xacdb, 0xadbb, 0xbd63, 0xb4f0,
 0xc1b8, 0xc65e, 0xb45b, 0xf9b3, 0xe6e7,
 0xeb52, 0xc4ec, 0xf7ee, 0xf5d2, 0xdfb9,
 0xf448,
};

static ZhiCode codelist7386[] = {
 0xb8d4, 0xb2bb, 0xadb0, 0xb5be, 0xabd6,
};

static ZhiCode codelist7387[] = {
 0xb751, 0xc554, 0xa8c9, 0xbbe8, 0xc557,
 0xf3d0, 0xf959, 0xd1d6,
};

static ZhiCode codelist7388[] = {
 0xabd1, 0xa656, 0xacdb, 0xb9b3, 0xb6b5,
 0xb648, 0xbef3, 0xc251, 0xe9b8, 0xf0ce,
 0xdfdd, 0xeeef, 0xf0c7, 0xf0d7, 0xf541,
 0xb66d, 0xced0, 0xe64d, 0xf85f,
};

static ZhiCode codelist7392[] = {
 0xbfb3, 0xac50, 0xb556, 0xb87b, 0xc4c9,
 0xb469, 0xef58, 0xde7a, 0xdebc, 0xd060,
 0xd153, 0xdfe8, 0xee7c, 0xf9b2,
};

static ZhiCode codelist7394[] = {
 0xa6e6, 0xa7ce, 0xabac, 0xa644, 0xa8b7,
 0xb0a4, 0xb2ba, 0xe478, 0xef4f, 0xcbb6,
 0xd278, 0xcfad, 0xd36e, 0xe87b, 0xed50,
};

static ZhiCode codelist7395[] = {
 0xacd9, 0xbff4, 0xecec, 0xd9fb,
};

static ZhiCode codelist7396[] = {
 0xa6e6, 0xbfb3, 0xa9ca, 0xa9af, 0xa96d,
 0xa7f6, 0xadc6, 0xb1a2, 0xd3ae, 0xd4d2,
 0xd763, 0xd5e5,
};

static ZhiCode codelist7552[] = {
 0xb6b7, 0xbbdd, 0xb5ea, 0xc5bd, 0xbc4e,
 0xbc56, 0xa6a6, 0xad45, 0xb058, 0xa653,
 0xe9df, 0xcd77, 0xe559, 0xf4ac, 0xd1fc,
 0xcaf9, 0xcbe6, 0xddd7, 0xecd2, 0xf768,
 0xcf64, 0xd0d8, 0xe346, 0xe6e9, 0xe7ad,
 0xeb53, 0xf7a1, 0xf7a8, 0xd1d5, 0xd8f3,
 0xd963, 0xe6e0,
};

static ZhiCode codelist7554[] = {
 0xae7d,
};

static ZhiCode codelist7555[] = {
 0xb35c, 0xaedd, 0xb7d6, 0xaba6, 0xe048,
 0xd0df, 0xcc4a, 0xd9fa, 0xeba5, 0xebda,
 0xe859, 0xd2b7, 0xd872,
};

static ZhiCode codelist7556[] = {
 0xa7c7, 0xc4f2, 0xbb57, 0xbafc, 0xb1d4,
 0xb5b6, 0xa6b0, 0xabf2, 0xa8f9, 0xb3a4,
 0xb442, 0xaf62, 0xacae, 0xc9ee, 0xcbc4,
 0xdd66, 0xe2a9, 0xf2cc, 0xb97a, 0xcdb9,
 0xf0ac, 0xe8d8, 0xd46d, 0xb1e5, 0xdbd8,
 0xf95b, 0xd277, 0xcca1, 0xd154, 0xdf43,
 0xed7c, 0xe4b0, 0xcd45, 0xcef3, 0xe2e2,
};

static ZhiCode codelist7584[] = {
 0xc1a7, 0xb975, 0xbebb, 0xe966, 0xca7b,
};

static ZhiCode codelist7586[] = {
 0xbec7, 0xa5de, 0xf8e6, 0xf4cd, 0xe460,
 0xed62, 0xed4f, 0xe950,
};

static ZhiCode codelist7587[] = {
 0xb3b7, 0xf7ab,
};

static ZhiCode codelist7588[] = {
 0xa6e5, 0xb3b7, 0xa5de, 0xab64, 0xe065,
 0xccef, 0xee7e, 0xcc5c, 0xd7b3,
};

static ZhiCode codelist7624[] = {
 0xabc5, 0xb061, 0xb3d9, 0xdeb1, 0xb8a9,
 0xb779, 0xc0a5, 0xe4eb, 0xbfdc, 0xdce4,
 0xe953, 0xd955, 0xf2bf, 0xeb7e, 0xd94a,
 0xaecf, 0xeedf, 0xf6c3, 0xd5cc, 0xb7dc,
 0xdfc5, 0xd950, 0xca69, 0xcccc, 0xe86d,
 0xd8c5, 0xeaae, 0xe7a1, 0xf2e0, 0xf475,
};

static ZhiCode codelist7626[] = {
 0xa5c8, 0xb1db, 0xc461, 0xba78, 0xe6a2,
 0xc27b, 0xca66, 0xcc4b, 0xd66f, 0xcfcb,
 0xe17a, 0xe7d6, 0xc1d9, 0xbfa4, 0xdfed,
};

static ZhiCode codelist7627[] = {
 0xbfef, 0xcdfa, 0xd26a,
};

static ZhiCode codelist7628[] = {
 0xacaf, 0xb5ba, 0xba78, 0xaf74, 0xccf0,
 0xb4e8, 0xb1db, 0xd6ad, 0xddc9, 0xe5c0,
 0xb962, 0xd7b1, 0xe77c, 0xef60, 0xec54,
 0xf361, 0xceec, 0xdddd, 0xd7b4, 0xedd1,
 0xf758, 0xf845,
};

static ZhiCode codelist7632[] = {
 0xbeb1, 0xc2c8, 0xc274, 0xe2c0, 0xc548,
 0xce7d, 0xefdb, 0xd64f, 0xed65, 0xf4ae,
 0xf0a1, 0xe765, 0xb3d4, 0xf27b,
};

static ZhiCode codelist7634[] = {
 0xb44d, 0xa8b5, 0xb8df, 0xb460, 0xa6af,
 0xb9a5, 0xbcf1, 0xd2b1, 0xf0c3, 0xacac,
 0xaffb, 0xabe0, 0xcecb, 0xce7d, 0xd1ec,
 0xea4b, 0xc27b, 0xd04a, 0xd0bd, 0xf858,
 0xe262, 0xe5b4, 0xcce8, 0xce4f, 0xea67,
 0xe9ce, 0xeb43, 0xe540,
};

static ZhiCode codelist7636[] = {
 0xb054, 0xb056, 0xa8b3, 0xbbb9, 0xaeee,
 0xb9a5, 0xabe0, 0xb453, 0xa6c4, 0xbfb8,
 0xe541, 0xcbc0, 0xbcf2, 0xf1a3, 0xd3ed,
 0xf1da,
};

static ZhiCode codelist7648[] = {
 0xa553, 0xa5fb, 0xafdd, 0xa4bf, 0xa649,
 0xaca4, 0xcae2, 0xce46, 0xcecc,
};

static ZhiCode codelist7650[] = {
 0xb6af, 0xbab5, 0xe05c,
};

static ZhiCode codelist7652[] = {
 0xe5c0, 0xdbdb,
};

static ZhiCode codelist7680[] = {
 0xa4a7, 0xaabe, 0xb0a6, 0xc2b4, 0xa4e4,
 0xaa4b, 0xa5c4, 0xa575, 0xa773, 0xaadb,
 0xafd7, 0xaacf, 0xbb6a, 0xace9, 0xb1f7,
 0xafad, 0xa4f3, 0xcf4c, 0xa3a4, 0xad4f,
 0xecae, 0xa567, 0xdda5, 0xcffc, 0xdbf4,
 0xaa7c, 0xe8e8, 0xcb5b, 0xd2f2, 0xe243,
 0xd059, 0xd3dc, 0xd9d8,
};

static ZhiCode codelist7682[] = {
 0xaabd, 0xc2be, 0xbde8, 0xadc8, 0xb4d3,
 0xb0f5, 0xb4de, 0xc259, 0xabbf, 0xcbbb,
 0xf0f9, 0xee68, 0xc5ad, 0xd1e8, 0xd4b2,
 0xdef9, 0xba54, 0xedde, 0xcf50, 0xda6a,
 0xd6c7, 0xefd1, 0xe4d8, 0xe57a, 0xe9be,
 0xeae8, 0xefce, 0xf0cd, 0xdbce, 0xdebf,
 0xe55b, 0xf748,
};

static ZhiCode codelist7683[] = {
 0xa575, 0xabfc, 0xafc8, 0xa4ee, 0xa6ae,
 0xa77d, 0xbc78, 0xace9, 0xb36b, 0xace7,
 0xaba4, 0xcf4c, 0xe0ad, 0xcec7, 0xcb54,
 0xcbaf, 0xaae9, 0xdcb0, 0xdc40, 0xd2c5,
 0xd1d3, 0xca74, 0xcaaa, 0xf2da, 0xd1f2,
 0xd643, 0xde56,
};

static ZhiCode codelist7684[] = {
 0xa6dc, 0xa8ee, 0xaa76, 0xa7d3, 0xbb73,
 0xad50, 0xb86d, 0xb4bc, 0xafb4, 0xbb78,
 0xb858, 0xbde8, 0xabcf, 0xbd6f, 0xbc6d,
 0xbaa2, 0xbcb0, 0xb2bf, 0xaaa5, 0xb2a9,
 0xb96e, 0xc3d1, 0xece4, 0xb569, 0xb8fe,
 0xf563, 0xcc6f, 0xd446, 0xaabe, 0xdd49,
 0xcadb, 0xd1e8, 0xc5ae, 0xb5ed, 0xf0f4,
 0xf7c1, 0xcbda, 0xf84b, 0xcba4, 0xceb6,
 0xd8f4, 0xd664, 0xd67a, 0xe2d9, 0xd6e9,
 0xf2f5, 0xd0bb, 0xe47e, 0xd45f, 0xe06a,
 0xe850, 0xe878, 0xf257, 0xd7ba, 0xf67e,
 0xd5f4, 0xd2a6, 0xf47e, 0xd36c, 0xe6fd,
 0xee70, 0xced9, 0xcfa3, 0xe445, 0xceb7,
 0xecad, 0xd0b3, 0xd6f9, 0xdb55, 0xec64,
 0xd2ec, 0xe042, 0xeca8,
};

static ZhiCode codelist7688[] = {
 0xb4ed, 0xa4e3, 0xb3e5, 0xddd3, 0xac64,
 0xf966, 0xcf48, 0xea74, 0xccbc, 0xcee1,
 0xe5d7, 0xf0e1,
};

static ZhiCode codelist7690[] = {
 0xa4e3, 0xa5be, 0xb2cf, 0xb968, 0xacb5,
 0xe8ad, 0xeed4, 0xd0f5, 0xe35a, 0xd7ac,
 0xf343, 0xf9a8,
};

static ZhiCode codelist7691[] = {
 0xaf77, 0xb4ed, 0xec7a, 0xca75, 0xd078,
};

static ZhiCode codelist7692[] = {
 0xba5e, 0xac5d, 0xacb5, 0xb642, 0xa545,
 0xb763, 0xb34b, 0xa951, 0xe3dc, 0xa65c,
 0xde4b, 0xafa4, 0xeeca, 0xec7a, 0xd2c6,
 0xedc0,
};

static ZhiCode codelist7704[] = {
 0xbe42, 0xc1b1, 0xd5ae, 0xe177,
};

static ZhiCode codelist7706[] = {
 0xa7e9, 0xadf5, 0xba50, 0xc4e0, 0xc1b7,
 0xc2d6, 0xbbb3, 0xba4b, 0xc2e1, 0xe1cd,
 0xb8bd, 0xe6c6, 0xc947, 0xf842, 0xd5ae,
 0xf1c6, 0xcb73, 0xd551, 0xcff3, 0xf0ed,
 0xd0a7, 0xf8e1, 0xf94d, 0xf273,
};

static ZhiCode codelist7707[] = {
 0xaacc, 0xbdea, 0xebe3,
};

static ZhiCode codelist7708[] = {
 0xb36f, 0xaefd, 0xbda9, 0xc5c2, 0xcf43,
 0xa676, 0xecfa, 0xd270, 0xee5b,
};

static ZhiCode codelist7709[] = {
 0xb5db, 0xbe42, 0xd5ae, 0xe177,
};

static ZhiCode codelist7720[] = {
 0xba4b, 0xc24e, 0xbbf4, 0xd1c7,
};

static ZhiCode codelist7722[] = {
 0xa676, 0xbb43,
};

static ZhiCode codelist7723[] = {
 0xafb6, 0xcc68,
};

static ZhiCode codelist7724[] = {
 0xb6c5, 0xb9eb, 0xb2bd, 0xb364, 0xea71,
 0xd6b9,
};

static ZhiCode codelist7736[] = {
 0xb4c2, 0xa9db, 0xac4c, 0xa56c, 0xb5db,
 0xbc4a, 0xb078, 0xe8cf, 0xe0b8, 0xaed0,
 0xcfdf, 0xeee9, 0xcc4f,
};

static ZhiCode codelist7738[] = {
 0xb5db,
};

static ZhiCode codelist7739[] = {
 0xa7e4, 0xaa68, 0xa4f6, 0xdba8, 0xe2d1,
};

static ZhiCode codelist7740[] = {
 0xb7d3, 0xbbaf, 0xa56c, 0xb86e, 0xa5fc,
 0xbb46, 0xb640, 0xaed0, 0xd345, 0xc267,
 0xacb7, 0xe4bd, 0xcfc5, 0xb4cd, 0xe355,
 0xf3e4, 0xce55, 0xd97d, 0xe9bc,
};

static ZhiCode codelist7744[] = {
 0xa950, 0xb667, 0xa67b, 0xac77, 0xa6e0,
 0xb5b0, 0xe7ea, 0xb0e7, 0xed79, 0xf64e,
 0xe07a, 0xd876, 0xf1b8, 0xefa3, 0xcf7c,
 0xd645, 0xe4aa, 0xd2ba, 0xd550, 0xe84d,
 0xcbc5, 0xd4db,
};

static ZhiCode codelist7746[] = {
 0xb662, 0xa96f,
};

static ZhiCode codelist7747[] = {
 0xa9aa, 0xa879, 0xdee2, 0xf3ca,
};

static ZhiCode codelist7748[] = {
 0xb1de, 0xbd4b, 0xa97a, 0xacf4, 0xbfa8,
 0xab60, 0xa947, 0xedd9, 0xe2d7, 0xc3b3,
 0xce43, 0xd440, 0xe4f0, 0xcca6, 0xad48,
 0xe942, 0xe8cb,
};

static ZhiCode codelist7752[] = {
 0xb8e2, 0xaa67, 0xc2a4, 0xc0d6, 0xc04c,
 0xd1d0, 0xc4b8, 0xf8d6, 0xdbd1, 0xeec2,
 0xd1ea, 0xf8de, 0xf853, 0xa565, 0xcbe1,
 0xf676, 0xe0b9, 0xdbda, 0xee4c, 0xf4ce,
};

static ZhiCode codelist7755[] = {
 0xae69, 0xb1d9, 0xb7f8, 0xc1d3, 0xddaa,
 0xb9f1, 0xda7e, 0xf8d5, 0xe85c, 0xe4cc,
 0xe9cd, 0xf052, 0xeebb, 0xe55a, 0xe25e,
 0xe9d2,
};

static ZhiCode codelist7756[] = {
 0xa6fb, 0xbed4, 0xafb8, 0xbcc8, 0xa565,
 0xb4cc, 0xc5b8, 0xb4ef, 0xbaec, 0xf145,
 0xc5d9, 0xeb59, 0xf358, 0xe84a, 0xd44e,
};

static ZhiCode codelist7760[] = {
 0xaf75, 0xb077, 0xacc3, 0xad73, 0xb0bb,
 0xbad5, 0xb772, 0xbd65, 0xaf7a, 0xbac2,
 0xbfb2, 0xb7a9, 0xba64, 0xb645, 0xe3b8,
 0xdeb0, 0xde4c, 0xe2ec, 0xd065, 0xeed3,
 0xf97a, 0xd8cc, 0xe8d0, 0xf0ab, 0xe6d0,
 0xe9d7, 0xe657, 0xdeb2, 0xe0a2, 0xd8d5,
 0xe3bf, 0xeec0, 0xf4a7, 0xf6b8, 0xd8b3,
};

static ZhiCode codelist7763[] = {
 0xb645, 0xaa45, 0xaf6c, 0xdc48, 0xd2c1,
 0xd7bf, 0xbfa6, 0xe6d2, 0xd6ec, 0xf568,
 0xd2d4, 0xf7c8, 0xf35b, 0xccba, 0xcae8,
 0xd347, 0xdf61, 0xdad3, 0xddc7, 0xeadd,
 0xecb4,
};

static ZhiCode codelist7764[] = {
 0xc2ed, 0xb07d, 0xaeb6, 0xbe5f, 0xbbac,
 0xaed3, 0xaa45, 0xbe7d, 0xd95f, 0xd7f2,
 0xd6a8, 0xae57, 0xcde0, 0xced6, 0xd1da,
 0xdfe3, 0xd5b4, 0xe44a, 0xe5bd,
};

static ZhiCode codelist7768[] = {
 0xb169, 0xb3b9, 0xb9fc, 0xba73, 0xbccc,
 0xbcfd, 0xbabc, 0xe16b, 0xe5c6, 0xe468,
 0xc1ad, 0xf7aa, 0xe1c5, 0xdcb4, 0xe160,
 0xf6a1, 0xe852,
};

static ZhiCode codelist7771[] = {
 0xaaf8, 0xb478, 0xbaa6, 0xc953, 0xef41,
};

static ZhiCode codelist7772[] = {
 0xa456, 0xa54d, 0xb162, 0xbbd9, 0xbde3,
 0xb5c8, 0xa7fa, 0xbaa6, 0xaaf8, 0xb9f3,
 0xbf60, 0xe1a3, 0xc9e9, 0xea7d, 0xd048,
};

static ZhiCode codelist7776[] = {
 0xaaa7, 0xa9ba, 0xbb5d, 0xb843, 0xbc78,
 0xb1c3, 0xbae5, 0xa5bf, 0xa9c3, 0xb275,
 0xbffe, 0xb157, 0xbdd8, 0xc470, 0xe0b2,
 0xd26d, 0xeac3, 0xcc4d, 0xcfb3, 0xd4c9,
 0xd742, 0xa442, 0xd2cf,
};

static ZhiCode codelist7779[] = {
 0xbee3, 0xac40, 0xc9a1, 0xe5b3, 0xcda9,
};

static ZhiCode codelist7780[] = {
 0xbe47, 0xa5bf, 0xc3d2, 0xac46, 0xb5fd,
 0xaf67, 0xb1c3, 0xb456,
};

static ZhiCode codelist7936[] = {
 0xaf5d, 0xa6b6, 0xbdd1, 0xaee8, 0xbdde,
 0xb5ef, 0xaffc, 0xb2b9, 0xb8dd, 0xbbcb,
 0xa8dc, 0xcf78, 0xeff5, 0xd0bc, 0xf255,
 0xf24c, 0xd6be, 0xc3c5, 0xdaf9, 0xdbc8,
 0xe7d2, 0xef7d, 0xf640, 0xe3d8, 0xef73,
 0xf2d0,
};

static ZhiCode codelist7938[] = {
 0xa6cb, 0xbf76, 0xb376, 0xc0eb, 0xf2e2,
 0xb5ae, 0xaac7, 0xa5ba, 0xc4bd, 0xd754,
 0xb662, 0xd2f9, 0xe762, 0xd043, 0xdbef,
 0xf7b0, 0xf8ad, 0xf9a6, 0xd37a, 0xeac4,
};

static ZhiCode codelist7939[] = {
 0xa544, 0xc4dd, 0xb54e, 0xc5f1, 0xb64a,
 0xb25a, 0xc666, 0xecaf, 0xa9d6, 0xdec9,
 0xf8f0, 0xd2e0, 0xd847, 0xf8a7, 0xce5f,
 0xd35b, 0xf8f1, 0xcd46, 0xd2cd,
};

static ZhiCode codelist7940[] = {
 0xa6ed, 0xb5db, 0xa755, 0xaa60, 0xafac,
 0xbe6e, 0xb5f9, 0xac57, 0xb345, 0xc5b1,
 0xcfae, 0xad52, 0xa6ee, 0xbae6, 0xaa56,
 0xd6e2, 0xe37d, 0xc972, 0xcf4d, 0xd6f3,
 0xe0e7, 0xd2c3, 0xd777, 0xe0af, 0xd6e4,
 0xd8f0, 0xdbf1, 0xdc4b, 0xe5ec, 0xecb0,
 0xefe0, 0xcf67, 0xe7d9,
};

static ZhiCode codelist7944[] = {
 0xa7ec, 0xbee2, 0xef66, 0xecf9,
};

static ZhiCode codelist7947[] = {
 0xa4f6,
};

static ZhiCode codelist7952[] = {
 0xaebb, 0xaee0, 0xb267, 0xb4cd, 0xedb2,
};

static ZhiCode codelist7954[] = {
 0xa8f4, 0xad5f, 0xbf42, 0xa9e5, 0xc0de,
 0xb075, 0xa860, 0xb5db, 0xb0d6, 0xc54e,
 0xc0c2, 0xb55a, 0xe7d8, 0xd0d3, 0xe5c1,
 0xd97c, 0xd5bf, 0xd9b8, 0xda5a, 0xe3df,
 0xe840, 0xf7bf, 0xc9df, 0xc9fe, 0xac48,
 0xe6cb, 0xeab9, 0xd255, 0xd9ba, 0xf0e8,
 0xebe7, 0xd47e, 0xdf6b, 0xecef, 0xf4c7,
 0xc9ca, 0xd0ec, 0xf461,
};

static ZhiCode codelist7976[] = {
 0xabfb,
};

static ZhiCode codelist7979[] = {
 0xe06d,
};

static ZhiCode codelist7980[] = {
 0xabfb,
};

static ZhiCode codelist7984[] = {
 0xb06c, 0xc040, 0xb4d5, 0xab41, 0xf1b6,
 0xf3eb, 0xdfa1, 0xefa9,
};

static ZhiCode codelist7987[] = {
 0xcd44,
};

static ZhiCode codelist7988[] = {
 0xbaf3, 0xbc59, 0xc2d8, 0xead8, 0xb46d,
 0xec5d, 0xe2f0, 0xe3a7, 0xf770,
};

static ZhiCode codelist8008[] = {
 0xb14d, 0xbf6a, 0xad42, 0xc346, 0xe157,
 0xe46c, 0xf7ad, 0xdcc7, 0xe16d, 0xe6aa,
 0xedbe, 0xf7b8, 0xe740, 0xf0c4,
};

static ZhiCode codelist8011[] = {
 0xc2e0, 0xc4da,
};

static ZhiCode codelist8012[] = {
 0xb6c7, 0xc1c8, 0xbd66, 0xbcb6, 0xf2fc,
 0xf557, 0xc2e0, 0xb9b6, 0xdeb5, 0xedd3,
 0xdf7b,
};

static ZhiCode codelist8016[] = {
 0xbdce, 0xa4d9, 0xaad2, 0xcffe, 0xcdcf,
 0xcabd, 0xd7c9,
};

static ZhiCode codelist8019[] = {
 0xb7c7, 0xade3, 0xd447, 0xd4ad, 0xe362,
};

static ZhiCode codelist8020[] = {
 0xdefc,
};

static ZhiCode codelist8024[] = {
 0xb8cb, 0xb2f8, 0xbcce, 0xa7a9, 0xf9db,
 0xc9dc, 0xd5ce,
};

static ZhiCode codelist8027[] = {
 0xae4e,
};

static ZhiCode codelist8028[] = {
 0xaaac, 0xa7a7, 0xbcb2, 0xf9ba, 0xd659,
};

static ZhiCode codelist8032[] = {
 0xa4a4, 0xc4c1, 0xb2d7, 0xa9be, 0xc1e9,
 0xb04a, 0xa7d8, 0xacd8, 0xee6e, 0xc9b1,
 0xcab8, 0xe779, 0xcf60, 0xdea1, 0xcad4,
 0xd371, 0xcd58, 0xf7ed,
};

static ZhiCode codelist8035[] = {
 0xbad8, 0xb87e, 0xb6ef, 0xbfe6, 0xade0,
};

static ZhiCode codelist8036[] = {
 0xa4a4, 0xbad8, 0xadab, 0xa5f2, 0xb2b3,
 0xd8d8, 0xb546, 0xcb64, 0xd3d3, 0xd45c,
 0xd8af, 0xe6f0,
};

static ZhiCode codelist8192[] = {
 0xa659, 0xb045, 0xc3a8, 0xb7f6, 0xb6e1,
 0xb3f0, 0xa3a5, 0xd3fb, 0xc55e, 0xb2c7,
 0xdf5d, 0xecae, 0xdcf7, 0xe1db, 0xdaab,
 0xee5a, 0xd6b2, 0xf5bd, 0xd6c3, 0xdbe9,
 0xe7e2, 0xea77, 0xf96a, 0xf875, 0xf7c7,
};

static ZhiCode codelist8194[] = {
 0xabf9, 0xa6c0, 0xbff0, 0xb9a3, 0xb0cd,
 0xa6a2, 0xbc55, 0xcbfb, 0xbdf3, 0xe357,
 0xd3b3, 0xd7a8, 0xeac1, 0xd3ce, 0xd07a,
 0xd2c6, 0xcae1, 0xcb59, 0xd3a2, 0xaeeb,
 0xd1fa, 0xd741, 0xdbe9, 0xe062, 0xe34e,
 0xe577, 0xeea1, 0xd8f6,
};

static ZhiCode codelist8195[] = {
 0xa4d8, 0xbea6, 0xaea2, 0xa760, 0xa8d7,
 0xbfc9, 0xd9dd, 0xddb6, 0xd3bf, 0xceca,
 0xcede, 0xce6a, 0xd85e, 0xe04e, 0xe4a4,
 0xc9ad, 0xf57b,
};

static ZhiCode codelist8196[] = {
 0xa8aa, 0xafcd, 0xa5b8, 0xb6bd, 0xa577,
 0xbf4b, 0xb3d7, 0xdcbf, 0xb1d5, 0xd2d5,
 0xccb8, 0xf555, 0xd1de, 0xe853, 0xc94c,
 0xe06b, 0xe460, 0xf7c2, 0xd44b, 0xe6b7,
 0xe0c9, 0xd0f4, 0xd5ea, 0xdece, 0xefc7,
 0xdd72, 0xe5ae,
};

static ZhiCode codelist8200[] = {
 0xae74, 0xb4a1, 0xa465, 0xb3e5, 0xeaf6,
 0xdcd8, 0xc9ea, 0xcb43, 0xd458, 0xea6a,
 0xf160,
};

static ZhiCode codelist8202[] = {
 0xac64, 0xb9ee, 0xaff9, 0xb767, 0xe241,
 0xeed0, 0xe2ed, 0xd068, 0xce51, 0xcda4,
};

static ZhiCode codelist8203[] = {
 0xebc1,
};

static ZhiCode codelist8204[] = {
 0xb8d2, 0xa7c3, 0xab62, 0xae74, 0xc9fc,
 0xd0ae, 0xe3dc, 0xcbb2, 0xc9cd, 0xd04c,
};

static ZhiCode codelist8216[] = {
 0xa8ae, 0xdacf, 0xd773,
};

static ZhiCode codelist8219[] = {
 0xa7e8, 0xe1e4, 0xf7d4,
};

static ZhiCode codelist8220[] = {
 0xb9fd, 0xbaab, 0xc2e1, 0xba4d, 0xb477,
 0xa95c, 0xc94b, 0xd0b6, 0xdace,
};

static ZhiCode codelist8232[] = {
 0xa9ee, 0xb3a6, 0xae74, 0xd85b,
};

static ZhiCode codelist8234[] = {
 0xaee3, 0xb05b, 0xbeab, 0xd6c2, 0xdcd7,
};

static ZhiCode codelist8236[] = {
 0xf2e3, 0xd3d9, 0xf6d7,
};

static ZhiCode codelist8248[] = {
 0xa7db, 0xb672, 0xb657, 0xb6d3, 0xcc70,
 0xcca2, 0xd7cb, 0xb6cf, 0xeae2,
};

static ZhiCode codelist8250[] = {
 0xb4c2, 0xbce9, 0xb15f, 0xbc4a, 0xaed0,
 0xe5dc, 0xf148, 0xe471,
};

static ZhiCode codelist8251[] = {
 0xa76e, 0xaaa3, 0xd2d8,
};

static ZhiCode codelist8252[] = {
 0xd366,
};

static ZhiCode codelist8256[] = {
 0xa9e2, 0xea6f, 0xddb1, 0xeac5, 0xf46c,
 0xd4db,
};

static ZhiCode codelist8258[] = {
 0xb754, 0xa4b3, 0xc477, 0xbaf7, 0xb953,
 0xb859, 0xd6e8, 0xc543, 0xc3a5, 0xb1a8,
 0xbb76, 0xbea9, 0xf841, 0xecdb, 0xc357,
 0xf0aa, 0xecd4, 0xd9d4, 0xdaf6, 0xdbac,
 0xece5, 0xe045, 0xec50, 0xeffd, 0xd1ee,
};

static ZhiCode codelist8259[] = {
 0xa4a1, 0xc1e0, 0xe2e4, 0xccd8, 0xcce4,
 0xca7c, 0xd770,
};

static ZhiCode codelist8260[] = {
 0xafe4, 0xedc5, 0xb7cd, 0xe268, 0xe57b,
};

static ZhiCode codelist8264[] = {
 0xba55, 0xc465, 0xd9c0, 0xf2ee, 0xcba6,
 0xe87e, 0xd8f8, 0xe956, 0xf5d0,
};

static ZhiCode codelist8266[] = {
 0xc4f1, 0xc2cd, 0xc149, 0xc661, 0xc5fe,
 0xbceb, 0xc3ca, 0xc460, 0xbc60, 0xb3e6,
 0xbf47, 0xe573, 0xb447, 0xf1ed, 0xc0d5,
 0xefed, 0xf464, 0xf75e, 0xf955, 0xeaa8,
 0xf7ef, 0xe0f7, 0xd9cd, 0xda52, 0xebee,
 0xde78, 0xe2cc, 0xf2b0, 0xf440, 0xf4e2,
};

static ZhiCode codelist8267[] = {
 0xb2a3, 0xc3ea, 0xc4c4, 0xb6d0, 0xeb41,
 0xe543, 0xf6d8, 0xcbb1, 0xe1ae, 0xea4c,
 0xbdd4, 0xf77c, 0xe56f, 0xf073, 0xe273,
 0xedba, 0xf7e4, 0xcafc, 0xf341,
};

static ZhiCode codelist8268[] = {
 0xc462, 0xc4f3, 0xc35f,
};

static ZhiCode codelist8272[] = {
 0xdcd2, 0xb560, 0xbd51, 0xd7eb, 0xe7ed,
 0xd9c7, 0xeeaf, 0xe7e1, 0xdda7, 0xd4ae,
};

static ZhiCode codelist8274[] = {
 0xb3af, 0xa849, 0xb1e1, 0xa6da, 0xb9d0,
 0xa8b0, 0xae57, 0xa7d5, 0xa848, 0xae66,
 0xbfdb, 0xde70, 0xd3b2, 0xe77d, 0xe5e7,
 0xd759, 0xd942, 0xdc71, 0xee6a, 0xf1de,
 0xf7bc, 0xc9af, 0xe5bd,
};

static ZhiCode codelist8275[] = {
 0xd577, 0xeaa7, 0xeed1, 0xdff1, 0xe15e,
 0xebbf, 0xf0f5,
};

static ZhiCode codelist8276[] = {
 0xb658, 0xbad9, 0xc5a8, 0xc468, 0xc640,
 0xaccf, 0xefb5, 0xf1f0, 0xf4c3, 0xefb8,
};

static ZhiCode codelist8280[] = {
 0xa9f7, 0xadd2, 0xb273, 0xb140, 0xec4b,
 0xdb75, 0xc449, 0xadce, 0xf6d0, 0xebf9,
 0xd640, 0xdaa8, 0xe3fb,
};

static ZhiCode codelist8282[] = {
 0xaaf8, 0xb160, 0xb3f5, 0xb9c1, 0xbb6e,
 0xc076, 0xb87a, 0xb9df, 0xf95a, 0xb175,
 0xc07c, 0xb5e7, 0xebf8, 0xe35e,
};

static ZhiCode codelist8283[] = {
 0xb3f5, 0xbc74, 0xb4af, 0xbefb, 0xceeb,
 0xebf3,
};

static ZhiCode codelist8284[] = {
 0xb0db, 0xadd2, 0xba5a, 0xb1a3, 0xd44a,
 0xef43,
};

static ZhiCode codelist8288[] = {
 0xbad9, 0xbcb5, 0xbf65, 0xf2de, 0xd457,
 0xecf7, 0xebb9, 0xdaa5, 0xe9da, 0xf4fe,
 0xd261, 0xd4bf, 0xd9d1, 0xda67, 0xedb8,
 0xd4f6, 0xf559,
};

static ZhiCode codelist8290[] = {
 0xa6a8, 0xb57b, 0xa9d3, 0xb2b1, 0xadbc,
 0xb8db, 0xa765, 0xabb0, 0xc367, 0xbce1,
 0xbeed, 0xa5e0, 0xe64a, 0xd9b3, 0xe473,
 0xd168, 0xd1d4, 0xdff4, 0xd0ba, 0xd14c,
 0xd5a3, 0xd9fe, 0xd66d, 0xd775, 0xf55d,
 0xd36f, 0xd749, 0xd957, 0xceae, 0xe4a8,
 0xdce6,
};

static ZhiCode codelist8291[] = {
 0xb378, 0xc1fe, 0xd1ad, 0xd547, 0xdcf0,
};

static ZhiCode codelist8292[] = {
 0xbad9, 0xafaf, 0xd457, 0xda67,
};

static ZhiCode codelist8448[] = {
 0xa558, 0xaaec, 0xc4d5, 0xf0f0,
};

static ZhiCode codelist8450[] = {
 0xb0a3, 0xc078, 0xbc70, 0xbe53, 0xc36f,
 0xc2fa, 0xafec, 0xc3dc, 0xde51, 0xf75d,
 0xeabe, 0xdf71, 0xdfef, 0xe0bc, 0xe3c1,
 0xb8f9, 0xf6bd, 0xefc6, 0xf0f0, 0xe060,
 0xe2c9,
};

static ZhiCode codelist8451[] = {
 0xb342, 0xb7a1, 0xc078, 0xc2a6, 0xaa53,
 0xbb75, 0xb4d8, 0xe9ea, 0xed47,
};

static ZhiCode codelist8452[] = {
 0xb342, 0xc4b2, 0xaf62, 0xb2d2, 0xc5f7,
 0xc24a, 0xd0d4, 0xa9c5, 0xdd7a, 0xc0d3,
 0xdbdc, 0xe0a4, 0xecf0, 0xc948, 0xcdcb,
 0xcd4d, 0xdaa2, 0xe462, 0xde47, 0xe4f1,
 0xedec, 0xd1cd,
};

static ZhiCode codelist8456[] = {
 0xd9db,
};

static ZhiCode codelist8464[] = {
 0xc257,
};

static ZhiCode codelist8468[] = {
 0xbaef, 0xbdf9, 0xc5c6, 0xd8bd, 0xb0e3,
 0xd55b, 0xf259, 0xe85d, 0xd4d8, 0xdec5,
 0xdc4e, 0xd15c, 0xca77, 0xd675, 0xeaab,
 0xdb4d, 0xe7ef, 0xe9a8, 0xf5c5,
};

static ZhiCode codelist8490[] = {
 0xe744,
};

static ZhiCode codelist8491[] = {
 0xb4a2,
};

static ZhiCode codelist8492[] = {
 0xbfe5, 0xe544,
};

static ZhiCode codelist8496[] = {
 0xa76a, 0xaaa4,
};

static ZhiCode codelist8498[] = {
 0xabab, 0xc2f1, 0xba6c, 0xddb4, 0xb4d5,
 0xb6ab, 0xc1e8, 0xb4a8, 0xddde, 0xbd69,
 0xd87c, 0xda50, 0xd45b, 0xdfc8, 0xbd78,
 0xd8c2, 0xdfa1, 0xe2d5,
};

static ZhiCode codelist8500[] = {
 0xa76a, 0xaaa4, 0xebaa,
};

static ZhiCode codelist8520[] = {
 0xacef, 0xa474, 0xf4fb, 0xcb4a, 0xdeb8,
};

static ZhiCode codelist8522[] = {
 0xb6c7, 0xb2ee, 0xe0a1, 0xdddc, 0xddf8,
 0xebaf, 0xe5c7, 0xebcc,
};

static ZhiCode codelist8523[] = {
 0xb3dd, 0xa6df, 0xd3b6,
};

static ZhiCode codelist8524[] = {
 0xa6ea, 0xb3a9, 0xcb6b, 0xca40, 0xc9cb,
 0xe455,
};

static ZhiCode codelist8528[] = {
 0xac4b, 0xddcf, 0xccd7, 0xebcf, 0xda59,
 0xf573, 0xd8c7, 0xddc5, 0xf5aa,
};

static ZhiCode codelist8530[] = {
 0xafc2, 0xae42, 0xbe4a, 0xb245, 0xe75d,
 0xc44c, 0xe27a, 0xebde, 0xef42, 0xb2e5,
 0xe9a3, 0xf3d3,
};

static ZhiCode codelist8531[] = {
 0xc4f8, 0xdd65, 0xebbd, 0xd462, 0xdfd8,
};

static ZhiCode codelist8536[] = {
 0xb5a1, 0xb3d0, 0xbd48, 0xa777, 0xe579,
 0xe1d7, 0xe1ec,
};

static ZhiCode codelist8538[] = {
 0xa7c9, 0xbc6c, 0xbcb2, 0xe9bf,
};

static ZhiCode codelist8539[] = {
 0xc2f4, 0xb76d, 0xe2b4,
};

static ZhiCode codelist8540[] = {
 0xb3d0, 0xc2f4, 0xb75b, 0xcbd4, 0xdeaf,
};

static ZhiCode codelist8544[] = {
 0xa552, 0xbdc4, 0xa852, 0xb2ea, 0xcadd,
 0xbca5, 0xcfcf, 0xd072, 0xd245, 0xf0fb,
 0xcff5,
};

static ZhiCode codelist8546[] = {
 0xadab, 0xb152, 0xa6e4, 0xc2ce, 0xcffa,
 0xd365, 0xe7c0, 0xdca3, 0xd3b5, 0xd6a1,
};

static ZhiCode codelist8547[] = {
 0xc364,
};

static ZhiCode codelist8548[] = {
 0xbdc4, 0xe0b6, 0xd96f,
};

static ZhiCode codelist8704[] = {
 0xa5a2, 0xac49, 0xae76, 0xb8d6, 0xc0e3,
 0xb7c3, 0xb7e0, 0xabcd, 0xa3a6, 0xbdbe,
 0xbc4e, 0xaaeb, 0xa472, 0xcba5, 0xe3b9,
 0xdfad, 0xe4e3, 0xd0b9, 0xda4f, 0xd6ea,
 0xf6b0, 0xde69, 0xf6c6, 0xe6d6, 0xee77,
 0xf948, 0xeb6b,
};

static ZhiCode codelist8706[] = {
 0xa451, 0xa4b0, 0xa5db, 0xaec9, 0xb9ea,
 0xadb9, 0xac42, 0xbb6b, 0xbad3, 0xae67,
 0xb4a3, 0xe3c2, 0xda41, 0xf6ad, 0xb6f6,
 0xd2e8, 0xf1e5, 0xe0c6, 0xe24d, 0xd9f3,
 0xde63, 0xf3f6, 0xd8d3,
};

static ZhiCode codelist8707[] = {
 0xa8cf, 0xa96c, 0xa576, 0xbe70, 0xa5da,
 0xabcb, 0xa8a8,
};

static ZhiCode codelist8708[] = {
 0xa5ab, 0xac4f, 0xa8c6, 0xa540, 0xa468,
 0xb6d5, 0xc3d1, 0xabc7, 0xa5dc, 0xb8d5,
 0xb5f8, 0xa6a1, 0xa4f3, 0xbe41, 0xc4c0,
 0xb9a2, 0xa8cd, 0xbb7d, 0xb375, 0xb6dd,
 0xabee, 0xa54b, 0xac55, 0xa8cf, 0xc1b1,
 0xb749, 0xbebd, 0xabf8, 0xb361, 0xd8ba,
 0xb862, 0xafe7, 0xb8fd, 0xebac, 0xdbea,
 0xbc5d, 0xcae6, 0xe9f5, 0xeba8, 0xf64b,
 0xe0b0, 0xd969, 0xe4ad, 0xd0fc, 0xe6fa,
 0xe8a4, 0xeeb0, 0xeec3, 0xf066, 0xf56c,
 0xf5ba, 0xe06d, 0xd272, 0xd8ed, 0xd8f6,
 0xdbd7, 0xdd72, 0xe7c9, 0xf8c0,
};

static ZhiCode codelist8709[] = {
 0xb0cd,
};

static ZhiCode codelist8712[] = {
 0xb1fe, 0xa846, 0xafbd, 0xace2, 0xb2ef,
 0xb7d9, 0xc354, 0xb8c6, 0xa7fc, 0xdaaf,
 0xf36a, 0xe8dd, 0xe5d9, 0xd2a3, 0xd546,
 0xe1e9, 0xe771, 0xdacd,
};

static ZhiCode codelist8714[] = {
 0xd4a3,
};

static ZhiCode codelist8715[] = {
 0xb6cc, 0xeddb,
};

static ZhiCode codelist8716[] = {
 0xb7d9, 0xc04b, 0xb748, 0xdcd3, 0xddf7,
 0xe351, 0xe37c, 0xdb67, 0xd86c,
};

static ZhiCode codelist8728[] = {
 0xb0f8, 0xbbad, 0xce61, 0xed42, 0xf0e0,
};

static ZhiCode codelist8730[] = {
 0xb344, 0xa6de, 0xacc6, 0xca65, 0xa4b0,
 0xd960, 0xe0ae,
};

static ZhiCode codelist8731[] = {
 0xb1cb, 0xaad9,
};

static ZhiCode codelist8732[] = {
 0xaac0, 0xb35d, 0xae67, 0xaf41, 0xaad9,
 0xc4e1, 0xb36a, 0xbef9, 0xc565, 0xcdf8,
 0xd669, 0xf5d4, 0xe751, 0xf1a6, 0xf1b7,
 0xac42, 0xb8ad, 0xd1c8, 0xf2e8,
};

static ZhiCode codelist8744[] = {
 0xbf7a,
};

static ZhiCode codelist8747[] = {
 0xbbeb, 0xf2b5,
};

static ZhiCode codelist8748[] = {
 0xc5ce, 0xaecd, 0xeef3, 0xb1fe,
};

static ZhiCode codelist8754[] = {
 0xbdd6,
};

static ZhiCode codelist8760[] = {
 0xbf4e, 0xb579, 0xb1e9, 0xdfa5, 0xaeb4,
 0xd17a, 0xdfea, 0xd776, 0xdf4b, 0xddbe,
 0xef65, 0xe466, 0xf1cd, 0xeb4b,
};

static ZhiCode codelist8762[] = {
 0xa840, 0xbbe0, 0xa8a2, 0xa463, 0xcfd0,
 0xc9ca, 0xcfb9,
};

static ZhiCode codelist8763[] = {
 0xa4d6,
};

static ZhiCode codelist8764[] = {
 0xa4d6, 0xb2d0, 0xadef, 0xaaf2, 0xa56c,
 0xca73, 0xca6f, 0xd7b8, 0xdabc, 0xe64c,
};

static ZhiCode codelist8768[] = {
 0xa6ac, 0xd3a7,
};

static ZhiCode codelist8770[] = {
 0xbcf4,
};

static ZhiCode codelist8771[] = {
 0xa4e2, 0xadba, 0xa675, 0xd953, 0xe746,
};

static ZhiCode codelist8772[] = {
 0xa8fc, 0xb0e2, 0xb9d8, 0xc37e, 0xb1c2,
 0xbd47, 0xacbc, 0xbafe,
};

static ZhiCode codelist8776[] = {
 0xa473, 0xaeb0, 0xad6d, 0xa7fc, 0xa752,
 0xacc0, 0xc3bb, 0xad51, 0xbab4, 0xbce8,
 0xb65c, 0xa96b, 0xaadf, 0xd073, 0xddb5,
 0xc168, 0xeab1, 0xd57d, 0xda5b, 0xcfc4,
 0xd6d3, 0xdcc9,
};

static ZhiCode codelist8779[] = {
 0xb07b, 0xb0a2, 0xdedb, 0xd9a5, 0xe7ce,
};

static ZhiCode codelist8780[] = {
 0xb5bd, 0xaeb0, 0xa6c2, 0xbed5, 0xbfaf,
 0xc2b5, 0xe854, 0xbab4, 0xb053, 0xb3e6,
 0xc4ba, 0xaab7, 0xc5eb, 0xf562, 0xc149,
 0xe54d, 0xe951, 0xd56c, 0xe1df, 0xeead,
 0xe552, 0xd7fc, 0xf2dc, 0xd3e4, 0xe4e7,
};

static ZhiCode codelist8784[] = {
 0xa8ad, 0xb260, 0xa6f9, 0xa5d3, 0xb2d4,
 0xa944, 0xab48, 0xb0d1, 0xe778, 0xae57,
 0xb2f1, 0xd2c0, 0xcbc2, 0xd045, 0xdfde,
 0xe04d, 0xec67, 0xea50, 0xaf7e, 0xcf5d,
 0xcf6b, 0xc9d9, 0xcfca, 0xd05b, 0xca58,
 0xcc50, 0xd170, 0xd2d1,
};

static ZhiCode codelist8786[] = {
 0xafab, 0xacc6,
};

static ZhiCode codelist8787[] = {
 0xa848, 0xbc66, 0xc254, 0xc26e, 0xe7dc,
 0xf75a, 0xcfe8, 0xab7b, 0xd4f2, 0xed7b,
 0xcba9, 0xf754,
};

static ZhiCode codelist8788[] = {
 0xb756, 0xb5c7, 0xbaaf, 0xacc6, 0xb8c2,
 0xa847, 0xdfb8, 0xddd2, 0xb2e9, 0xccbd,
 0xcdec, 0xe87a,
};

static ZhiCode codelist8792[] = {
 0xb0d3, 0xb6cb, 0xbcdc, 0xc2d2, 0xb4f6,
 0xe2b9, 0xe74e, 0xee59, 0xf0da, 0xf6a7,
};

static ZhiCode codelist8795[] = {
 0xbde0, 0xaece, 0xa457,
};

static ZhiCode codelist8796[] = {
 0xa457, 0xa97c, 0xf5dc, 0xce73, 0xc967,
};

static ZhiCode codelist8797[] = {
 0xbb6e,
};

static ZhiCode codelist8800[] = {
 0xa5cd, 0xc16e, 0xb3d3, 0xa4c9, 0xacb9,
 0xaa40, 0xb563, 0xb2c6, 0xb0a5, 0xcd4e,
 0xe0c8, 0xf1e6, 0xcaa2, 0xcd64, 0xda54,
 0xda64, 0xf3ef,
};

static ZhiCode codelist8802[] = {
 0xc3b7, 0xbf49, 0xe97a, 0xf4d0, 0xf8d8,
 0xde68,
};

static ZhiCode codelist8803[] = {
 0xacd9, 0xd2d6, 0xcbce, 0xe6de, 0xd466,
};

static ZhiCode codelist8804[] = {
 0xb3d3, 0xb2b1, 0xb874, 0xb3d1, 0xdd4f,
 0xadbc, 0xc1cb, 0xc96f, 0xdbeb,
};

static ZhiCode codelist8960[] = {
 0xaed1, 0xbfe9, 0xaeed, 0xb5ce, 0xaede,
 0xb2a8, 0xbdad, 0xbccf, 0xd356, 0xa7e7,
 0xefd2, 0xce67, 0xe5cc, 0xe1dd, 0xc95f,
 0xcce6, 0xd0c7, 0xdf59, 0xc0cf, 0xcff6,
 0xd7df, 0xf3f1, 0xf2cf,
};

static ZhiCode codelist8962[] = {
 0xa8fb, 0xbcf4, 0xb251, 0xb9d1, 0xc5ab,
 0xb145, 0xb5e0, 0xd2ed, 0xf2ed, 0xd4c8,
 0xd65a, 0xe461, 0xf8e2, 0xf9a5,
};

static ZhiCode codelist8963[] = {
 0xbcc6, 0xb9ab, 0xc4dd, 0xb4bb, 0xb870,
 0xc1a6, 0xb8be, 0xb6c1, 0xf04c, 0xe661,
 0xc3c5, 0xf9c9, 0xd4e7, 0xf649, 0xf2ad,
 0xf772,
};

static ZhiCode codelist8964[] = {
 0xb34e, 0xbcc6, 0xbef0, 0xa7f4, 0xad7a,
 0xb870, 0xbddd, 0xb2a8, 0xaea4, 0xb166,
 0xc0c6, 0xb9d6, 0xbaa4, 0xb0bf, 0xa6a7,
 0xe640, 0xdf6f, 0xccf5, 0xdff2, 0xe0b4,
 0xd8d7, 0xf1ec, 0xf36f, 0xf57d,
};

static ZhiCode codelist8968[] = {
 0xa8ea, 0xd47c, 0xef6d,
};

static ZhiCode codelist8971[] = {
 0xad41,
};

static ZhiCode codelist8972[] = {
 0xa8ea,
};

static ZhiCode codelist8976[] = {
 0xbba1,
};

static ZhiCode codelist8980[] = {
 0xaed2, 0xbad3, 0xc37b, 0xbcc6, 0xc5e0,
 0xdcde, 0xb276, 0xc1ac, 0xabd3, 0xdd7d,
 0xa671, 0xe254, 0xe6d8, 0xe3b7, 0xa463,
 0xd5d6, 0xdd78, 0xe67c, 0xf161,
};

static ZhiCode codelist9000[] = {
 0xba4c, 0xb049, 0xeace, 0xf5c7,
};

static ZhiCode codelist9003[] = {
 0xa5cf,
};

static ZhiCode codelist9004[] = {
 0xb276, 0xabd3, 0xc1ac, 0xce4f, 0xedd2,
};

static ZhiCode codelist9010[] = {
 0xbdd6, 0xdb4f,
};

static ZhiCode codelist9011[] = {
 0xa4f4,
};

static ZhiCode codelist9012[] = {
 0xbba1, 0xbace, 0xb57c, 0xb8c0, 0xd174,
 0xd258, 0xdff5,
};

static ZhiCode codelist9032[] = {
 0xaeea, 0xadac, 0xac43,
};

static ZhiCode codelist9036[] = {
 0xb252,
};

static ZhiCode codelist9043[] = {
 0xacde, 0xdde3, 0xa76d, 0xd970, 0xebb7,
};

static ZhiCode codelist9044[] = {
 0xb6b6, 0xb5cf, 0xc0fe, 0xeb48, 0xf3c3,
 0xea76,
};

static ZhiCode codelist9048[] = {
 0xc2f9, 0xc1f7, 0xc45c, 0xf8bb, 0xf9b4,
 0xf7b9, 0xf5c8, 0xf6f6,
};

static ZhiCode codelist9051[] = {
 0xb26e, 0xb9d7, 0xe5e6, 0xe2b4, 0xe1d4,
 0xeadc,
};

static ZhiCode codelist9052[] = {
 0xf466,
};

static ZhiCode codelist9216[] = {
 0xa3a7,
};

static ZhiCode codelist9220[] = {
 0xa4e9, 0xd3d2, 0xe4d4, 0xdc73,
};

static ZhiCode codelist9243[] = {
 0xb753, 0xd86f, 0xad59,
};

static ZhiCode codelist9244[] = {
 0xbcf6, 0xd9fc,
};

static ZhiCode codelist9274[] = {
 0xc4c7, 0xeafe, 0xbc63, 0xbef8, 0xc2cc,
 0xf0d2,
};

static ZhiCode codelist9275[] = {
 0xc25a,
};

static ZhiCode codelist9276[] = {
 0xc2b6, 0xebd0, 0xe8ab,
};

static ZhiCode codelist9282[] = {
 0xac58, 0xb47c, 0xf1a5, 0xbfe4, 0xebca,
 0xddd6, 0xc9a8, 0xdfd7, 0xeee2, 0xc2fd,
 0xf3b6, 0xf5a2, 0xd8c6, 0xe7ac, 0xf571,
};

static ZhiCode codelist9283[] = {
 0xe6df, 0xeee1, 0xd34d, 0xde6e,
};

static ZhiCode codelist9284[] = {
 0xa6d7,
};

static ZhiCode codelist9290[] = {
 0xb54d, 0xbf55, 0xbe77, 0xd7a3, 0xd7a4,
 0xd7b9,
};

static ZhiCode codelist9291[] = {
 0xac56, 0xa554, 0xbe77, 0xad5c, 0xcfd3,
 0xe9cf, 0xcbe4, 0xcc49, 0xe17b,
};

static ZhiCode codelist9298[] = {
 0xa448, 0xa5f4, 0xa4af, 0xa4d0, 0xd351,
 0xa449, 0xcdc6, 0xe4b9,
};

static ZhiCode codelist9299[] = {
 0xa7d4, 0xb85a, 0xaff6, 0xdb50, 0xd9c2,
 0xd1f4, 0xd765,
};

static ZhiCode codelist9300[] = {
 0xa5f4, 0xbb7b, 0xa462, 0xb6b9, 0xb8ee,
 0xb062, 0xb04d, 0xacf7, 0xa7b3, 0xd1a1,
 0xa551, 0xd3dd, 0xb6b4, 0xcb60, 0xefa6,
 0xc9d8, 0xcb74, 0xd7e0,
};

static ZhiCode codelist9306[] = {
 0xc463, 0xc5a1, 0xf6f8, 0xf1ee, 0xf45b,
 0xc57b, 0xf1eb, 0xf46d, 0xf5f1, 0xf8c4,
 0xf9b6, 0xf7f7,
};

static ZhiCode codelist9307[] = {
 0xc457, 0xc45b, 0xc463, 0xf5dc,
};

static ZhiCode codelist9308[] = {
 0xc5fd, 0xf44a,
};

static ZhiCode codelist9312[] = {
 0xa5b5,
};

static ZhiCode codelist9314[] = {
 0xa4b4, 0xcb72, 0xdc7d,
};

static ZhiCode codelist9315[] = {
 0xa5b5,
};

static ZhiCode codelist9474[] = {
 0xa670, 0xbea7, 0xc0a9, 0xaff8, 0xc4af,
 0xc07d, 0xc0e1, 0xdbcc, 0xf4cb, 0xefa7,
 0xdae3, 0xf07d, 0xf65d, 0xd1b2, 0xf0b8,
 0xe4a7, 0xefdc, 0xc277, 0xceb4, 0xeb51,
};

static ZhiCode codelist9475[] = {
 0xa8c5, 0xa6bc, 0xb064, 0xece9, 0xa46b,
 0xcbc7,
};

static ZhiCode codelist9476[] = {
 0xa44a, 0xb064, 0xbfc8, 0xc0a9, 0xaff8,
 0xcf76, 0xead0, 0xe3bd, 0xde50, 0xe0a6,
 0xdd40, 0xdcd9,
};

static ZhiCode codelist9490[] = {
 0xd1bd,
};

static ZhiCode codelist9492[] = {
 0xad59, 0xae7a, 0xe6d9, 0xb0b4, 0xf26b,
 0xdc59, 0xbf78, 0xe3c0, 0xddd8, 0xc564,
};

static ZhiCode codelist9522[] = {
 0xeb42, 0xe36f, 0xd4eb,
};

static ZhiCode codelist9523[] = {
 0xbfb6, 0xe9d0, 0xf075, 0xd8fb, 0xd5bd,
};

static ZhiCode codelist9524[] = {
 0xb7e7, 0xbe55, 0xcdba, 0xbacd, 0xd3c2,
 0xe8fb, 0xccd9, 0xcb55,
};

static ZhiCode codelist9546[] = {
 0xd8a3, 0xecca, 0xe5b5,
};

static ZhiCode codelist9547[] = {
 0xb36e, 0xa8bf, 0xc4af, 0xd052, 0xe7ab,
 0xf041, 0xe6e4, 0xf27d, 0xccd2,
};

static ZhiCode codelist9552[] = {
 0xda69,
};

static ZhiCode codelist9556[] = {
 0xbced, 0xb67c, 0xe9db,
};

static ZhiCode codelist9570[] = {
 0xae65, 0xba61, 0xbfc4, 0xb7bb, 0xb5b3,
 0xbab2, 0xa6a5, 0xbb54, 0xc2e8, 0xaff1,
 0xba5f, 0xdb41, 0xc0af, 0xe2ce, 0xcb78,
 0xd243, 0xcfc0, 0xf267, 0xd376, 0xd653,
 0xf4c6, 0xeffc, 0xdd44, 0xe260, 0xeb79,
 0xec63, 0xec6e, 0xf6a9, 0xf7b7,
};

static ZhiCode codelist9571[] = {
 0xa4be, 0xaff1, 0xe9e6, 0xd85f, 0xdc44,
};

static ZhiCode codelist9728[] = {
 0xb8ea, 0xaff7, 0xb4fe, 0xa773, 0xabba,
 0xab74, 0xa7b6, 0xbfd4, 0xb8ed, 0xaf59,
 0xa3a8, 0xbdfd, 0xb264, 0xc568, 0xbafd,
 0xb446, 0xdae7, 0xc068, 0xd8db, 0xdba4,
 0xeecd, 0xf5ac, 0xecb7, 0xc9d3, 0xe9fa,
 0xcd72, 0xe0a7, 0xf3cf, 0xc045, 0xe05e,
 0xd9c4, 0xe4ba, 0xf3e9, 0xf3f9, 0xd1f3,
 0xd353, 0xd540, 0xd6c6, 0xf2db,
};

static ZhiCode codelist9731[] = {
 0xa46c, 0xa54a, 0xb5b5, 0xb1ea, 0xacf3,
 0xb7ba, 0xd054, 0xb8e4, 0xd6d7, 0xd2f1,
 0xd064, 0xd3a5, 0xc9c5, 0xcb45, 0xcb7e,
 0xce49, 0xcda1, 0xd842, 0xe049,
};

static ZhiCode codelist9732[] = {
 0xa6db, 0xa672, 0xaea1, 0xba7b, 0xd6b0,
 0xb446, 0xd0e7, 0xdb49, 0xdb48, 0xcaee,
 0xd0d1, 0xd27e,
};

static ZhiCode codelist9733[] = {
 0xa46c,
};

static ZhiCode codelist9736[] = {
 0xb2cf, 0xa560, 0xcbdf, 0xd473, 0xe14e,
 0xccc0, 0xe0c4,
};

static ZhiCode codelist9738[] = {
 0xc2f8, 0xaba5, 0xaf7b, 0xb0af, 0xf8cd,
 0xeda9,
};

static ZhiCode codelist9754[] = {
 0xab68, 0xb364, 0xbedc, 0xbf41, 0xb9c9,
 0xafb6, 0xd756, 0xa951, 0xe1b2, 0xb2c8,
 0xf0f3, 0xd0b5, 0xd8e7, 0xdfc1, 0xf0e9,
 0xf2e1, 0xb8e9, 0xf2e5,
};

static ZhiCode codelist9755[] = {
 0xabe7,
};

static ZhiCode codelist9756[] = {
 0xa4b7, 0xb0bc, 0xccca, 0xc97a, 0xdada,
};

static ZhiCode codelist9768[] = {
 0xa861, 0xaee2, 0xab76, 0xd9ee, 0xebb8,
};

static ZhiCode codelist9771[] = {
 0xa54a, 0xae5f, 0xd8e6, 0xb8fc, 0xeacd,
};

static ZhiCode codelist9772[] = {
 0xa662, 0xa641, 0xb8fc,
};

static ZhiCode codelist9778[] = {
 0xb8e9,
};

static ZhiCode codelist9784[] = {
 0xbe44, 0xc156, 0xf0fe, 0xdcb7,
};

static ZhiCode codelist9786[] = {
 0xc677,
};

static ZhiCode codelist9787[] = {
 0xa6ad, 0xb4c7, 0xbefe, 0xc4a6, 0xb044,
 0xed6a, 0xf2b2,
};

static ZhiCode codelist9788[] = {
 0xb379, 0xa86d, 0xc0ea, 0xbeb8, 0xe1d1,
 0xc4b7, 0xa85f, 0xc4bc, 0xcb71, 0xf4d6,
 0xf054,
};

static ZhiCode codelist9792[] = {
 0xb951, 0xeea4, 0xc1dd, 0xe7d4, 0xb0e7,
 0xd570, 0xdb68, 0xb3b5, 0xf55f, 0xf3c8,
 0xd9c5, 0xe369, 0xd9b4, 0xd7ea, 0xdcfa,
 0xf3f4, 0xf8a1, 0xf969,
};

static ZhiCode codelist9795[] = {
 0xa8ab,
};

static ZhiCode codelist9796[] = {
 0xabb5, 0xc64a, 0xb47e,
};

static ZhiCode codelist9800[] = {
 0xc2af, 0xf4ee,
};

static ZhiCode codelist9802[] = {
 0xaba5, 0xb0af, 0xe6e1,
};

static ZhiCode codelist9803[] = {
 0xcedf, 0xf6e3, 0xd4f1, 0xcef5, 0xf8b7,
 0xd873, 0xf5c1, 0xd965, 0xf8b5,
};

static ZhiCode codelist9804[] = {
 0xc3d9, 0xbcc8, 0xc667, 0xc3f5, 0xc5d0,
 0xf7e0, 0xf766, 0xf9b1, 0xf6eb, 0xf6d9,
 0xf96f,
};

static ZhiCode codelist9808[] = {
 0xc2af, 0xc95e,
};

static ZhiCode codelist9811[] = {
 0xabe7,
};

static ZhiCode codelist9812[] = {
 0xf2fb,
};

static ZhiCode codelist9816[] = {
 0xc5bc, 0xc542, 0xc5d8, 0xd27d, 0xbb4e,
};

static ZhiCode codelist9819[] = {
 0xe8ca,
};

static ZhiCode codelist9820[] = {
 0xc2c3, 0xc5a6, 0xb8ae, 0xae4e,
};

static ZhiCode codelist9824[] = {
 0xb4bf, 0xbc57, 0xbca8, 0xede3, 0xc2b9,
 0xeda4, 0xe9c1, 0xeda5, 0xf779, 0xea65,
};

static ZhiCode codelist9828[] = {
 0xc3d8, 0xed70,
};

static ZhiCode codelist9984[] = {
 0xafb2, 0xe3c6,
};

static ZhiCode codelist9986[] = {
 0xa8ac, 0xb1da, 0xa8f2, 0xb9be, 0xd56a,
 0xd541, 0xebc7, 0xd0fb, 0xdcc3, 0xe7f6,
};

static ZhiCode codelist9987[] = {
 0xb2d5, 0xafaa, 0xaafd, 0xab5b, 0xb641,
 0xcfd1, 0xe4c5,
};

static ZhiCode codelist10000[] = {
 0xa740, 0xe544,
};

static ZhiCode codelist10002[] = {
 0xac51, 0xa740, 0xafa4, 0xd9cb, 0xdf4f,
 0xdefe, 0xdfc3,
};

static ZhiCode codelist10003[] = {
 0xa5aa, 0xa6f5, 0xf077,
};

static ZhiCode codelist10004[] = {
 0xb0b5, 0xa740, 0xa7a4, 0xae79, 0xdc60,
 0xafae, 0xc677, 0xac67, 0xcca9, 0xd05f,
 0xcdda, 0xdfdc, 0xd159,
};

static ZhiCode codelist10032[] = {
 0xb0ef, 0xd470, 0xdf6e, 0xe1ab, 0xf8b9,
};

static ZhiCode codelist10035[] = {
 0xbc4c, 0xf046, 0xe043, 0xe1aa, 0xecc8,
 0xed5a,
};

static ZhiCode codelist10036[] = {
 0xb3cc, 0xb86f, 0xbe4b, 0xecfc, 0xbfbf,
 0xd9a2, 0xed49, 0xd6ee, 0xdef5, 0xebf4,
 0xe550, 0xe962,
};

static ZhiCode codelist10056[] = {
 0xc670, 0xf970,
};

static ZhiCode codelist10059[] = {
 0xc4a1, 0xc670, 0xf940, 0xf8fc, 0xf5c1,
};

static ZhiCode codelist10060[] = {
 0xc1c8, 0xc670, 0xf7dd, 0xf9b1,
};

static ZhiCode codelist10064[] = {
 0xb44c, 0xbfed, 0xbeea, 0xe54a, 0xf4eb,
 0xe564, 0xf06d, 0xf862, 0xe553,
};

static ZhiCode codelist10067[] = {
 0xbcc1, 0xe4f7, 0xe54a, 0xe0f1, 0xf2f6,
};

static ZhiCode codelist10068[] = {
 0xab54, 0xa660, 0xd1c1, 0xf857, 0xe4b2,
 0xea51,
};

static ZhiCode codelist10080[] = {
 0xa976, 0xc2dc, 0xc161, 0xbaee, 0xb4c4,
 0xc34f, 0xf0ef, 0xf3bd, 0xf3c6, 0xe6f7,
 0xe671, 0xd0d9, 0xd948, 0xda77, 0xe347,
 0xe749, 0xd8e2, 0xe7b6,
};

static ZhiCode codelist10083[] = {
 0xc160, 0xe1eb, 0xb6cd, 0xe670, 0xdf7a,
 0xe3ce,
};

static ZhiCode codelist10084[] = {
 0xc161, 0xbaea, 0xbaee, 0xb171, 0xea72,
 0xcef8,
};

static ZhiCode codelist10240[] = {
 0xb2ab, 0xceb8, 0xbbdb, 0xa3a9, 0xae74,
 0xdbee, 0xec6c,
};

static ZhiCode codelist10242[] = {
 0xb5fc, 0xc3e3, 0xb74f, 0xbacf, 0xb2a1,
 0xbbdb, 0xafa8, 0xb2ab, 0xaffd, 0xdae7,
 0xe8bf, 0xcf5a, 0xe959, 0xed5b, 0xce4d,
 0xe8c0, 0xedf9,
};

static ZhiCode codelist10243[] = {
 0xa6b9, 0xcbbd, 0xcf75, 0xd2af, 0xe06c,
 0xd6a6,
};

static ZhiCode codelist10244[] = {
 0xa6b8, 0xa8eb, 0xbde7, 0xb45a, 0xa6f8,
 0xcbb5, 0xdbb4, 0xdb6c, 0xc9f4, 0xd1ef,
 0xd3cc, 0xdaeb,
};

static ZhiCode codelist10248[] = {
 0xc0bf, 0xb767, 0xecc0,
};

static ZhiCode codelist10251[] = {
 0xf47d,
};

static ZhiCode codelist10252[] = {
 0xf5c4,
};

static ZhiCode codelist10268[] = {
 0xa555, 0xb5a6, 0xb4fa, 0xb0bc, 0xb45a,
 0xb46c, 0xdf49, 0xd2c2, 0xd37c, 0xd6e1,
 0xcee3, 0xdee3, 0xe5a8, 0xe3d1,
};

static ZhiCode codelist10280[] = {
 0xb271,
};

static ZhiCode codelist10282[] = {
 0xa47e, 0xb05d, 0xa7f7, 0xb5f4, 0xc5d7,
};

static ZhiCode codelist10283[] = {
 0xb1c4, 0xb16d, 0xaaf6, 0xb842, 0xbdf2,
 0xbaf9, 0xe073, 0xd4f2, 0xd9bd, 0xd4ea,
};

static ZhiCode codelist10284[] = {
 0xbdb2, 0xb5e6, 0xd4ca, 0xaaf6, 0xedda,
};

static ZhiCode codelist10296[] = {
 0xbede, 0xc157, 0xebd6, 0xdcd5,
};

static ZhiCode codelist10298[] = {
 0xb1e4, 0xbcd1, 0xb9cb, 0xbaa8, 0xee5d,
 0xedf1, 0xe1a6,
};

static ZhiCode codelist10299[] = {
 0xaff3, 0xe97b, 0xf55a, 0xca4a,
};

static ZhiCode codelist10300[] = {
 0xc157, 0xbede, 0xcdab, 0xf2f1,
};

static ZhiCode codelist10308[] = {
 0xb4ea, 0xbfea, 0xdf73, 0xddce,
};

static ZhiCode codelist10312[] = {
 0xb0d1, 0xc05c, 0xf67c,
};

static ZhiCode codelist10314[] = {
 0xb4dd, 0xc5fa, 0xba46, 0xe95b,
};

static ZhiCode codelist10315[] = {
 0xba47, 0xe5a3, 0xd9a9, 0xe4fd, 0xf876,
};

static ZhiCode codelist10316[] = {
 0xc0e9, 0xb447, 0xc0f6, 0xdf54, 0xea44,
};

static ZhiCode codelist10320[] = {
 0xb0d1, 0xe1ad, 0xd5b7,
};

static ZhiCode codelist10322[] = {
 0xa7c2, 0xaf4b, 0xd5ba, 0xd348, 0xd158,
};

static ZhiCode codelist10328[] = {
 0xbb61, 0xaddc, 0xb7c9, 0xbfb5, 0xb3c9,
 0xf6c1, 0xd861, 0xdd56,
};

static ZhiCode codelist10330[] = {
 0xc2c3, 0xf974,
};

static ZhiCode codelist10336[] = {
 0xe4f8,
};

static ZhiCode codelist10338[] = {
 0xb4bf, 0xbc68, 0xe565, 0xe855, 0xdef0,
};

static ZhiCode codelist10340[] = {
 0xf34f,
};

static ZhiCode codelist10496[] = {
 0xb2ca, 0xf9d2, 0xd7c8,
};

static ZhiCode codelist10498[] = {
 0xcf65, 0xcc75,
};

static ZhiCode codelist10500[] = {
 0xab50, 0xbe4c, 0xc14c, 0xc3e0, 0xe754,
 0xc2d9, 0xd660, 0xa8f2, 0xbff9, 0xbdec,
 0xc1cd, 0xc3eb, 0xea6b, 0xe7fe, 0xbcd8,
 0xd5c7, 0xe4f6, 0xe9e1, 0xf1e2,
};

static ZhiCode codelist10512[] = {
 0xb762, 0xbcbc, 0xbd52, 0xc1ce, 0xe3b5,
 0xe84f, 0xf565,
};

static ZhiCode codelist10514[] = {
 0xe6af, 0xdac4, 0xf6c9, 0xdab5, 0xeecb,
 0xb744, 0xe768,
};

static ZhiCode codelist10515[] = {
 0xe2cf, 0xd74c, 0xeacc, 0xdacd,
};

static ZhiCode codelist10516[] = {
 0xbff9, 0xb1b9, 0xaec0, 0xbe56, 0xbcbc,
 0xcdf1, 0xaded, 0xd76b, 0xcde8, 0xd0e8,
 0xf8a2, 0xe3c4,
};

static ZhiCode codelist10544[] = {
 0xba52, 0xb6ca, 0xb15a, 0xe151, 0xe167,
 0xeaa5, 0xf369, 0xe1fc, 0xb049,
};

static ZhiCode codelist10546[] = {
 0xdcc5, 0xe1d0,
};

static ZhiCode codelist10547[] = {
 0xbd41, 0xe7f1, 0xe2a8,
};

static ZhiCode codelist10548[] = {
 0xbb41, 0xafdc, 0xbae9, 0xb17c, 0xb7f1,
 0xb5d1, 0xd475, 0xb266, 0xd0c9, 0xd9e5,
 0xbef5, 0xda58, 0xedb9, 0xeaef, 0xe363,
 0xeaec, 0xdb51, 0xed5a,
};

static ZhiCode codelist10568[] = {
 0xf5cd, 0xf94f, 0xe87d,
};

static ZhiCode codelist10570[] = {
 0xf6e3, 0xf6de, 0xf5c3,
};

static ZhiCode codelist10572[] = {
 0xc2ab, 0xbf79, 0xc679, 0xeabf,
};

static ZhiCode codelist10576[] = {
 0xa7f8, 0xb572,
};

static ZhiCode codelist10578[] = {
 0xa673, 0xdbc6,
};

static ZhiCode codelist10579[] = {
 0xa6a4, 0xc96b,
};

static ZhiCode codelist10580[] = {
 0xa46f, 0xa654, 0xd047,
};

static ZhiCode codelist10592[] = {
 0xa55e, 0xc16f, 0xb171, 0xa777, 0xe6a6,
 0xe6a7, 0xbcd7, 0xf67b, 0xe776, 0xf36b,
 0xe670, 0xd9d9, 0xe5c4, 0xbdb5, 0xea7a,
 0xee65, 0xeed8,
};

static ZhiCode codelist10594[] = {
 0xb171, 0xc24f, 0xb246, 0xda7a, 0xd555,
 0xe2a6, 0xe2ac, 0xe7eb, 0xebef, 0xd4dd,
 0xd4f0, 0xd54f, 0xe1c8,
};

static ZhiCode codelist10596[] = {
 0xf6e6, 0xf0a8, 0xf0e5,
};

static ZhiCode codelist10752[] = {
 0xa571, 0xabe4, 0xb4b5, 0xb5b7, 0xa870,
 0xbcb9, 0xbc72, 0xc5ee, 0xbc52, 0xa3aa,
 0xe642, 0xe6eb, 0xd454, 0xe37a, 0xf1ab,
 0xe6cd, 0xd3b8, 0xddf1, 0xeed6, 0xe140,
 0xcd47, 0xeb57, 0xe0c2, 0xcdef, 0xdbd2,
 0xe253, 0xe340, 0xe3f1, 0xe6c8, 0xeea9,
 0xf0cf, 0xf6c2, 0xf87c,
};

static ZhiCode codelist10755[] = {
 0xa6ba,
};

static ZhiCode codelist10756[] = {
 0xa57c, 0xa6fc, 0xbde7, 0xb6e0, 0xb97d,
 0xa678, 0xb876, 0xaac1, 0xadb9, 0xab53,
 0xa6f8, 0xaa72, 0xa478, 0xb2e0, 0xecbe,
 0xa971, 0xd6ce, 0xbe6f, 0xa8e1, 0xd25d,
 0xcf4e, 0xc9fa, 0xd1fb, 0xe059, 0xee41,
 0xd249,
};

static ZhiCode codelist10757[] = {
 0xabe4,
};

static ZhiCode codelist10760[] = {
 0xbcbb, 0xc965,
};

static ZhiCode codelist10763[] = {
 0xc578, 0xbcbb, 0xe0dc, 0xcf73,
};

static ZhiCode codelist10764[] = {
 0xc2c4, 0xa4ca, 0xd7d9, 0xbbe3, 0xefd6,
 0xe4d6, 0xe4bc,
};

static ZhiCode codelist10780[] = {
 0xa6e2, 0xb6eb, 0xb7e6, 0xa7a3, 0xb6de,
 0xc0df, 0xc2a8, 0xe9ec, 0xf4db, 0xf64f,
 0xe4a3, 0xed6c, 0xdf70, 0xea5a, 0xf775,
 0xe9fc,
};

static ZhiCode codelist10792[] = {
 0xb6eb, 0xc4ce, 0xb87c, 0xd242, 0xd96c,
};

static ZhiCode codelist10796[] = {
 0xc1c9, 0xb6eb, 0xe4e6,
};

static ZhiCode codelist10808[] = {
 0xbfb4, 0xc4cc, 0xc162, 0xb76b, 0xedeb,
 0xdd69, 0xde52, 0xf3ae, 0xf8d9,
};

static ZhiCode codelist10811[] = {
 0xb1bd, 0xb741, 0xd4b5,
};

static ZhiCode codelist10812[] = {
 0xb1bd, 0xedeb, 0xed4d, 0xe6b1,
};

static ZhiCode codelist10816[] = {
 0xb76a, 0xc442, 0xe0aa, 0xbb60, 0xdd60,
 0xde59, 0xc349, 0xdeae, 0xeec8, 0xdcdb,
 0xf15c, 0xf55e,
};

static ZhiCode codelist10819[] = {
 0xadee, 0xb9be, 0xc3c1, 0xc25d, 0xe6bc,
 0xeea7, 0xf5e4,
};

static ZhiCode codelist10820[] = {
 0xb9c2,
};

static ZhiCode codelist10824[] = {
 0xa454, 0xb0d1, 0xe5f7, 0xf44d, 0xf6a6,
};

static ZhiCode codelist10827[] = {
 0xb4b2, 0xb3ca, 0xf06f, 0xc158, 0xf4ed,
};

static ZhiCode codelist10828[] = {
 0xb4b2, 0xdc7b,
};

static ZhiCode codelist10832[] = {
 0xb4cb, 0xe5db, 0xdf69, 0xee78, 0xe1b4,
 0xedc8,
};

static ZhiCode codelist10840[] = {
 0xb3e0, 0xaee1,
};

static ZhiCode codelist10843[] = {
 0xb6da, 0xf3a8, 0xddba, 0xe6ca, 0xf162,
 0xeb7b,
};

static ZhiCode codelist10844[] = {
 0xb3e0,
};

static ZhiCode codelist10848[] = {
 0xb9ac, 0xf7a5,
};

static ZhiCode codelist11008[] = {
 0xc4ac, 0xb564, 0xb670, 0xbf71, 0xc5c8,
 0xf45a,
};

static ZhiCode codelist11010[] = {
 0xab55,
};

static ZhiCode codelist11012[] = {
 0xb644, 0xb374, 0xafc0, 0xb5c2, 0xb14a,
 0xb6ec, 0xa667, 0xb5af, 0xb7b9, 0xe8c4,
 0xe1c2, 0xbdb6, 0xc159, 0xe448, 0xdd68,
 0xe3a5, 0xeea2, 0xb6e8, 0xe9cb, 0xcd41,
 0xd250, 0xe646, 0xc150, 0xe75c, 0xe5cf,
 0xe853, 0xf77b, 0xf859, 0xf865, 0xdd42,
 0xc9a7, 0xe25a, 0xcfa9, 0xd1e3, 0xd857,
 0xde4d, 0xe5a5, 0xe879, 0xeade, 0xf2cd,
 0xe0f4, 0xdf42,
};

static ZhiCode codelist11024[] = {
 0xc159, 0xb1f4, 0xb2ef, 0xadf6, 0xae50,
 0xbf75, 0xb6db, 0xd854, 0xd566, 0xbb62,
 0xd5c4, 0xf0f7, 0xd761, 0xe456, 0xe1da,
};

static ZhiCode codelist11026[] = {
 0xafc1,
};

static ZhiCode codelist11027[] = {
 0xa9d2, 0xafc1, 0xc2ea, 0xbabe, 0xe6a8,
 0xdcd4, 0xe1e2, 0xf163, 0xf540,
};

static ZhiCode codelist11028[] = {
 0xd7e2,
};

static ZhiCode codelist11056[] = {
 0xc1f6, 0xb86b, 0xea41, 0xb846, 0xd768,
 0xde42, 0xd6aa, 0xd267, 0xd143, 0xd163,
 0xd76f, 0xde44,
};

static ZhiCode codelist11058[] = {
 0xc048, 0xb6a6, 0xf173,
};

static ZhiCode codelist11059[] = {
 0xc5e8, 0xe967, 0xf261, 0xf172, 0xf8cf,
};

static ZhiCode codelist11060[] = {
 0xb7b3, 0xb945, 0xb848, 0xc14a, 0xc047,
 0xafa9, 0xc0e6, 0xbdd9, 0xded9, 0xf060,
 0xed67, 0xecf4, 0xf2ea, 0xf661, 0xc2e3,
 0xd4bd, 0xe7e8, 0xed48, 0xedd8, 0xf05e,
 0xf249, 0xf2b1, 0xf544,
};

static ZhiCode codelist11080[] = {
 0xbbc4, 0xb56d, 0xd2a9,
};

static ZhiCode codelist11083[] = {
 0xe8fa,
};

static ZhiCode codelist11084[] = {
 0xbae2, 0xbb5b, 0xdf48,
};

static ZhiCode codelist11088[] = {
 0xae5d, 0xb6b8, 0xbb5e, 0xdeac, 0xddbb,
 0xe25f, 0xedfe, 0xeb4e,
};

static ZhiCode codelist11091[] = {
 0xb76c, 0xb5ab, 0xba67, 0xf069, 0xf168,
};

static ZhiCode codelist11092[] = {
 0xbcf2, 0xe1d2,
};

static ZhiCode codelist11104[] = {
 0xaa51, 0xc350, 0xb253, 0xb743, 0xa7d8,
 0xdb70, 0xce65, 0xb15d, 0xea43, 0xd0db,
 0xdeee, 0xe3dd,
};

static ZhiCode codelist11107[] = {
 0xc171, 0xbca3, 0xaeaa, 0xdadc, 0xdcc0,
 0xdd6e, 0xe1a9, 0xef5b,
};

static ZhiCode codelist11108[] = {
 0xb065, 0xa7ba, 0xb97c, 0xb35e, 0xbb77,
};

struct YinZhi _YinZhiTable[] = {
  {       8,   3, codelist8 },
  {      12,   1, codelist12 },
  {      13,   2, codelist13 },
  {      16,   2, codelist16 },
  {      18,   1, codelist18 },
  {      24,   7, codelist24 },
  {      26,  20, codelist26 },
  {      27,   1, codelist27 },
  {      28,  44, codelist28 },
  {      32,   1, codelist32 },
  {      36,   1, codelist36 },
  {      40,   7, codelist40 },
  {      42,   4, codelist42 },
  {      43,   7, codelist43 },
  {      44,  19, codelist44 },
  {      48,   1, codelist48 },
  {      56,   4, codelist56 },
  {      58,  23, codelist58 },
  {      59,   4, codelist59 },
  {      60,  11, codelist60 },
  {      64,  12, codelist64 },
  {      66,   1, codelist66 },
  {      67,   8, codelist67 },
  {      68,   3, codelist68 },
  {      72,  18, codelist72 },
  {      74,   3, codelist74 },
  {      75,   4, codelist75 },
  {      76,  17, codelist76 },
  {      80,   3, codelist80 },
  {      84,   1, codelist84 },
  {      88,   3, codelist88 },
  {      90,   2, codelist90 },
  {      91,   1, codelist91 },
  {      92,   2, codelist92 },
  {      96,   2, codelist96 },
  {     104,   2, codelist104 },
  {     106,  15, codelist106 },
  {     107,  12, codelist107 },
  {     108,  10, codelist108 },
  {     128,  34, codelist128 },
  {     130,  65, codelist130 },
  {     131,  31, codelist131 },
  {     132, 132, codelist132 },
  {     136,   9, codelist136 },
  {     138,  11, codelist138 },
  {     139,   9, codelist139 },
  {     140,  16, codelist140 },
  {     144,   1, codelist144 },
  {     160,   3, codelist160 },
  {     162,   6, codelist162 },
  {     163,   5, codelist163 },
  {     164,  25, codelist164 },
  {     170,   4, codelist170 },
  {     184,  12, codelist184 },
  {     186,  34, codelist186 },
  {     187,  20, codelist187 },
  {     188,  18, codelist188 },
  {     192,  16, codelist192 },
  {     194,  25, codelist194 },
  {     195,  15, codelist195 },
  {     196,  23, codelist196 },
  {     200,  25, codelist200 },
  {     202,  37, codelist202 },
  {     203,  46, codelist203 },
  {     204,  49, codelist204 },
  {     208,  31, codelist208 },
  {     210,  28, codelist210 },
  {     211,  19, codelist211 },
  {     212,  13, codelist212 },
  {     216,  14, codelist216 },
  {     218,  24, codelist218 },
  {     219,  13, codelist219 },
  {     220,   8, codelist220 },
  {     224,  33, codelist224 },
  {     226,  23, codelist226 },
  {     227,  10, codelist227 },
  {     228,   8, codelist228 },
  {     256,  22, codelist256 },
  {     258,  28, codelist258 },
  {     259,  23, codelist259 },
  {     260,  42, codelist260 },
  {     264,  12, codelist264 },
  {     266,   1, codelist266 },
  {     267,   2, codelist267 },
  {     268,   3, codelist268 },
  {     272,   6, codelist272 },
  {     275,   3, codelist275 },
  {     276,  11, codelist276 },
  {     296,   1, codelist296 },
  {     299,   1, codelist299 },
  {     300,   1, codelist300 },
  {     304,  22, codelist304 },
  {     306,  32, codelist306 },
  {     307,  44, codelist307 },
  {     308,  39, codelist308 },
  {     328,   8, codelist328 },
  {     330,  11, codelist330 },
  {     331,  25, codelist331 },
  {     332,  13, codelist332 },
  {     336,   8, codelist336 },
  {     338,  16, codelist338 },
  {     339,   5, codelist339 },
  {     340,  10, codelist340 },
  {     344,   3, codelist344 },
  {     346,   2, codelist346 },
  {     347,  12, codelist347 },
  {     348,   8, codelist348 },
  {     352,   5, codelist352 },
  {     355,   7, codelist355 },
  {     356,   4, codelist356 },
  {     384,  10, codelist384 },
  {     386,  78, codelist386 },
  {     387,  32, codelist387 },
  {     388,  88, codelist388 },
  {     416,   5, codelist416 },
  {     420,  35, codelist420 },
  {     456,  21, codelist456 },
  {     458,  42, codelist458 },
  {     459,   2, codelist459 },
  {     460,  14, codelist460 },
  {     464,   6, codelist464 },
  {     466,  24, codelist466 },
  {     467,  11, codelist467 },
  {     468,  16, codelist468 },
  {     480,  22, codelist480 },
  {     482,   8, codelist482 },
  {     483,  20, codelist483 },
  {     484,   3, codelist484 },
  {     512,   1, codelist512 },
  {     520,  13, codelist520 },
  {     522,  11, codelist522 },
  {     523,   3, codelist523 },
  {     524,   9, codelist524 },
  {     525,   4, codelist525 },
  {     528,  18, codelist528 },
  {     530,  47, codelist530 },
  {     531,   3, codelist531 },
  {     532,  11, codelist532 },
  {     533,   1, codelist533 },
  {     552,   1, codelist552 },
  {     554,   1, codelist554 },
  {     555,   8, codelist555 },
  {     556,   8, codelist556 },
  {     560,  17, codelist560 },
  {     563,   1, codelist563 },
  {     564,  27, codelist564 },
  {     568,   8, codelist568 },
  {     570,   4, codelist570 },
  {     571,  11, codelist571 },
  {     572,  18, codelist572 },
  {     584,  11, codelist584 },
  {     587,   9, codelist587 },
  {     588,  13, codelist588 },
  {     592,   5, codelist592 },
  {     595,   3, codelist595 },
  {     596,   3, codelist596 },
  {     600,   7, codelist600 },
  {     603,   5, codelist603 },
  {     604,  10, codelist604 },
  {     608,   8, codelist608 },
  {     610,   1, codelist610 },
  {     611,   5, codelist611 },
  {     612,   5, codelist612 },
  {     640,   5, codelist640 },
  {     642,   1, codelist642 },
  {     643,  15, codelist643 },
  {     644,  98, codelist644 },
  {     672,   3, codelist672 },
  {     674,   6, codelist674 },
  {     675,   2, codelist675 },
  {     676,   2, codelist676 },
  {     696,  29, codelist696 },
  {     699,   8, codelist699 },
  {     700,   1, codelist700 },
  {     712,  13, codelist712 },
  {     715,   8, codelist715 },
  {     716,  18, codelist716 },
  {     720,  19, codelist720 },
  {     724,   7, codelist724 },
  {     736,   4, codelist736 },
  {     739,  17, codelist739 },
  {     740,   8, codelist740 },
  {     768,   5, codelist768 },
  {     770,   1, codelist770 },
  {     771,   7, codelist771 },
  {     772,  13, codelist772 },
  {    1024,   1, codelist1024 },
  {    1032,   5, codelist1032 },
  {    1034,   6, codelist1034 },
  {    1036,   4, codelist1036 },
  {    1040,   7, codelist1040 },
  {    1042,   4, codelist1042 },
  {    1043,   4, codelist1043 },
  {    1044,  11, codelist1044 },
  {    1064,   2, codelist1064 },
  {    1066,   6, codelist1066 },
  {    1067,   2, codelist1067 },
  {    1068,   4, codelist1068 },
  {    1072,   8, codelist1072 },
  {    1074,   9, codelist1074 },
  {    1075,   2, codelist1075 },
  {    1076,  12, codelist1076 },
  {    1080,   2, codelist1080 },
  {    1082,  11, codelist1082 },
  {    1083,   1, codelist1083 },
  {    1084,   7, codelist1084 },
  {    1088,   2, codelist1088 },
  {    1090,   4, codelist1090 },
  {    1091,   4, codelist1091 },
  {    1096,   3, codelist1096 },
  {    1098,  18, codelist1098 },
  {    1099,   1, codelist1099 },
  {    1100,  14, codelist1100 },
  {    1104,   2, codelist1104 },
  {    1106,   3, codelist1106 },
  {    1107,   3, codelist1107 },
  {    1112,   3, codelist1112 },
  {    1114,  13, codelist1114 },
  {    1115,   2, codelist1115 },
  {    1116,   1, codelist1116 },
  {    1120,  12, codelist1120 },
  {    1122,  23, codelist1122 },
  {    1123,   2, codelist1123 },
  {    1124,   4, codelist1124 },
  {    1152,  23, codelist1152 },
  {    1154,  35, codelist1154 },
  {    1155,  11, codelist1155 },
  {    1156,  17, codelist1156 },
  {    1184,   3, codelist1184 },
  {    1187,   1, codelist1187 },
  {    1208,   9, codelist1208 },
  {    1210,   3, codelist1210 },
  {    1211,  10, codelist1211 },
  {    1212,   8, codelist1212 },
  {    1224,   9, codelist1224 },
  {    1226,   7, codelist1226 },
  {    1228,   3, codelist1228 },
  {    1232,   4, codelist1232 },
  {    1234,   7, codelist1234 },
  {    1235,   1, codelist1235 },
  {    1236,   2, codelist1236 },
  {    1248,   5, codelist1248 },
  {    1250,  27, codelist1250 },
  {    1251,   1, codelist1251 },
  {    1280,   9, codelist1280 },
  {    1282,  20, codelist1282 },
  {    1283,  11, codelist1283 },
  {    1284,   5, codelist1284 },
  {    1536,   1, codelist1536 },
  {    1544,   3, codelist1544 },
  {    1546,   6, codelist1546 },
  {    1547,   9, codelist1547 },
  {    1548,   4, codelist1548 },
  {    1549,   3, codelist1549 },
  {    1552,   1, codelist1552 },
  {    1554,  13, codelist1554 },
  {    1555,   1, codelist1555 },
  {    1556,  48, codelist1556 },
  {    1557,   1, codelist1557 },
  {    1565,   1, codelist1565 },
  {    1578,   3, codelist1578 },
  {    1579,   3, codelist1579 },
  {    1580,   6, codelist1580 },
  {    1586,  25, codelist1586 },
  {    1587,   9, codelist1587 },
  {    1588,  13, codelist1588 },
  {    1592,   1, codelist1592 },
  {    1594,  19, codelist1594 },
  {    1595,   4, codelist1595 },
  {    1596,  19, codelist1596 },
  {    1602,  14, codelist1602 },
  {    1603,   3, codelist1603 },
  {    1610,  14, codelist1610 },
  {    1611,   3, codelist1611 },
  {    1612,  13, codelist1612 },
  {    1616,   1, codelist1616 },
  {    1618,   8, codelist1618 },
  {    1619,   1, codelist1619 },
  {    1620,   3, codelist1620 },
  {    1621,   1, codelist1621 },
  {    1626,  21, codelist1626 },
  {    1627,   8, codelist1627 },
  {    1634,  25, codelist1634 },
  {    1635,   8, codelist1635 },
  {    1636,   4, codelist1636 },
  {    1664,   2, codelist1664 },
  {    1666,  21, codelist1666 },
  {    1667,  11, codelist1667 },
  {    1668,  23, codelist1668 },
  {    1696,   3, codelist1696 },
  {    1700,  13, codelist1700 },
  {    1720,   1, codelist1720 },
  {    1722,   4, codelist1722 },
  {    1723,  10, codelist1723 },
  {    1724,   4, codelist1724 },
  {    1728,   1, codelist1728 },
  {    1732,   1, codelist1732 },
  {    1738,   9, codelist1738 },
  {    1739,  16, codelist1739 },
  {    1740,   2, codelist1740 },
  {    1746,  16, codelist1746 },
  {    1747,  18, codelist1747 },
  {    1762,  19, codelist1762 },
  {    1763,   3, codelist1763 },
  {    1764,   2, codelist1764 },
  {    1794,   2, codelist1794 },
  {    1795,  10, codelist1795 },
  {    1796,  23, codelist1796 },
  {    2048,   1, codelist2048 },
  {    2056,   3, codelist2056 },
  {    2058,  10, codelist2058 },
  {    2059,   2, codelist2059 },
  {    2060,   2, codelist2060 },
  {    2066,   2, codelist2066 },
  {    2096,  14, codelist2096 },
  {    2098,   5, codelist2098 },
  {    2099,  13, codelist2099 },
  {    2100,  24, codelist2100 },
  {    2114,   4, codelist2114 },
  {    2115,   5, codelist2115 },
  {    2120,  12, codelist2120 },
  {    2122,  29, codelist2122 },
  {    2123,   3, codelist2123 },
  {    2124,  17, codelist2124 },
  {    2128,  17, codelist2128 },
  {    2130,  20, codelist2130 },
  {    2131,   2, codelist2131 },
  {    2132,  14, codelist2132 },
  {    2136,   9, codelist2136 },
  {    2138,   6, codelist2138 },
  {    2139,  10, codelist2139 },
  {    2140,   1, codelist2140 },
  {    2144,  25, codelist2144 },
  {    2146,   8, codelist2146 },
  {    2147,   2, codelist2147 },
  {    2148,   7, codelist2148 },
  {    2236,   1, codelist2236 },
  {    2304,  27, codelist2304 },
  {    2306,  69, codelist2306 },
  {    2307,  26, codelist2307 },
  {    2308,  39, codelist2308 },
  {    2404,   1, codelist2404 },
  {    2560,   1, codelist2560 },
  {    2568,   8, codelist2568 },
  {    2570,  19, codelist2570 },
  {    2571,   1, codelist2571 },
  {    2572,   1, codelist2572 },
  {    2586,   3, codelist2586 },
  {    2589,   2, codelist2589 },
  {    2600,   3, codelist2600 },
  {    2603,   2, codelist2603 },
  {    2604,  28, codelist2604 },
  {    2611,   1, codelist2611 },
  {    2616,   7, codelist2616 },
  {    2619,   9, codelist2619 },
  {    2620,  13, codelist2620 },
  {    2624,   3, codelist2624 },
  {    2627,   7, codelist2627 },
  {    2628,  12, codelist2628 },
  {    2632,  16, codelist2632 },
  {    2635,  12, codelist2635 },
  {    2636,  40, codelist2636 },
  {    2648,  11, codelist2648 },
  {    2651,   7, codelist2651 },
  {    2652,  14, codelist2652 },
  {    2656,   7, codelist2656 },
  {    2659,   2, codelist2659 },
  {    2660,   9, codelist2660 },
  {    2688,  12, codelist2688 },
  {    2690,  26, codelist2690 },
  {    2691,  17, codelist2691 },
  {    2692,  33, codelist2692 },
  {    2696,   1, codelist2696 },
  {    2720,   1, codelist2720 },
  {    2722,  33, codelist2722 },
  {    2744,  16, codelist2744 },
  {    2747,   1, codelist2747 },
  {    2748,  10, codelist2748 },
  {    2752,   2, codelist2752 },
  {    2760,  12, codelist2760 },
  {    2763,   7, codelist2763 },
  {    2764,  23, codelist2764 },
  {    2784,  11, codelist2784 },
  {    2787,   6, codelist2787 },
  {    2788,  13, codelist2788 },
  {    2816,   5, codelist2816 },
  {    2818,  19, codelist2818 },
  {    2819,   8, codelist2819 },
  {    2820,   9, codelist2820 },
  {    2832,   5, codelist2832 },
  {    2834,  15, codelist2834 },
  {    2835,   8, codelist2835 },
  {    2836,  18, codelist2836 },
  {    2864,   3, codelist2864 },
  {    2868,  12, codelist2868 },
  {    2888,   5, codelist2888 },
  {    2891,   1, codelist2891 },
  {    2892,  11, codelist2892 },
  {    2896,   9, codelist2896 },
  {    2899,   2, codelist2899 },
  {    2900,  19, codelist2900 },
  {    2912,  13, codelist2912 },
  {    2915,   4, codelist2915 },
  {    2916,  10, codelist2916 },
  {    3072,   1, codelist3072 },
  {    3080,   8, codelist3080 },
  {    3083,   3, codelist3083 },
  {    3084,  30, codelist3084 },
  {    3100,   7, codelist3100 },
  {    3112,   2, codelist3112 },
  {    3114,  17, codelist3114 },
  {    3116,   9, codelist3116 },
  {    3128,  15, codelist3128 },
  {    3130,  20, codelist3130 },
  {    3131,   1, codelist3131 },
  {    3132,   1, codelist3132 },
  {    3136,   2, codelist3136 },
  {    3138,   4, codelist3138 },
  {    3139,   5, codelist3139 },
  {    3140,   2, codelist3140 },
  {    3141,   1, codelist3141 },
  {    3144,  10, codelist3144 },
  {    3146,  24, codelist3146 },
  {    3147,  13, codelist3147 },
  {    3148,   9, codelist3148 },
  {    3160,   5, codelist3160 },
  {    3162,  26, codelist3162 },
  {    3163,  12, codelist3163 },
  {    3164,   4, codelist3164 },
  {    3170,   8, codelist3170 },
  {    3200,   4, codelist3200 },
  {    3202,  27, codelist3202 },
  {    3203,   3, codelist3203 },
  {    3204,  19, codelist3204 },
  {    3232,   3, codelist3232 },
  {    3235,   4, codelist3235 },
  {    3236,   3, codelist3236 },
  {    3256,   5, codelist3256 },
  {    3258,  16, codelist3258 },
  {    3259,   5, codelist3259 },
  {    3260,   9, codelist3260 },
  {    3272,   6, codelist3272 },
  {    3274,  12, codelist3274 },
  {    3275,  12, codelist3275 },
  {    3276,   3, codelist3276 },
  {    3296,   6, codelist3296 },
  {    3298,  20, codelist3298 },
  {    3299,  11, codelist3299 },
  {    3300,   1, codelist3300 },
  {    3328,   5, codelist3328 },
  {    3330,  34, codelist3330 },
  {    3331,   5, codelist3331 },
  {    3332,   5, codelist3332 },
  {    3344,  14, codelist3344 },
  {    3346,  22, codelist3346 },
  {    3347,   5, codelist3347 },
  {    3348,   8, codelist3348 },
  {    3376,   3, codelist3376 },
  {    3378,   8, codelist3378 },
  {    3379,   2, codelist3379 },
  {    3380,   4, codelist3380 },
  {    3400,   3, codelist3400 },
  {    3402,   9, codelist3402 },
  {    3404,   2, codelist3404 },
  {    3408,   5, codelist3408 },
  {    3410,  11, codelist3410 },
  {    3411,   3, codelist3411 },
  {    3412,   2, codelist3412 },
  {    3424,   7, codelist3424 },
  {    3426,  38, codelist3426 },
  {    3427,   7, codelist3427 },
  {    3428,   4, codelist3428 },
  {    3584,   1, codelist3584 },
  {    3594,   4, codelist3594 },
  {    3595,   2, codelist3595 },
  {    3596,  14, codelist3596 },
  {    3597,   1, codelist3597 },
  {    3608,   1, codelist3608 },
  {    3612,   2, codelist3612 },
  {    3626,   2, codelist3626 },
  {    3627,  10, codelist3627 },
  {    3628,   9, codelist3628 },
  {    3635,   3, codelist3635 },
  {    3636,   1, codelist3636 },
  {    3640,   1, codelist3640 },
  {    3642,  13, codelist3642 },
  {    3643,   3, codelist3643 },
  {    3644,   2, codelist3644 },
  {    3650,   2, codelist3650 },
  {    3652,   4, codelist3652 },
  {    3656,   2, codelist3656 },
  {    3658,  11, codelist3658 },
  {    3659,   6, codelist3659 },
  {    3660,   2, codelist3660 },
  {    3668,   1, codelist3668 },
  {    3672,   1, codelist3672 },
  {    3674,   1, codelist3674 },
  {    3675,   3, codelist3675 },
  {    3676,   1, codelist3676 },
  {    3677,   1, codelist3677 },
  {    3682,   3, codelist3682 },
  {    3684,   1, codelist3684 },
  {    3714,  26, codelist3714 },
  {    3715,  16, codelist3715 },
  {    3716,  14, codelist3716 },
  {    3744,   3, codelist3744 },
  {    3746,   1, codelist3746 },
  {    3748,  27, codelist3748 },
  {    3771,   7, codelist3771 },
  {    3772,   1, codelist3772 },
  {    3776,   1, codelist3776 },
  {    3778,   1, codelist3778 },
  {    3779,   7, codelist3779 },
  {    3780,   1, codelist3780 },
  {    3786,   5, codelist3786 },
  {    3787,  12, codelist3787 },
  {    3788,   6, codelist3788 },
  {    3794,   1, codelist3794 },
  {    3795,   1, codelist3795 },
  {    3802,   2, codelist3802 },
  {    3804,   1, codelist3804 },
  {    3810,  12, codelist3810 },
  {    3811,   1, codelist3811 },
  {    3812,   2, codelist3812 },
  {    3842,   5, codelist3842 },
  {    3843,   3, codelist3843 },
  {    3844,   1, codelist3844 },
  {    3858,   5, codelist3858 },
  {    3859,   1, codelist3859 },
  {    3860,   8, codelist3860 },
  {    3915,   4, codelist3915 },
  {    3938,  10, codelist3938 },
  {    3940,   1, codelist3940 },
  {    3971,   3, codelist3971 },
  {    3972,   4, codelist3972 },
  {    4004,   3, codelist4004 },
  {    4096,   1, codelist4096 },
  {    4104,   7, codelist4104 },
  {    4106,   3, codelist4106 },
  {    4107,   2, codelist4107 },
  {    4108,  11, codelist4108 },
  {    4109,   1, codelist4109 },
  {    4124,  16, codelist4124 },
  {    4125,   1, codelist4125 },
  {    4138,  14, codelist4138 },
  {    4140,   8, codelist4140 },
  {    4144,   1, codelist4144 },
  {    4146,  17, codelist4146 },
  {    4147,  26, codelist4147 },
  {    4148,  10, codelist4148 },
  {    4152,   1, codelist4152 },
  {    4154,  11, codelist4154 },
  {    4155,  11, codelist4155 },
  {    4156,   8, codelist4156 },
  {    4160,   1, codelist4160 },
  {    4162,  16, codelist4162 },
  {    4163,   4, codelist4163 },
  {    4164,   5, codelist4164 },
  {    4170,  20, codelist4170 },
  {    4171,  12, codelist4171 },
  {    4172,   6, codelist4172 },
  {    4184,   1, codelist4184 },
  {    4186,  16, codelist4186 },
  {    4187,   8, codelist4187 },
  {    4188,   3, codelist4188 },
  {    4194,   7, codelist4194 },
  {    4195,   1, codelist4195 },
  {    4196,   3, codelist4196 },
  {    4224,   1, codelist4224 },
  {    4226,  49, codelist4226 },
  {    4227,  21, codelist4227 },
  {    4228,  94, codelist4228 },
  {    4235,   1, codelist4235 },
  {    4256,   1, codelist4256 },
  {    4259,   1, codelist4259 },
  {    4260,  24, codelist4260 },
  {    4280,   1, codelist4280 },
  {    4282,  32, codelist4282 },
  {    4283,   8, codelist4283 },
  {    4284,   9, codelist4284 },
  {    4288,   2, codelist4288 },
  {    4290,  28, codelist4290 },
  {    4291,   6, codelist4291 },
  {    4292,  11, codelist4292 },
  {    4298,  30, codelist4298 },
  {    4299,   6, codelist4299 },
  {    4300,  17, codelist4300 },
  {    4306,  32, codelist4306 },
  {    4307,   8, codelist4307 },
  {    4308,   7, codelist4308 },
  {    4314,  12, codelist4314 },
  {    4315,   5, codelist4315 },
  {    4316,  11, codelist4316 },
  {    4320,   1, codelist4320 },
  {    4322,  55, codelist4322 },
  {    4323,   3, codelist4323 },
  {    4324,   3, codelist4324 },
  {    4352,   1, codelist4352 },
  {    4354,  21, codelist4354 },
  {    4355,  13, codelist4355 },
  {    4356,  51, codelist4356 },
  {    4368,   1, codelist4368 },
  {    4370,  17, codelist4370 },
  {    4371,   6, codelist4371 },
  {    4372,  17, codelist4372 },
  {    4426,  10, codelist4426 },
  {    4427,   1, codelist4427 },
  {    4428,   2, codelist4428 },
  {    4432,   1, codelist4432 },
  {    4434,  17, codelist4434 },
  {    4435,   1, codelist4435 },
  {    4436,   2, codelist4436 },
  {    4450,  27, codelist4450 },
  {    4451,   3, codelist4451 },
  {    4452,   4, codelist4452 },
  {    4482,   7, codelist4482 },
  {    4483,  18, codelist4483 },
  {    4484,  12, codelist4484 },
  {    4516,   5, codelist4516 },
  {    4554,   2, codelist4554 },
  {    4555,   1, codelist4555 },
  {    4608,   1, codelist4608 },
  {    4616,   2, codelist4616 },
  {    4618,   3, codelist4618 },
  {    4620,   1, codelist4620 },
  {    4621,   1, codelist4621 },
  {    4632,  14, codelist4632 },
  {    4634,  29, codelist4634 },
  {    4635,   7, codelist4635 },
  {    4636,   5, codelist4636 },
  {    4637,   1, codelist4637 },
  {    4648,  13, codelist4648 },
  {    4651,   1, codelist4651 },
  {    4652,   8, codelist4652 },
  {    4659,   1, codelist4659 },
  {    4664,  13, codelist4664 },
  {    4667,   9, codelist4667 },
  {    4668,   6, codelist4668 },
  {    4672,  11, codelist4672 },
  {    4675,   9, codelist4675 },
  {    4676,  18, codelist4676 },
  {    4680,  19, codelist4680 },
  {    4683,  10, codelist4683 },
  {    4684,  13, codelist4684 },
  {    4688,   2, codelist4688 },
  {    4690,   1, codelist4690 },
  {    4691,   1, codelist4691 },
  {    4692,   3, codelist4692 },
  {    4696,  19, codelist4696 },
  {    4699,   2, codelist4699 },
  {    4700,   1, codelist4700 },
  {    4704,  11, codelist4704 },
  {    4707,   9, codelist4707 },
  {    4708,   3, codelist4708 },
  {    4864,  27, codelist4864 },
  {    4866,   2, codelist4866 },
  {    4867,  36, codelist4867 },
  {    4868,  17, codelist4868 },
  {    4872,  21, codelist4872 },
  {    4875,   2, codelist4875 },
  {    4876,   9, codelist4876 },
  {    4880,   9, codelist4880 },
  {    4882,  10, codelist4882 },
  {    4883,  11, codelist4883 },
  {    4884,   1, codelist4884 },
  {    4904,   1, codelist4904 },
  {    4907,   3, codelist4907 },
  {    4908,   5, codelist4908 },
  {    4912,  18, codelist4912 },
  {    4915,  18, codelist4915 },
  {    4916,  14, codelist4916 },
  {    4936,  13, codelist4936 },
  {    4939,   8, codelist4939 },
  {    4940,  20, codelist4940 },
  {    4947,   7, codelist4947 },
  {    4948,   2, codelist4948 },
  {    4952,  10, codelist4952 },
  {    4955,   2, codelist4955 },
  {    4956,   5, codelist4956 },
  {    4960,  22, codelist4960 },
  {    4963,  11, codelist4963 },
  {    4964,   5, codelist4964 },
  {    5120,   1, codelist5120 },
  {    5128,   4, codelist5128 },
  {    5131,   3, codelist5131 },
  {    5132,   2, codelist5132 },
  {    5144,  22, codelist5144 },
  {    5146,   2, codelist5146 },
  {    5147,   9, codelist5147 },
  {    5148,  18, codelist5148 },
  {    5160,   4, codelist5160 },
  {    5163,  13, codelist5163 },
  {    5164,   8, codelist5164 },
  {    5176,   1, codelist5176 },
  {    5179,   7, codelist5179 },
  {    5180,   3, codelist5180 },
  {    5184,   5, codelist5184 },
  {    5187,   1, codelist5187 },
  {    5188,  12, codelist5188 },
  {    5192,   7, codelist5192 },
  {    5195,  13, codelist5195 },
  {    5196,  10, codelist5196 },
  {    5203,   8, codelist5203 },
  {    5204,   3, codelist5204 },
  {    5208,   6, codelist5208 },
  {    5210,   1, codelist5210 },
  {    5211,   1, codelist5211 },
  {    5212,  10, codelist5212 },
  {    5216,  11, codelist5216 },
  {    5219,   1, codelist5219 },
  {    5376,  11, codelist5376 },
  {    5379,   2, codelist5379 },
  {    5380,   7, codelist5380 },
  {    5384,   7, codelist5384 },
  {    5387,   3, codelist5387 },
  {    5388,   3, codelist5388 },
  {    5395,   1, codelist5395 },
  {    5396,  10, codelist5396 },
  {    5416,   2, codelist5416 },
  {    5419,   1, codelist5419 },
  {    5420,  16, codelist5420 },
  {    5424,  13, codelist5424 },
  {    5426,  20, codelist5426 },
  {    5427,   6, codelist5427 },
  {    5428,  21, codelist5428 },
  {    5448,   3, codelist5448 },
  {    5451,   3, codelist5451 },
  {    5456,  14, codelist5456 },
  {    5459,  10, codelist5459 },
  {    5460,   3, codelist5460 },
  {    5464,   7, codelist5464 },
  {    5466,   3, codelist5466 },
  {    5467,   1, codelist5467 },
  {    5468,  13, codelist5468 },
  {    5472,   8, codelist5472 },
  {    5475,   3, codelist5475 },
  {    5476,   3, codelist5476 },
  {    5632,   1, codelist5632 },
  {    5640,   1, codelist5640 },
  {    5642,   1, codelist5642 },
  {    5643,   1, codelist5643 },
  {    5656,   4, codelist5656 },
  {    5658,  45, codelist5658 },
  {    5660,  15, codelist5660 },
  {    5672,   3, codelist5672 },
  {    5674,   4, codelist5674 },
  {    5675,   3, codelist5675 },
  {    5676,   8, codelist5676 },
  {    5680,   3, codelist5680 },
  {    5683,   1, codelist5683 },
  {    5688,   3, codelist5688 },
  {    5690,  15, codelist5690 },
  {    5691,   2, codelist5691 },
  {    5692,  22, codelist5692 },
  {    5696,   1, codelist5696 },
  {    5698,  11, codelist5698 },
  {    5699,   1, codelist5699 },
  {    5700,  12, codelist5700 },
  {    5704,  10, codelist5704 },
  {    5706,  13, codelist5706 },
  {    5707,   6, codelist5707 },
  {    5708,  37, codelist5708 },
  {    5714,   3, codelist5714 },
  {    5715,   2, codelist5715 },
  {    5716,   1, codelist5716 },
  {    5720,   1, codelist5720 },
  {    5722,  14, codelist5722 },
  {    5723,   1, codelist5723 },
  {    5724,   2, codelist5724 },
  {    5728,   4, codelist5728 },
  {    5730,  14, codelist5730 },
  {    5732,   4, codelist5732 },
  {    5888,  25, codelist5888 },
  {    5890,  32, codelist5890 },
  {    5891,   6, codelist5891 },
  {    5892,  28, codelist5892 },
  {    5896,   5, codelist5896 },
  {    5898,  14, codelist5898 },
  {    5900,  15, codelist5900 },
  {    5904,   1, codelist5904 },
  {    5906,   4, codelist5906 },
  {    5907,   4, codelist5907 },
  {    5908,  38, codelist5908 },
  {    5909,   1, codelist5909 },
  {    5930,  11, codelist5930 },
  {    5932,   7, codelist5932 },
  {    5936,  23, codelist5936 },
  {    5938,   9, codelist5938 },
  {    5939,  12, codelist5939 },
  {    5940,  48, codelist5940 },
  {    5960,   8, codelist5960 },
  {    5962,  25, codelist5962 },
  {    5963,   5, codelist5963 },
  {    5964,  20, codelist5964 },
  {    5968,  11, codelist5968 },
  {    5970,  12, codelist5970 },
  {    5971,   2, codelist5971 },
  {    5972,   9, codelist5972 },
  {    5976,   6, codelist5976 },
  {    5978,  34, codelist5978 },
  {    5979,  11, codelist5979 },
  {    5980,   2, codelist5980 },
  {    5984,  14, codelist5984 },
  {    5986,  35, codelist5986 },
  {    5987,   2, codelist5987 },
  {    5988,   5, codelist5988 },
  {    6144,   1, codelist6144 },
  {    6272,  67, codelist6272 },
  {    6274,  73, codelist6274 },
  {    6275,  20, codelist6275 },
  {    6276,  64, codelist6276 },
  {    6280,  26, codelist6280 },
  {    6282,  23, codelist6282 },
  {    6283,  15, codelist6283 },
  {    6284,   8, codelist6284 },
  {    6304,  18, codelist6304 },
  {    6306,  56, codelist6306 },
  {    6307,   5, codelist6307 },
  {    6308,  25, codelist6308 },
  {    6328,  34, codelist6328 },
  {    6330,   1, codelist6330 },
  {    6331,  29, codelist6331 },
  {    6332,  21, codelist6332 },
  {    6336,  15, codelist6336 },
  {    6339,   8, codelist6339 },
  {    6340,  16, codelist6340 },
  {    6344,  54, codelist6344 },
  {    6347,  28, codelist6347 },
  {    6348,  44, codelist6348 },
  {    6352,  20, codelist6352 },
  {    6355,  15, codelist6355 },
  {    6356,  33, codelist6356 },
  {    6360,  16, codelist6360 },
  {    6363,   6, codelist6363 },
  {    6364,  13, codelist6364 },
  {    6368,  27, codelist6368 },
  {    6371,  16, codelist6371 },
  {    6372,  25, codelist6372 },
  {    6528,  32, codelist6528 },
  {    6530,  31, codelist6530 },
  {    6531,  16, codelist6531 },
  {    6532,  47, codelist6532 },
  {    6560,   3, codelist6560 },
  {    6562,  63, codelist6562 },
  {    6563,   1, codelist6563 },
  {    6564,   1, codelist6564 },
  {    6600,  11, codelist6600 },
  {    6603,   5, codelist6603 },
  {    6604,  18, codelist6604 },
  {    6608,  15, codelist6608 },
  {    6611,   2, codelist6611 },
  {    6612,  22, codelist6612 },
  {    6624,   3, codelist6624 },
  {    6627,  14, codelist6627 },
  {    6656,   1, codelist6656 },
  {    6784,  37, codelist6784 },
  {    6786,  64, codelist6786 },
  {    6787,  16, codelist6787 },
  {    6788,  30, codelist6788 },
  {    6792,   1, codelist6792 },
  {    6795,   2, codelist6795 },
  {    6796,   5, codelist6796 },
  {    6816,   2, codelist6816 },
  {    6818,   3, codelist6818 },
  {    6819,   1, codelist6819 },
  {    6820,  16, codelist6820 },
  {    6840,  20, codelist6840 },
  {    6842,  18, codelist6842 },
  {    6843,   7, codelist6843 },
  {    6844,  12, codelist6844 },
  {    6848,  20, codelist6848 },
  {    6850,  40, codelist6850 },
  {    6851,   1, codelist6851 },
  {    6856,  37, codelist6856 },
  {    6858,  30, codelist6858 },
  {    6859,   8, codelist6859 },
  {    6860,  16, codelist6860 },
  {    6864,   9, codelist6864 },
  {    6866,  22, codelist6866 },
  {    6867,   7, codelist6867 },
  {    6868,   4, codelist6868 },
  {    6872,  20, codelist6872 },
  {    6874,  12, codelist6874 },
  {    6875,   7, codelist6875 },
  {    6876,   5, codelist6876 },
  {    6880,  13, codelist6880 },
  {    6882,   9, codelist6882 },
  {    6883,   3, codelist6883 },
  {    6884,  14, codelist6884 },
  {    7040,  27, codelist7040 },
  {    7042,  32, codelist7042 },
  {    7043,   6, codelist7043 },
  {    7044,  10, codelist7044 },
  {    7072,   3, codelist7072 },
  {    7074,   1, codelist7074 },
  {    7076,  21, codelist7076 },
  {    7112,   6, codelist7112 },
  {    7114,  32, codelist7114 },
  {    7115,   7, codelist7115 },
  {    7116,   6, codelist7116 },
  {    7120,   3, codelist7120 },
  {    7122,   3, codelist7122 },
  {    7136,   3, codelist7136 },
  {    7138,  20, codelist7138 },
  {    7168,   1, codelist7168 },
  {    7296,  90, codelist7296 },
  {    7298,  33, codelist7298 },
  {    7299,  21, codelist7299 },
  {    7300,  44, codelist7300 },
  {    7304,   5, codelist7304 },
  {    7306,  32, codelist7306 },
  {    7308,  10, codelist7308 },
  {    7328,   7, codelist7328 },
  {    7330,  29, codelist7330 },
  {    7331,   2, codelist7331 },
  {    7332,  47, codelist7332 },
  {    7352,  48, codelist7352 },
  {    7354,   4, codelist7354 },
  {    7355,   5, codelist7355 },
  {    7356,  11, codelist7356 },
  {    7360,  18, codelist7360 },
  {    7363,   3, codelist7363 },
  {    7364,  16, codelist7364 },
  {    7368,  32, codelist7368 },
  {    7370,  28, codelist7370 },
  {    7371,  27, codelist7371 },
  {    7372,  28, codelist7372 },
  {    7376,  21, codelist7376 },
  {    7378,   5, codelist7378 },
  {    7379,   1, codelist7379 },
  {    7380,  10, codelist7380 },
  {    7384,  16, codelist7384 },
  {    7386,   5, codelist7386 },
  {    7387,   8, codelist7387 },
  {    7388,  19, codelist7388 },
  {    7392,  14, codelist7392 },
  {    7394,  15, codelist7394 },
  {    7395,   4, codelist7395 },
  {    7396,  12, codelist7396 },
  {    7552,  32, codelist7552 },
  {    7554,   1, codelist7554 },
  {    7555,  13, codelist7555 },
  {    7556,  35, codelist7556 },
  {    7584,   5, codelist7584 },
  {    7586,   8, codelist7586 },
  {    7587,   2, codelist7587 },
  {    7588,   9, codelist7588 },
  {    7624,  30, codelist7624 },
  {    7626,  15, codelist7626 },
  {    7627,   3, codelist7627 },
  {    7628,  22, codelist7628 },
  {    7632,  14, codelist7632 },
  {    7634,  28, codelist7634 },
  {    7636,  16, codelist7636 },
  {    7648,   9, codelist7648 },
  {    7650,   3, codelist7650 },
  {    7652,   2, codelist7652 },
  {    7680,  33, codelist7680 },
  {    7682,  32, codelist7682 },
  {    7683,  27, codelist7683 },
  {    7684,  73, codelist7684 },
  {    7688,  12, codelist7688 },
  {    7690,  12, codelist7690 },
  {    7691,   5, codelist7691 },
  {    7692,  16, codelist7692 },
  {    7704,   4, codelist7704 },
  {    7706,  24, codelist7706 },
  {    7707,   3, codelist7707 },
  {    7708,   9, codelist7708 },
  {    7709,   4, codelist7709 },
  {    7720,   4, codelist7720 },
  {    7722,   2, codelist7722 },
  {    7723,   2, codelist7723 },
  {    7724,   6, codelist7724 },
  {    7736,  13, codelist7736 },
  {    7738,   1, codelist7738 },
  {    7739,   5, codelist7739 },
  {    7740,  19, codelist7740 },
  {    7744,  22, codelist7744 },
  {    7746,   2, codelist7746 },
  {    7747,   4, codelist7747 },
  {    7748,  17, codelist7748 },
  {    7752,  20, codelist7752 },
  {    7755,  16, codelist7755 },
  {    7756,  15, codelist7756 },
  {    7760,  35, codelist7760 },
  {    7763,  21, codelist7763 },
  {    7764,  19, codelist7764 },
  {    7768,  17, codelist7768 },
  {    7771,   5, codelist7771 },
  {    7772,  15, codelist7772 },
  {    7776,  23, codelist7776 },
  {    7779,   5, codelist7779 },
  {    7780,   8, codelist7780 },
  {    7936,  26, codelist7936 },
  {    7938,  20, codelist7938 },
  {    7939,  19, codelist7939 },
  {    7940,  33, codelist7940 },
  {    7944,   4, codelist7944 },
  {    7947,   1, codelist7947 },
  {    7952,   5, codelist7952 },
  {    7954,  38, codelist7954 },
  {    7976,   1, codelist7976 },
  {    7979,   1, codelist7979 },
  {    7980,   1, codelist7980 },
  {    7984,   8, codelist7984 },
  {    7987,   1, codelist7987 },
  {    7988,   9, codelist7988 },
  {    8008,  14, codelist8008 },
  {    8011,   2, codelist8011 },
  {    8012,  11, codelist8012 },
  {    8016,   7, codelist8016 },
  {    8019,   5, codelist8019 },
  {    8020,   1, codelist8020 },
  {    8024,   7, codelist8024 },
  {    8027,   1, codelist8027 },
  {    8028,   5, codelist8028 },
  {    8032,  18, codelist8032 },
  {    8035,   5, codelist8035 },
  {    8036,  12, codelist8036 },
  {    8192,  25, codelist8192 },
  {    8194,  28, codelist8194 },
  {    8195,  17, codelist8195 },
  {    8196,  27, codelist8196 },
  {    8200,  11, codelist8200 },
  {    8202,  10, codelist8202 },
  {    8203,   1, codelist8203 },
  {    8204,  10, codelist8204 },
  {    8216,   3, codelist8216 },
  {    8219,   3, codelist8219 },
  {    8220,   9, codelist8220 },
  {    8232,   4, codelist8232 },
  {    8234,   5, codelist8234 },
  {    8236,   3, codelist8236 },
  {    8248,   9, codelist8248 },
  {    8250,   8, codelist8250 },
  {    8251,   3, codelist8251 },
  {    8252,   1, codelist8252 },
  {    8256,   6, codelist8256 },
  {    8258,  25, codelist8258 },
  {    8259,   7, codelist8259 },
  {    8260,   5, codelist8260 },
  {    8264,   9, codelist8264 },
  {    8266,  30, codelist8266 },
  {    8267,  19, codelist8267 },
  {    8268,   3, codelist8268 },
  {    8272,  10, codelist8272 },
  {    8274,  23, codelist8274 },
  {    8275,   7, codelist8275 },
  {    8276,  10, codelist8276 },
  {    8280,  13, codelist8280 },
  {    8282,  14, codelist8282 },
  {    8283,   6, codelist8283 },
  {    8284,   6, codelist8284 },
  {    8288,  17, codelist8288 },
  {    8290,  31, codelist8290 },
  {    8291,   5, codelist8291 },
  {    8292,   4, codelist8292 },
  {    8448,   4, codelist8448 },
  {    8450,  21, codelist8450 },
  {    8451,   9, codelist8451 },
  {    8452,  22, codelist8452 },
  {    8456,   1, codelist8456 },
  {    8464,   1, codelist8464 },
  {    8468,  19, codelist8468 },
  {    8490,   1, codelist8490 },
  {    8491,   1, codelist8491 },
  {    8492,   2, codelist8492 },
  {    8496,   2, codelist8496 },
  {    8498,  18, codelist8498 },
  {    8500,   3, codelist8500 },
  {    8520,   5, codelist8520 },
  {    8522,   8, codelist8522 },
  {    8523,   3, codelist8523 },
  {    8524,   6, codelist8524 },
  {    8528,   9, codelist8528 },
  {    8530,  12, codelist8530 },
  {    8531,   5, codelist8531 },
  {    8536,   7, codelist8536 },
  {    8538,   4, codelist8538 },
  {    8539,   3, codelist8539 },
  {    8540,   5, codelist8540 },
  {    8544,  11, codelist8544 },
  {    8546,  10, codelist8546 },
  {    8547,   1, codelist8547 },
  {    8548,   3, codelist8548 },
  {    8704,  27, codelist8704 },
  {    8706,  23, codelist8706 },
  {    8707,   7, codelist8707 },
  {    8708,  59, codelist8708 },
  {    8709,   1, codelist8709 },
  {    8712,  18, codelist8712 },
  {    8714,   1, codelist8714 },
  {    8715,   2, codelist8715 },
  {    8716,   9, codelist8716 },
  {    8728,   5, codelist8728 },
  {    8730,   7, codelist8730 },
  {    8731,   2, codelist8731 },
  {    8732,  19, codelist8732 },
  {    8744,   1, codelist8744 },
  {    8747,   2, codelist8747 },
  {    8748,   4, codelist8748 },
  {    8754,   1, codelist8754 },
  {    8760,  14, codelist8760 },
  {    8762,   7, codelist8762 },
  {    8763,   1, codelist8763 },
  {    8764,  10, codelist8764 },
  {    8768,   2, codelist8768 },
  {    8770,   1, codelist8770 },
  {    8771,   5, codelist8771 },
  {    8772,   8, codelist8772 },
  {    8776,  22, codelist8776 },
  {    8779,   5, codelist8779 },
  {    8780,  25, codelist8780 },
  {    8784,  28, codelist8784 },
  {    8786,   2, codelist8786 },
  {    8787,  12, codelist8787 },
  {    8788,  12, codelist8788 },
  {    8792,  10, codelist8792 },
  {    8795,   3, codelist8795 },
  {    8796,   5, codelist8796 },
  {    8797,   1, codelist8797 },
  {    8800,  17, codelist8800 },
  {    8802,   6, codelist8802 },
  {    8803,   5, codelist8803 },
  {    8804,   9, codelist8804 },
  {    8960,  23, codelist8960 },
  {    8962,  14, codelist8962 },
  {    8963,  16, codelist8963 },
  {    8964,  24, codelist8964 },
  {    8968,   3, codelist8968 },
  {    8971,   1, codelist8971 },
  {    8972,   1, codelist8972 },
  {    8976,   1, codelist8976 },
  {    8980,  19, codelist8980 },
  {    9000,   4, codelist9000 },
  {    9003,   1, codelist9003 },
  {    9004,   5, codelist9004 },
  {    9010,   2, codelist9010 },
  {    9011,   1, codelist9011 },
  {    9012,   7, codelist9012 },
  {    9032,   3, codelist9032 },
  {    9036,   1, codelist9036 },
  {    9043,   5, codelist9043 },
  {    9044,   6, codelist9044 },
  {    9048,   8, codelist9048 },
  {    9051,   6, codelist9051 },
  {    9052,   1, codelist9052 },
  {    9216,   1, codelist9216 },
  {    9220,   4, codelist9220 },
  {    9243,   3, codelist9243 },
  {    9244,   2, codelist9244 },
  {    9274,   6, codelist9274 },
  {    9275,   1, codelist9275 },
  {    9276,   3, codelist9276 },
  {    9282,  15, codelist9282 },
  {    9283,   4, codelist9283 },
  {    9284,   1, codelist9284 },
  {    9290,   6, codelist9290 },
  {    9291,   9, codelist9291 },
  {    9298,   8, codelist9298 },
  {    9299,   7, codelist9299 },
  {    9300,  18, codelist9300 },
  {    9306,  12, codelist9306 },
  {    9307,   4, codelist9307 },
  {    9308,   2, codelist9308 },
  {    9312,   1, codelist9312 },
  {    9314,   3, codelist9314 },
  {    9315,   1, codelist9315 },
  {    9474,  20, codelist9474 },
  {    9475,   6, codelist9475 },
  {    9476,  12, codelist9476 },
  {    9490,   1, codelist9490 },
  {    9492,  10, codelist9492 },
  {    9522,   3, codelist9522 },
  {    9523,   5, codelist9523 },
  {    9524,   8, codelist9524 },
  {    9546,   3, codelist9546 },
  {    9547,   9, codelist9547 },
  {    9552,   1, codelist9552 },
  {    9556,   3, codelist9556 },
  {    9570,  29, codelist9570 },
  {    9571,   5, codelist9571 },
  {    9728,  39, codelist9728 },
  {    9731,  19, codelist9731 },
  {    9732,  12, codelist9732 },
  {    9733,   1, codelist9733 },
  {    9736,   7, codelist9736 },
  {    9738,   6, codelist9738 },
  {    9754,  18, codelist9754 },
  {    9755,   1, codelist9755 },
  {    9756,   5, codelist9756 },
  {    9768,   5, codelist9768 },
  {    9771,   5, codelist9771 },
  {    9772,   3, codelist9772 },
  {    9778,   1, codelist9778 },
  {    9784,   4, codelist9784 },
  {    9786,   1, codelist9786 },
  {    9787,   7, codelist9787 },
  {    9788,  11, codelist9788 },
  {    9792,  18, codelist9792 },
  {    9795,   1, codelist9795 },
  {    9796,   3, codelist9796 },
  {    9800,   2, codelist9800 },
  {    9802,   3, codelist9802 },
  {    9803,   9, codelist9803 },
  {    9804,  11, codelist9804 },
  {    9808,   2, codelist9808 },
  {    9811,   1, codelist9811 },
  {    9812,   1, codelist9812 },
  {    9816,   5, codelist9816 },
  {    9819,   1, codelist9819 },
  {    9820,   4, codelist9820 },
  {    9824,  10, codelist9824 },
  {    9828,   2, codelist9828 },
  {    9984,   2, codelist9984 },
  {    9986,  10, codelist9986 },
  {    9987,   7, codelist9987 },
  {   10000,   2, codelist10000 },
  {   10002,   7, codelist10002 },
  {   10003,   3, codelist10003 },
  {   10004,  13, codelist10004 },
  {   10032,   5, codelist10032 },
  {   10035,   6, codelist10035 },
  {   10036,  12, codelist10036 },
  {   10056,   2, codelist10056 },
  {   10059,   5, codelist10059 },
  {   10060,   4, codelist10060 },
  {   10064,   9, codelist10064 },
  {   10067,   5, codelist10067 },
  {   10068,   6, codelist10068 },
  {   10080,  18, codelist10080 },
  {   10083,   6, codelist10083 },
  {   10084,   6, codelist10084 },
  {   10240,   7, codelist10240 },
  {   10242,  17, codelist10242 },
  {   10243,   6, codelist10243 },
  {   10244,  12, codelist10244 },
  {   10248,   3, codelist10248 },
  {   10251,   1, codelist10251 },
  {   10252,   1, codelist10252 },
  {   10268,  14, codelist10268 },
  {   10280,   1, codelist10280 },
  {   10282,   5, codelist10282 },
  {   10283,  10, codelist10283 },
  {   10284,   5, codelist10284 },
  {   10296,   4, codelist10296 },
  {   10298,   7, codelist10298 },
  {   10299,   4, codelist10299 },
  {   10300,   4, codelist10300 },
  {   10308,   4, codelist10308 },
  {   10312,   3, codelist10312 },
  {   10314,   4, codelist10314 },
  {   10315,   5, codelist10315 },
  {   10316,   5, codelist10316 },
  {   10320,   3, codelist10320 },
  {   10322,   5, codelist10322 },
  {   10328,   8, codelist10328 },
  {   10330,   2, codelist10330 },
  {   10336,   1, codelist10336 },
  {   10338,   5, codelist10338 },
  {   10340,   1, codelist10340 },
  {   10496,   3, codelist10496 },
  {   10498,   2, codelist10498 },
  {   10500,  19, codelist10500 },
  {   10512,   7, codelist10512 },
  {   10514,   7, codelist10514 },
  {   10515,   4, codelist10515 },
  {   10516,  12, codelist10516 },
  {   10544,   9, codelist10544 },
  {   10546,   2, codelist10546 },
  {   10547,   3, codelist10547 },
  {   10548,  18, codelist10548 },
  {   10568,   3, codelist10568 },
  {   10570,   3, codelist10570 },
  {   10572,   4, codelist10572 },
  {   10576,   2, codelist10576 },
  {   10578,   2, codelist10578 },
  {   10579,   2, codelist10579 },
  {   10580,   3, codelist10580 },
  {   10592,  17, codelist10592 },
  {   10594,  13, codelist10594 },
  {   10596,   3, codelist10596 },
  {   10752,  33, codelist10752 },
  {   10755,   1, codelist10755 },
  {   10756,  26, codelist10756 },
  {   10757,   1, codelist10757 },
  {   10760,   2, codelist10760 },
  {   10763,   4, codelist10763 },
  {   10764,   7, codelist10764 },
  {   10780,  16, codelist10780 },
  {   10792,   5, codelist10792 },
  {   10796,   3, codelist10796 },
  {   10808,   9, codelist10808 },
  {   10811,   3, codelist10811 },
  {   10812,   4, codelist10812 },
  {   10816,  12, codelist10816 },
  {   10819,   7, codelist10819 },
  {   10820,   1, codelist10820 },
  {   10824,   5, codelist10824 },
  {   10827,   5, codelist10827 },
  {   10828,   2, codelist10828 },
  {   10832,   6, codelist10832 },
  {   10840,   2, codelist10840 },
  {   10843,   6, codelist10843 },
  {   10844,   1, codelist10844 },
  {   10848,   2, codelist10848 },
  {   11008,   6, codelist11008 },
  {   11010,   1, codelist11010 },
  {   11012,  42, codelist11012 },
  {   11024,  15, codelist11024 },
  {   11026,   1, codelist11026 },
  {   11027,   9, codelist11027 },
  {   11028,   1, codelist11028 },
  {   11056,  12, codelist11056 },
  {   11058,   3, codelist11058 },
  {   11059,   5, codelist11059 },
  {   11060,  23, codelist11060 },
  {   11080,   3, codelist11080 },
  {   11083,   1, codelist11083 },
  {   11084,   3, codelist11084 },
  {   11088,   8, codelist11088 },
  {   11091,   5, codelist11091 },
  {   11092,   2, codelist11092 },
  {   11104,  12, codelist11104 },
  {   11107,   8, codelist11107 },
  {   11108,   5, codelist11108 },
};

#endif /* __TABE_YIN2ZHI_H__ */
