# This spec file creates two relocatable RPMS:
# - one for library usage only
# - a devel version, including header files and documentation.
#
%define prefix   /usr

Summary: A libpcap trace file navigation library
Name: libpcapnav
Version: 0.6
Release: 1
License: BSD
Group: Development/Libraries
URL: http://netdude.sf.net
# Using FTP to get around SourceForge's habit of adding something after .tar.gz
Source: ftp://ftp.sf.net/pub/sourceforge/netdude/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Packager: Christian Kreibich <christian@whoop.org> 
Requires: libpcap
Prefix: %{prefix}

%description
libpcapnav is a libpcap wrapper library that allows navigation to
arbitrary locations in a tcpdump trace file between reads. The API is
intentionally much like that of the pcap library. You can navigate in
trace files both in time and space: you can jump to a packet which is
at approximately 2/3 of the trace, or you can jump as closely as
possible to a packet with a given timestamp, and then read packets
from there.

%package devel
Summary: Development and documentation files for libpcapnav.
Group: Development/Libraries
Requires: libpcapnav

%description devel
Static libraries, header files and documentation
for libpcapnav

%prep
%setup -q
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix
fi

%build
if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog NEWS README
%{prefix}/lib/lib*.so.*

%files devel
%defattr(-,root,root,-)
%doc %{prefix}/share/gtk-doc/html/pcapnav
%{prefix}/lib/lib*a
%{prefix}/include/pcapnav.h
%{prefix}/bin/pcapnav-config

%changelog
* Sat Apr 10 2004 Christian Kreibich <christian@whoop.org> 
- Updated to 0.5
* Tue Dec  9 2003 Christian Kreibich <christian@whoop.org> 
- Added spec file to tree.


