/*

Copyright (C) 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_tanalyzer_tasks_h
#define __nd_tanalyzer_tasks_h

#include "libnd_ta.h"

void libnd_ta_task_basic(LND_TAnalysis *ta, LND_Packet *packet);
void libnd_ta_task_ip_protocols(LND_TAnalysis *ta, LND_Packet *packet);
void libnd_ta_task_tcp_flows(LND_TAnalysis *ta, LND_Packet *packet);
void libnd_ta_task_ports(LND_TAnalysis *ta, LND_Packet *packet);
void libnd_ta_task_sports(LND_TAnalysis *ta);
void libnd_ta_task_dports(LND_TAnalysis *ta);

void libnd_ta_task_basic_print(const LND_TAnalysis *ta, FILE *output);
void libnd_ta_task_ip_protocols_print(const LND_TAnalysis *ta, FILE *output);
void libnd_ta_task_flows_print(const LND_TAnalysis *ta, FILE *output);
void libnd_ta_task_ports_print(const LND_TAnalysis *ta, FILE *output);
void libnd_ta_task_sports_print(const LND_TAnalysis *ta, FILE *output);
void libnd_ta_task_dports_print(const LND_TAnalysis *ta, FILE *output);

#endif
