# This spec file creates one relocatable RPM, containing
# both the library files and any headers to install. It's
# likely package bloat to use separate RPMs for such a small
# number of files ...
%define prefix		/usr
%define version		0.3

Summary: Traffic Analyzer plugin for libnetdude
Name: libnetdude-traffic-analyzer-plugin
Version: %{version}
Release: 1
License: BSD
Group: Applications/Communications
URL: http://netdude.sf.net
# Using FTP to get around SourceForge's habit of adding something after .tar.gz
Source: ftp://ftp.sf.net/pub/sourceforge/netdude/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Packager: Christian Kreibich <christian@whoop.org>
Requires: libnetdude >= 0.6
Requires: libnetdude-conntrack-plugin >= 0.3
Requires: libnetdude-traceset-plugin >= 0.2

Prefix: %{prefix}

%description
This plugin gathers simple statistics from one or more trace files and
allows you to save the results in a user-provided output stream. The
analyzed items comprise basic packet counts, IP protocol usage, UDP + TCP
port usage, and UDP/TCP flows.

%prep
%setup -q
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=$RPM_BUILD_ROOT%prefix --with-prefix-subst
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=$RPM_BUILD_ROOT%prefix --with-prefix-subst
fi

%build
if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{prefix}/include/libnetdude/*
%{prefix}/share/libnetdude/*

%changelog
* Sat Apr 17 2004 Christian Kreibich <christian@whoop.org> 
- Updated to 0.3, and added proper dependancies.

* Wed Jan 28 2004 Christian Kreibich <christian@whoop.org> 
- Initial build.


