# This spec file creates one relocatable RPM, containing
# both the library files and any headers to install. It's
# likely package bloat to use separate RPMs for such a small
# number of files ...
%define prefix		/usr
%define version		0.2

Summary: Flow Demultiplexer plugin for libnetdude
Name: libnetdude-demux-plugin
Version: %{version}
Release: 1
License: BSD
Group: Applications/Communications
URL: http://netdude.sf.net
# Using FTP to get around SourceForge's habit of adding something after .tar.gz
Source: ftp://ftp.sf.net/pub/sourceforge/netdude/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Packager: Christian Kreibich <christian@whoop.org>
Requires: libnetdude >= 0.6
Requires: libnetdude-conntrack-plugin >= 0.3
Requires: libnetdude-traceset-plugin >= 0.2

Prefix: %{prefix}

%description
This plugin scans a set of input traces and creates a separate
pcap trace file for each flow contained in the input traces.
The output is placed in a directory tree whose first level
differentiates by IP protocol, the second by source IP address,
and the third by destination IP address. Arbitrarily many input
traces are supported.

%prep
%setup -q
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=$RPM_BUILD_ROOT%prefix --with-prefix-subst
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=$RPM_BUILD_ROOT%prefix --with-prefix-subst
fi

%build
if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{prefix}/include/libnetdude/*
%{prefix}/share/libnetdude/*

%changelog
* Fri Apr 30 2004 Christian Kreibich <christian@whoop.org> 
- Update to 0.2
* Sat Apr 17 2004 Christian Kreibich <christian@whoop.org> 
- Filled in template spec file.

