/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <libnd_macros.h>
#include <libnd_packet.h>
#include <libnd_trace.h>
#include <libnd_protocol_inst.h>
#include <libnd_null_protocol.h>


static void
null_proto_init(void)
{
}

static void     
null_proto_init_packet(LND_Packet *packet, guchar *data, guchar *data_end)
{
  return;
  TOUCH(packet);
  TOUCH(data);
  TOUCH(data_end);
}

static gboolean 
null_proto_header_complete(const LND_Packet *packet, guint nesting)
{
  return FALSE;
  TOUCH(packet);
  TOUCH(nesting);
}

static gboolean
null_proto_fix_packet(LND_Packet *packet)
{
  return FALSE;
  TOUCH(packet);
}

static void
null_proto_init_state(LND_Trace *trace)
{
  return;
  TOUCH(trace);
}

static void       
null_proto_update_state(const LND_Packet *packet, int index)
{
  return;
  TOUCH(packet);
  TOUCH(index);
}

static void       
null_proto_update_tcpdump_line(const LND_Packet *packet, char *line)
{
  return;
  TOUCH(packet);
  TOUCH(line);
}

static void       
null_proto_free_state(LND_Trace *trace)
{
  return;
  trace = NULL;
}



void
libnd_null_proto_hook_up(LND_Protocol *proto)
{
  if (!proto)
    return;

  proto->init_proto          = null_proto_init;
  proto->init_packet         = null_proto_init_packet;
  proto->header_complete     = null_proto_header_complete;
  proto->fix_packet          = null_proto_fix_packet;
  proto->init_state          = null_proto_init_state;
  proto->update_state        = null_proto_update_state;
  proto->update_tcpdump_line = null_proto_update_tcpdump_line;
  proto->free_state          = null_proto_free_state;
}

