/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <libnd_filter.h>
#include <libnd_filter_factory.h>

static GList      *factories;

LND_FilterFactory *
libnd_filter_factory_new(const char *name,
			 LND_FilterCreateFunc create_func,
			 LND_FilterModifyFunc modify_func)
{
  LND_FilterFactory *factory; 

  if (!name || !create_func || !modify_func)
    return NULL;

  if (! (factory = g_new0(LND_FilterFactory, 1)))
    return NULL;

  factory->name = strdup(name);
  
  factory->create_func = create_func;
  factory->modify_func = modify_func;

  return factory;
}


void               
libnd_filter_factory_free(LND_FilterFactory *factory)
{
  if (!factory)
    return;

  g_free((char *) factory->name);
  g_free(factory);
}


gboolean  
libnd_filter_factory_register(LND_FilterFactory *factory)
{
  if (!factory)
    return FALSE;

  if (libnd_filter_factory_find(factory->name))
    return FALSE;

  factories = g_list_prepend(factories, factory);
  return TRUE;
}


void               
libnd_filter_factory_foreach(LND_FilterFactoryFunc func, void *user_data)
{
  GList *l;

  if (!func)
    return;

  for (l = factories; l; l = g_list_next(l))
    {
      LND_FilterFactory *ff = (LND_FilterFactory *) l->data;
      func(ff, user_data);
    }
}


LND_FilterFactory *
libnd_filter_factory_find(const char *name)
{
  GList *l;

  for (l = g_list_first(factories); l; l = g_list_next(l))
    {
      LND_FilterFactory *ff = (LND_FilterFactory *) l->data;

      if (! strcmp(ff->name, name))
	return ff;
    }

  return NULL;
}

