/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#include <libnd.h>

/* The Checksum Fix plugin. It calls the fix_packet()
 * callback for all protocols existing in the relevant
 * packets (ie, the selection, the local trace part
 * or the entire trace).
 */
static guint last_tested, last_modified;

const char *
name(void)
{
  return "Checksum-Fix";
}

const char *
author(void)
{
  return "Christian Kreibich, <christian@whoop.org>";
}

const char *
version(void)
{
  return VERSION;
}

void
run(LND_Trace *trace, void *user_data)
{
  LND_PacketIterator pit;

  if (!trace)
    return;

  D(("Starting Checksum Fix Plugin\n"));

  last_tested = last_modified = 0;

  /* Use a packet iterator packets in the given trace -- it will
   * do The Right Thing for whatever selection mode is currently
   * active.
   */
  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      last_tested++;
      
      if (libnd_packet_fix(libnd_pit_get(&pit)))
	last_modified++;
    }
  
  return;
  TOUCH(user_data);
}


void
libnd_cksumfix_run(LND_Trace *trace, guint *tested, guint *modified)
{
  if (!trace)
    return;

  run(trace, NULL);
  
  if (tested)
    *tested = last_tested;
  if (modified)
    *modified = last_modified;

  if (last_modified > 0)
    libnd_trace_set_dirty(trace, TRUE);
}
