# This spec file creates two relocatable RPMS:
# - one for library usage only
# - a devel version, including header files and documentation.
#
%define prefix /usr

Summary: A libpcap trace file manipulation library
Name: libnetdude
Version: 0.7
Release: 1
License: BSD
Group: Development/Libraries
URL: http://netdude.sf.net
# Using FTP to get around SourceForge's habit of adding something after .tar.gz
Source: ftp://ftp.sf.net/pub/sourceforge/netdude/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Packager: Christian Kreibich <christian@whoop.org> 
Requires: libpcapnav >= 0.5
Prefix: %{prefix}

%description
libnetdude is the packet manipulating backend of Netdude, the
network dump data editing framework. It fills the gap between
the low-level libpcap API and the high-level requirements for
packet manipulation applications. libnetdude provides data types
and an API for the most common requirements when dealing with
libpcap trace files: trace files, packets, network protocols,
packet iterators, packet filters. libnetdude supports manipulation
of arbitrarily large trace files, and is extendable through a
plugin facility.

%package devel
Summary: Development and documentation files for libnetdude
Group: Development/Libraries
Requires: libnetdude = 0.7 libpcapnav-devel >= 0.5

%description devel
Static libraries, header files and documentation for libnetdude.

%prep
%setup -q
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix
fi

%build

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{prefix}/lib/lib*.so.*
%{prefix}/share/libnetdude/%{version}

%files devel
%defattr(-,root,root,-)
%doc %{prefix}/share/gtk-doc/html/libnetdude
%{prefix}/lib/lib*a
%{prefix}/include/libnetdude/%{version}
%{prefix}/bin/lndtool

%changelog
* Tue Dec  9 2003 Christian Kreibich <christian@whoop.org> 
- Added spec file to tree.
