/*

Copyright (C) 2000 - 2006 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libnd_tcp.h>
#include <libnd_tcp_prefs.h>

#define LND_DOM_TCP "TCP"

static LND_PrefsEntry prefs_entries_tcp[] = {
  { "tcp_seqack_none",          LND_PREFS_INT, 1, LND_UNUSED, LND_UNUSED },
  { "tcp_seqack_once",          LND_PREFS_INT, 0, LND_UNUSED, LND_UNUSED },
  { "tcp_seqack_update_single", LND_PREFS_INT, 0, LND_UNUSED, LND_UNUSED },
  { "tcp_seqack_update_all",    LND_PREFS_INT, 0, LND_UNUSED, LND_UNUSED },
};


static void
tcp_prefs_apply_cb(LND_PrefsDomain *domain, void *user_data)
{
  int val;

  D(("Apply options to TCP plugin\n"));

  libnd_tcpdump_options_reset();
  
  libnd_prefs_get_int_item(LND_DOM_TCP, "tcp_seqack_none", &val);  
  if (val)
    {
      libnd_tcp_set_state_mode(LND_TCP_STATE_NONE);
      libnd_tcpdump_options_add("-S");
      return;
    }

  libnd_prefs_get_int_item(LND_DOM_TCP, "tcp_seqack_once", &val);  
  if (val)
    {
      libnd_tcp_set_state_mode(LND_TCP_STATE_ONCE);
      return;
    }

  libnd_prefs_get_int_item(LND_DOM_TCP, "tcp_seqack_update_single", &val);  
  if (val)
    {
      libnd_tcp_set_state_mode(LND_TCP_STATE_UPDATE_SINGLE);
      return;
    }

  libnd_prefs_get_int_item(LND_DOM_TCP, "tcp_seqack_update_all", &val);  
  if (val)
    {
      libnd_tcp_set_state_mode(LND_TCP_STATE_UPDATE_ALL);
      return;
    }

  return;
  TOUCH(domain);
  TOUCH(user_data);
}


void      
libnd_tcp_init_prefs(void)
{
  LND_PrefsDomain *domain;

  domain = libnd_prefs_add_domain(LND_DOM_TCP, prefs_entries_tcp,
				  sizeof(prefs_entries_tcp) / sizeof(LND_PrefsEntry));

  libnd_prefs_domain_add_apply_cb(domain, tcp_prefs_apply_cb);
}
