/* $Id: debug.c,v 1.3 1998/11/21 23:55:52 marcus Exp $
******************************************************************************

   LibGG - Debug output

   Copyright (C) 1997 Todd Fries	[toddf@acm.org]
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdarg.h>

#include <ggi/gg.h>
#include "plat.h"

#ifndef __GNUC__
void DPRINT(int sync, const char *form,...)
{
	va_list args;

	va_start(args, form);
	vfprintf(stderr,form,args);
	va_end(args);
}
#endif /* !__GNUC__ */

void ggDPrintf(int sync, const char *file, int line, const char *form,...)
{
	va_list args;

	va_start(args, form);
	fprintf(stderr,"LibGG: %s:%i: ",file,line);
	vfprintf(stderr,form,args);
	if (sync) {
		fflush(stderr);
	}
	va_end(args);
}
