/* $Id: misc_int.h,v 1.4 1999/06/21 22:56:01 marcus Exp $
******************************************************************************

   LibGGI Misc extension internals

   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]
   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_MISC_INT_H
#define _GGI_MISC_INT_H

#include <ggi/internal/internal.h>
#include "misc.h"

__BEGIN_DECLS

/* Exported variables */
#ifdef BUILDING_LIBGGIMISC
extern ggi_extid    ggiMiscID;
#else
IMPORTVAR ggi_extid ggiMiscID;
#endif

__END_DECLS

typedef int (ggimiscfunc_setsplitline)(ggi_visual *vis, int y);
typedef int (ggimiscfunc_getraypos)(ggi_visual *vis, sint32 *x, sint32 *y);
typedef ggimiscfunc_getraypos ggimiscfunc_waitraypos;

typedef struct misc_ext {
	ggimiscfunc_setsplitline  *setsplitline;
	ggimiscfunc_getraypos     *getraypos;
	ggimiscfunc_waitraypos    *waitraypos;
	void *priv;
} miscext;

#define LIBGGI_MISCEXT(vis) ((miscext *)LIBGGI_EXT(vis, ggiMiscID))

#endif /* _GGI_MISC_INT_H */
