/* $Id: init.c,v 1.10 2000/04/24 17:43:19 marcus Exp $
******************************************************************************

   Misc extension implementation for X target

   Copyright (C) 1998 Steve Cheng	[steve@ggi-project.org]
   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]
   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>
#include "misc_int.h"
#include <ggi/display/x.h>


static int
GGI_x_setsplitline(ggi_visual *vis, int y)
{
	ggi_x_priv *priv;

	GGIDPRINT("X setting splitline %d !\n", y);

	if (y < 0 || y > LIBGGI_MODE(vis)->visible.y) return -1;

	priv = LIBGGI_PRIVATE(vis);

	if (priv->yoff > LIBGGI_MODE(vis)->virt.y - y) {
		priv->yoff = LIBGGI_MODE(vis)->virt.y - y;
	}

	priv->ysplit = y;

	return 0;
}

static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32 *dlret)
{
	miscext *me = LIBGGI_MISCEXT(vis);

	me->setsplitline = GGI_x_setsplitline;

	*dlret = GGI_DL_EXTENSION;
	return 0;
}


int GGIdl_X_misc(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;
	case GGIFUNC_exit:
	case GGIFUNC_close:
		*funcptr = NULL;
		return 0;
	default:
		*funcptr = NULL;
	}

	return GGI_ENOTFOUND;
}

#include <ggi/internal/ggidlinit.h>
