/* $Id: fbdev.h,v 1.9 1999/05/05 20:27:39 marcus Exp $
******************************************************************************

   Display-FBDEV

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_DISPLAY_FBDEV_H
#define _GGI_DISPLAY_FBDEV_H

#include <linux/fb.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/linvtsw.h>

ggifunc_getmode		GGI_fbdev_getmode;
ggifunc_setmode		GGI_fbdev_setmode;
ggifunc_checkmode	GGI_fbdev_checkmode;
ggifunc_resetmode	GGI_fbdev_resetmode;
ggifunc_getapi		GGI_fbdev_getapi;
ggifunc_setflags	GGI_fbdev_setflags;
		
ggifunc_setpalvec	GGI_fbdev_setpalvec;
ggifunc_setorigin	GGI_fbdev_setorigin;
ggifunc_setdisplayframe	GGI_fbdev_setdisplayframe;


/* Visual-specific private data */

typedef struct fbdev_hook
{	
	/* Framebuffer info */
	int   vtswitchfd;
	void *fb_ptr;
	long  fb_size;
	long  mmap_size;
	long  frame_size;

	struct fb_var_screeninfo var;
	struct fb_fix_screeninfo fix;

	uint16 reds[256];
	uint16 greens[256];
	uint16 blues[256];
	
	/* Original mode on framebuffer */
	struct fb_var_screeninfo orig_var;
	struct fb_fix_screeninfo orig_fix;
	
	/* Save original palette here if it exists */
	uint16 *orig_reds;
	uint16 *orig_greens;
	uint16 *orig_blues;

	/* Miscellaneous */
	int dohalt;
	int autoswitch;
	int switchpending;
	int ismapped;
	ggi_linvtsw_func *doswitch;
	int inputs;
	gii_input *inp;
	
	/* Acceleration */
	ggi_gc *normalgc;
	char   *accel;
	int	have_accel;
	void   *accelpriv;		/* Accel lib private data */
	volatile uint8  *mmioaddr;	/* Faster access for accel lib */
	ggifunc_flush	  *flush;
	ggifunc_idleaccel *idleaccel;
} fbdev_hook;

#define FBDEV_PRIV(vis) ((fbdev_hook *)LIBGGI_PRIVATE(vis))

#define FBDEV_INP_KBD    0x01
#define FBDEV_INP_MOUSE  0x02
#define FBDEV_INP_VT     0x04   /* not really an input. too bad */

#endif /* _GGI_DISPLAY_FBDEV_H */
