/* $Id: visual.c,v 1.9 1998/12/18 21:36:24 marcus Exp $
******************************************************************************

   Misc extension for LibGGI SVGAlib-target

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <ggi/internal/ggi-dl.h>
#include "misc_int.h"
#include "svgamisc.h"

#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
#include <asm/io.h>
#endif

int GGIdlinit(ggi_visual *vis,const char *args,void *ptr)
{
	LIBGGI_MISCEXT(vis)->private
		= _ggi_malloc(sizeof(struct svgamisc_priv));
#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
	{
#define	MISCr	0x03CC
#define	MISCw	0x03C2
#define	CRTIm	0x03B4
#define CRTIc	0x03D4
#define CRTDm	0x03B5
#define	CRTDc	0x03D5
#define	MISC_COLOR_IO	0x01
	int tmp = inb(MISCr);
	outb(tmp, MISCw);
	if (tmp & MISC_COLOR_IO) { 
		SVGAMISC_PRIV(vis)->CRTI = CRTIc;
		SVGAMISC_PRIV(vis)->CRTD = CRTDc; 
	} else {
		SVGAMISC_PRIV(vis)->CRTI = CRTIm;
		SVGAMISC_PRIV(vis)->CRTD = CRTDm;
	}
	}
	LIBGGI_MISCEXT(vis)->setsplitline=GGIsetsplitline;
#endif
	LIBGGI_MISCEXT(vis)->waitraypos=GGIwaitraypos;

	return GGI_DL_EXTENSION;
}

int GGIdlcleanup(ggi_visual *vis)
{
	free(LIBGGI_MISCEXT(vis)->private);
	return 0;
}

#include <ggi/internal/ggidlinit.h>
