/* $Id: hline.c,v 1.13 1998/12/18 21:36:23 marcus Exp $
******************************************************************************

   SVGAlib target: horizontal lines

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/svgalib.h>

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGI_svga_drawhline(ggi_visual *vis,int x,int y,int w)
{
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y))
		return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		vga_setcolor(LIBGGI_GC_FGCOLOR(vis));
		vga_drawline(x,y,x+w-1,y);
	}
	return 0;
}

int GGI_svga_drawhline_nc(ggi_visual *vis,int x,int y,int w)
{
	vga_setcolor(LIBGGI_GC_FGCOLOR(vis));
	vga_drawline(x,y,x+w-1,y);
	return 0;
}

int GGI_svga_puthline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) {
		return 0;
	}
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
		buffer=((char *)buffer)+diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		if (SVGA_PRIV(vis)->ismodex && x%4 != 0) {
			for (;x%4 != 0;x++) {
				ggiPutPixel(vis, x, y, *((char*)buffer));
				buffer = ((char*)buffer)+1;
			}
			for (;w%4 != 0;w--)
				ggiPutPixel(vis, x, y, *((char*)buffer+w));	
		}
        vga_drawscansegment(buffer, x, y, w*LIBGGI_PIXFMT(vis)->size/8);
	}
	return 0;
}
