/* $Id: color.c,v 1.9 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   Graphics library for GGI. Pixels.

   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "lin4lib.h"

/* The magic numbers are calculated like so:
 *   2^14+2^12+..2^4+2^2+1
 *
 *  Where the differece between the powers is equal to
 * the number of bits of color. Pretty spiff stuff...
 */
# define MAGIC_1	0xffff
# define MAGIC_2	0x5555

/* Return `1:2:1' mapping
 */
ggi_pixel GGI_lin4_mapcolor(ggi_visual *vis,ggi_color *col)
{
	return	((col->r>>(GGI_COLOR_PRECISION-1))<<3)|
		((col->g>>(GGI_COLOR_PRECISION-2))<<1)|
		(col->b>>(GGI_COLOR_PRECISION-1));
}

/* Map `1:2:1' pixel to color
 */
int GGI_lin4_unmappixel(ggi_visual *vis,ggi_pixel pixel,ggi_color *col)
{
	if (pixel>255 || col==NULL) 
		return -1;

	col->b=(pixel & 0x1) * MAGIC_1; 
	col->g=((pixel>>1)&0x3) * MAGIC_2;
	col->r=((pixel>>3)&0x1) * MAGIC_1;

	return 0;	
}

/* Pack the colors into an array
 */
int GGI_lin4_packcolors(ggi_visual *vis,void *outbuf,ggi_color *cols,int len)
{
	uint8 *obuf=(uint8 *)outbuf;
	int i;

	for (i=0;i<len/2;i++) 
		*(obuf++)=(uint8)(ggiMapColor(vis,(cols++)) << 4)
			| (uint8)(ggiMapColor(vis,(cols++)));
	
	if (len & 1) {
		*obuf = ggiMapColor(vis, cols) << 4;
	}
	
	return 0;
}
	
/* Unpack into the ggi_color array the values of the pixels
 */
int GGI_lin4_unpackpixels(ggi_visual *vis,void *outbuf,ggi_color *cols,int len)
{
	uint8 *obuf=(uint8 *)outbuf;
	int i;
	ggi_pixel tmp;
	
	for (i=0;i<len/2;i++) {
		tmp = *obuf >> 4;
		ggiUnmapPixel(vis,tmp,cols++);
		tmp = *(obuf++) & 0x0F;
		ggiUnmapPixel(vis,tmp,cols++);
	}
	
	if (len & 1) {
		tmp = *obuf >> 4;
		ggiUnmapPixel(vis,tmp,cols++);
	}

	return 0;
}	
	
  
