/* $Id: visual.c,v 1.10 1999/01/15 02:53:09 marcus Exp $
******************************************************************************

   Generic color handling library

   Copyright (C) 1998 Andrew Apted  [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>

#include "color.h"

static int _GGIcalctotal(ggi_pixel mask)
{
	int total;

	for (total=0; mask != 0; mask >>= 1, total++) {
	}

	return total;
}

static void do_setup_color_info(ggi_visual *vis)
{
	color_hook *hk = (color_hook *) vis->colorpriv;
	
	if (GT_SCHEME(LIBGGI_GT(vis)) != GT_TRUECOLOR)
		return;

	hk->red_total   = _GGIcalctotal(LIBGGI_PIXFMT(vis)->red_mask);
	hk->green_total = _GGIcalctotal(LIBGGI_PIXFMT(vis)->green_mask);
	hk->blue_total  = _GGIcalctotal(LIBGGI_PIXFMT(vis)->blue_mask);
}

int GGIdlinit(ggi_visual *vis, const char *version,void *argptr)
{
	vis->colorpriv = _ggi_malloc(sizeof(color_hook));

	do_setup_color_info(vis);
	
	/* Color mapping
	 */
	 
	switch (GT_SCHEME(LIBGGI_GT(vis))) {

		case GT_PALETTE:
		case GT_STATIC_PALETTE:
			vis->opcolor->mapcolor=GGI_color_PAL_mapcolor;
			vis->opcolor->unmappixel=GGI_color_PAL_unmappixel;
			break;

		case GT_TRUECOLOR:
			vis->opcolor->mapcolor=GGI_color_TRUE_mapcolor;
			vis->opcolor->unmappixel=GGI_color_TRUE_unmappixel;
			break;

		case GT_GREYSCALE:
			vis->opcolor->mapcolor=GGI_color_GREY_mapcolor;
			vis->opcolor->unmappixel=GGI_color_GREY_unmappixel;
			break;
	}

	if (! (GT_SUBSCHEME(LIBGGI_GT(vis)) & GT_SUB_PACKED_GETPUT))

	switch ((GT_SIZE(LIBGGI_GT(vis)) + 7) / 8) {

		case 1: vis->opcolor->packcolors=GGI_color_L1_packcolors;
			vis->opcolor->unpackpixels=GGI_color_L1_unpackpixels;
			break;

		case 2: vis->opcolor->packcolors=GGI_color_L2_packcolors;
			vis->opcolor->unpackpixels=GGI_color_L2_unpackpixels;
			break;

		case 3: vis->opcolor->packcolors=GGI_color_L3_packcolors;
			vis->opcolor->unpackpixels=GGI_color_L3_unpackpixels;
			break;

		case 4: vis->opcolor->packcolors=GGI_color_L4_packcolors;
			vis->opcolor->unpackpixels=GGI_color_L4_unpackpixels;
			break;
	}

	/* Palette handling
	 */
	vis->opcolor->getpalvec=GGI_color_getpalvec;

	/* Gamma mapping 
	 */
	
	vis->opcolor->getgamma=GGI_color_getgamma;	
	vis->opcolor->setgamma=GGI_color_setgamma;	

	return GGI_DL_OPCOLOR;
}

int GGIdlcleanup(ggi_visual *vis)
{
	free(vis->colorpriv);

	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
