/* 
 * testpattern  flat panel check routine
 *
 * $Id: flatpanel.c,v 1.1 1998/12/13 23:26:36 becka Exp $
 *
 *   Written in 1998 by Hartmut Niemann
 *   With a lot of help from Andreas Beck and his mousedemo.c
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 *
 */

#include <ggi/ggi.h>

#include "monitest.h"

#define COL(x) (x==0?black:(x==1?red:(x==2?green:(x==3?blue:white))))
void flatpanel(ggi_visual_t vis)
{  
	ggi_mode currmode;
	int mousex,mousey;
	int boxsizex,boxsizey;
	int fgcol,bgcol;          /* 0: black, 1: red, 2: green, 3: blue,
				     4: white */
	int sizing,keeprunning;
	int xmax, ymax;
	int x;

	ggiGetMode(vis,&currmode);
        xmax = currmode.visible.x;
        ymax = currmode.visible.y;

	mousex=mousey=0;
	boxsizex=boxsizey=100;
	fgcol=4;
	bgcol=0;
	sizing=0;keeprunning=1;

	ggiSetGCForeground(vis, COL(bgcol));
	ggiFillscreen(vis);
	
	while(keeprunning)
	{
		ggi_event event;
		
		ggiSetGCForeground(vis, COL(fgcol));
		ggiDrawBox(vis,mousex,mousey,boxsizex,boxsizey);
		ggiFlush(vis);
		ggiEventRead(vis,&event,emKey|emPointer);
		ggiSetGCForeground(vis, COL(bgcol));
		ggiDrawBox(vis,mousex,mousey,boxsizex,boxsizey);
		
		switch(event.any.type)
		{
			case evPtrButtonPress:
				switch(event.pbutton.button)
				{
					case GII_PBUTTON_FIRST:
						fgcol++;if (fgcol>4) fgcol=0;
						break;
					case GII_PBUTTON_SECOND:
						sizing=1;
						break;
					case GII_PBUTTON_THIRD:
						x=fgcol;fgcol=bgcol;bgcol=x;
						ggiSetGCForeground(vis, 
								   COL(bgcol));
						ggiFillscreen(vis);
						break;
				}
				break;
			case evPtrButtonRelease:
				switch(event.pbutton.button)
				{
					case GII_PBUTTON_SECOND:
						sizing=0;
						break;
				}
				break;
			case evPtrAbsolute:
				if (sizing) {
					boxsizex=event.pmove.x-mousex;
					boxsizey=event.pmove.y-mousey;
					if (boxsizex<1) boxsizex=1;
					if (boxsizey<1) boxsizey=1;
				} else {
					mousex=event.pmove.x;
					mousey=event.pmove.y;
				}
				break;
			case evPtrRelative:
				if (sizing) {
					boxsizex+=event.pmove.x;
					boxsizey+=event.pmove.y;
					if (boxsizex<1) boxsizex=1;
					if (boxsizey<1) boxsizey=1;
				} else {
					mousex+=event.pmove.x;
					mousey+=event.pmove.y;
				}
				break;
			case evKeyPress:
			case evKeyRepeat:
				switch (event.key.sym){
				case ' ':
					fgcol++;if (fgcol>4) fgcol=0;
					break;
				case '0': fgcol=0; break;
				case '1': 
				case 'r': fgcol=1; break;
				case '2': 
				case 'g': fgcol=2; break;
				case '3': 
				case 'b': fgcol=3; break;
				case '4': 
				case 'w': fgcol=4; break;
				case 'i':
					x=fgcol;fgcol=bgcol;bgcol=x;
					ggiSetGCForeground(vis, 
							   COL(bgcol));
					ggiFillscreen(vis);
					break;
				case GIIK_Up:
					mousey -= (boxsizey >> 1);
					break;
				case GIIK_Down:
					mousey += (boxsizey >> 1);
					break;
				case GIIK_Left:
					mousex -= (boxsizex >> 1);
					break;
				case GIIK_Right:
					mousex += (boxsizex >> 1);
					break;

				/*default:*/
				case 'q':
				case GIIUC_Escape:
					keeprunning=0;
					break;
				}
		}
		if (mousex < 0) mousex=0;
		if (mousey < 0) mousey=0;
		if (mousex > xmax - boxsizex ) mousex = xmax - boxsizex;
		if (mousey > ymax - boxsizey ) mousey = ymax - boxsizey;

	}

}


