/* $Id: fbdev.h,v 1.1 1998/12/18 21:36:24 marcus Exp $
******************************************************************************

   Display-FBDEV

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_DISPLAY_FBDEV_H
#define _GGI_DISPLAY_FBDEV_H

#include <unistd.h>
#include <termios.h>
#include <linux/fb.h>

#include <ggi/internal/ggi-dl.h>

ggifunc_getmode		GGI_fbdev_getmode;
ggifunc_setmode		GGI_fbdev_setmode;
ggifunc_checkmode	GGI_fbdev_checkmode;
ggifunc_resetmode	GGI_fbdev_resetmode;
ggifunc_getapi		GGI_fbdev_getapi;
ggifunc_flush		GGI_fbdev_flush;
ggifunc_setflags	GGI_fbdev_setflags;
		
ggifunc_setpalvec	GGI_fbdev_setpalvec;
ggifunc_setorigin	GGI_fbdev_setorigin;
ggifunc_setdisplayframe	GGI_fbdev_setdisplayframe;


/* Visual-specific private data */

typedef struct fbdev_hook
{	
	/* Framebuffer info */
	int   vtswitchfd;
	void *fb_ptr;
	long  fb_size;
	long  mmap_size;
	long  frame_size;

	char *devicetype;

	struct fb_var_screeninfo var;
	struct fb_fix_screeninfo fix;

	uint16 reds[256];
	uint16 greens[256];
	uint16 blues[256];
	
	/* Original mode on framebuffer */
	struct fb_var_screeninfo orig_var;
	struct fb_fix_screeninfo orig_fix;
	
	uint16 orig_reds[256];
	uint16 orig_greens[256];
	uint16 orig_blues[256];

	/* Miscellaneous */
	int inputs;
	int need_redraw;
	
	/* Kgicon specific */
	ggi_gc *normalgc;
	int have_kgi;

} fbdev_hook;

#define FBDEV_PRIV(vis) ((fbdev_hook *)LIBGGI_PRIVATE(vis))
#define VTSWITCH_VT_FD(vis) (FBDEV_PRIV(vis)->vtswitchfd)

#define FBDEV_INP_KBD    0x01
#define FBDEV_INP_MOUSE  0x02


/* Linux_common routines */

extern int  vtswitch_open(ggi_visual *vis);
extern void vtswitch_close(ggi_visual *vis);


/* Internal routines */

extern void _GGI_fbdev_save_palette(ggi_visual *vis);
extern void _GGI_fbdev_save_panning(ggi_visual *vis);

extern void _GGI_fbdev_restore_palette(ggi_visual *vis);
extern void _GGI_fbdev_restore_panning(ggi_visual *vis);


#endif /* _GGI_DISPLAY_FBDEV_H */
