/* $Id: stubs.c,v 1.1 1998/12/09 04:27:29 marcus Exp $
******************************************************************************

   Function call stubs.

   Copyright (C) 1997 Jason McMullan	[jmcc@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/internal.h>

#undef putc

/************** Mode info ****************/

int ggiSetFlags(ggi_visual *vis,ggi_flags flags)
{  
	return vis->opdisplay->setflags(vis,flags);
}
ggi_flags ggiGetFlags(ggi_visual *vis)
{  
	return LIBGGI_FLAGS(vis);
}

const ggi_pixelformat *ggiGetPixelFormat(ggi_visual *vis)
{
	return LIBGGI_PIXFMT(vis);
}

/*************** Lib management ***********************/

#if 1 /* Is this is the old extension mechanism ? */
ggi_lib_id ggiLoadLibrary(ggi_visual *vis,const char *name,const char *args,void *argptr)
{ return (ggi_lib_id)_ggiAddDL(vis,name,args,argptr,GGI_DLTYPE_EXTENSION); }

ggi_lib_func ggiGetLibraryFunc(ggi_visual *vis,ggi_lib_id id,ggi_uint func)
{ if (((ggi_dlhandle *)id)->privfunc == NULL)
	return NULL;
   else return (ggi_lib_func)((ggi_dlhandle *)id)->privfunc(vis,func); }

int ggiUnloadLibrary(ggi_visual *vis,ggi_lib_id lib)
{ if (lib) {lib->use=0;_ggiRemoveDL(vis,&vis->extlib);} return 0;}

ggi_lib_id ggiFindLibrary(ggi_visual *vis,const char * name)
{
	ggi_dlhandle_l *tmp=vis->extlib;
	while (tmp && strcmp(tmp->handle->name,name)) tmp=tmp->next; 
	if (tmp) return (ggi_lib_id) tmp->handle; else return NULL;	
}
#endif

int        ggiGetAPI(ggi_visual_t vis, int num, char *apiname, char *arguments)
{
	return vis->opdisplay->getapi(vis,num,apiname,arguments);
}

/*************** Display management *******************/

/* Flush _all_ pending accel commands, and ready the visual for software 
 * drawing
 */
int
ggiFlush(ggi_visual *vis)
{
	return vis->opdisplay->flush(vis, 1);
}

/* Internal flush function */
int
_ggiInternFlush(ggi_visual *vis, int tryflag)
{
	return vis->opdisplay->flush(vis, tryflag);
}

/* Directly call a KGI command. DONT DO THAT IN NORMAL PROGRAMS !
 */
int _ggiSendKGICommand(ggi_visual *vis,int cmd,void *arg)
{  return vis->opdisplay->kgicommand(vis,cmd,arg); }

/* Palette, colors, etc...
 */
int ggiSetPalette(ggi_visual *vis,int s,int len,ggi_color *cmap)
{ return vis->opcolor->setpalvec(vis,s,len,cmap); }

int ggiGetPalette(ggi_visual *vis,int s,int len,ggi_color *cmap)
{ return vis->opcolor->getpalvec(vis,s,len,cmap); }

ggi_pixel ggiMapColor(ggi_visual *vis,ggi_color *col)
{ return vis->opcolor->mapcolor(vis,col); }

int ggiUnmapPixel(ggi_visual *vis,ggi_pixel pixel,ggi_color *col)
{ return vis->opcolor->unmappixel(vis,pixel,col); }

int ggiPackColors(ggi_visual *vis,void *buf,ggi_color *cols,int len)
{ return vis->opcolor->packcolors(vis,buf,cols,len); }

int ggiUnpackPixels(ggi_visual *vis,void *buf,ggi_color *cols,int len)
{ return vis->opcolor->unpackpixels(vis,buf,cols,len); }


/* Gamma mapping ...
 */

int  ggiGetGamma(ggi_visual_t vis,ggi_float *r,ggi_float *g,ggi_float *b)
{ return vis->opcolor->getgamma(vis,r,g,b); }

int  ggiSetGamma(ggi_visual_t vis,ggi_float  r,ggi_float  g,ggi_float  b)
{ return vis->opcolor->setgamma(vis,r,g,b); }

int  ggiGetGammaMap(ggi_visual_t vis,int s,int len,ggi_color *gammamap)
{ return vis->opcolor->getgammamap(vis,s,len,gammamap); }

int  ggiSetGammaMap(ggi_visual_t vis,int s,int len,ggi_color *gammamap)
{ return vis->opcolor->setgammamap(vis,s,len,gammamap); }


/* Origin
 */
int ggiSetOrigin(ggi_visual *vis,int x,int y)
{ return vis->opdraw->setorigin(vis,x,y); }

int ggiGetOrigin(ggi_visual *vis,int *x, int *y)
{ *x = vis->origin_x; *y = vis->origin_y; return 0; }


/* Generic drawing routines 
 */
int ggiPutc(ggi_visual *vis,int x,int y,char c)
{ return vis->opdraw->putc(vis,x,y,c); }

int ggiPuts(ggi_visual *vis,int x,int y,const char *str)
{ return vis->opdraw->puts(vis,x,y,str); }

int ggiGetCharSize(ggi_visual *vis, int *width, int *height)
{ return vis->opdraw->getcharsize(vis, width, height); }


int ggiFillscreen(ggi_visual *vis)
{ return vis->opdraw->fillscreen(vis); }


int _ggiDrawPixelNC(ggi_visual *vis,int x,int y)
{ return vis->opdraw->drawpixel_nc(vis,x,y); }

int ggiDrawPixel(ggi_visual *vis,int x,int y)
{ return vis->opdraw->drawpixel(vis,x,y); }

int _ggiPutPixelNC(ggi_visual *vis,int x,int y,ggi_pixel col)
{ return vis->opdraw->putpixel_nc(vis,x,y,col); }

int ggiPutPixel(ggi_visual *vis,int x,int y,ggi_pixel col)
{ return vis->opdraw->putpixel(vis,x,y,col); }

int ggiGetPixel(ggi_visual *vis,int x,int y,ggi_pixel *col)
{ return vis->opdraw->getpixel(vis,x,y,col); }



int ggiDrawLine(ggi_visual *vis,int x,int y,int xe,int ye)
{ return vis->opdraw->drawline(vis,x,y,xe,ye); }

int _ggiDrawHLineNC(ggi_visual *vis,int x,int y,int w)
{ return vis->opdraw->drawhline_nc(vis,x,y,w); }

int ggiDrawHLine(ggi_visual *vis,int x,int y,int w)
{ return vis->opdraw->drawhline(vis,x,y,w); }

int ggiPutHLine(ggi_visual *vis,int x,int y,int w,void *buf)
{ return vis->opdraw->puthline(vis,x,y,w,buf); }

int ggiGetHLine(ggi_visual *vis,int x,int y,int w,void *buf)
{ return vis->opdraw->gethline(vis,x,y,w,buf); }


int _ggiDrawVLineNC(ggi_visual *vis,int x,int y,int h)
{ return vis->opdraw->drawvline_nc(vis,x,y,h); }

int ggiDrawVLine(ggi_visual *vis,int x,int y,int h)
{ return vis->opdraw->drawvline(vis,x,y,h); }

int ggiPutVLine(ggi_visual *vis,int x,int y,int h,void *buf)
{ return vis->opdraw->putvline(vis,x,y,h,buf); }

int ggiGetVLine(ggi_visual *vis,int x,int y,int h,void *buf)
{ return vis->opdraw->getvline(vis,x,y,h,buf); }


int ggiDrawBox(ggi_visual *vis,int x,int y,int w,int h)
{ return vis->opdraw->drawbox(vis,x,y,w,h); }

int ggiPutBox(ggi_visual *vis,int x,int y,int w,int h,void *buf)
{ return vis->opdraw->putbox(vis,x,y,w,h,buf); }

int ggiGetBox(ggi_visual *vis,int x,int y,int w,int h,void *buf)
{ return vis->opdraw->getbox(vis,x,y,w,h,buf); }


int ggiCopyBox(ggi_visual *vis,int x,int y,int w,int h,int nx,int ny)
{ return vis->opdraw->copybox(vis,x,y,w,h,nx,ny); }

int ggiCrossBlit(ggi_visual *src,int sx,int sy,int w,int h,
		 ggi_visual *dst,int dx,int dy)
{ if (src==dst)
     return dst->opdraw->copybox(dst,sx,sy,w,h,dx,dy);
  /* Note: We use dst to map the request to, as it will normally be
     the "smarter" device. */
  return dst->opdraw->crossblit(src,sx,sy,w,h,dst,dx,dy); }


/* Frames
 */

int ggiSetDisplayFrame(ggi_visual_t vis, int frameno)
{ return vis->opdraw->setdisplayframe(vis, frameno); }

int ggiSetReadFrame(ggi_visual_t vis, int frameno)
{ return vis->opdraw->setreadframe(vis, frameno); }

int ggiSetWriteFrame(ggi_visual_t vis, int frameno)
{ return vis->opdraw->setwriteframe(vis, frameno); }

int ggiGetDisplayFrame(ggi_visual_t vis)
{ return vis->d_frame_num; }

int ggiGetReadFrame(ggi_visual_t vis)
{ return vis->r_frame_num; }

int ggiGetWriteFrame(ggi_visual_t vis)
{ return vis->w_frame_num; }

