/* $Id: color.c,v 1.5 1998/12/18 21:36:24 marcus Exp $
******************************************************************************

   Display-VCSA: color mapping

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#include <ggi/display/vcsa.h>

static ggi_color ansi_16_colors[16] =
{
	{ 0x0000, 0x0000, 0x0000 },
	{ 0x0000, 0x0000, 0xaaaa },
	{ 0x0000, 0xaaaa, 0x0000 },
	{ 0x0000, 0xaaaa, 0xaaaa },
	{ 0xaaaa, 0x0000, 0x0000 },
	{ 0xaaaa, 0x0000, 0xaaaa },
	{ 0xaaaa, 0xaaaa, 0x0000 },
	{ 0xaaaa, 0xaaaa, 0xaaaa },

	{ 0x5555, 0x5555, 0x5555 },
	{ 0x5555, 0x5555, 0xffff },
	{ 0x5555, 0xffff, 0x5555 },
	{ 0x5555, 0xffff, 0xffff },
	{ 0xffff, 0x5555, 0x5555 },
	{ 0xffff, 0x5555, 0xffff },
	{ 0xffff, 0xffff, 0x5555 },
	{ 0xffff, 0xffff, 0xffff }
};

#define NUM_COLS  45

static ggi_color vcsa_colors[NUM_COLS] =
{
	{ 0x0000, 0x0000, 0x0000 }, { 0x0000, 0x0000, 0x2aaa },
	{ 0x0000, 0x0000, 0x5555 }, { 0x0000, 0x0000, 0x7fff },
	{ 0x0000, 0x0000, 0xaaaa }, { 0x0000, 0x0000, 0xbfff },
	{ 0x0000, 0x0000, 0xffff }, { 0x0000, 0x2aaa, 0x0000 },
	{ 0x0000, 0x2aaa, 0x2aaa }, { 0x0000, 0x5555, 0x0000 },
	{ 0x0000, 0x5555, 0x5555 }, { 0x0000, 0x7fff, 0x0000 },
	{ 0x0000, 0x7fff, 0x7fff }, { 0x0000, 0xaaaa, 0x0000 },
	{ 0x0000, 0xaaaa, 0xaaaa }, { 0x0000, 0xbfff, 0x0000 },
	{ 0x0000, 0xbfff, 0xbfff }, { 0x0000, 0xffff, 0x0000 },
	{ 0x0000, 0xffff, 0xffff }, { 0x1555, 0x1555, 0x1555 },
	{ 0x2aaa, 0x0000, 0x0000 }, { 0x2aaa, 0x0000, 0x2aaa },
	{ 0x2aaa, 0x2aaa, 0x0000 }, { 0x2aaa, 0x2aaa, 0x2aaa },
	{ 0x3fff, 0x3fff, 0x3fff }, { 0x5555, 0x0000, 0x0000 },
	{ 0x5555, 0x0000, 0x5555 }, { 0x5555, 0x5555, 0x0000 },
	{ 0x5555, 0x5555, 0x5555 }, { 0x7fff, 0x0000, 0x0000 },
	{ 0x7fff, 0x0000, 0x7fff }, { 0x7fff, 0x7fff, 0x0000 },
	{ 0x7fff, 0x7fff, 0x7fff }, { 0xaaaa, 0x0000, 0x0000 },
	{ 0xaaaa, 0x0000, 0xaaaa }, { 0xaaaa, 0xaaaa, 0x0000 },
	{ 0xaaaa, 0xaaaa, 0xaaaa }, { 0xbfff, 0x0000, 0x0000 },
	{ 0xbfff, 0x0000, 0xbfff }, { 0xbfff, 0xbfff, 0x0000 },
	{ 0xbfff, 0xbfff, 0xbfff }, { 0xffff, 0x0000, 0x0000 },
	{ 0xffff, 0x0000, 0xffff }, { 0xffff, 0xffff, 0x0000 },
	{ 0xffff, 0xffff, 0xffff }
};

static ggi_pixel vcsa_normal_pixels[NUM_COLS] =
{
	0x0020, 0x01b0, 0x01b1, 0x01b2, 0x01db,
	0x09b2, 0x09db, 0x02b0, 0x03b0, 0x02b1,
	0x03b1, 0x02b2, 0x03b2, 0x02db, 0x03db,
	0x0ab2, 0x0bb2, 0x0adb, 0x0bdb, 0x08b0,
	0x04b0, 0x05b0, 0x06b0, 0x08b1, 0x08b2,
	0x04b1, 0x05b1, 0x06b1, 0x08db, 0x04b2,
	0x05b2, 0x06b2, 0x07b2, 0x04db, 0x05db,
	0x06db, 0x07db, 0x0cb2, 0x0db2, 0x0eb2,
	0x0fb2, 0x0cdb, 0x0ddb, 0x0edb, 0x0fdb
};

static ggi_pixel vcsa_ascii_pixels[NUM_COLS] =
{
	0x0020, 0x012e, 0x013a, 0x0125, 0x014d,
	0x0925, 0x094d, 0x022e, 0x032e, 0x023a,
	0x033a, 0x0225, 0x0325, 0x024d, 0x034d,
	0x0a25, 0x0b25, 0x0a4d, 0x0b4d, 0x082e,
	0x042e, 0x052e, 0x062e, 0x083a, 0x0825,
	0x043a, 0x053a, 0x063a, 0x084d, 0x0425,
	0x0525, 0x0625, 0x0725, 0x044d, 0x054d,
	0x064d, 0x074d, 0x0c25, 0x0d25, 0x0e25,
	0x0f25, 0x0c4d, 0x0d4d, 0x0e4d, 0x0f4d
};

ggi_pixel GGI_vcsa_mapcolor(ggi_visual *vis, ggi_color *col)
{
	VcsaHook *vv = VCSA_HOOK(vis);

	int index = _ggi_match_palette(vcsa_colors, NUM_COLS, col);

	if (vv->flags & VCSA_FLAG_ASCII) {
		return vcsa_ascii_pixels[index];
	}

	return vcsa_normal_pixels[index];
}

int GGI_vcsa_unmappixel(ggi_visual *vis, ggi_pixel pixel, ggi_color *col)
{
	*col = ansi_16_colors[(pixel & 0x0f00) >> 8];

	return 0;
}
