/* $Id: visual.c,v 1.19 1998/12/20 01:00:12 becka Exp $
******************************************************************************

   Terminfo target

   Copyright (C) 1998 MenTaLguY         [mentalg@geocities.com]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "TIvisual.h"

void _GGI_terminfo_freedbs(ggi_visual *vis) {
	int i;

	for (i=LIBGGI_APPLIST(vis)->num-1; i >= 0; i--) {
		free(LIBGGI_APPBUFS(vis)[i]->write);
		_ggi_db_free(LIBGGI_APPBUFS(vis)[i]);
		_ggi_db_del_buffer(LIBGGI_APPLIST(vis), i);
	}
}

int GGIdlinit(ggi_visual *vis, const char *args, void *argptr)
{
	struct TIhooks *tiinfo;
	int i;

	char *term_type;
	char *term_path;
	char *finger;

	term_type = NULL;
	if ( args == NULL ) {
		term_path = alloca(1);
		*term_path = '\000';
	} else {
		term_path = alloca(strlen(args) + 1);
	}

	for ( finger = term_path ; *finger != '\000' ; finger++ ) {
		if ( *finger == ':' ) {
			*finger = '\000';
			term_type = finger + 1;
			break;
		}
	}

	DPRINT("display-terminfo: initializing %s on %s.\n", term_type, ( ( *term_path == '\000' ) ? "stdin/stdout" : term_path ));

	tiinfo = (struct TIhooks *)_ggi_malloc(sizeof(struct TIhooks));

	tiinfo->splitline = 0;

	tiinfo->virgin = 1;

	if ( *term_path == '\000' ) {
		tiinfo->f_in = fdopen(fileno(stdin), "r");
		tiinfo->f_out = fdopen(fileno(stdout), "w");
	} else {
		tiinfo->f_in = tiinfo->f_out = fopen(term_path, "rw");
	}

	_terminfo_init_ncurses();

	tiinfo->scr = _terminfo_new_screen(term_type, tiinfo->f_out, tiinfo->f_in);
	if ( tiinfo->scr == NULL ) {
		fprintf(stderr, "display-terminfo: error creating ncurses"
				" SCREEN\n");
		fclose(tiinfo->f_in);
		fclose(tiinfo->f_out);
		free(tiinfo);
		return GGI_DL_ERROR;
	}

	LIBGGI_FD(vis) = fileno(tiinfo->f_out);

	if ( has_colors() ) {
		static const int vga_color[8] = {
			COLOR_BLACK,
			COLOR_BLUE,
			COLOR_GREEN,
			COLOR_CYAN,
			COLOR_RED,
			COLOR_MAGENTA,
			COLOR_YELLOW,
			COLOR_WHITE
		};
		int j;
		DPRINT("display-terminfo: terminal supports %d colors\n", COLORS);
		DPRINT("display-terminfo: initializing %d - 1 color pairs\n", COLOR_PAIRS);
		for ( i = 1 ; i < COLOR_PAIRS ; i++ ) {
			if ( init_pair(i, COLORS - ( i % COLORS ) - 1, i / COLORS) == ERR ) {
				DPRINT("display-terminfo: error initializing color pair %d to %d,%d\n", i, COLORS - ( i % COLORS ) - 1, i / COLORS);
				fprintf(stderr, "display-terminfo: error initializing colors\n");
				break;
			}
		}
		for ( i = 0 ; i < 16 ; i++ ) {
			for ( j = 0 ; j < 16 ; j++ ) {
				tiinfo->color16_table[i+(j<<4)] =
					COLOR_PAIR(((COLORS-vga_color[i&0x07]%COLORS-1)
					 +(vga_color[j&0x07]%COLORS*COLORS))%COLOR_PAIRS)
					| ( ( i > 7 ) ? A_BOLD : A_NORMAL )
					| ( ( j > 7 ) ? A_BLINK : A_NORMAL );
			}
		}

	} else {
		DPRINT("display-terminfo: terminal lacks color support\n");
	}
	for ( i = 0 ; i < 256 ; i++ ) tiinfo->charmap[i] = i;
	/* FIXME mapping needs to be more complete; i.e. 'fake'
	   double-line versions of ACS_??CORNER and friends with the
	   single-line version we know through terminfo */
	tiinfo->charmap[219] = ACS_BLOCK;
	tiinfo->charmap[218] = ACS_ULCORNER;
	tiinfo->charmap[192] = ACS_LLCORNER;
	tiinfo->charmap[191] = ACS_URCORNER;
	tiinfo->charmap[217] = ACS_LRCORNER;
	tiinfo->charmap[180] = ACS_RTEE;
	tiinfo->charmap[195] = ACS_LTEE;
	tiinfo->charmap[193] = ACS_BTEE;
	tiinfo->charmap[194] = ACS_TTEE;
	tiinfo->charmap[196] = ACS_HLINE;
	tiinfo->charmap[179] = ACS_VLINE;
	tiinfo->charmap[197] = ACS_PLUS;
	tiinfo->charmap[177] = ACS_CKBOARD;
	tiinfo->charmap[248] = ACS_DEGREE;
	tiinfo->charmap[241] = ACS_PLMINUS;
	tiinfo->charmap[254] = tiinfo->charmap[249] = tiinfo->charmap[250] = ACS_BULLET;
	/* we need arrows, diamond and such ... they're all below
	   ascii 26 in IBM-ASCII, though, so looking them up on the
	   console doesn't work too well. Someone who has time, please
	   find them out and add them */
	tiinfo->charmap[243] = ACS_LEQUAL;
	tiinfo->charmap[242] = ACS_GEQUAL;
	tiinfo->charmap[227] = ACS_PI;
	tiinfo->charmap[155] = ACS_NEQUAL; /* is this right? */
	tiinfo->charmap[156] = ACS_STERLING;
#if ( NCURSES_MOUSE_VERSION == 1 ) 
	DPRINT("display-terminfo: mouse support is enabled\n");
	mousemask(REPORT_MOUSE_POSITION | BUTTON1_PRESSED | BUTTON1_RELEASED |
			BUTTON2_PRESSED | BUTTON2_RELEASED | BUTTON3_PRESSED |
			BUTTON3_RELEASED | BUTTON4_PRESSED | BUTTON4_RELEASED,
			NULL);
#else
	DPRINT("display-terminfo: mouse support is disabled\n");
#endif
	LIBGGI_PRIVATE(vis) = tiinfo;
	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	/* mode management */
	vis->opdisplay->flush     = GGI_terminfo_flush;
	vis->opdisplay->getmode   = GGI_terminfo_getmode;
	vis->opdisplay->setmode   = GGI_terminfo_setmode;
	vis->opdisplay->checkmode = GGI_terminfo_checkmode;
	vis->opdisplay->getapi    = GGI_terminfo_getapi;
	vis->opdisplay->setflags  = GGI_terminfo_setflags;

	/* event management */
	{
		gii_input *inp;
		inp = _giiInputAlloc();

		if ( inp == NULL ) {
			fprintf(stderr, "display-terminfo: error allocating gii_input\n");
			_terminfo_destroy_screen();
			return GGI_DL_ERROR;
		}

#if ( NCURSES_MOUSE_VERSION == 1 )
		inp->targetcan =emKey | emPtrButton | emPtrAbsolute,
#else
		inp->targetcan =emKey, /* without mouse support */
#endif
		inp->GIIseteventmask(inp,inp->targetcan);

		inp->GIIeventpoll = GII_terminfo_eventpoll;
		inp->GIIsendevent = GII_terminfo_sendevent;

		tiinfo->vis = vis;
		inp->priv = (void *)tiinfo;

		inp->maxfd=0;   /* This is polled. */
		inp->flags|=GII_FLAGS_HASPOLLED;

		vis->input = giiJoinInputs(vis->input, inp);
	}

	_terminfo_release_screen();
 
	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis) {
	struct TIhooks *tiinfo;

	tiinfo = LIBGGI_PRIVATE(vis);
	if ( tiinfo != NULL ) {
		if ( tiinfo->scr != NULL ) {
			_terminfo_select_screen(tiinfo->scr);
			if ( !tiinfo->virgin ) {
				wclear(stdscr);
				refresh();
			}
			_terminfo_destroy_screen();
		}
		if ( tiinfo->f_in != NULL ) {
			fclose(tiinfo->f_in);
		}
		if ( ( tiinfo->f_out != NULL ) && ( tiinfo->f_out != tiinfo->f_in ) ) {
			fclose(tiinfo->f_out);
		}

		_GGI_terminfo_freedbs(vis);

		free(tiinfo);
	}	

	free(LIBGGI_GC(vis));

	_terminfo_finalize_ncurses();

	return 0;
}

#include <ggi/internal/ggidlinit.h>
