/* $Id: gtext.c,v 1.3 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   LibGGI GLIDE target - Text functions

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/display/glide.h>

#include <ggi/internal/font/8x8>

#define BUFSIZE		8*8*sizeof(ggi_pixel)

static uint8 buf[BUFSIZE];

#define BITMASK		0x01

int
GGI_glide16_putc(ggi_visual *vis, int x, int y, char ch)
{
	int xc, yc;
	int h = 8;
	int w = 8;
	uint16 *data = (uint16 *) (buf + BUFSIZE);
	uint8 *fontptr = font+((uint8)ch<<3)+8;
	
	if (y< LIBGGI_GC(vis)->cliptl.y) {
		int diff=LIBGGI_GC(vis)->cliptl.y-y;
		y+=diff;
		h-=diff;
	}
	if (y+h>LIBGGI_GC(vis)->clipbr.y) {
		h=LIBGGI_GC(vis)->clipbr.y-y;
	}
	if (h<1) return 0;

	if (x< LIBGGI_GC(vis)->cliptl.x) {
		int diff=LIBGGI_GC(vis)->cliptl.x-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>LIBGGI_GC(vis)->clipbr.x) {
		w=LIBGGI_GC(vis)->clipbr.x-x;
	}
	if (w<1) return 0;

	for (yc = h; yc != 0; yc--) {
		uint8 fontrow = *(--fontptr);
		data -= w-8;
		for (xc = w; xc != 0; xc--) {
			*(--data) = (fontrow & BITMASK) ? LIBGGI_GC_FGCOLOR(vis)
				: LIBGGI_GC_BGCOLOR(vis);
			fontrow >>= 1;
		}
	}

	grLfbWriteRegion(GLIDE_PRIV(vis)->writebuf, x, y,
			 GLIDE_PRIV(vis)->src_format, w, h, 16, data);
	
	return 0;
}


int
GGI_glide32_putc(ggi_visual *vis, int x, int y, char ch)
{
	int xc, yc;
	int h = 8;
	int w = 8;
	uint32 *data = (uint32 *) (buf + BUFSIZE);
	uint8 *fontptr = font+((uint8)ch<<3)+8;
	
	if (y< LIBGGI_GC(vis)->cliptl.y) {
		int diff=LIBGGI_GC(vis)->cliptl.y-y;
		y+=diff;
		h-=diff;
	}
	if (y+h>LIBGGI_GC(vis)->clipbr.y) {
		h=LIBGGI_GC(vis)->clipbr.y-y;
	}
	if (h<1) return 0;

	if (x< LIBGGI_GC(vis)->cliptl.x) {
		int diff=LIBGGI_GC(vis)->cliptl.x-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>LIBGGI_GC(vis)->clipbr.x) {
		w=LIBGGI_GC(vis)->clipbr.x-x;
	}
	if (w<1) return 0;

	for (yc = h; yc != 0; yc--) {
		uint8 fontrow = *(--fontptr);
		data -= w-8;
		for (xc = w; xc != 0; xc--) {
			*(--data) = (fontrow & BITMASK) ? LIBGGI_GC_FGCOLOR(vis)
				: LIBGGI_GC_BGCOLOR(vis);
			fontrow >>= 1;
		}
	}

	grLfbWriteRegion(GLIDE_PRIV(vis)->writebuf, x, y,
			 GLIDE_PRIV(vis)->src_format, w, h, 32, data);
	
	return 0;
}
