/* $Id: visual.c,v 1.8 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   Display-file: initialization

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/file.h>


#if 0  /* This may come in handy later on */
static ggi_option file_options[1] =
{
};
#endif

int GGIdlinit(ggi_visual *vis, const char *args,void *argptr)
{
	FileHook *ff;
	
	LIBGGI_FD(vis) = -1;


	/* initialize */

	if (!args || !args[0]) {
		fprintf(stderr, "display-file: Missing filename.\n");
		return GGI_DL_ERROR;
	}

	DPRINT("display-file: coming up (filename='%s').\n", args);
	
	LIBGGI_PRIVATE(vis) = ff = _ggi_malloc(sizeof(FileHook));
	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	ff->flags = 0;
	ff->writer = (file_writer_func *) NULL;
	ff->fb_ptr = ff->file_mmap = NULL;


	/* handle arguments */
#if 0
	if (getenv("GGI_FILE_OPTIONS") != NULL) {
		if (_GGIparseoptions(getenv("GGI_FILE_OPTIONS"),
			file_options, 2) == NULL) {
			
			fprintf(stderr, "display-file: error in "
				"$GGI_FILE_OPTIONS.\n");
			free(ff);
			return GGI_DL_ERROR;
		}
	}
	
	args = _GGIparseoptions((char *) args, file_options, 2);
			
	if (args == NULL) {
		fprintf(stderr, "display-file: error in "
			"arguments.\n");
		free(ff);
		return GGI_DL_ERROR;
	}
#endif


	ff->filename = strdup(args);
	
	if (_ggi_file_ppm_detect(ff->filename)) {
		ff->writer = &_ggi_file_ppm_write;
	} else {
		ff->flags |= FILEFLAG_RAW;
	}


	vis->opdisplay->getmode=GGI_file_getmode;
	vis->opdisplay->setmode=GGI_file_setmode;
	vis->opdisplay->getapi=GGI_file_getapi;
	vis->opdisplay->checkmode=GGI_file_checkmode;
	vis->opdisplay->setflags=GGI_file_setflags;
	
	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	FileHook *ff = FILE_PRIV(vis);

	DPRINT("display-file: going down.\n");
	
	if (ff->fb_ptr != NULL) {
		GGI_file_resetmode(vis);
	}

	free(ff->filename);

	free(FILE_PRIV(vis));
	free(LIBGGI_GC(vis));

	LIBGGI_PRIVATE(vis) = LIBGGI_GC(vis) = NULL;

	return 0;
}

#include <ggi/internal/ggidlinit.h>
