/* $Id: visual.c,v 1.30 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   AAlib target for GGI.

   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/aa.h>


void _GGI_aa_freedbs(ggi_visual *vis) {
	int i;

	for (i=LIBGGI_APPLIST(vis)->num-1; i >= 0; i--) {
		_ggi_db_free(LIBGGI_APPBUFS(vis)[i]);
		_ggi_db_del_buffer(LIBGGI_APPLIST(vis), i);
	}
}

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	struct AAhooks *aainfo;

	DPRINT("AA-lib starting.\n");
	
	aainfo = _ggi_malloc(sizeof(struct AAhooks));

	if ((aainfo->aalock = ggLockCreate()) == NULL) {
		free(aainfo);
		return GGI_DL_ERROR;
	}

	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	aainfo->opmansync=_ggi_malloc(sizeof(_ggi_opmansync));

	aainfo->context=0;
	aainfo->lx=0;
	aainfo->ly=0;
	aainfo->lb=0;
	aainfo->lastkey=0;
	aainfo->lastkeyticks=0;
	
	/* Get options from environment variable AAOPTS */
	if(!aa_parseoptions(NULL, NULL, NULL, NULL))
		fprintf(stderr, "display-aa: warning: parsing AAOPTS failed\n");


	if(!_ggiAddDL(vis, "helper-mansync", NULL, aainfo->opmansync, 0)) {
		fprintf(stderr, 
			"display-aa: Cannot load required helper-mansync!\n");
		return GGI_DL_ERROR;
	}

	LIBGGI_PRIVATE(vis) = aainfo;

	MANSYNC_init(vis);

	/* Has mode management */
	vis->opdisplay->flush=GGI_aa_flush;
	vis->opdisplay->getmode=GGI_aa_getmode;
	vis->opdisplay->setmode=GGI_aa_setmode;
	vis->opdisplay->checkmode=GGI_aa_checkmode;
	vis->opdisplay->getapi =GGI_aa_getapi;
	vis->opdisplay->setflags=GGI_aa_setflags;

	{
		gii_input *inp;
		DPRINT_MISC("gii starting\n");

		/* First allocate a new gii_input descriptor. */

		if (NULL==(inp=_giiInputAlloc()))
		{
			DPRINT_MISC("giiInputAlloc failure.\n");
			return GGI_DL_ERROR;
		}
		DPRINT_MISC("gii inp=%p\n",inp);

		/* Now fill in the blanks. */

		inp->priv=aainfo;	/* We need that in GII_aa_poll() */

		/* What events _can_  we create at all ?
		   Save useless polling time. */

		inp->targetcan= emKeyPress | emKeyRelease | emKeyRepeat |
				emPtrButtonPress | emPtrButtonRelease |
				emPtrAbsolute ;

		/* What events _do_ we generate by default ? */
		inp->GIIseteventmask(inp,inp->targetcan);

		/* We only need the "poll" function. For all others,
		   defaults are fine. */
		inp->GIIeventpoll=GII_aa_poll;

		/* Now join the new event source in. */
		vis->input=giiJoinInputs(vis->input,inp);
	}

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	struct AAhooks *aainfo;

	MANSYNC_deinit(vis);

	_GGI_aa_freedbs(vis);

	/* FIXME !!! */
	if ((aainfo=LIBGGI_PRIVATE(vis)) != NULL)
	{
		if (aainfo->context)
		{
			aa_uninitmouse(aainfo->context);
			aa_uninitkbd(aainfo->context);
			aa_close(aainfo->context);
		}
		free(aainfo->opmansync);		

		ggLockDestroy(aainfo->aalock);

		free(LIBGGI_PRIVATE(vis));
	}
	
	if(vis->palette)
		free(vis->palette);
	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
