/* $Id: box.c,v 1.9 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   Display-Xlib: copying boxes

   Copyright (C) 1998 Marcus Sundberg    [marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/xlib.h>

int GGI_Xlib_drawbox(ggi_visual *vis, int x, int y, int w, int h)
{
	XFillRectangle(XLIB_PRIV(vis)->display,
				   XLIB_PRIV(vis)->window,
				   XLIB_PRIV(vis)->gc,
				   x, y, w, h);

	XLIB_DOSYNC(vis);
	return 0;
}

int GGI_Xlib_putbox(ggi_visual *vis, int x, int y, int w, int h, void *data)
{
	XImage *ximg;
	
	ximg=XCreateImage(XLIB_PRIV(vis)->display, 
					  DefaultVisual(XLIB_PRIV(vis)->display, 0),
					  LIBGGI_PIXFMT(vis)->size, ZPixmap, 0,
					  data, w, h, 8, 0);
	XPutImage(XLIB_PRIV(vis)->display, 
			  XLIB_PRIV(vis)->window,
			  XLIB_PRIV(vis)->gc,
			  ximg, 0, 0, x, y, w, h);
	XFree(ximg);

	XLIB_DOSYNC(vis);
	return 0;
}

int GGI_Xlib_copybox(ggi_visual *vis, int x, int y, 
			   int w, int h, int nx, int ny)
{
	XCopyArea(XLIB_PRIV(vis)->display, 
			  XLIB_PRIV(vis)->window,
			  XLIB_PRIV(vis)->window,
			  XLIB_PRIV(vis)->gc,
			  x, y, w, h, nx, ny);

	XLIB_DOSYNC(vis);
	return 0;
}

int GGI_Xlib_getbox(ggi_visual *vis, int x, int y, int w, int h, void *data)
{
	XImage *ximg;

	ximg = XGetImage(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->window, x, y,
			  w, h, AllPlanes, ZPixmap);
	memcpy(data, ximg->data, w*h*LIBGGI_PIXFMT(vis)->size/8);
	XFree(ximg);

	XLIB_DOSYNC(vis);
	return 0;
}
