/* $Id: color.inc,v 1.19 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   Color functions for the various X targets.

   Copyright (C) 1997 Andreas Beck      [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include <string.h>


/* Minimum number of colors needed before we use the `smart allocation'
 * method for choosing where to put colors with GGI_PALETTE_DONTCARE.
 */
#define COLOR_THRESHOLD(num,max)  ((num)*4 >= (max)*3)


#if 0  /* not yet implemented */
static int _ggi_smart_allocate(ggi_visual *vis, int len, ggi_color *cols)
{
	struct Xhooks *xhook=LIBGGI_PRIVATE(vis);
	
	/* ... */
}
#endif

int GGI_X_setpalvec(ggi_visual *vis, int start, int len, ggi_color *colormap)
{
	struct Xhooks *xhook=LIBGGI_PRIVATE(vis);
	
	DPRINT_COLOR("X setpalette.\n");

	if (colormap==NULL)
		return -1;

	if (start == GGI_PALETTE_DONTCARE) {

		if (len > xhook->nocols) {
			return -1;
		}

#if 0  /* not yet implemented */
		if (COLOR_THRESHOLD(len, xhook->nocols)) {
			return _ggi_smart_allocate(vis, len, colormap);
		}
#endif

		start = xhook->nocols - len;
	}
		
	if (start+len > xhook->nocols || start < 0)
		return -1;

	memcpy(vis->palette+start, colormap, len*sizeof(ggi_color));

	if ( start     < xhook->cmap_first ) xhook->cmap_first = start;
	if ( start+len > xhook->cmap_last  ) xhook->cmap_last  = start+len;

	return 0;
}
