/* $Id: visual.c,v 1.41 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   Display-X: initialization

   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/x.h>

void _GGI_X_freedbs(ggi_visual *vis, struct Xhooks *xhook) {
	int i;
	int first = LIBGGI_APPLIST(vis)->first_targetbuf;
	int last = LIBGGI_APPLIST(vis)->last_targetbuf;

	if (first < 0) {
		return;
	}
	for (i = (last - first); i >= 0; i--) {

		if (xhook->ximage_list[i])
			XDestroyImage(xhook->ximage_list[i]);
		xhook->ximage_list[i] = NULL;

#ifdef HAVE_SHM
		if (xhook->shminfo[i].shmid!=-1) {	
			XShmDetach(xhook->display, &(xhook->shminfo[i]));
			DPRINT_MISC("_GGI_X_freedbs: XShmDetach(%p, %d)\n",
			       xhook->display, xhook->shminfo[i]);
			if (LIBGGI_APPLIST(vis)->bufs[i]->write!=NULL)
				shmdt(LIBGGI_APPLIST(vis)->bufs[i]->write);
		}
#endif
		_ggi_db_free(LIBGGI_APPLIST(vis)->bufs[i+first]);
		_ggi_db_del_buffer(LIBGGI_APPLIST(vis), i+first);
	}
	LIBGGI_APPLIST(vis)->first_targetbuf = -1;
	xhook->ximage = NULL;
}

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	struct Xhooks *xinfo;
	int i;

	DPRINT_MISC("X-target starting.\n");

	xinfo = _ggi_malloc(sizeof(struct Xhooks));

	if ((xinfo->XLibLock = ggLockCreate()) == NULL) {
		free(xinfo);
		return GGI_DL_ERROR;
	}

	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	xinfo->opmansync = _ggi_malloc(sizeof(_ggi_opmansync));
	
	xinfo->display=NULL;
	xinfo->ximage =NULL;
	xinfo->cmap=0;
	xinfo->cmap_first=256;
	xinfo->cmap_last=0;
	xinfo->window=0;
	xinfo->gc=0;
	for(i = 0; i<8; i++) {
		xinfo->ximage_list[i]=NULL;
#ifdef HAVE_SHM
		xinfo->shminfo[i].shmid=-1;
	}
	xinfo->have_shm=0;
#else	
	}
#endif

	xinfo->viswidth=0;
	xinfo->visheight=0;

	DPRINT_MISC("X-target wants display %s\n",args);
	xinfo->display = XOpenDisplay(args);
	if (xinfo->display == NULL)
		return GGI_DL_ERROR;

	DPRINT_MISC("X-target has display %s\n",args);

#ifdef HAVE_SHM
	if (XShmQueryExtension(xinfo->display)) {
		
		DPRINT_MISC("X-target: Enabling use of XSHM extension\n");
		xinfo->have_shm=1;
	}
#endif
            
	xinfo->screen = DefaultScreen (xinfo->display);
	DPRINT_MISC("X-target has screen %d\n", xinfo->screen);

	if(!_ggiAddDL(vis, "helper-mansync", NULL, xinfo->opmansync, 0)) {
		fprintf(stderr,
			"display-X: Cannot load required helper-mansync!\n");
		return GGI_DL_ERROR;
	}

	LIBGGI_PRIVATE(vis) = xinfo;

	MANSYNC_init(vis);
	
	/* Has mode management */
	vis->opdisplay->flush=GGI_X_flush;
	vis->opdisplay->getmode=GGI_X_getmode;
	vis->opdisplay->setmode=GGI_X_setmode;
	vis->opdisplay->checkmode=GGI_X_checkmode;
	vis->opdisplay->getapi =GGI_X_getapi;
	vis->opdisplay->setflags=GGI_X_setflags;

	{
		gii_inputxwin_arg args;
		gii_input *inp;
		
		args.disp = xinfo->display;
		args.ptralwaysrel = 0;
		args.wait = 1;
		
		if ((inp = giiOpen("xwin", &args, NULL)) == NULL) {
			DPRINT_MISC("Unable to open xwin inputlib\n");
			GGIdlcleanup(vis);
			return GGI_DL_ERROR;
		}

		xinfo->inp = inp;
		/* Now join the new event source in. */
		vis->input = giiJoinInputs(vis->input, inp);
        }

	DPRINT_MISC("X-target fully up\n");

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	struct Xhooks *xinfo;

	MANSYNC_deinit(vis);

	if ((xinfo=LIBGGI_PRIVATE(vis)) != NULL) {
		if (xinfo->cmap)
			XFreeColormap(xinfo->display,xinfo->cmap);
		_GGI_X_freedbs(vis, xinfo);
		if (xinfo->gc)
			XFreeGC(xinfo->display,xinfo->gc);
		if (xinfo->window)
			XDestroyWindow(xinfo->display,xinfo->window);
		XSync(xinfo->display,0);
		if (xinfo->display) {
			XCloseDisplay(xinfo->display);
		}
		free(xinfo->opmansync);
	
		ggLockDestroy(xinfo->XLibLock);

		free(xinfo);
	}

	if(vis->palette)
		free(vis->palette);
	free(LIBGGI_GC(vis));

	DPRINT_MISC("X-target closed\n");
	
	return 0;
}

#include <ggi/internal/ggidlinit.h>
