/* $Id: mode.c,v 1.36 1998/12/20 00:57:41 marcus Exp $
******************************************************************************

   Graphics library for GGI. X target.

   Copyright (C) 1998 Marcus Sundberg [marcus@ggi-project.org]
   Copyright (C) 1998 Steve Cheng     [steve@ggi-project.org]
   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan  [jmcc@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/x.h>
#include <ggi/display/mansync.h>


static int GGI_X_setorigin(ggi_visual *vis,int x,int y)
{
	struct Xhooks *xhook=LIBGGI_PRIVATE(vis);
	ggi_mode *mode=LIBGGI_MODE(vis);

	if ( x<0 || x> mode->virt.x-mode->visible.x ||
	     y<0 || y> mode->virt.y-xhook->ysplit )
	     return -1;

	xhook->xoff=x;
	xhook->yoff=y;

	vis->origin_x=x;
	vis->origin_y=y;
	
	return 0;
}


static int GGI_X_setdisplayframe(ggi_visual *vis, int num)
{
	struct Xhooks *xhook=LIBGGI_PRIVATE(vis);
	ggi_directbuffer *db = _ggi_db_find_frame(vis, num);

	if (db == NULL) {
		return -1;
	}

	vis->d_frame_num = num;
	xhook->ximage = xhook->ximage_list[num];

	return 0;
}


int GGI_X_flush(ggi_visual *vis, int tryflag)
{
	struct Xhooks *xhook = XLIB_PRIV(vis);

	if (tryflag == 0) {
		if (ggTryLock(xhook->XLibLock) != 0) {
			DPRINT_MISC("TRYLOCK fail!\n");
			return 0;
		}
	} else {
		ggLock(xhook->XLibLock);
	}

	if (xhook->cmap && xhook->cmap_first<xhook->cmap_last) {
		int x;
		XColor xcol;
	       	for(x=xhook->cmap_first;x<xhook->cmap_last;x++)
       		{
       			xcol.red  =vis->palette[x].r;
	       		xcol.green=vis->palette[x].g;
       			xcol.blue =vis->palette[x].b;
       			xcol.pixel=x;
	       		xcol.flags= DoRed | DoGreen | DoBlue ;
       			XStoreColor(xhook->display, xhook->cmap,&xcol);
	       	}
		xhook->cmap_first=256;
		xhook->cmap_last=0;
		XSetWindowColormap(xhook->display, xhook->window, xhook->cmap);
	}

#ifdef HAVE_SHM
	if (xhook->have_shm) {
		XShmPutImage(xhook->display, xhook->window, xhook->gc,
			  xhook->ximage, 
			  xhook->xoff, xhook->yoff, /* panning ! */
			  0, 0,
			  xhook->viswidth,
			  xhook->ysplit, 0);

		if (xhook->ysplit<xhook->visheight) {
			XShmPutImage(xhook->display, xhook->window, xhook->gc,
				  xhook->ximage, 
				  0, 0,
				  0, xhook->ysplit,
				  xhook->viswidth,
				  xhook->visheight-xhook->ysplit, 0);
		}
	} else 
#endif
		{

		XPutImage(xhook->display, xhook->window, xhook->gc,
			  xhook->ximage, 
			  xhook->xoff, xhook->yoff, /* panning ! */
			  0, 0,
			  xhook->viswidth, 
			  xhook->ysplit);

		if (xhook->ysplit<xhook->visheight)
			XPutImage(xhook->display, xhook->window, xhook->gc,
				  xhook->ximage, 
				  0, 0,
				  0, xhook->ysplit, /* panning ! */
				  xhook->viswidth, 
				  xhook->visheight-xhook->ysplit);
	}

	XSync(xhook->display,0);

	ggUnlock(xhook->XLibLock);

	return 0;
}

#ifdef HAVE_SHM
/* Hack to fall back when shm is not working. */
static ggi_visual *curvis = NULL;

static int shmerrorhandler (Display * disp, XErrorEvent * event)
{
	if (event->error_code == BadAccess)
		XLIB_PRIV(curvis)->shmerror = 1;
	else
		XLIB_PRIV(curvis)->oldshmerrorhandler(disp, event);
	return 0;
}
#endif

/*************************/
/* set the current flags */
/*************************/
int GGI_X_setflags(ggi_visual *vis,ggi_flags flags)
{
	LIBGGI_FLAGS(vis)=flags;

	MANSYNC_SETFLAGS(vis,flags);

	return 0;
}

#define GGI_X_TARGET
#include "../X_common/mode.inc"
