/* $Id: fillscreen.c,v 1.10 1998/11/19 01:06:28 marcus Exp $
******************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <string.h>

#include "lin4lib.h"

/*************************************/
/* fill (erase) the (virtual) screen */
/*************************************/

int GGI_lin4_fillscreen(ggi_visual *vis)
{
	DPRINT("fillscreen: fb=%p, fg=0x%.2x, width=%d, height=%d\n",
	       LIBGGI_CURWRITE(vis),LIBGGI_GC_FGCOLOR(vis),
	       LIBGGI_VIRTX(vis),LIBGGI_VIRTY(vis));
	memset(LIBGGI_CURWRITE(vis),LIBGGI_GC_FGCOLOR(vis),
				 (LIBGGI_FB_W_STRIDE(vis))*LIBGGI_VIRTY(vis));
	return 0;
}

