/* $Id: vline.c,v 1.9 1998/11/19 01:06:28 marcus Exp $
******************************************************************************

   Graphics library for GGI.

   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

/********************************/
/* draw/get/put a vertical line */
/********************************/
int GGIdrawvline(ggi_visual *vis,int x,int y,int height)
{
	uint16 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis)/2;
	uint16 color=LIBGGI_GC_FGCOLOR(vis);

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	ptr=((uint16 *)LIBGGI_CURWRITE(vis))+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*ptr=color; 
	
	return 0;
}

int GGIdrawvline_nc(ggi_visual *vis,int x,int y,int height)
{
	uint16 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis)/2;
	uint16 color=LIBGGI_GC_FGCOLOR(vis);

	/* no Clipping */
	ptr=((uint16 *)LIBGGI_CURWRITE(vis))+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*ptr=color; 
	
	return 0;
}

int GGIputvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint16 *ptr,*pixels=(uint16 *)buffer;
	int w=LIBGGI_FB_W_STRIDE(vis)/2;

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
		buffer =((uint16 *)buffer)+diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	ptr=((uint16 *)LIBGGI_CURWRITE(vis))+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*ptr=*(pixels++); 
	
	return 0;
}

int GGIgetvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint16 *ptr,*pixels=(uint16 *)buffer;
	int w=LIBGGI_FB_R_STRIDE(vis)/2;

	if (x<0||y<0||x>=LIBGGI_VIRTX(vis)||y+height>LIBGGI_VIRTY(vis)) return -1;

	ptr=((uint16 *)LIBGGI_CURREAD(vis))+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*(pixels++)=*ptr; 
	
	return 0;
}

