/* $Id: copybox.c,v 1.8 1998/11/19 01:06:28 marcus Exp $
******************************************************************************

   Graphics library for GGI. Pixels.

   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>

/*******************************/
/* draw/get/put a single pixel */
/*******************************/

int GGIcopybox(ggi_visual *vis,int x,int y,int w,int h,int nx,int ny)
{
	uint16 *obox,*nbox;
	int linew=LIBGGI_FB_W_STRIDE(vis)/sizeof(uint16);
	int line;

	/* Clipping */
	if (nx< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-nx;
		nx+=diff;
		x +=diff;
		w -=diff;
	}
	if (nx+w>=(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-nx;
	}
	if (ny< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-ny;
		ny+=diff;
		y +=diff;
		h -=diff;
	}
	if (ny+h>(LIBGGI_GC(vis)->clipbr.y)) {
		h=(LIBGGI_GC(vis)->clipbr.y)-ny;
	}

	/* If nothing to copy or the source leaves the virtual screen, bail out. */
	if (w<=0||h<=0||x<0||y<0||x+w>LIBGGI_VIRTX(vis)||y+h>LIBGGI_VIRTY(vis)) return 0;

	if (ny < y) {
		obox=(uint16 *)(LIBGGI_CURWRITE(vis))+y*linew+x;
		nbox=(uint16 *)(LIBGGI_CURWRITE(vis))+ny*linew+nx;
		for (line=0;line<h;line++,obox+=linew,nbox+=linew)
			memmove(nbox,obox,w*2);
	} else {
		obox=(uint16 *)(LIBGGI_CURWRITE(vis))+(y+h-1)*linew+x;
		nbox=(uint16 *)(LIBGGI_CURWRITE(vis))+(ny+h-1)*linew+nx;
		for (line=0;line<h;line++,obox-=linew,nbox-=linew)
			memmove(nbox,obox,w*2);
	}
	return 0;
}
