/* 
  Linear 1 bit graphics (high-bit-left)

  Copyright (C) 1995 Andreas Beck   [becka@ggi-project.org]
  Copyright (C) 1997 Jason McMullan  [jmcc@ggi-project.org]
  Copyright (C) 1998 Andrew Apted  [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>


int GGIdlinit(ggi_visual *vis, const char *version,void *argptr)
{
	/* Color mapping 
	 */
/* !!!	vis->opcolor->packcolors=GGIpackcolors; */
/* !!!	vis->opcolor->unpackpixels=GGIunpackpixels; */

	/* Frame handling
	 */

	vis->opdraw->setreadframe = _ggi_default_setreadframe;
	vis->opdraw->setwriteframe = _ggi_default_setwriteframe;
	
	/* Generic drawing
	 */
	vis->opdraw->putc=GGIputc;
	vis->opdraw->getcharsize=GGIgetcharsize;

	vis->opdraw->putpixel_nc=GGIputpixel_nc;
	vis->opdraw->putpixel=GGIputpixel;
	vis->opdraw->drawpixel_nc=GGIdrawpixel_nc;
	vis->opdraw->drawpixel=GGIdrawpixel;
	vis->opdraw->getpixel=GGIgetpixel;

	vis->opdraw->drawhline_nc=GGIdrawhline_nc;
/* !!!	vis->opdraw->puthline=GGIputhline; */
/* !!!	vis->opdraw->gethline=GGIgethline; */

	vis->opdraw->drawvline_nc=GGIdrawvline_nc;
/* !!!	vis->opdraw->putvline=GGIputvline; */
/* !!!	vis->opdraw->getvline=GGIgetvline; */

	/* Left to generic-stubs:
	 *    drawhline, drawvline, drawline,
	 *    puts, copybox, crossblit.
	 */

	return GGI_DL_OPCOLOR | GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *vis)
{
	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
