/* $Id: visual.c,v 1.10 1998/11/19 01:06:28 marcus Exp $
******************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

int GGIdlinit(ggi_visual *visual,const char *version,void *argptr)
{
	/* Color mapping 
	 */
	visual->opcolor->mapcolor=GGImapcolor;
	visual->opcolor->unmappixel=GGIunmappixel;
	visual->opcolor->packcolors=GGIpackcolors;
	visual->opcolor->unpackpixels=GGIunpackpixels;

	/* Generic drawing
	 */
	visual->opdraw->fillscreen=GGIfillscreen;

	visual->opdraw->drawpixel=GGIdrawpixel;
	visual->opdraw->putpixel=GGIputpixel;
	visual->opdraw->getpixel=GGIgetpixel;

	visual->opdraw->drawhline=GGIdrawhline;
	visual->opdraw->puthline=GGIputhline;
	visual->opdraw->gethline=GGIgethline;

	visual->opdraw->drawvline=GGIdrawvline;
	visual->opdraw->putvline=GGIputvline;
	visual->opdraw->getvline=GGIgetvline;

	visual->opdraw->copybox=GGIcopybox;

	return GGI_DL_OPCOLOR|GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
