/*
 * Galago Context Private API
 *
 * Copyright (C) 2004-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_CONTEXT_PRIV_H_
#define _GALAGO_CONTEXT_PRIV_H_

typedef struct _GalagoContextOps GalagoContextOps;

#include <libgalago/galago-person.h>
#include <libgalago/galago-service.h>

/**
 * The context operations.
 */
struct _GalagoContextOps
{
	/* Called when a service is added. */
	void (*service_added)(GalagoService *service);
	/* Called when a service is removed. */
	void (*service_removed)(GalagoService *service);
	/* Called when a person is added. */
	void (*person_added)(GalagoPerson *person);
	/* Called when a person is removed. */
	void (*person_removed)(GalagoPerson *person);
};

G_BEGIN_DECLS

void galago_context_set_ops(GalagoContext *context, GalagoContextOps *ops);

void galago_context_add_service(GalagoService *service);
void galago_context_remove_service(GalagoService *service);

void galago_context_add_person(GalagoPerson *person);
void galago_context_remove_person(GalagoPerson *person);

void galago_context_add_object(GalagoObject *obj);
void galago_context_remove_object(GalagoObject *obj);
void galago_context_clear_objects(GalagoOrigin origin);

G_END_DECLS

#endif /* _GALAGO_CONTEXT_PRIV_H_ */
