/* btcheck.c */

#include "config.h"

#include <curl/curl.h>
#include <curl/easy.h>
#include <openssl/sha.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#if !WIN32
	#include <sys/param.h>
	#if HAVE_IO_H
		#include <io.h>
	#endif
	#if HAVE_UNISTD_H
		#include <unistd.h>
	#endif
#endif
#include <time.h>
#include <signal.h>

/* libbt */
#include "types.h"
#include "benc.h"
#include "util.h"
#include "segmenter.h"
#include "context.h"
#include "bitset.h"

/* globals */
btContext context;

/* functions */
int main(int argc, char **argv)
{
	int result=0;
	int dlid;
	char *filename, *dirname;
	btStream *bts;
	struct btContext *ctx = &context;

	/* main */
	if(argc!=2) goto usage;
	if(argv[1][0]=='-') goto usage;

	dirname=argv[1];
	filename=dirname+strlen(dirname);
	while(filename>dirname&&filename[-1]!='/') --filename;
	if(filename!=dirname) {
		filename[-1]='\0';
		chdir(dirname);
	}

	if(!(bts=bts_create_filestream(filename, BTS_INPUT))) {
		perror(filename);
		return 1;
	}
	/* load tracker file */
	if((dlid=ctx_loadfile(bts, ctx, 0))<0) {
		errno=-dlid; /* ctx_loadfile() returns the error */
		perror(filename);
		return 1;
	}
	result=!bs_isFull(&ctx->downloads[dlid]->fileset.completed);
	ctx_closedownload(ctx, dlid);
	bts_destroy(bts); 

	btContext_destroy(ctx);
	return result;

usage:
	fprintf(stderr, "Usage: %s torrentfile\n", argv[0]);
	return 1;
}

