/***************************************************************************
                          deploy.c  -  description
                             -------------------
    begin                : Thu Aug 2 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <SDL.h>

#ifdef WITH_SOUND
#include <SDL_mixer.h>
#include "audio.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>

#include "tools.h"
#include "sdl.h"
#include "dynlist.h"
#include "gui.h"
#include "theme.h"
#include "config.h"
#include "nation.h"
#include "unit.h"
#include "ai_action.h"
#include "player.h"
#include "date.h"
#include "map.h"
#include "scenario.h"
#include "engine_tools.h"
#include "deploy.h"

extern Map map;
extern Scen scen;

/*
====================================================================
Sort and reset position (to x = -1) reinforcements of player.
====================================================================
*/
void reset_avail_reinf( Player *player )
{
    int i;
    /* sort:
        ground, air, naval
        in each of these classes by unit class index
    */
    /* reset position */
    for ( i = 0; i < player->avail_reinf.count; i++ )
        ((Unit*)dl_get( &player->avail_reinf, i ))->x = -1;
}


/*
====================================================================
Setup deploy mask for unit (if it's flying: use airfields else
all flags)
====================================================================
*/
void set_deploy_mask( Unit *unit )
{
    int x, y;

    clear_mask( F_DEPLOY );

    for ( x = 1; x < map.width - 1; x++ )
        for ( y = 1; y < map.height - 1; y++ ) {
            /* if unit is 0 setup mask that indicates where deployed units are standing */
            if ( unit == 0 ) {
                if ( map_tile( x, y )->unit && map_tile( x, y )->unit->delay > 0 )
                    mask_tile( x, y )->deploy = 1;
                if ( map_tile( x, y )->air_unit && map_tile( x, y )->air_unit->delay > 0 )
                    mask_tile( x, y )->deploy = 1;
            }
            else {
                if ( ( unit->prop.flags & FLYING && map_tile( x, y )->air_unit == 0 ) ||
                     ( !(unit->prop.flags & FLYING) && map_tile( x, y )->unit == 0 ) )
                    if ( may_deploy_unit( unit, x, y ) )
                        mask_tile( x, y )->deploy = 1;
            }
        }
}

/*
====================================================================
Cancel deploy of units of current player.
Remove placed reinforcements from map and reset player's
reinforcement list.
====================================================================
*/
void cancel_deploy( Engine *engine )
{
     int i;
     Unit *unit;

    for ( i = 0; i < engine->player->avail_reinf.count; i++ ) {
        unit = (Unit*)dl_get( &engine->player->avail_reinf, i );
        if ( unit->x != -1 ) {
            remove_unit_from_map( unit );
            unit->x = -1;
        }
    }
}

/*
====================================================================
Apply deployed units by transfering from player::avail_reinf to
scen::units (note: these units must be already inserted to map).
Sets delay (which is >0 ) to 0.
====================================================================
*/
void apply_deploy( Engine *engine )
{
     int i;
     Unit *unit;

    for ( i = 0; i < engine->player->avail_reinf.count; i++ ) {
        unit = (Unit*)dl_get( &engine->player->avail_reinf, i );
        if ( unit->x != -1 ) {
            transfer_unit( unit, &engine->player->avail_reinf, &scen.units );
            unit->delay = 0;
            prep_unit_for_turn( unit, scen.cur_turn, NO_FUEL_CHECK | NO_ENTR_CHECK );
            /* reset index */
            i--;
        }
    }
}

/*
====================================================================
Transfer unit pointer from source to target list.
====================================================================
*/
void transfer_unit( Unit *unit, Dyn_List *source, Dyn_List *dest )
{
    int old_flags;
    /* add to destination */
    dl_add( dest, unit );
    /* as the pointer is added to dest without changes only the empty
    entry must be deleted in source */
    old_flags = source->flags;
    source->flags = NO_AUTO_DELETE | NO_CALLBACK;
    dl_delete_poi( source, unit );
    source->flags = old_flags;
}

/*
====================================================================
Check if a particular unit may be deployed to position x,y
====================================================================
*/
int is_airfield( int x, int y )
{
    return map_tile( x, y )->prop->flags & AIRFIELD;
}
int may_deploy_unit( Unit *unit, int x, int y )
{
    if ( unit->prop.flags & FLYING ) {
        /* unit needs an airfield near by */
        if ( map_tile( x, y )->player_id == unit->player_id && is_airfield( x, y ) ) return 1;
        if ( map_tile( x + 1, y )->player_id == unit->player_id && is_airfield( x + 1, y ) ) return 1;
        if ( map_tile( x - 1, y )->player_id == unit->player_id && is_airfield( x - 1, y ) ) return 1;
        if ( map_tile( x, y + 1 )->player_id == unit->player_id && is_airfield( x, y + 1 ) ) return 1;
        if ( map_tile( x, y - 1 )->player_id == unit->player_id && is_airfield( x, y - 1 ) ) return 1;
        if ( x & 1 ) {
            if ( map_tile( x + 1, y + 1 )->player_id == unit->player_id && is_airfield( x + 1, y + 1 ) ) return 1;
            if ( map_tile( x - 1, y + 1 )->player_id == unit->player_id && is_airfield( x - 1, y + 1 ) ) return 1;
        }
        else {
            if ( map_tile( x + 1, y - 1 )->player_id == unit->player_id && is_airfield( x + 1, y - 1 ) ) return 1;
            if ( map_tile( x - 1, y - 1 )->player_id == unit->player_id && is_airfield( x - 1, y - 1 ) ) return 1;
        }
    }
    else {
        if ( map_tile( x, y )->player_id == unit->player_id ) return 1;
        if ( map_tile( x + 1, y )->player_id == unit->player_id ) return 1;
        if ( map_tile( x - 1, y )->player_id == unit->player_id ) return 1;
        if ( map_tile( x, y + 1 )->player_id == unit->player_id ) return 1;
        if ( map_tile( x, y - 1 )->player_id == unit->player_id ) return 1;
        if ( x & 1 ) {
            if ( map_tile( x + 1, y + 1 )->player_id == unit->player_id ) return 1;
            if ( map_tile( x - 1, y + 1 )->player_id == unit->player_id ) return 1;
        }
        else {
            if ( map_tile( x + 1, y - 1 )->player_id == unit->player_id ) return 1;
            if ( map_tile( x - 1, y - 1 )->player_id == unit->player_id ) return 1;
        }
    }
    return 0;
}

/*
====================================================================
Deploy unit: set position of unit and insert to map. Then transfer
from player::avail_reinf to scen::units
====================================================================
*/
void deploy_unit( Unit *unit, int x, int y );

/*
====================================================================
Get next deployable unit from list engine::deploy_units.
====================================================================
*/
Unit* get_next_deploy_unit( Engine *engine )
{
    /* the next unit is the one at the current deploy_sel_id (as the list was recreated
       but maybe it was the previously deployed unit was the last in list then start at beginning
    */
    if ( engine->deploy_sel_id >= engine->deploy_unit_count ) {
        if ( engine->deploy_unit_count == 0 ) return 0; /* no units remain */
        engine->deploy_sel_id = 0;
    }
    return engine->deploy_units[engine->deploy_sel_id];
}

/*
====================================================================
Create the list containing all pointers from player::avail_reinf
whose pos is x != -1
====================================================================
*/
void create_deploy_list( Engine *engine )
{
    int i, j;
    Unit *unit;

    /* create a static pointer list with valid unit pointers */
    engine->deploy_unit_count = 0;
    for ( i = 0; i < engine->player->avail_reinf.count; i++ )
        if ( ((Unit*)dl_get( &engine->player->avail_reinf, i ))->x == -1 )
            engine->deploy_unit_count++;
    if ( engine->deploy_units ) free( engine->deploy_units );
    engine->deploy_units = calloc( engine->deploy_unit_count, sizeof( Unit* ) );
    for ( i = 0, j = 0; i < engine->player->avail_reinf.count; i++ ) {
        unit = (Unit*)dl_get( &engine->player->avail_reinf, i );
        if ( unit->x == -1 ) engine->deploy_units[j++] = unit;
    }

}
