/***************************************************************************
                          ai_tools.c  -  description
                             -------------------
    begin                : Wed Mar 28 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <SDL.h>

#ifdef WITH_SOUND
#include <SDL_mixer.h>
#include "audio.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tools.h"
#include "sdl.h"
#include "dynlist.h"
#include "gui.h"
#include "theme.h"
#include "nation.h"
#include "unit.h"
#include "player.h"
#include "date.h"
#include "map.h"
#include "scenario.h"
#include "ai_action.h"
#include "engine_tools.h"
#include "ai_tools.h"

extern Map map;
extern Scen scen;
/*
====================================================================
AI style is either aggressive AGGR or defensive DEF.
====================================================================
*/
extern int ai_style;
/*
====================================================================
Current unit processed in ai_get_action()
====================================================================
*/
extern Unit *cur_unit;

/*
====================================================================
Create a static list of all units that belong to the player_id.
====================================================================
*/
Unit** get_player_units( Engine *engine, int player_id, int *unit_count )
{
    DL_Entry *entry = scen.units.head.next;
    Unit **list = 0;
    int i;

    /* first count them */
    (*unit_count) = 0;
    while ( entry != &scen.units.tail ) {
        if ( ((Unit*)entry->data)->player_id == player_id )
            (*unit_count)++;
        entry = entry->next;
    }

    if ( *unit_count == 0 ) return 0;

    /* get mem */
    list = calloc( *unit_count, sizeof( Unit* ) );

    /* get units */
    entry = scen.units.head.next;
    i = 0;
    while ( entry != &scen.units.tail ) {
        if ( ((Unit*)entry->data)->player_id == player_id )
            list[i++] = (Unit*)entry->data;
        entry = entry->next;
    }

    return list;
}

/*
====================================================================
Check if either ammo or fuel dropped below a sperrbestand (not much
left)
====================================================================
*/
int ai_low_ammo()
{
    if ( cur_unit->cur_prop.ammo <= 2 ) {
#ifdef AI_DEBUG
        printf( "low ammo\n" );
#endif
        return 1;
    }
    return 0;
}
int ai_low_fuel()
{
    int ret = 0;
    if ( ai_is_flying() ) {
        if ( cur_unit->cur_prop.fuel <= 20 )
            ret = 1;
    }
    else
        if ( use_fuel( cur_unit ) && cur_unit->cur_prop.fuel <= 5 )
            ret = 1;
#ifdef AI_DEBUG
    if ( ret )
        printf( "low fuel\n" );
#endif
    return ret;
}
/*
====================================================================
Check if cur_unit may supply anything.
====================================================================
*/
int ai_may_supply()
{
    return unit_can_supply( cur_unit, ANYTHING );
}

/*
====================================================================
Check flags of current unit.
====================================================================
*/
int ai_is_flying()
{
    return ( cur_unit->sel_prop->flags & FLYING );
}

/*
====================================================================
Scan the surrounding for an airfield and check if it's in
fuel-range of cur_unit. If so return 1 and setup an MOVE action
heading for this airfield (if it's not reached in one turn
this function will be called again)
====================================================================
*/
int ai_find_airfield( AI_Action *action )
{
    return 0;
}

/*
====================================================================
Find a target for this unit. Depending on type movement is
allowed or not allowed. The taken action (ATTACK, MOVE_ATTACK)
is set and 1 is returned if successful.
Note: AI_ALLOW_MOVE is only allowed for flying units.
====================================================================
*/
int ai_find_target( Engine *engine, int type, AI_Action *action )
{
    int i, j;
    int old_x, old_y;
    int count;
    Damage_Pred *pred = 0;

    /* find target that requires no movement */
    pred = get_pred( cur_unit, &count );
    if ( pred ) {
        *action = ai_attack_action( pred[0].def );
        free( pred );
        return 1;
    }
    /* if movement is not allowed and close target wasn't found exit here */
    if ( type != AI_ALLOW_MOVE ) return 0;
    /* and ground units are not supported */
    if ( !ai_is_flying() ) {
#ifdef AI_DEBUG
        printf( "ai_find_target: only flying units may move and attack so far\n" );
#endif
        return 0;
    }
    /* set up move mask */
    set_move_mask( engine, cur_unit );
    /* backup position */
    old_x = cur_unit->x, old_y = cur_unit->y;
    /* check each position in range for their targets */
    for ( j = 0; j < map.height; j++ )
        for ( i = 0; i < map.width; i++ )
            if ( mask_tile( i, j )->in_range != -1 && !mask_tile( i, j )->blocked ) {
                cur_unit->x = i; cur_unit->y = j;
                pred = get_pred( cur_unit, &count );
                if ( pred ) {
                    cur_unit->x = old_x; cur_unit->y = old_y;
                    /* target found; set action */
                    *action = ai_move_attack_action( i, j, pred[0].def );
                    free( pred );
                    return 1;
                }
            }
    cur_unit->x = old_x; cur_unit->y = old_y;
    return 0;
}
