/*
 * lftp - file transfer program
 *
 * Copyright (c) 1999 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: ChmodJob.cc,v 1.2 2000/01/22 16:27:28 lav Exp $ */

#include <config.h>
#include "ChmodJob.h"
#include "url.h"

ChmodJob::ChmodJob(FileAccess *s,int new_m,ArgV *a) : TreatFileJob(s,a)
{
   m=new_m;
}

void ChmodJob::TreatCurrent()
{
   ParsedURL u(curr,true);
   if(u.proto)
      url_session=FA::New(&u);
   if(url_session)
      url_session->Chmod(u.path,m);
   else
      session->Chmod(curr,m);
}
