/**
 * 
 * $Header: /cvsroot/lesstif/lesstif/lib/Xm-2.1/PrintShell.c,v 1.6 2000/12/20 19:55:35 dannybackx Exp $
 *
 * Copyright  2000 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static const char rcsid[] = "$Header: /cvsroot/lesstif/lesstif/lib/Xm-2.1/PrintShell.c,v 1.6 2000/12/20 19:55:35 dannybackx Exp $";

#include <LTconfig.h>

/*
 * Only compile if we have the Xp library.
 */
#ifdef	HAVE_LIB_XP

#include <XmI/XmI.h>

#include <Xm/XmP.h>
#include <Xm/PrintSP.h>
#include <Xm/Print.h>

#include <XmI/DebugUtil.h>


/* Forward Declarations */
static void class_initialize(void);
static void class_part_initialize(WidgetClass w_class);
static void initialize(Widget request, Widget new_w,
		       ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void realize(Widget w, XtValueMask *value_mask,
		    XSetWindowAttributes *attributes);
static void resize(Widget w);
static Boolean set_values(Widget current, Widget request, Widget new_w,
			  ArgList args, Cardinal *num_args);
static void _XmPrintNotify(Widget w, XtPointer client, XEvent *evp, Boolean *cont);

#define Offset(field) XtOffsetOf(XmPrintShellRec, print_shell.field)


/* Resources for the PrintShell class */
static XtResource resources[] =
{
    {
	XmNstartJobCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(start_job_callback),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNendJobCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(end_job_callback),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNpageSetupCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(page_setup_callback),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNpdmNotificationCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(pdm_notification_callback),
	XmRImmediate, (XtPointer)NULL
    },
    {
	XmNminX, XmCMinX, XmRDimension,
	sizeof(Dimension), Offset(min_x),
	XmRImmediate, (XtPointer)NULL		/* dynamic */
    },
    {
	XmNminY, XmCMinY, XmRDimension,
	sizeof(Dimension), Offset(min_y),
	XmRImmediate, (XtPointer)NULL		/* dynamic */
    },
    {
	XmNmaxX, XmCMaxX, XmRDimension,
	sizeof(Dimension), Offset(max_x),
	XmRImmediate, (XtPointer)NULL		/* dynamic */
    },
    {
	XmNmaxY, XmCMaxY, XmRDimension,
	sizeof(Dimension), Offset(max_y),
	XmRImmediate, (XtPointer)NULL		/* dynamic */
    },
    {
	XmNdefaultPixmapResolution, XmCDefaultPixmapResolution, XmRShort,
	sizeof(unsigned short), Offset(default_pixmap_resolution),
	XmRImmediate, (XtPointer)100
    },
};

static XtActionsRec actions[] =
{
#if 0
    {"MenuShellPopdownOne", MenuShellPopdownOne},
#endif
};


static XmBaseClassExtRec _XmPrintShellCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL,
    /* set_values_prehook        */ NULL,
    /* initialize_posthook       */ NULL,
    /* set_values_posthook       */ NULL,
    /* secondary_object_class    */ NULL,
    /* secondary_object_create   */ NULL,
    /* get_secondary_resources   */ NULL,
    /* fast_subclass             */ { 0 },
    /* get_values_prehook        */ NULL,
    /* get_values_posthook       */ NULL,
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ False,
    /* widget_navigable          */ NULL,
    /* focus_change              */ NULL,
    /* wrapper_data              */ NULL
};

XmPrintShellClassRec xmPrintShellClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &applicationShellClassRec,
        /* class_name            */ "XmPrintShell",
	/* widget_size           */ sizeof(XmPrintShellRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ False,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ realize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ True,
	/* compress_exposure     */ XtExposeCompressMaximal /*XtExposeCompressMultiple*/,
	/* compress_enterleave   */ True,
	/* visible_interest      */ False,
	/* destroy               */ destroy,
	/* resize                */ resize,
	/* expose                */ XtInheritExpose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ NULL,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmPrintShellCoreClassExtRec
    },
    /* Composite class part */
    {
	/* geometry manager */	XtInheritGeometryManager,
        /* change_managed   */	XtInheritChangeManaged,
        /* insert_child     */	XtInheritInsertChild,
        /* delete_child     */	XtInheritDeleteChild,
        /* extension        */	NULL,	
    },
    /* Shell class part */
    {
	/* extension        */ NULL,
    },
    /* WM Shell class part */
    {
	/* extension	*/		NULL,
    },
    /* VendorShell class part */
    {
	/* extension	*/		NULL,
    },
    /* TopLevelShell class part */
    {
	/* extension	*/		NULL,
    },
    /* ApplicationShell class part */
    {
	/* extension	*/		NULL,
    },
};

WidgetClass xmPrintShellWidgetClass = (WidgetClass)&xmPrintShellClassRec;

static void
class_initialize(void)
{
    _XmInitializeExtensions();

    _XmPrintShellCoreClassExtRec.record_type = XmQmotif;
}


static void
class_part_initialize(WidgetClass widget_class)
{
#if 0
    _XmFastSubclassInit(widget_class, XmMENU_SHELL_BIT);
#endif
}

static void
select_notify(Widget w, int *e, XtPointer *s, int n, XtPointer client)
{
	XPContext	c = XpGetContext(XtDisplay(w));

	if (! c) {
#if 0
		fprintf(stderr, "XmPrintShell select_notify: no Context, creating one (wid %s)\n",
			XtName(w));
		c = XpCreateContext(XtDisplay(w), "lp");
#endif
		_XmWarning(w, "XmPrintShell select_notify: no print context\n");
		return;
	}

	XpSelectInput(XtDisplay(w), c, XPPrintMask | XPAttributeMask);
}

static void
initialize(Widget request, Widget new_w, ArgList args, Cardinal *num_args)
{
	int	error_base, event_base;

	fprintf(stderr, "XmPrintShell Initialize (size %d %d)\n", new_w->core.width, new_w->core.height);

	new_w->core.width = 100;
	new_w->core.height = 100;	/* FIX ME */

	if (!XpQueryExtension(XtDisplay(new_w), &event_base, &error_base))
		return;

	XtInsertEventTypeHandler(new_w,
		event_base + XPPrintNotify,
		(XtPointer)XPPrintMask,
		_XmPrintNotify, NULL,
		XtListTail);
	XtRegisterExtensionSelector(XtDisplay(new_w),
			event_base + XPPrintNotify,
			event_base + XPAttributeNotify,
			select_notify,
		NULL);

}

static void
destroy(Widget w)
{
	fprintf(stderr, "XmPrintShell Destroy\n");
}

static void
resize(Widget w)
{
	fprintf(stderr, "XmPrintShell Resize\n");
}

static void
realize(Widget w, XtValueMask *value_mask, XSetWindowAttributes *attributes)
{
	fprintf(stderr, "XmPrintShell Realize\n");
#if 1

#define superclass (&applicationShellClassRec)
    (*superclass->core_class.realize) (w, value_mask, attributes);
#undef superclass

#endif
}

static Boolean
set_values(Widget current, Widget request, Widget new_w,
	   ArgList args, Cardinal *num_args)
{
#if 0

#endif
	fprintf(stderr, "XmPrintShell SetValues\n");
	return True;
}

extern Widget
XmCreatePrintShell(Widget parent, char *name, ArgList arglist, Cardinal argcount)
{
    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    return XtCreatePopupShell(name, xmPrintShellWidgetClass, parent,
			      arglist, argcount);
}


static void
_XmPrintNotify(Widget w, XtPointer client, XEvent *evp, Boolean *cont)
{
	XPPrintEvent	*e = (XPPrintEvent *)evp;

	switch (e->detail) {
	case XPStartJobNotify:
		fprintf(stderr, "XPStartJobNotify\n");
		break;
	case XPEndJobNotify:
		fprintf(stderr, "XPEndJobNotify\n");
		break;
	default:
		break;
	}
}
#endif	/* HAVE_LIB_XP */
