/*
 * Copyright(c) 1992 Bell Communications Research, Inc. (Bellcore)
 *                        All rights reserved
 * Permission to use, copy, modify and distribute this material for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of Bellcore not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * Bellcore.
 *
 * BELLCORE MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL BELLCORE OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES RELAT-
 * ING TO THE SOFTWARE.
 *
 * $Id: traversal.c,v 1.4 2000/04/27 07:48:58 amai Exp $
 */

#ifdef HAVE_CONFIG_H
#include <XbaeConfig.h>
#endif
#include <stdlib.h>
#include <Xbae/Matrix.h>

/*
 * Custom traversal.
 * Defines a new type of traversal.  Pressing the Return key will
 * now move down a row and back to the first column (like a carriage
 * return).
 */

void TraverseCB(Widget w, XtPointer client_data, XbaeMatrixTraverseCellCallbackStruct *call_data);

int
main(int argc, char *argv[])
{
    Widget toplevel, mw;
    XtAppContext app;
#ifdef USE_EDITRES
    extern void _XEditResCheckMessages();
#endif

    toplevel = XtVaAppInitialize(&app, "Traversal",
				 NULL, 0,
				 &argc, argv,
				 NULL,
				 NULL);
#ifdef USE_EDITRES
    XtAddEventHandler( toplevel, (EventMask)0, True,
                       _XEditResCheckMessages, NULL);
#endif

    mw = XtVaCreateManagedWidget("mw",
				 xbaeMatrixWidgetClass, toplevel,
				 NULL);
    XtAddCallback(mw, XmNtraverseCellCallback, (XtCallbackProc)TraverseCB, NULL);

    XtRealizeWidget(toplevel);
    XtAppMainLoop(app);
    /*NOTREACHED*/
    return 0;
}

/*
 * Custom traversal callback.  If the EditCell() action has the param
 * "Return", then we move down a row and back to the first editable
 * column.
 */
/* ARGSUSED */
void
TraverseCB(Widget w, XtPointer client_data, XbaeMatrixTraverseCellCallbackStruct *call_data)
{
    static XrmQuark Qreturn = NULLQUARK;

    /*
     * Get a Quark for our special action parm (for faster comparisons)
     */
    if (Qreturn == NULLQUARK)
	Qreturn = XrmStringToQuark("Return");

    /*
     * See if this is our special quark
     */
    if (call_data->qparam != Qreturn)
	return;

    /*
     * If we are on the last row we don't move
     */
    if (call_data->row == call_data->num_rows - 1)
	return;

    /*
     * Move down a row and back to the first non-fixed column
     */
    call_data->next_row = call_data->row + 1;
    call_data->next_column = call_data->fixed_columns;

}
