/**
 *
 * $Id: DebugUtil.h,v 1.30 2000/11/02 11:12:04 amai Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 * Copyright (C) 1995-2000 LessTif Development Team
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef _XMI_DEBUGUTIL_H
#define _XMI_DEBUGUTIL_H

#include <LTconfig.h>

#include <Xm/XmP.h>


/*
 * Print a widget tree
 */
void XdbPrintTree(Widget w);
void XdbPrintCompleteTree(Widget w);

/*
 * Print an Arg list
 */
void XdbPrintArgList(const char *fn, Widget w, ArgList al, int n, Boolean Get);

/*
 * Convert types into string format
 */
const char *XdbFocusDetail2String(int type);
const char *XdbFocusMode2String(int type);
const char *XdbEventType2String(int type);
#if XmVERSION > 1
const char *XdbComboBoxType2String(unsigned char type);
#endif
const char *XdbGeoAction2String(int action);
const char *XdbGeometryResult2String(XtGeometryResult r);
const char *XdbDragAndDropMessageType2String(unsigned char r);
const char *XdbDragType2String(unsigned char r);
const char *XdbWidgetGeometry2String(XtWidgetGeometry *g);

const char *XdbAttachment2String(int i);
const char *XdbMenuFocusOp2String(int f);
const char *XdbMenuEnum2String(int f);
const char *XdbBoolean2String(int b);
const char *XdbXmString2String(XmString xms);
const char *XdbPacking2String(unsigned char p);
const char *XdbRcType2String(unsigned char t);
const char *XdbAlignment2String(int n);
const char *XdbMenuType2String(int n);
const char *XdbNavigability2String(unsigned char n);
const char *XdbHighlightMode2String(int mode);
const char *XdbSelectionPolicy2String(int n);
const char *XdbReason2String(int reason);

const char *XdbFocusChange2String(XmFocusChange c);

const char *XdbNavigationType2String(XmNavigationType nt);
const char *XdbEditMode2String(int n);
const char *XdbSBDisplayPolicy2String(int n);
const char *XdbSBPlacement2String(int n);
const char *XdbListSizePolicy2String(int n);
const char *XdbResizePolicy2String(int n);

/*
 * Debug printing functions
 */
void XdbDebug (const char *fn, Widget w, const char *fmt, ...);
void XdbDebug2(const char *fn, Widget w, Widget c, const char *fmt, ...);
void XdbDebug0(const char *fn, Widget w, const char *fmt, ...);
void XdbPrintString(const char *s);

#ifdef	LESSTIF_PRODUCTION
#define	XdbInDebug(x, y)	False
#define DEBUGOUT(x)

# ifdef	USE_DMALLOC
# undef	USE_DMALLOC
# endif
#else
Boolean XdbInDebug(const char *fn, Widget w);
#define DEBUGOUT(x)	x
#endif

/*
 * Some stuff to produce sensible tracing with dmalloc.
 * Check the INSTALL(.html) doc for references about the
 * dmalloc package!
 */
#ifdef	USE_DMALLOC

#include <dmalloc.h>

#ifdef	XtMalloc
#undef	XtMalloc
#endif
#define	XtMalloc(x)	XdbMalloc(__FILE__, __LINE__, x)
#ifdef	XtCalloc
#undef	XtCalloc
#endif
#define	XtCalloc(x,y)	XdbCalloc(__FILE__, __LINE__, x, y)
#ifdef	XtRealloc
#undef	XtRealloc
#endif
#define	XtRealloc(x,y)	XdbRealloc(__FILE__, __LINE__, x, y)
#ifdef	XtFree
#undef	XtFree
#endif
#define	XtFree(x)	XdbFree(__FILE__, __LINE__, x)

#endif	/* USE_DMALLOC */

XtPointer   XdbMalloc(char *f,  int l, int size);
XtPointer   XdbCalloc(char *f,  int l, int count, int size);
XtPointer   XdbRealloc(char *f, int l, XtPointer p, int size);
void        XdbFree(char *f,    int l, XtPointer p);

#endif /* _XMI_DEBUGUTIL_H */
