/**
 * 
 * $Id: ComboBox.h,v 1.4 2000/12/20 19:48:31 amai Exp $
 *
 * Copyright (C) 1997 Free Software Foundation, Inc.
 * Copyright (C) 1997-2000 LessTif Development Team
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef _XM_COMBOBOX_H
#define _XM_COMBOBOX_H

#include <Xm/Xm.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* ComboBox Widget */

extern WidgetClass xmComboBoxWidgetClass;
typedef struct _XmComboBoxRec *XmComboBoxWidget;
typedef struct _XmComboBoxClassRec *XmComboBoxWidgetClass;

#ifndef XmIsComboBox
#define XmIsComboBox(w) XtIsSubclass((w), xmComboBoxWidgetClass)
#endif

Widget XmCreateComboBox(Widget parent,  
                        char *name, 
                        Arg *arglist, 
                        Cardinal argcount);

Widget XmCreateDropDownComboBox(Widget parent,
                                char *name, 
                                Arg *arglist, 
                                Cardinal argcount);

Widget XmCreateDropDownList(Widget parent,
                            char *name, 
                            Arg *arglist, 
                            Cardinal argcount);

void XmComboBoxUpdate(Widget widget);

void XmComboBoxAddItem(Widget w, XmString xms, int a, Boolean unique);

#ifdef __cplusplus
}
#endif

#endif /* _XM_COMBOBOX_H */
