#!/bin/sh
# This script cares for the rpm crap.
# First draft written by Karsten Merker <merker@guug.de>
# Heavily modified by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>
# See COPYING for restrictions of use of this software.

if [ $# -ne 10 ]
then
    echo "Usage: $0 [path to rpm] [specfile] [listfile] [builddir]"
    echo "  [leafnode version] [usrdir] [bindir] [mandir] [lockfile] [spooldir]"
    echo 'Possible reason for failure: rpm not found?'
    echo This script should preferentially be called from the Makefile only.
    exit 1
fi

RPM=$1
SPECFILE=$2
LISTFILE=$3
SRCDIR=`dirname ${LISTFILE}`
BUILDDIR=$4
VERSION=$5
USRDIR=$6
BINDIR=$7
MANDIR=$8
LOCKFILE=$9
LOCKDIR=`dirname ${LOCKFILE}`
SPOOLDIR=${10}
HOMEDIR=`pwd`

if [ `id -u` -ne 0 ]
then
    echo This command must be run as root.
    exit 1
fi

if [ ! -x ${RPM} ]
then
    echo rpm should be in $RPM but not found
    exit 1
fi

echo Creating ${LISTFILE} ...

mkdir -p `dirname ${LISTFILE}`

cat << EOF > $LISTFILE
%doc CHANGES
%doc COPYING
%doc CREDITS
%doc INSTALL
%doc README
%doc TODO
%doc update.sh
${BINDIR}/leafnode
${BINDIR}/fetch
${BINDIR}/texpire
${BINDIR}/checkgroups
${BINDIR}/applyfilter
${USRDIR}/newsq
${MANDIR}/man1/newsq.1
${MANDIR}/man8/checkgroups.8
${MANDIR}/man8/fetch.8
${MANDIR}/man8/leafnode.8
${MANDIR}/man8/texpire.8
${LIBDIR}/config.example
%dir ${LOCKDIR}
%dir ${SPOOLDIR}
%dir ${SPOOLDIR}/leaf.node
%dir ${SPOOLDIR}/message.id
%dir ${SPOOLDIR}/interesting.groups
%dir ${SPOOLDIR}/out.going
EOF

for a in  0 1 2 3 4 5 6 7 8 9 ; do \
for b in 0 1 2 3 4 5 6 7 8 9 ; do \
for c in 0 1 2 3 4 5 6 7 8 9 ; do \
echo +%dir ${SPOOLDIR}/message.id/${a}${b}${c} >> $LISTFILE
done ; done ; done

echo Creating ${SPECFILE} ...

mkdir -p `dirname ${SPECFILE}`

cat << EOF > ${SPECFILE}
Summary: Leafnode - a leafsite NNTP server (Version ${VERSION})
Summary(de): Leafnode - ein offline-Newsserver (Version ${VERSION})
Name: leafnode
Version: ${VERSION}
Release: 1
Copyright: see COPYING
Group: Applications/News
Source: ftp://wpxx02.toxi.uni-wuerzburg.de/pub/leafnode-${VERSION}.tar.gz
Source1: ${LISTFILE}
Distribution: RedHat >5.0
Vendor: none
Packager: rpm template specfile written by K. Merker <merker@guug.de>
%description
Leafnode is a small NNTP server for leaf sites without permanent
connection to the internet. It supports a subset of NNTP and is able to
automatically fetch the newsgroups the user reads regularly from the
newsserver of the ISP.

%description -l de
Leafnode ist ein offline-Newsserver, der vor allem fr den typischen
Einzelnutzer-Rechner ohne permanente Internetanbindung geeignet ist.
Leafnode bezieht automatisch die Newsgroups, die der oder die Nutzer
regelmaessig lesen, vom Newsserver des Providers.

%prep
%setup
%build
make

%install
make install

%clean
make uninstall
%files -f ../leafnode-${VERSION}.filelist
EOF

mkdir -p ${BUILDDIR}
cd ${BUILDDIR}
tar xzf ${HOMEDIR}/leafnode-${VERSION}.tar.gz
cp ${HOMEDIR}/leafnode-${VERSION}.tar.gz ${SRCDIR}

echo Building RPMs from ${SPECFILE} ...
${RPM} -ba ${SPECFILE}
